/*
 * Decompiled with CFR 0.152.
 */
package com.cadence.orbit;

import com.sigrity.acl.AFile;
import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Design;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.OrbitDbReader;
import com.sigrity.orbit.OrbitDbReaderImport;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.OrbitIOWriter;
import java.io.File;
import java.util.stream.Stream;

public class OrbitDbUtil {
    private OrbitDbUtil() {
    }

    public static boolean convertAllToLatestDbVersion(String libDirPath) {
        if (libDirPath == null || libDirPath.trim().isEmpty()) {
            ALog.logError((String)"No library directory path specified.");
            return false;
        }
        File dir = new File(libDirPath);
        ALog.logInfo((String)"Converting oio files in '%s' to latest database version.", (Object[])new Object[]{dir.getAbsolutePath()});
        return Stream.of(dir.listFiles(f -> AFile.getExtension((File)f).equalsIgnoreCase("oio"))).map(OrbitDbUtil::convertOioToLatestDbVersion).reduce(Boolean::logicalAnd).orElse(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean convertOioToLatestDbVersion(File oioFile) {
        Design design = OrbitIO.getApp().createDesign().orElse(null);
        if (design == null) {
            return false;
        }
        Db db = design.getDb();
        try {
            OrbitDbReaderImport dbr = new OrbitDbReaderImport(db);
            dbr.setConvertOld(true);
            dbr.setAllowDifferentVersion(true);
            if (!dbr.read(oioFile.getAbsolutePath())) {
                ALog.logError((String)"Error reading '%s', not converted.", (Object[])new Object[]{oioFile.getAbsolutePath()});
                boolean bl = false;
                return bl;
            }
            Db.Version readVer = OrbitDbReader.getLastReadVersion((Db)db);
            if (readVer.equals((Object)OrbitApp.DBVERSION)) {
                ALog.logDebug((String)"File '%s', is already up to date.", (Object[])new Object[]{oioFile.getAbsolutePath()});
                boolean bl = true;
                return bl;
            }
            if (!OrbitIOWriter.write((Db)db, (String)AUtil.getCanonicalPath((File)oioFile), (boolean)true)) {
                ALog.logError((String)"Writing updated '%s' failed.");
                boolean bl = false;
                return bl;
            }
            ALog.logInfo((String)"Converted '%s' from Db version %s to %s", (Object[])new Object[]{oioFile.getAbsolutePath(), readVer, OrbitApp.DBVERSION});
            boolean bl = true;
            return bl;
        }
        finally {
            db.setDirty(false);
            OrbitIO.getApp().closeDesign(db);
        }
    }
}

