/*
 * Decompiled with CFR 0.152.
 */
package com.cadence.orbit.ballmapplanner;

import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Metal;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.DiffPairUI;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.export.BgaDieTxtIO;
import com.sigrity.orbit.export.ExportSymbolSpreadsheet;
import com.sigrity.orbit.ui.AssignPwrGndDlg;
import com.sigrity.orbit.ui.CSVNetlistInDlg;
import com.sigrity.orbit.ui.ExportNetsText;
import java.util.ArrayList;

public class BallMapPlanner {
    public static void Autoassignpersonalities() {
        String name = BallMapPlanner.getDeviceName();
        Cp.exec((String)"com.sigrity.orbit.ui.PersonalityUI.assignBallsToPersonalities(\"%s\");", (Object[])new Object[]{name});
    }

    public static void ImportNetInterfaceFile() {
        String name = BallMapPlanner.getDeviceName();
        CSVNetlistInDlg.showMe(name, true);
    }

    public static void CreateNetInterfaceFileTemplate() {
        for (DevicePath d : OrbitIO.getCurDesign().getDescendantDevices()) {
            if (!d.getLast().isPackage()) continue;
            ExportNetsText.showMe(d.escapedString());
            break;
        }
    }

    public static void MapNets() {
        String name = BallMapPlanner.getDeviceName();
        CSVNetlistInDlg.showMe(name, false);
    }

    public static void AssignPowerGround() {
        DevicePath name = BallMapPlanner.getDevice();
        AssignPwrGndDlg.createDialog(OrbitIO.getMainWindow(), name).setVisible(true);
    }

    public static void CreateDiffPair() {
        DeviceTemplate name = BallMapPlanner.getDeviceTemplate();
        new DiffPairUI.DiffPairCreationUI(OrbitIO.getMainWindow(), name).setVisible(true);
    }

    public static void BGABallMap() {
        ExportSymbolSpreadsheet.showFor(BallMapPlanner.getDevice().toString());
    }

    public static void BGAText() {
        BgaDieTxtIO.showExportUI(BallMapPlanner.getDevice().getDb(), BallMapPlanner.getDeviceName());
    }

    public static void DeleteBoardRouting() {
        for (DevicePath d : OrbitIO.getCurDesign().getDescendantDevices()) {
            DeviceTemplate dt = d.getDeviceTemplate();
            ArrayList<Wire> lw = new ArrayList<Wire>();
            ArrayList<Metal> lm = new ArrayList<Metal>();
            for (Wire w : dt.getWires()) {
                lw.add(w);
            }
            int length = lw.size();
            for (int i = length - 1; i >= 0; --i) {
                Wire w = (Wire)lw.remove(i);
                w.deleteFromDb();
                --length;
            }
            for (Metal m : dt.getMetals()) {
                lm.add(m);
            }
            length = lm.size();
            for (int i = length - 1; i >= 0; --i) {
                Metal m;
                m = (Metal)lm.remove(i);
                m.deleteFromDb();
                --length;
            }
            OrbitIO.refreshViewsOf(OrbitIO.getCurDb());
        }
    }

    public static DevicePath getDevice() {
        DevicePath name = null;
        for (DevicePath d : OrbitIO.getCurDesign().getDescendantDevices()) {
            if (!d.getLast().isPackage()) continue;
            name = d;
            break;
        }
        return name;
    }

    public static DeviceTemplate getDeviceTemplate() {
        DeviceTemplate name = null;
        for (DevicePath d : OrbitIO.getCurDesign().getDescendantDevices()) {
            if (!d.getLast().isPackage()) continue;
            name = d.getDeviceTemplate();
            break;
        }
        return name;
    }

    public static String getDeviceName() {
        String name = null;
        for (DevicePath d : OrbitIO.getCurDesign().getDescendantDevices()) {
            if (!d.getLast().isPackage()) continue;
            name = "/" + d.getDevice().getName();
            break;
        }
        return name;
    }
}

