/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.dbui;

import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbUtil;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.xml.AXslUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DbStructureDescPanel
extends JPanel {
    protected Db mDb;
    protected Element mXmlStruct;
    protected JTextPane mTxtHtml;

    public DbStructureDescPanel(Db db) {
        this.mDb = db;
        GridBagManager l = GridBagManager.layout((Container)this);
        this.mTxtHtml = new JTextPane();
        this.mTxtHtml.setContentType("text/html");
        this.mTxtHtml.setPreferredSize(new Dimension(480, 640));
        this.mTxtHtml.setEditable(false);
        JScrollPane sp = new JScrollPane(this.mTxtHtml);
        l.add((Component)sp, (GridBagConstraints)GridBagManager.FILLALL.noInsets());
        this.mXmlStruct = DbUtil.getStructure((Db)db);
        InputStream isXsl = this.getClass().getResourceAsStream("res/DbStructure.xsl");
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        AXslUtil.xslTransform((Node)this.mXmlStruct, (InputStream)isXsl, (OutputStream)os);
        String html = os.toString();
        this.mTxtHtml.setText(html);
        this.mTxtHtml.setCaretPosition(0);
    }

    public Element getXml() {
        return this.mXmlStruct;
    }

    public String getHtml() {
        return this.mTxtHtml.getText();
    }
}

