/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.dbui;

import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbClass;
import com.sigrity.acl.db.DbRelationDef;
import com.sigrity.acl.ui.graph.AGraphPanel;
import com.sigrity.tools.dbexplorer.DBEResources;
import edu.uci.ics.jung.algorithms.layout.CircleLayout;
import edu.uci.ics.jung.algorithms.layout.FRLayout;
import edu.uci.ics.jung.algorithms.layout.FRLayout2;
import edu.uci.ics.jung.algorithms.layout.ISOMLayout;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.DirectedSparseMultigraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.visualization.renderers.DefaultVertexLabelRenderer;
import edu.uci.ics.jung.visualization.renderers.VertexLabelRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Paint;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JComponent;

public class DbStructureGraphPanel
extends AGraphPanel {
    protected DbStructureGraph mGraph;

    public DbStructureGraphPanel(Db db) {
        this(new DbStructureGraph(db));
        this.mViewer.getRenderContext().setVertexLabelRenderer((VertexLabelRenderer)new DefaultVertexLabelRenderer(Color.RED){

            public <V> Component getVertexLabelRendererComponent(JComponent vv, Object value, Font font, boolean isSelected, V vertex) {
                Component c = super.getVertexLabelRendererComponent(vv, value, font, isSelected, vertex);
                c.setFont(font.deriveFont(1));
                return c;
            }
        });
    }

    public DbStructureGraphPanel(DbStructureGraph graph) {
        super(new Layout[]{new CircleLayout((Graph)graph.getGraphModel()), new FRLayout((Graph)graph.getGraphModel()), new FRLayout2((Graph)graph.getGraphModel()), new ISOMLayout((Graph)graph.getGraphModel())});
        this.mGraph = graph;
    }

    public static class DbStructGraphModel
    extends DirectedSparseMultigraph<AGraphPanel.GPVertex, AGraphPanel.GPEdge> {
        protected HashMap<DbClass, DbClassVertex> mClass2Vertex = new HashMap();

        public DbClassVertex addDbClass(DbClass dbc) {
            DbClassVertex dbcv = new DbClassVertex(dbc);
            this.addVertex(dbcv);
            this.mClass2Vertex.put(dbc, dbcv);
            return dbcv;
        }

        public DbRelationEdge addRelation(DbRelationDef dbrd) {
            DbRelationEdge dbre = new DbRelationEdge(dbrd);
            DbClass classL = dbrd.getDbClassL();
            DbClassVertex vL = this.mClass2Vertex.get(classL);
            DbClass classR = dbrd.getDbClassR();
            DbClassVertex vR = classR == null ? new DbClassVertexGeneric() : this.mClass2Vertex.get(classR);
            this.addEdge(dbre, vL, vR);
            return dbre;
        }
    }

    public static class DbRelationEdge
    extends AGraphPanel.GPEdge {
        protected final DbRelationDef mDbRel;

        public DbRelationEdge(DbRelationDef dbrd) {
            this.mDbRel = dbrd;
        }

        @Override
        public String getLabel() {
            return this.mDbRel.getName();
        }
    }

    public static class DbClassVertexGeneric
    extends DbClassVertex {
        public DbClassVertexGeneric() {
            super(null);
        }

        @Override
        public String getLabel() {
            return "[Run-time Class]";
        }
    }

    public static class DbClassVertex
    extends AGraphPanel.GPVertex {
        protected DbClass mDbClass;

        public DbClassVertex(DbClass c) {
            this.mDbClass = c;
        }

        public DbClass getDbClass() {
            return this.mDbClass;
        }

        @Override
        public String getLabel() {
            return this.mDbClass.getName();
        }

        @Override
        public Paint getPaint() {
            if (this.mDbClass != null) {
                return Color.WHITE;
            }
            return Color.LIGHT_GRAY;
        }

        @Override
        public Icon getIcon() {
            if (this.mDbClass != null) {
                return DBEResources.ICON_DBCLASS;
            }
            return DBEResources.ICON_UNKNOWN;
        }
    }

    public static class DbStructureGraph {
        protected DbStructGraphModel mModel = new DbStructGraphModel();

        public DbStructureGraph(Db db) {
            for (DbClass dbc : db.getDbClasses()) {
                this.mModel.addDbClass(dbc);
            }
            for (DbRelationDef dbrd : db.getRelations()) {
                this.mModel.addRelation(dbrd);
            }
        }

        public DbStructGraphModel getGraphModel() {
            return this.mModel;
        }
    }
}

