/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.dbui;

import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.ALog;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.dbui.DbStructureDescPanel;
import com.sigrity.acl.dbui.DbStructureGraphPanel;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.AFileChooser;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.acl.xml.AXDomUtil;
import com.sigrity.orbit.OrbitIO;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JTabbedPane;
import javax.swing.filechooser.FileFilter;
import org.w3c.dom.Node;

public class DbStructureUI
extends ADialog {
    protected JTabbedPane mTabs;
    protected DbStructureDescPanel mDescPanel;
    protected DbStructureGraphPanel mGraphPanel;
    protected ActionListener mSave = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            AFileChooser fc = new AFileChooser();
            AFileFilter ffHtml = AFileFilter.HTML;
            fc.addChoosableFileFilter((FileFilter)AFileFilter.HTML);
            fc.addChoosableFileFilter((FileFilter)AFileFilter.XML);
            fc.setAcceptAllFileFilterUsed(false);
            fc.setFileFilter((FileFilter)ffHtml);
            int result = fc.showSaveDialog((Component)((Object)DbStructureUI.this));
            if (result != 0) {
                return;
            }
            File file = fc.getSelectedFile();
            try (FileWriter ofw = new FileWriter(file);){
                if (fc.getFileFilter() == ffHtml) {
                    ofw.write(DbStructureUI.this.mDescPanel.getHtml());
                } else {
                    String xml = AXDomUtil.serialize((Node)DbStructureUI.this.mDescPanel.getXml());
                    ofw.write(xml);
                }
            }
            catch (IOException ioe) {
                ALog.logError((Throwable)ioe, (String)"Error writing to file '%s'.", (Object[])new Object[0]);
            }
        }
    };

    public static void showUI() {
        DbStructureUI.show(null, null);
    }

    public static void show(Db db, Component owner) {
        if (db == null) {
            db = OrbitIO.getCurDb();
        }
        if (owner == null) {
            owner = OrbitIO.getMainWindow();
        }
        if (db == null) {
            ALog.logError((String)"No database.");
            return;
        }
        DbStructureUI dlg = new DbStructureUI(db, owner);
        dlg.setVisible(true);
    }

    public DbStructureUI(Db db, Component owner) {
        super(owner);
        this.setTitle("Database Structure");
        GridBagManager l = GridBagManager.layout((Container)this.getContentPane());
        this.mTabs = (JTabbedPane)l.add((Component)new JTabbedPane(), (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
        this.mDescPanel = new DbStructureDescPanel(db);
        this.mTabs.addTab("Description", this.mDescPanel);
        this.mGraphPanel = new DbStructureGraphPanel(db);
        this.mTabs.addTab("Graph", this.mGraphPanel);
        l.newline();
        l.push((GridBagConstraints)GridBagManager.FILLX_REMAINX.noInsets());
        l.addFillX();
        JButton btnSave = (JButton)l.add((Component)new JButton("Save"), (GridBagConstraints)GridBagManager.RIGHT);
        btnSave.addActionListener(this.mSave);
        JButton btnClose = (JButton)l.add((Component)new JButton("Close"), (GridBagConstraints)GridBagManager.RIGHT);
        l.pop();
        this.pack();
        UIUtil.center((Component)((Object)this));
        UIUtil.enableEscapeClose((Window)((Object)this), (AbstractButton)btnClose);
        UIUtil.enforceDialogMinSize((Window)((Object)this));
    }
}

