/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.dbui;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.SelectionContext;
import com.sigrity.acl.db.SelectionCriteria;
import com.sigrity.acl.db.Selectors;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.dbui.MovingSet;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.ui.log.ALogHelper;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.HierPortShape;
import com.sigrity.orbit.HierShape;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.canvas_views.DefaultViewDrawer;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.core.ViewColorizer;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.LinkedList;
import java.util.List;

public class MoveAuxiliaryAdapter
implements MovingSet.MovingSetListener {
    static final List<AuxiliaryLine> sAuxiliary = new LinkedList<AuxiliaryLine>();

    public static List<AuxiliaryLine> getAuxiliary() {
        return sAuxiliary;
    }

    @Override
    public String validToMove(MovingSet movingSet, String objectType) {
        return movingSet.verifyOkToMove(objectType);
    }

    @Override
    public APoint2D chooseOrigin(MovingSet movingSet, APoint2D cursorLoc) {
        APoint2D anchor = this.getReferAnchor(movingSet, cursorLoc, STATUS.CHOOSE_ORIGIN);
        if (anchor != null) {
            return anchor;
        }
        return cursorLoc;
    }

    @Override
    public boolean drawBackground(MovingSet movingSet, Graphics2D g, Rectangle bounds, DesignView2D view) {
        return true;
    }

    @Override
    public boolean drawDbObject(MovingSet movingSet, DevicePath devPath, DbObject dbo, DefaultViewDrawer viewDrawer, Graphics2D g) {
        movingSet.drawDbObject(devPath, dbo, viewDrawer, g);
        return true;
    }

    @Override
    public boolean isValidLoc(MovingSet movingSet) {
        sAuxiliary.clear();
        if (!(OrbitIO.getCurView() instanceof DesignView2D)) {
            return true;
        }
        DesignView2D dv2d = (DesignView2D)OrbitIO.getCurView();
        DesignCanvas2D.XForm xform = dv2d.getCanvas().getXForm();
        long fuzzyRange = xform.getWorldLength(4);
        ARect visibleBB = dv2d.getCanvas().getVisibleBounds();
        long region = Math.max(visibleBB.width(), visibleBB.height());
        Selection.SelSet selSet = movingSet.getSelSet();
        APoint2D anchor = this.getReferAnchor(movingSet, movingSet.mCursorLoc, STATUS.PICKING);
        if (anchor != null && anchor.distance(movingSet.mCursorLoc) < fuzzyRange) {
            long ext = fuzzyRange * 4L;
            AuxiliaryLine l = new AuxiliaryLine(new ALine(anchor.add(ext, 0L), anchor.add(-ext, 0L)), anchor);
            l.prefer = true;
            l.ans = anchor;
            sAuxiliary.add(l);
            l = new AuxiliaryLine(new ALine(anchor.add(0L, ext), anchor.add(0L, -ext)), anchor);
            l.prefer = true;
            l.ans = anchor;
            sAuxiliary.add(l);
            l = new AuxiliaryLine(new ALine(anchor.add(ext, ext), anchor.add(-ext, -ext)), anchor);
            l.prefer = true;
            l.ans = anchor;
            sAuxiliary.add(l);
            l = new AuxiliaryLine(new ALine(anchor.add(ext, -ext), anchor.add(-ext, ext)), anchor);
            l.prefer = true;
            l.ans = anchor;
            sAuxiliary.add(l);
            return false;
        }
        for (HierInst hierInst : selSet.getHierInsts()) {
            this.findAuxiliary(fuzzyRange, region, (HierInst<DbObject>)hierInst, movingSet, movingSet.mCursorLoc);
        }
        return sAuxiliary.isEmpty();
    }

    private APoint2D getReferAnchor(MovingSet movingSet, APoint2D cursorLoc, STATUS status) {
        APoint2D pt;
        APoint2D aPoint2D = pt = cursorLoc != null ? cursorLoc : movingSet.mStartLoc;
        if (pt == null) {
            return null;
        }
        Db db = OrbitIO.getCurDb();
        DesignView2D dv2d = (DesignView2D)OrbitIO.getCurView();
        ARect area = new ARect(pt, pt);
        SelectionCriteria criteria = new SelectionCriteria();
        criteria.clearFilters();
        criteria.clearPropertyFilters();
        criteria.setSelArea((AGeom)area);
        criteria.setNetFilterConsidersConnectedNets(false);
        criteria.setMode(Selection.Mode.Replace);
        SelectionContext selCtx = SelectionContext.create((Db)db);
        selCtx.setNetFiltersMatchMapped(false);
        selCtx.setSubstrate(null);
        Selectors.ShapeSelector s = new Selectors.ShapeSelector(selCtx);
        ViewColorizer colorizer = dv2d.getColorizer();
        Selectors.VisibleItemFilter filter = new Selectors.VisibleItemFilter(colorizer);
        HierInst bestChoice = null;
        for (HierInst hw : s.getMatching((AGeom)area, Selection.AreaMode.Touch, criteria.getPropertyFilters(), (Selection.Filter)filter)) {
            if (!(hw.getDbObject() instanceof LayerShape)) continue;
            bestChoice = bestChoice == null ? hw : s.getBetter(bestChoice, hw, area);
        }
        if (!HierShape.class.isInstance(bestChoice)) {
            return null;
        }
        HierShape hiShape = (HierShape)HierShape.cast(bestChoice);
        if (hiShape.getOwner() instanceof PortTemplate) {
            PortTemplate port = (PortTemplate)hiShape.getOwner();
            HierPortShape pshape = new HierPortShape(hiShape.getPath(), port, (LayerShape)hiShape.getDbObject());
            APoint2D center = pshape.getCenter();
            if (status == STATUS.CHOOSE_ORIGIN) {
                ALog.flogInfo((String)"Pick the center of %s shape", (Object[])new Object[]{ALogHelper.createSelectElement((HierInst<DbObject>)HierInst.create((DevicePath)hiShape.getPath(), (DbObject)port), String.format("port %s (%s)", port, hiShape.getPath()))});
            }
            return center;
        }
        return null;
    }

    private APoint2D findAuxiliary(long fuzzyRange, long region, HierInst<DbObject> hierInst, MovingSet movingSet, APoint2D cursorLoc) {
        DevicePath path = hierInst.getPath();
        DbObject dbo = hierInst.getDbObject();
        ARect bb = movingSet.getDesignBB(path, dbo);
        DevicePath banPath = dbo instanceof Device ? path.addPath(new DevicePath((Device)dbo)) : path;
        DevicePath substratePath = path.pathToSubstrate();
        for (DevicePath instPath : substratePath.getDescendants()) {
            long x;
            long y;
            if (instPath.isChildOf(banPath)) continue;
            ARect devBB = instPath.getBB();
            long lx = Math.min(devBB.left(), bb.left());
            long ly = Math.min(devBB.bottom(), bb.bottom());
            long rx = Math.max(devBB.right(), bb.right());
            long ry = Math.max(devBB.top(), bb.top());
            if (rx - lx - devBB.width() - bb.width() > region || ry - ly - devBB.height() - bb.height() > region) continue;
            long dx = 0L;
            long dy = 0L;
            dx = 0L;
            if (Math.abs(devBB.top() - bb.top()) < fuzzyRange) {
                dy = devBB.top() - bb.top();
                y = devBB.top();
                sAuxiliary.add(new AuxiliaryLine(new ALine(lx, y, rx, y), cursorLoc.sub(new APoint2D(-dx, -dy))));
            }
            if (Math.abs(devBB.top() - bb.bottom()) < fuzzyRange) {
                dy = devBB.top() - bb.bottom();
                y = devBB.top();
                sAuxiliary.add(new AuxiliaryLine(new ALine(lx, y, rx, y), cursorLoc.sub(new APoint2D(-dx, -dy))));
            }
            if (Math.abs(devBB.bottom() - bb.top()) < fuzzyRange) {
                dy = devBB.bottom() - bb.top();
                y = devBB.bottom();
                sAuxiliary.add(new AuxiliaryLine(new ALine(lx, y, rx, y), cursorLoc.sub(new APoint2D(-dx, -dy))));
            }
            if (Math.abs(devBB.bottom() - bb.bottom()) < fuzzyRange) {
                dy = devBB.bottom() - bb.bottom();
                y = devBB.bottom();
                sAuxiliary.add(new AuxiliaryLine(new ALine(lx, y, rx, y), cursorLoc.sub(new APoint2D(-dx, -dy))));
            }
            dy = 0L;
            if (Math.abs(devBB.left() - bb.left()) < fuzzyRange) {
                dx = devBB.left() - bb.left();
                x = devBB.left();
                sAuxiliary.add(new AuxiliaryLine(new ALine(x, ly, x, ry), cursorLoc.sub(new APoint2D(-dx, -dy))));
            }
            if (Math.abs(devBB.left() - bb.right()) < fuzzyRange) {
                dx = devBB.left() - bb.right();
                x = devBB.left();
                sAuxiliary.add(new AuxiliaryLine(new ALine(x, ly, x, ry), cursorLoc.sub(new APoint2D(-dx, -dy))));
            }
            if (Math.abs(devBB.right() - bb.left()) < fuzzyRange) {
                dx = devBB.right() - bb.left();
                x = devBB.right();
                sAuxiliary.add(new AuxiliaryLine(new ALine(x, ly, x, ry), cursorLoc.sub(new APoint2D(-dx, -dy))));
            }
            if (Math.abs(devBB.right() - bb.right()) >= fuzzyRange) continue;
            dx = devBB.right() - bb.right();
            x = devBB.right();
            sAuxiliary.add(new AuxiliaryLine(new ALine(x, ly, x, ry), cursorLoc.sub(new APoint2D(-dx, -dy))));
        }
        if (sAuxiliary.isEmpty()) {
            return cursorLoc;
        }
        return this.pickPrefer(cursorLoc);
    }

    private APoint2D pickPrefer(APoint2D cursorLoc) {
        long dy;
        long dx;
        long distX = Long.MAX_VALUE;
        long distY = Long.MAX_VALUE;
        APoint2D pick = cursorLoc;
        for (AuxiliaryLine l : sAuxiliary) {
            dx = l.updateLoc.getX() - cursorLoc.getX();
            dy = l.updateLoc.getY() - cursorLoc.getY();
            if (dx == 0L && Math.abs(dy) < Math.abs(distY)) {
                distY = dy;
            }
            if (dy != 0L || Math.abs(dx) >= Math.abs(distX)) continue;
            distX = dx;
        }
        if (distX == Long.MAX_VALUE) {
            distX = 0L;
        }
        if (distY == Long.MAX_VALUE) {
            distY = 0L;
        }
        pick = pick.add(distX, distY);
        for (AuxiliaryLine l : sAuxiliary) {
            dx = l.updateLoc.getX() - cursorLoc.getX();
            dy = l.updateLoc.getY() - cursorLoc.getY();
            if (dx != 0L && dx == distX) {
                l.prefer = true;
            }
            if (dy != 0L && dy == distY) {
                l.prefer = true;
            }
            if (distX == 0L && distY == 0L && dx == 0L && dy == 0L) {
                l.prefer = true;
            }
            l.ans = pick;
        }
        return pick.add(distX, distY);
    }

    @Override
    public APoint2D adjustLoc(MovingSet movingSet, APoint2D prevValidLoc) {
        for (AuxiliaryLine l : sAuxiliary) {
            if (!l.prefer) continue;
            return l.ans;
        }
        return prevValidLoc;
    }

    @Override
    public float bestRot(MovingSet movingSet) {
        return movingSet.bestRotMinCrossingsAndLength();
    }

    @Override
    public boolean place(MovingSet movingSet, boolean allowHierarchyChange, boolean smartAlign) {
        return movingSet.place(allowHierarchyChange, smartAlign);
    }

    @Override
    public boolean drawDynamicConnections() {
        return true;
    }

    @Override
    public int getPriority() {
        return -1;
    }

    static enum STATUS {
        CHOOSE_ORIGIN,
        PICKING;

    }

    public static class AuxiliaryLine {
        private final ALine l;
        private final APoint2D updateLoc;
        private boolean prefer;
        private APoint2D ans;

        AuxiliaryLine(ALine l, APoint2D updateLoc) {
            this.l = l;
            this.updateLoc = updateLoc;
        }

        public ALine getLine() {
            return this.l;
        }

        public boolean isPreferred() {
            return this.prefer;
        }
    }
}

