/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.dbui;

import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.AclInfo;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbFieldDef;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Connection;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Floorplan;
import com.sigrity.acl.db.std.FloorplanPin;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PersonalityMap;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.db.std.Text;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.dbui.MoveAnywhereAdapter;
import com.sigrity.acl.dbui.MoveAuxiliaryAdapter;
import com.sigrity.acl.dbui.MoveInsideParentAdapter;
import com.sigrity.acl.dbui.MoveOrthogonalAdapter;
import com.sigrity.acl.dbui.MoveSnapAdapter;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.transformers.Rotater;
import com.sigrity.eda.NetCutManager;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.OrbitGridUtil;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.UserCommands;
import com.sigrity.orbit.automation.BundleMover;
import com.sigrity.orbit.ui.ObjectCopyOrMoveUI;
import com.sigrity.orbit.ui.PlaceableItemUI;
import com.sigrity.orbit.ui.canvas_modes.SpotLight;
import com.sigrity.orbit.ui.canvas_views.DefaultViewDrawer;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.core.ViewColorizer;
import com.sigrity.orbit.util.PhysicalNetUtil;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class MovingSet {
    public static final String FLD_PINMAP = "pinMap";
    protected Selection.SelSet selSet = null;
    protected Selection.SelSet dynamicDrawingSet = null;
    protected DevicePath mCommonParentDevicePath = null;
    protected APoint2D mStartLoc = new APoint2D();
    protected APoint2D mCursorLoc = new APoint2D();
    protected APoint2D mLoc = null;
    protected ARect mBBoxRelativeToZero = null;
    protected boolean mMirrorAboutX = false;
    protected boolean mMirrorAboutY = false;
    protected boolean mMirrorInverted = false;
    protected float mRotate = 0.0f;
    protected AffineTransform userRequestedTransform = null;
    protected boolean objectsAreCopy = false;
    protected List<Net> mNetsList = null;
    protected APair<DevicePath, DbObject> mCurRefObj = null;
    protected DesignView2D mView = null;
    protected static PropertyChangeListener mColorizerListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if (prop != null && prop.startsWith("Visible:LayerKey")) {
                MovingSet.setPinMap(((DesignView2D)OrbitIO.getCurView()).getDb(), null);
            }
        }
    };
    protected static OrbitApp.CurrentDbListener mDbListener = new OrbitApp.CurrentDbListener(){

        public void currentDbChanged(Db newDb) {
            MovingSet.setPinMap(newDb, null);
        }
    };
    static Floorplan mMovingFloorplan = null;
    protected static LinkedList<MovingSetListener> sMovePOListeners = new LinkedList();
    static MoveInsideParentAdapter restrictAdaptor = null;
    static MoveOrthogonalAdapter orthogonalAdaptor = null;
    static MoveAuxiliaryAdapter auxiliaryAdapter = null;
    static MoveSnapAdapter snapAdapter = null;
    static CopyPersonalityAdapter copyPersonalityAdaptor = null;
    static MoveFloorplanAdapter moveFloorplanAdaptor = null;

    public MovingSet(boolean init) {
        if (init) {
            sMovePOListeners = new LinkedList();
        }
        if (sMovePOListeners.isEmpty()) {
            MovingSet.addMovingListener(new MoveAnywhereAdapter());
        }
        this.mLoc = null;
        this.mView = null;
        this.userRequestedTransform = new AffineTransform();
    }

    public MovingSet(Selection.SelSet s) {
        if (sMovePOListeners.isEmpty()) {
            MovingSet.addMovingListener(new MoveAnywhereAdapter());
        }
        this.selSet = this.dynamicDrawingSet = s;
        this.mCommonParentDevicePath = s.getCommonParentDevicePath();
        this.userRequestedTransform = new AffineTransform();
        this.mView = null;
    }

    public String verifyOkToMove(String objectType) {
        if (objectType.equals("Pin Personality") || objectType.equals("Floorplan")) {
            return null;
        }
        if (this.getSelSet().getDevicePathIfOnlyOne() == null) {
            return "Can not move " + objectType + "s from different parents";
        }
        return null;
    }

    public void rotateAndMirror() {
        AffineTransform mirror;
        APoint2D anchor = this.getLoc(null);
        this.userRequestedTransform.setToIdentity();
        this.userRequestedTransform.rotate(Math.toRadians(this.mRotate), anchor.getX(), anchor.getY());
        if (this.mMirrorAboutY) {
            mirror = new AffineTransform(-1.0, 0.0, 0.0, 1.0, (double)(2L * anchor.getX()), 0.0);
            this.userRequestedTransform.concatenate(mirror);
        }
        if (this.mMirrorAboutX) {
            mirror = new AffineTransform(1.0, 0.0, 0.0, -1.0, 0.0, (double)(2L * anchor.getY()));
            this.userRequestedTransform.concatenate(mirror);
        }
    }

    public void rotateAndMirror(float rot, boolean mirrorX, boolean mirrorY) {
        this.mRotate = !this.mMirrorInverted && !mirrorX && !mirrorY ? (360.0f - rot) % 360.0f : (!this.mMirrorInverted && mirrorX && mirrorY ? (360.0f - rot) % 360.0f : rot);
        if ((Math.abs(rot - 90.0f) < 1.0E-4f || Math.abs(rot - 270.0f) < 1.0E-4f) && !this.mMirrorInverted && (this.mMirrorAboutX || this.mMirrorAboutY)) {
            this.mMirrorAboutX = mirrorY;
            this.mMirrorAboutY = mirrorX;
            this.mMirrorInverted = true;
        } else {
            this.mMirrorAboutX = mirrorX;
            this.mMirrorAboutY = mirrorY;
            this.mMirrorInverted = false;
        }
        this.rotateAndMirror();
    }

    public void setNetsList(List<Net> list) {
        this.mNetsList = list;
    }

    public boolean getObjectsAreCopy() {
        return this.objectsAreCopy;
    }

    public void setObjectsAreCopy(boolean val) {
        this.objectsAreCopy = val;
    }

    public void setSelSet(Selection.SelSet selSet) {
        this.setSelSet(selSet, null);
    }

    public void setSelSet(Selection.SelSet selSet, APoint2D moveStartLoc) {
        this.dynamicDrawingSet = moveStartLoc == null ? selSet : selSet.ensureAllPathsAreAbsolute(moveStartLoc);
        this.selSet = this.dynamicDrawingSet;
        this.mLoc = null;
        this.mCommonParentDevicePath = selSet.getCommonParentDevicePath();
        this.userRequestedTransform = new AffineTransform();
    }

    public Selection.SelSet getSelSet() {
        if (this.selSet == null) {
            this.selSet = this.dynamicDrawingSet = new Selection.SelSet();
        }
        return this.selSet;
    }

    public void setDynamicDrawingSet(Selection.SelSet val) {
        this.dynamicDrawingSet = val;
    }

    public Selection.SelSet getDynamicDrawingSet() {
        return this.dynamicDrawingSet;
    }

    public void setView(DesignView2D view) {
        this.mView = view;
    }

    public static Selection.SelSet addAttachedToDrawingSet(Selection.SelSet dynamicDrawSet) {
        if (dynamicDrawSet == null) {
            return dynamicDrawSet;
        }
        HashSet objs = new HashSet();
        for (HierInst hierInst : dynamicDrawSet.getHierInsts()) {
            PhysicalNetUtil.getPhysAndExternallyConnected((PinInstance)((PinInstance)hierInst.getDbObject()), (DevicePath)hierInst.getPath(), objs);
        }
        Selection.SelSet ans = new Selection.SelSet();
        for (HierInst netObj : objs) {
            ans.add(netObj);
        }
        return ans;
    }

    public ARect getBB() {
        ARect ans = this.selSet.getBB();
        if (ans == null) {
            return ans;
        }
        return ans.transform(this.userRequestedTransform).getBounds();
    }

    APoint2D chooseOriginLLOrFirstLoc(APoint2D cursorLoc) {
        APoint2D ans = null;
        long bestDist = 0L;
        this.mCurRefObj = null;
        if (cursorLoc != null) {
            for (APair thePair : this.getSelSet().getElements()) {
                ARect bbox = ((DevicePath)thePair.first).getBBOfChildObj((DbObject)thePair.second, true);
                if (bbox.contains(cursorLoc)) {
                    this.mCurRefObj = thePair;
                    ans = this.getAdjustedLoc((DevicePath)thePair.first, (DbObject)thePair.second);
                    return ans;
                }
                long dist = bbox.distance(cursorLoc);
                if (bestDist != 0L && dist >= bestDist) continue;
                bestDist = dist;
                this.mCurRefObj = thePair;
            }
        }
        if (this.selSet.size() == 1) {
            APair thePair;
            this.mCurRefObj = thePair = (APair)this.selSet.getElements().next();
            ans = this.getAdjustedLoc((DevicePath)thePair.first, (DbObject)thePair.second);
        } else {
            ans = cursorLoc != null ? this.getAdjustedLoc((DevicePath)this.mCurRefObj.first, (DbObject)this.mCurRefObj.second) : this.getBB().getLL().copy();
        }
        return ans;
    }

    public void updateBBoxRelativeToZero() {
        if (this.mLoc != null) {
            this.mBBoxRelativeToZero = this.getBB();
            this.mBBoxRelativeToZero.moveBy(-this.mLoc.getX(), -this.mLoc.getY());
        }
    }

    public APoint2D getLoc(APoint2D cursorLoc) {
        if (this.mLoc == null) {
            this.selSet = this.selSet.ensureAllPathsAreAbsolute(cursorLoc);
            this.mLoc = MovingSet.fireChooseOrigin(this, cursorLoc);
            this.mBBoxRelativeToZero = this.getBB();
            this.mBBoxRelativeToZero.moveBy(-this.mLoc.getX(), -this.mLoc.getY());
        }
        return this.mLoc;
    }

    public APoint2D getLocAdjustment(double angle) {
        if (angle == 90.0) {
            return new APoint2D(0L, this.getBB().height());
        }
        if (angle == 180.0) {
            return new APoint2D(this.getBB().width(), 0L);
        }
        if (angle == 270.0) {
            return new APoint2D(0L, -this.getBB().height());
        }
        return new APoint2D(0L, 0L);
    }

    public APoint2D getStartLoc() {
        return this.mStartLoc;
    }

    public void initialize() {
        this.mMirrorAboutX = false;
        this.mMirrorAboutY = false;
        this.mMirrorInverted = false;
        this.mRotate = 0.0f;
        this.setStartLoc(0L, 0L);
    }

    public void setStartLoc(long x, long y) {
        this.mStartLoc.setLoc(x, y);
    }

    private void drawDevice(DevicePath devPath, Device device, DefaultViewDrawer viewDrawer, Graphics2D g, AffineTransform parentXForm) {
        DevicePath path = new DevicePath(devPath, device);
        try {
            DefaultViewDrawer.DeviceDrawer dd = viewDrawer.getDeviceDrawer(path, parentXForm, null);
            dd.setGraphics(g);
            dd.draw(true);
        }
        catch (Exception e) {
            ALog.logError((Throwable)e, (String)"Unexpected error while drawing a device.", (Object[])new Object[0]);
        }
    }

    private void drawPin(DevicePath devPath, PinInstance pin, DefaultViewDrawer viewDrawer, Graphics2D g, AffineTransform parentXForm) {
        try {
            DefaultViewDrawer.DeviceDrawer dd = viewDrawer.getDeviceDrawer(devPath, parentXForm, null);
            dd.setGraphics(g);
            dd.drawPin(pin, true);
        }
        catch (Exception e) {
            ALog.logError((Throwable)e, (String)"Unexpected error while drawing a pin.", (Object[])new Object[0]);
        }
    }

    private void drawWire(DevicePath devPath, Wire wire, DefaultViewDrawer viewDrawer, Graphics2D g, AffineTransform parentXForm) {
        try {
            DefaultViewDrawer.DeviceDrawer dd = viewDrawer.getDeviceDrawer(devPath, parentXForm, null);
            dd.setGraphics(g);
            dd.drawWire(wire, true);
        }
        catch (Exception e) {
            ALog.logError((Throwable)e, (String)"Unexpected error while drawing a wire.", (Object[])new Object[0]);
        }
    }

    private void drawFloorplan(DevicePath devPath, Floorplan floorplan, DefaultViewDrawer viewDrawer, Graphics2D g, AffineTransform parentXForm) {
        try {
            DefaultViewDrawer.DrawContext drawContext = new DefaultViewDrawer.DrawContext(viewDrawer.getCanvas());
            drawContext.setGMain(g);
            viewDrawer.drawFloorplan(drawContext, floorplan, devPath, parentXForm, PlaceableItemUI.getIncludeNonIOPins(), true);
        }
        catch (Exception e) {
            ALog.logError((Throwable)e, (String)"Unexpected error while drawing a floorplan.", (Object[])new Object[0]);
        }
    }

    private void drawTextHtml(DevicePath devPath, Text text, DefaultViewDrawer viewDrawer, Graphics2D g, AffineTransform parentXForm) {
        try {
            DefaultViewDrawer.DeviceDrawer dd = viewDrawer.getDeviceDrawer(devPath, parentXForm, null);
            dd.setGraphics(g);
            dd.drawText(text, true);
        }
        catch (Exception e) {
            ALog.logError((Throwable)e, (String)"Unexpected error while drawing a text.", (Object[])new Object[0]);
        }
    }

    void drawDbObject(DevicePath devPath, DbObject dbo, DefaultViewDrawer viewDrawer, Graphics2D g) {
        if (dbo instanceof Device) {
            AffineTransform localTrans = devPath.getTransform();
            localTrans.preConcatenate(this.userRequestedTransform);
            this.drawDevice(devPath, (Device)dbo, viewDrawer, g, localTrans);
        } else if (dbo instanceof PinInstance) {
            AffineTransform localTrans = devPath.getParent().getTransform();
            localTrans.preConcatenate(this.userRequestedTransform);
            this.drawPin(devPath, (PinInstance)dbo, viewDrawer, g, localTrans);
        } else if (dbo instanceof PinTemplate) {
            AffineTransform localTrans = this.getLocalTrans(devPath);
            PinInstance pinInst = ((PinTemplate)dbo).getPinInstance(devPath);
            if (pinInst != null) {
                this.drawPin(devPath, pinInst, viewDrawer, g, localTrans);
            }
        } else if (dbo instanceof Text) {
            AffineTransform localTrans = devPath.getParent().getTransform();
            localTrans.preConcatenate(this.userRequestedTransform);
            this.drawTextHtml(devPath, (Text)dbo, viewDrawer, g, localTrans);
        } else if (dbo instanceof Wire) {
            AffineTransform localTrans = devPath.getTransform();
            localTrans.preConcatenate(this.userRequestedTransform);
            this.drawWire(devPath, (Wire)dbo, viewDrawer, g, localTrans);
        } else if (AclInfo.getDebugMode()) {
            ALog.logDebug((Throwable)new Throwable(), (String)"Unsupport: draw object '%s'", (Object[])new Object[]{dbo});
        }
    }

    protected AffineTransform getLocalTrans(DevicePath devPath) {
        AffineTransform localTrans = devPath.getParent() == null ? new AffineTransform() : devPath.getParent().getTransform();
        localTrans.preConcatenate(this.userRequestedTransform);
        return localTrans;
    }

    private void drawDbObjectFloorplan(DevicePath devPath, DbObject dbo, DefaultViewDrawer viewDrawer, Graphics2D g) {
        if (dbo instanceof PinInstance) {
            AffineTransform localTrans = devPath.getParent().getTransform();
            localTrans.preConcatenate(this.userRequestedTransform);
            this.drawPin(devPath, (PinInstance)dbo, viewDrawer, g, localTrans);
        } else if (dbo instanceof Floorplan) {
            this.drawFloorplan(devPath, (Floorplan)dbo, viewDrawer, g, this.userRequestedTransform);
        }
    }

    public void draw(DefaultViewDrawer viewDrawer, Graphics2D g) {
        for (APair thePair : this.getDynamicDrawingSet().getElements()) {
            MovingSet.fireDrawDbObject(this, (DevicePath)thePair.first, (DbObject)thePair.second, viewDrawer, g);
        }
    }

    private APoint2D getStartLoc(DevicePath devPath, DbObject object) {
        DevicePath path = devPath;
        if (object instanceof Device) {
            path = new DevicePath(devPath, (Device)object);
        }
        return path.getLoc(object);
    }

    private APoint2D getRelativeLoc(DevicePath devPath, DbObject object) {
        return this.getStartLoc(devPath, object).sub(this.mStartLoc);
    }

    private APoint2D getAdjustedLoc(DevicePath devPath, DbObject object) {
        return this.getRelativeLoc(devPath, object);
    }

    public APoint2D getDesignLocation(DevicePath devPath, DbObject object) {
        AffineTransform mirror;
        APoint2D delta = this.mCursorLoc.sub(this.mStartLoc);
        AffineTransform localTransform = new AffineTransform();
        localTransform.setToIdentity();
        localTransform.rotate(Math.toRadians(this.mRotate), this.mStartLoc.getX(), this.mStartLoc.getY());
        if (this.mMirrorAboutY) {
            mirror = new AffineTransform(-1.0, 0.0, 0.0, 1.0, (double)(2L * this.mStartLoc.getX()), 0.0);
            localTransform.concatenate(mirror);
        }
        if (this.mMirrorAboutX) {
            mirror = new AffineTransform(1.0, 0.0, 0.0, -1.0, 0.0, 2.0 * (double)this.mStartLoc.getY());
            localTransform.concatenate(mirror);
        }
        APoint2D startLoc = this.getStartLoc(devPath, object);
        return startLoc.transform(localTransform).add(delta);
    }

    public double getDesignRotation(DevicePath devPath, DbObject object) {
        if (object instanceof Device) {
            return Math.toRadians(this.mRotate + (360.0f - ((Device)object).getWorldRotation(devPath))) % 360.0;
        }
        if (object instanceof PinInstance) {
            return Math.toRadians(this.mRotate + (360.0f - ((PinInstance)object).getWorldRotation(devPath))) % 360.0;
        }
        return 0.0;
    }

    public ARect getDesignBB(DevicePath devPath, DbObject object) {
        AffineTransform mirror;
        ARect originBB = devPath.getBBOfChildObj(object, false);
        if (originBB == null) {
            return null;
        }
        APoint2D delta = this.mCursorLoc.sub(this.mStartLoc);
        AffineTransform localTransform = new AffineTransform();
        localTransform.rotate(Math.toRadians(this.mRotate), this.mStartLoc.getX(), this.mStartLoc.getY());
        if (this.mMirrorAboutY) {
            mirror = new AffineTransform(-1.0, 0.0, 0.0, 1.0, (double)(2L * this.mStartLoc.getX()), 0.0);
            localTransform.concatenate(mirror);
        }
        if (this.mMirrorAboutX) {
            mirror = new AffineTransform(1.0, 0.0, 0.0, -1.0, 0.0, 2.0 * (double)this.mStartLoc.getY());
            localTransform.concatenate(mirror);
        }
        AGeom g = originBB.transform(localTransform);
        g.moveBy(delta.getX(), delta.getY());
        return g.getBounds();
    }

    public ARect getDesignLocationOfBBox() {
        AffineTransform mirror;
        ARect ans = this.mBBoxRelativeToZero.copy();
        ans.moveBy(this.mCursorLoc);
        AffineTransform localTransform = new AffineTransform();
        localTransform.setToIdentity();
        localTransform.rotate(Math.toRadians(this.mRotate), this.mCursorLoc.getX(), this.mCursorLoc.getY());
        if (this.mMirrorAboutY) {
            mirror = new AffineTransform(-1.0, 0.0, 0.0, 1.0, (double)(2L * this.mCursorLoc.getX()), 0.0);
            localTransform.concatenate(mirror);
        }
        if (this.mMirrorAboutX) {
            mirror = new AffineTransform(1.0, 0.0, 0.0, -1.0, 0.0, (double)(2L * this.mCursorLoc.getY()));
            localTransform.concatenate(mirror);
        }
        ans = ans.transform(localTransform).getBounds();
        return ans;
    }

    public static boolean doPlace(boolean allowHierarchyChange, boolean smartAlign, float userPendingRot, boolean mirrorAboutX, boolean mirrorAboutY) {
        MovingSet movingSet = PlaceableItemUI.getMovingSet();
        DevicePath devPath = movingSet.getSelSet().getDevicePathIfOnlyOne();
        assert (devPath != null);
        boolean first = true;
        for (DbObject object : movingSet.getSelSet().getDbObjects()) {
            DbObject owner;
            float rot = userPendingRot;
            APoint2D startLoc = movingSet.getStartLoc(devPath, object);
            APoint2D curLoc = movingSet.getDesignLocation(devPath, object);
            if (object instanceof Device) {
                Device device = (Device)object;
                DevicePath path = new DevicePath(devPath, device);
                boolean deviceMirror = device.getMirror();
                if (mirrorAboutY) {
                    boolean bl = deviceMirror = !deviceMirror;
                }
                if (mirrorAboutX) {
                    deviceMirror = !deviceMirror;
                    rot = (180.0f + rot) % 360.0f;
                }
                if (devPath.getMirror() && userPendingRot % 180.0f != 0.0f) {
                    rot = (180.0f + rot) % 360.0f;
                }
                if (mirrorAboutX ^ mirrorAboutY && device.getRotate() % 180.0f != 0.0f) {
                    rot = (180.0f + rot) % 360.0f;
                }
                UserCommands.moveDevice(path.toString(), curLoc.getX(), curLoc.getY(), Float.valueOf(rot + device.getRotate()), deviceMirror, smartAlign, false, false, false, false, allowHierarchyChange);
                continue;
            }
            if (object instanceof PinInstance) {
                PinInstance pin = (PinInstance)object;
                PinTemplate pinT = pin.getPinTemplate();
                String objStr = pin.getPinTemplate().getKeyStr();
                if (first) {
                    ObjectCopyOrMoveUI.setObjectTypeString("pin");
                }
                if (movingSet.objectsAreCopy) {
                    ObjectCopyOrMoveUI.setCreateInstances(true);
                }
                first = false;
                curLoc = curLoc.sub(startLoc);
                ObjectCopyOrMoveUI.movePinRelative(devPath, objStr, curLoc.getX(), curLoc.getY(), rot, mirrorAboutX);
                pinT.setIsDynamic(false);
                continue;
            }
            if (!(object instanceof Text) || !((owner = ((Text)object).getOwner()) instanceof Device)) continue;
            APoint2D textLoc = Device.getALocRelativeToMeFromWorld((DevicePath)devPath, (APoint2D)new APoint2D(curLoc.getX(), curLoc.getY()));
            ((Text)object).setLoc(textLoc);
        }
        movingSet.setStartLoc(movingSet.mCursorLoc.getX(), movingSet.mCursorLoc.getY());
        movingSet.mLoc.setLoc(movingSet.mCursorLoc.getX(), movingSet.mCursorLoc.getY());
        return true;
    }

    public boolean place(boolean allowHierarchyChange, boolean smartAlign) {
        MovingSet movingSet = PlaceableItemUI.getMovingSet();
        return MovingSet.doPlace(allowHierarchyChange, smartAlign, (360.0f - this.mRotate) % 360.0f, movingSet.mMirrorAboutX, movingSet.mMirrorAboutY);
    }

    public long maxObjectSize() {
        long ans = 0L;
        for (DbObject object : this.getSelSet().getDbObjects()) {
            if (!(object instanceof PinInstance)) continue;
            APair info = ((PinInstance)object).getPinTemplate().getLargestGeom(null);
            ARect bounds = ((LayerShape)info.first).getBounds();
            long size = bounds.height();
            if (size > ans) {
                ans = size;
            }
            if ((size = bounds.width()) <= ans) continue;
            ans = size;
        }
        return ans;
    }

    public boolean okToCopyPersonalitiesToDifferentSubstrate() {
        int numMismatchSubstrates = 0;
        int numMissingSubstrateNames = 0;
        long snapDist = this.maxObjectSize() / 4L;
        Map<APair<DevicePath, DbObject>, HierInst<PinInstance>> srcAndDst = this.getClosestPins((IterableIterator<APair<DevicePath, DbObject>>)this.getSelSet().getElements(), snapDist);
        for (Map.Entry<APair<DevicePath, DbObject>, HierInst<PinInstance>> snd : srcAndDst.entrySet()) {
            Personality p;
            APair<DevicePath, DbObject> src = snd.getKey();
            PinInstance pin = (PinInstance)src.second;
            HierInst<PinInstance> closest = snd.getValue();
            if (closest.first == null || pin.getPinTemplate().getSubstrate() == ((PinInstance)closest.getDbObject()).getPinTemplate().getSubstrate()) continue;
            ALog.logDebug((String)("pin = " + pin.getName() + "(" + pin.getType() + ") closest = " + ((PinInstance)closest.getDbObject()).getName() + "(" + ((PinInstance)closest.getDbObject()).getType() + ")"));
            ALog.logDebug((String)("  pin = " + src + " closest = " + closest));
            ++numMismatchSubstrates;
            if (pin.getPersonality() == null || (p = (Personality)Personality.getPersonality((DeviceTemplate)((DevicePath)closest.first).getDeviceTemplate(), (Personality.Type)Personality.Type.PORT, (String)pin.getPersonality().getName()).orElse(null)) != null) continue;
            ++numMissingSubstrateNames;
        }
        if (numMismatchSubstrates == 0) {
            return true;
        }
        String msg = numMissingSubstrateNames > 0 ? numMismatchSubstrates + " pin(s) are on a different substrate than the associated source pin. " + numMissingSubstrateNames + " have personailty name(s) are that are missing on the destination substrate. Continue copy by using and creating the same personality names?" : numMismatchSubstrates + " pin(s) are on a different substrate than the associated source pin. Continue copy using the same personality names?";
        int answer = OrbitApp.showConfirmDialog((String)msg, (String)"Confirm Personality Copy", (int)3, (int)0);
        return answer == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean placePersonalities(boolean allowHierarchyChange, boolean smartAlign) {
        APoint2D curLoc;
        PinInstance pin;
        HierInst closest;
        boolean overwrite = PlaceableItemUI.getOverwriteExisting();
        long snapDist = this.maxObjectSize() / 4L;
        if (this.mCurRefObj != null && this.mCurRefObj.second != null && this.mCurRefObj.second instanceof PinInstance && (closest = (pin = (PinInstance)this.mCurRefObj.second).getClosestInst((DevicePath)this.mCurRefObj.first, curLoc = this.getDesignLocation((DevicePath)this.mCurRefObj.first, (DbObject)this.mCurRefObj.second), null, snapDist)) != null && closest.getDbObject() != null) {
            this.mCursorLoc = this.getStartLoc(closest.getPath(), closest.getDbObject());
        }
        if (!this.okToCopyPersonalitiesToDifferentSubstrate()) {
            return false;
        }
        boolean success = false;
        try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (String)"Copy Personalities");){
            Map<APair<DevicePath, DbObject>, HierInst<PinInstance>> srcAndDst = this.getClosestPins((IterableIterator<APair<DevicePath, DbObject>>)this.getSelSet().getElements(), snapDist);
            success = PersonalityMap.copyPersonalities(srcAndDst, (boolean)overwrite);
        }
        finally {
            OrbitApp.getApp().refreshCurrentView(false);
        }
        return success;
    }

    private Map<APair<DevicePath, DbObject>, HierInst<PinInstance>> getClosestPins(IterableIterator<APair<DevicePath, DbObject>> sourcePins, long snapDist) {
        HashMap<APair<DevicePath, DbObject>, HierInst<PinInstance>> closestPins = new HashMap<APair<DevicePath, DbObject>, HierInst<PinInstance>>();
        HashMap<String, HierInst<PinInstance>> pinMap = null;
        for (APair thePair : sourcePins) {
            if (!(thePair.second instanceof PinInstance)) continue;
            if (pinMap == null) {
                pinMap = MovingSet.getPinMap(((DevicePath)thePair.first).getDb());
            }
            APoint2D curLoc = this.getDesignLocation((DevicePath)thePair.first, (DbObject)thePair.second);
            PinInstance pin = (PinInstance)thePair.second;
            HierInst closest = pinMap != null ? MovingSet.getPinForLoc(pinMap, curLoc) : pin.getClosestInst((DevicePath)thePair.first, curLoc, this.getSelSet(), snapDist);
            if (closest == null || closest.getDbObject() == null) continue;
            closestPins.put((APair<DevicePath, DbObject>)thePair, (HierInst<PinInstance>)closest);
        }
        return closestPins;
    }

    static void setPinMap(Db db, HashMap<String, HierInst<PinInstance>> map) {
        Design design = Design.getDesign((Db)db);
        if (design == null) {
            throw new IllegalStateException("Design not found");
        }
        try (OrbitApp.ChangeWarningSilencer cm = OrbitIO.suppressDbChangeMonitorWarnings();){
            design.setValue(FLD_PINMAP, map);
        }
        AAppView curView = OrbitIO.getCurView();
        if (curView instanceof DesignView2D) {
            ViewColorizer vc;
            DesignCanvas2D c2d = ((DesignView2D)curView).getCanvas();
            ViewColorizer viewColorizer = vc = c2d == null ? null : c2d.getColorizer();
            if (vc != null) {
                vc.addChangeListener(mColorizerListener);
            }
        }
    }

    private static HashMap<String, HierInst<PinInstance>> getPinMap(Db db) {
        Design design = Design.getDesign((Db)db);
        if (design != null) {
            DbFieldDef fd = design.getDbClass().getField(FLD_PINMAP);
            if (fd == null) {
                return null;
            }
            return (HashMap)design.getValue(FLD_PINMAP);
        }
        return null;
    }

    private static HierInst<PinInstance> getPinForLoc(Map<String, HierInst<PinInstance>> map, APoint2D pt) {
        String str = String.format("%d,%d", pt.getX(), pt.getY());
        return map.get(str);
    }

    public static void resetPinMap(Db db) {
        MovingSet.setPinMap(db, null);
    }

    public boolean validPinsAtLoc(long snapDist, boolean allowMissingSlots, boolean allowExistingFloorplanPin, boolean forcePersonalityMatch, boolean restrictToParent, DesignView2D view) {
        if (view == null && (view = this.mView) == null) {
            view = (DesignView2D)OrbitIO.getCurView();
        }
        ViewColorizer visibility = view.getColorizer();
        int numFound = 0;
        int numMissing = 0;
        Floorplan movingFloorplan = null;
        LinkedList ioPersonalities = null;
        APoint2D mPointForCurrentRefObj = null;
        APoint2D startCursorLoc = new APoint2D(this.mCursorLoc);
        if (this.mCurRefObj != null && this.mCurRefObj.second != null && this.mCurRefObj.second instanceof PinInstance) {
            PinInstance pin = (PinInstance)this.mCurRefObj.second;
            APoint2D curLoc = this.getDesignLocation((DevicePath)this.mCurRefObj.first, (DbObject)this.mCurRefObj.second);
            HierInst closest = visibility.getClosestInst(pin, (DevicePath)this.mCurRefObj.first, curLoc, null, snapDist);
            if (closest != null && closest.getDbObject() != null) {
                mPointForCurrentRefObj = this.getStartLoc(closest.getPath(), closest.getDbObject());
                if (allowMissingSlots) {
                    return true;
                }
                this.mCursorLoc = mPointForCurrentRefObj;
            }
            if (this.mCurRefObj == null || this.mCurRefObj.second == null) {
                if (AclInfo.getDebugMode()) {
                    ALog.logDebug((Throwable)new Exception(), (String)"unexpected?", (Object[])new Object[0]);
                }
                return false;
            }
            if (MovingSet.getPinMap(((DbObject)this.mCurRefObj.second).getDb()) == null && !allowMissingSlots && closest != null && closest.getDbObject() != null) {
                MovingSet.setPinMap(((DbObject)this.mCurRefObj.second).getDb(), visibility.getAllPinLocsMap(((DbObject)this.mCurRefObj.second).getDb()));
            }
        }
        for (APair thePair : this.getSelSet().getElements()) {
            FloorplanPin floorplanPin;
            if (thePair.second instanceof Floorplan) {
                movingFloorplan = (Floorplan)thePair.second;
                ioPersonalities = movingFloorplan.getIOPersonalities();
                continue;
            }
            if (!(thePair.second instanceof PinInstance)) continue;
            if (!PlaceableItemUI.getIncludeNonIOPins()) {
                APair validAndPersonalityList = PersonalityMap.getPersonalityList((PinTemplate)((PinInstance)thePair.second).getPinTemplate(), (DevicePath)((DevicePath)thePair.first));
                boolean isIOPin = false;
                List pinPerList = (List)validAndPersonalityList.second;
                if (movingFloorplan.getIncludeNoneInIOPersonalityList() && (pinPerList == null || pinPerList.isEmpty())) {
                    isIOPin = true;
                } else {
                    for (Personality personality : pinPerList) {
                        if (!ioPersonalities.contains(personality)) continue;
                        isIOPin = true;
                    }
                }
                if (!isIOPin) continue;
            }
            APoint2D curLoc = this.getDesignLocation((DevicePath)thePair.first, (DbObject)thePair.second);
            PinInstance pin = (PinInstance)thePair.second;
            HierInst closest = null;
            HashMap<String, HierInst<PinInstance>> pinMap = MovingSet.getPinMap(pin.getDb());
            closest = pinMap != null ? MovingSet.getPinForLoc(pinMap, curLoc) : pin.getClosestInst((DevicePath)thePair.first, curLoc, null, mPointForCurrentRefObj == null ? snapDist : 0L);
            if (closest == null || closest.getDbObject() == null) {
                if (!allowMissingSlots) {
                    this.mCursorLoc = startCursorLoc;
                    return false;
                }
                ++numMissing;
                continue;
            }
            ++numFound;
            if (restrictToParent && ((floorplanPin = ((PinInstance)closest.getDbObject()).getPinTemplate().findFloorplanPin(closest.getPath())) == null ? movingFloorplan.getMyInterface().getParent() != null : !movingFloorplan.isInThisOrParentOrHasNoParent(floorplanPin))) {
                this.mCursorLoc = startCursorLoc;
                return false;
            }
            if (!allowExistingFloorplanPin && (floorplanPin = ((PinInstance)closest.getDbObject()).getPinTemplate().findFloorplanPin(closest.getPath())) != null && floorplanPin.getOwner() != movingFloorplan) {
                this.mCursorLoc = startCursorLoc;
                return false;
            }
            if (!forcePersonalityMatch || PersonalityMap.personalitiesMatch((DevicePath)((DevicePath)thePair.first), (PinTemplate)((PinInstance)thePair.second).getPinTemplate(), (DevicePath)closest.getPath(), (PinTemplate)((PinInstance)closest.getDbObject()).getPinTemplate())) continue;
            this.mCursorLoc = startCursorLoc;
            return false;
        }
        this.mCursorLoc = startCursorLoc;
        if (allowMissingSlots) {
            return numFound > 0;
        }
        return numMissing == 0;
    }

    public static void addToSelSet(Selection.SelSet theSet, DbObject object, DevicePath devPath) {
        if (object instanceof Floorplan) {
            theSet.add(devPath, object);
        } else if (object instanceof Device) {
            Device d = (Device)object;
            DeviceTemplate tmpl = d.getParent();
            Device copy = Device.copy((Db)d.getDb(), (String)tmpl.getKeyStr(), (String)d.getName(), (String)tmpl.getKeyStr());
            theSet.add(devPath, (DbObject)copy);
            PersonalityMap.copyPersonalities((DbObject)object, (DevicePath)devPath, (DbObject)copy, (DevicePath)devPath, (boolean)true);
        } else if (object instanceof PinInstance) {
            PinTemplate pin;
            PinTemplate original = pin = ((PinInstance)object).getPinTemplate();
            pin = PinTemplate.create((Net)original.getNet(), (String)"", (String)original.getName());
            pin.setIsDynamic(true);
            LinkedList ports = AUtil.linkedList((Iterator)original.getPortTemplates());
            Collections.sort(ports, PortTemplate.CompareByPortNum);
            for (PortTemplate port : ports) {
                port.copyTo(pin);
            }
            pin.setPadTemplate(original.getPadTemplate());
            pin.setUse(original.getUse());
            pin.setType(original.getType());
            PinInstance pinInst = PinInstance.getPinInstance((Device)((PinInstance)object).getDevice(), (PinTemplate)pin);
            pinInst.setCopiedFrom((PinInstance)object);
            theSet.add(devPath, (DbObject)pinInst);
            PersonalityMap.copyPersonalities((DbObject)object, (DevicePath)devPath, (DbObject)pinInst, (DevicePath)devPath, (boolean)true);
        } else assert (false) : "Unimplemented";
    }

    public DevicePath copyAllObjects() {
        Selection.SelSet copies = new Selection.SelSet();
        DevicePath aPath = null;
        for (APair thePair : this.getSelSet().getElements()) {
            MovingSet.addToSelSet(copies, (DbObject)thePair.second, (DevicePath)thePair.first);
        }
        this.getSelSet().clear();
        this.selSet = this.dynamicDrawingSet = copies.copy();
        this.objectsAreCopy = true;
        return aPath;
    }

    public void clearSelSet() {
        this.objectsAreCopy = false;
        if (this.selSet != null) {
            this.selSet.clear();
        }
        if (this.selSet != this.dynamicDrawingSet) {
            this.dynamicDrawingSet.clear();
        }
    }

    public APoint2D adjustLocInsideParent(APoint2D prevOkPoint) {
        DevicePath parentPath = this.getSelSet().getDevicePathIfOnlyOne();
        if (parentPath == null || parentPath.isDesign()) {
            return prevOkPoint;
        }
        ARect parentBB = parentPath.pathToSubstrate().getBB();
        ARect childBB = this.getDesignLocationOfBBox();
        APoint2D ans = prevOkPoint;
        long dist = parentBB.left() - childBB.left();
        if (dist > 0L) {
            ans.moveBy(dist, 0L);
            childBB.moveBy(dist, 0L);
        }
        if ((dist = parentBB.bottom() - childBB.bottom()) > 0L) {
            ans.moveBy(0L, dist);
            childBB.moveBy(0L, dist);
        }
        if ((dist = childBB.right() - parentBB.right()) > 0L) {
            ans.moveBy(-dist, 0L);
            childBB.moveBy(-dist, 0L);
        }
        if ((dist = childBB.top() - parentBB.top()) > 0L) {
            ans.moveBy(0L, -dist);
            childBB.moveBy(0L, -dist);
        }
        if (!parentBB.inOrOnRect(childBB)) {
            return prevOkPoint;
        }
        return ans;
    }

    public boolean elementsInsideParent() {
        DevicePath parentPath = this.getSelSet().getDevicePathIfOnlyOne();
        if (parentPath == null) {
            return true;
        }
        if (parentPath.isDesign()) {
            return true;
        }
        parentPath = parentPath.pathToSubstrate();
        ARect parentBB = parentPath.getBB();
        ARect childGeom = this.getDesignLocationOfBBox();
        return childGeom == null || parentBB == null || parentBB.inOrOnRect(childGeom.getBounds());
    }

    public HierInst<DbObject> getSnapInst() {
        if (this.mCurRefObj == null) {
            return null;
        }
        DbObject obj = (DbObject)this.mCurRefObj.second;
        HierInst hObject = null;
        if (obj == null) {
            hObject = this.getAnyItemOnCursor();
            if (hObject == null) {
                return null;
            }
        } else {
            hObject = new HierInst((DevicePath)this.mCurRefObj.first, (DbObject)this.mCurRefObj.second);
        }
        return hObject;
    }

    public APoint2D snapMe(APoint2D prevOkPoint) {
        HierInst<DbObject> hObject = this.getSnapInst();
        if (hObject == null) {
            return prevOkPoint;
        }
        APoint2D curLoc = this.getDesignLocation((DevicePath)hObject.first, (DbObject)hObject.second);
        APoint2D snappedPosition = OrbitGridUtil.getSnapWorld(hObject, (APoint2D)curLoc);
        if (snappedPosition == null) {
            return prevOkPoint;
        }
        APoint2D diff = snappedPosition.sub(curLoc);
        APoint2D ans = prevOkPoint.add(diff);
        return ans;
    }

    public boolean onSnap() {
        HierInst<DbObject> any = this.getAnyItemOnCursor();
        if (any == null) {
            return true;
        }
        APoint2D curLoc = this.getDesignLocation((DevicePath)any.first, (DbObject)any.second);
        APoint2D snappedPosition = OrbitGridUtil.getSnapWorld(any, (APoint2D)curLoc);
        if (snappedPosition == null) {
            return true;
        }
        if (snappedPosition.equals((Object)curLoc)) {
            return false;
        }
        return false;
    }

    protected HierInst<DbObject> getAnyItemOnCursor() {
        IterableIterator elems = this.getSelSet().getElements();
        if (!elems.hasNext()) {
            return null;
        }
        APair any = (APair)elems.next();
        return new HierInst((DevicePath)any.first, (DbObject)any.second);
    }

    public void spotlightParent(Graphics2D g, Rectangle bounds, DesignView2D view) {
        if (!((Boolean)Settings.get((String)"UserPreferences", (String)"EnableSpotlights", (Object)false)).booleanValue()) {
            return;
        }
        DevicePath parentPath = this.getSelSet().getDevicePathIfOnlyOne();
        if (parentPath == null) {
            return;
        }
        ARect parentBB = parentPath.getBB();
        if (parentBB != null) {
            DesignCanvas2D.XForm xform = view.getCanvas().getXForm();
            ARect viewBounds = view.getViewBounds();
            SpotLight.spotlight(g, viewBounds, (AGeom)parentBB, xform);
        }
    }

    public AffineTransform getTransformForCurrentLoc(float additionalRot) {
        AffineTransform mirror;
        AffineTransform ans = new AffineTransform();
        ans.rotate(Math.toRadians(360.0f - this.mRotate + additionalRot), this.mStartLoc.getX(), this.mStartLoc.getY());
        if (this.mMirrorAboutY) {
            mirror = new AffineTransform(-1.0, 0.0, 0.0, 1.0, (double)(2L * this.mStartLoc.getX()), 0.0);
            ans.concatenate(mirror);
        }
        if (this.mMirrorAboutX) {
            mirror = new AffineTransform(1.0, 0.0, 0.0, -1.0, 0.0, (double)(2L * this.mStartLoc.getY()));
            ans.concatenate(mirror);
        }
        ans.translate(this.mStartLoc.getX() - this.mCursorLoc.getX(), this.mStartLoc.getY() - this.mCursorLoc.getY());
        try {
            ans.invert();
        }
        catch (NoninvertibleTransformException e) {
            ALog.logDebug((Throwable)e, (String)"Failed on inverted transformation in Moving Set.", (Object[])new Object[0]);
        }
        return ans;
    }

    public APoint2D setCurLoc(APoint2D p) {
        APoint2D prevPoint = p.copy();
        this.mCursorLoc.setLoc(p);
        if (!MovingSet.fireIsValidLoc(this)) {
            this.mCursorLoc = MovingSet.fireAdjustLoc(this, prevPoint);
        }
        return this.mCursorLoc;
    }

    public int crossingCount(AffineTransform transform) {
        NetCutManager mNCM = new NetCutManager();
        mNCM.addDynamicForSelSet(this.selSet);
        mNCM.deriveNetCutSet();
        ArrayList<Connection> dynConnections = mNCM.getClosestConnectionSet(this.mCursorLoc);
        Connection.setDynamictransform((AffineTransform)transform);
        return Rotater.determineConnectionCrossings(dynConnections);
    }

    public int crossingCount(float rot) {
        return this.crossingCount(this.getTransformForCurrentLoc(rot));
    }

    public double getTotalLength(AffineTransform transform) {
        NetCutManager mNCM = new NetCutManager();
        mNCM.addDynamicForSelSet(this.selSet);
        mNCM.deriveNetCutSet();
        ArrayList<Connection> dynConnections = mNCM.getClosestConnectionSet(this.mCursorLoc);
        Connection.setDynamictransform((AffineTransform)transform);
        int size = dynConnections.size();
        double length = 0.0;
        for (int i = 0; i < size; ++i) {
            ALine aL = dynConnections.get(i).getLine();
            length += (double)aL.getLength();
        }
        return length;
    }

    public double getTotalLength(float rot) {
        return this.getTotalLength(this.getTransformForCurrentLoc(rot));
    }

    public float bestRotMinCrossingsAndLength() {
        int bestRot = 0;
        int bestCrosses = 0;
        double minLength = 0.0;
        for (int i = 0; i < 4; ++i) {
            int crosses = this.crossingCount((float)i * 90.0f);
            double length = this.getTotalLength((float)i * 90.0f);
            if (i != 0 && crosses >= bestCrosses && (crosses != bestCrosses || !(length < minLength))) continue;
            bestRot = i;
            bestCrosses = crosses;
            minLength = length;
        }
        return (float)bestRot * 90.0f;
    }

    public boolean placeFloorplanPins(boolean allowHierarchyChange, boolean smartAlign) {
        if (!this.validPinsAtLoc(this.maxObjectSize() / 4L, false, PlaceableItemUI.getOverwriteExistingFloorplan(), PlaceableItemUI.getRequirePersonalityMatch(), PlaceableItemUI.getRestrictToParent(), null)) {
            ALog.logWarn((String)"Invalid location to place floorplan. Try again and wait until cursor indicates the location is valid before clicking.");
            return true;
        }
        LinkedList<Floorplan> floorplansList = new LinkedList<Floorplan>();
        for (APair thePair : this.getSelSet().getElements()) {
            if (!(thePair.second instanceof PinInstance)) continue;
            FloorplanPin fpPin = FloorplanPin.find((PinTemplate)((PinInstance)thePair.second).getPinTemplate(), (DevicePath)((DevicePath)thePair.first));
            floorplansList.add(fpPin.getOwner());
        }
        if (PlaceableItemUI.getRestrictToParent()) {
            MovingSet.getMovingFloorplan().movePinsToParent(true);
        } else {
            MovingSet.getMovingFloorplan().removePins(true);
        }
        long snapDist = this.maxObjectSize() / 4L;
        int netIndex = 0;
        int i = 0;
        for (APair thePair : this.getSelSet().getElements()) {
            if (!(thePair.second instanceof PinInstance)) continue;
            Floorplan destFloorplan = (Floorplan)floorplansList.get(i++);
            if (!PlaceableItemUI.getIncludeNonIOPins()) {
                APair validAndPersonalityList = PersonalityMap.getPersonalityList((PinTemplate)((PinInstance)thePair.second).getPinTemplate(), (DevicePath)((DevicePath)thePair.first));
                boolean isIOPin = false;
                List pinPerList = (List)validAndPersonalityList.second;
                if (MovingSet.getMovingFloorplan().getIncludeNoneInIOPersonalityList() && (pinPerList == null || pinPerList.isEmpty())) {
                    isIOPin = true;
                } else {
                    for (Object personality : pinPerList) {
                        if (!MovingSet.getMovingFloorplan().getIOPersonalities().contains(personality)) continue;
                        isIOPin = true;
                    }
                }
                if (!isIOPin) {
                    ++netIndex;
                    continue;
                }
            }
            Net net = this.mNetsList.get(netIndex++);
            PinInstance pin = (PinInstance)thePair.second;
            APoint2D curLoc = this.getDesignLocation((DevicePath)thePair.first, (DbObject)thePair.second);
            HierInst closest = pin.getClosestInst((DevicePath)thePair.first, curLoc, null, snapDist);
            if (closest == null || closest.first == null) continue;
            if (pin.getPinTemplate().getSubstrate() != ((PinInstance)closest.getDbObject()).getPinTemplate().getSubstrate()) {
                ALog.logWarn((String)"Substrates do not match");
                continue;
            }
            destFloorplan.getMyInterface().addPinToFloorplan(destFloorplan, closest.getPath(), (PinInstance)((PinInstance)closest.getDbObject()).getPinTemplate().getPinInstances().next(), net);
        }
        BundleMover bundleMover = null;
        netIndex = 0;
        int cnt = 0;
        for (APair thePair : this.getSelSet().getElements()) {
            APoint2D curLoc;
            PinInstance pin;
            HierInst closest;
            if (!(thePair.second instanceof PinInstance)) continue;
            if (!PlaceableItemUI.getIncludeNonIOPins()) {
                APair validAndPersonalityList = PersonalityMap.getPersonalityList((PinTemplate)((PinInstance)thePair.second).getPinTemplate(), (DevicePath)((DevicePath)thePair.first));
                boolean isIOPin = false;
                List pinPerList = (List)validAndPersonalityList.second;
                if (MovingSet.getMovingFloorplan().getIncludeNoneInIOPersonalityList() && (pinPerList == null || pinPerList.isEmpty())) {
                    isIOPin = true;
                } else {
                    for (Personality personality : pinPerList) {
                        if (!MovingSet.getMovingFloorplan().getIOPersonalities().contains(personality)) continue;
                        isIOPin = true;
                    }
                }
                if (!isIOPin) continue;
            }
            if ((closest = (pin = (PinInstance)thePair.second).getClosestInst((DevicePath)thePair.first, curLoc = this.getDesignLocation((DevicePath)thePair.first, (DbObject)thePair.second), null, snapDist)) == null || closest.first == null || pin.getPinTemplate().getSubstrate() != ((PinInstance)closest.getDbObject()).getPinTemplate().getSubstrate()) continue;
            DevicePath newAbsDevicePath = closest.getPath();
            DevicePath originalAbsDevicePath = (DevicePath)thePair.first;
            Device originalDevice = originalAbsDevicePath.getLast();
            if (originalDevice == null) {
                DeviceTemplate dt = originalAbsDevicePath.getDeviceTemplate();
                originalDevice = dt.getAnInstance();
            }
            PinTemplate originalPinTemplate = ((PinInstance)thePair.second).getPinTemplate();
            PinInstance originalPinInstance = originalDevice.getPin(originalPinTemplate);
            Device newDevice = newAbsDevicePath.getLast();
            if (newDevice == null) {
                DeviceTemplate dt = newAbsDevicePath.getDeviceTemplate();
                newDevice = dt.getAnInstance();
            }
            PinTemplate newPinTemplate = ((PinInstance)closest.getDbObject()).getPinTemplate();
            PinInstance newPinInstance = newDevice.getPin(newPinTemplate);
            if (cnt == 0) {
                bundleMover = new BundleMover();
                bundleMover.startBundleMove();
            }
            ++cnt;
            bundleMover.moveBundlePin(originalAbsDevicePath, originalPinInstance, closest.getPath(), newPinInstance);
        }
        if (cnt > 0) {
            bundleMover.endBundleMove();
        }
        OrbitApp.getApp().refreshCurrentView(false);
        return true;
    }

    public static void setMovingFloorplan(Db db, String keyStr) {
        mMovingFloorplan = (Floorplan)db.getByKeyStr(Floorplan.class, keyStr);
    }

    static void setMovingFloorplan(Floorplan fp) {
        mMovingFloorplan = fp;
    }

    static Floorplan getMovingFloorplan() {
        return mMovingFloorplan;
    }

    public static void addMovingListener(MovingSetListener l) {
        sMovePOListeners.addFirst(l);
    }

    public static void addMovingListener(MovingSetListener l, boolean last) {
        if (last) {
            sMovePOListeners.addLast(l);
        } else {
            sMovePOListeners.addFirst(l);
        }
    }

    public static boolean removeMovingListener(MovingSetListener l) {
        return sMovePOListeners.remove(l);
    }

    public static String fireValidToMove(MovingSet movingSet, String objectType) {
        for (MovingSetListener l : sMovePOListeners) {
            String ans = l.validToMove(movingSet, objectType);
            if (ans == null) continue;
            return ans;
        }
        return null;
    }

    public static APoint2D fireChooseOrigin(MovingSet movingSet, APoint2D cursorLoc) {
        Collections.sort(sMovePOListeners, new MovingSetListenerSorter());
        for (MovingSetListener l : sMovePOListeners) {
            APoint2D ans = l.chooseOrigin(movingSet, cursorLoc);
            if (ans == null) continue;
            return ans;
        }
        return null;
    }

    public static void fireDrawDbObject(MovingSet movingSet, DevicePath devPath, DbObject dbo, DefaultViewDrawer viewDrawer, Graphics2D g) {
        for (MovingSetListener l : sMovePOListeners) {
            if (!l.drawDbObject(movingSet, devPath, dbo, viewDrawer, g)) continue;
            return;
        }
    }

    public static void fireDrawBackground(MovingSet movingSet, Graphics2D g, Rectangle bounds, DesignView2D view) {
        for (MovingSetListener l : sMovePOListeners) {
            if (!l.drawBackground(movingSet, g, bounds, view)) continue;
            return;
        }
    }

    public static boolean fireDrawDynamicConnections() {
        for (MovingSetListener l : sMovePOListeners) {
            boolean ans = l.drawDynamicConnections();
            if (ans) continue;
            return ans;
        }
        return false;
    }

    public static boolean fireIsValidLoc(MovingSet movingSet) {
        boolean state = true;
        for (MovingSetListener l : sMovePOListeners) {
            state &= l.isValidLoc(movingSet);
        }
        return state;
    }

    public static APoint2D fireAdjustLoc(MovingSet movingSet, APoint2D prevValidLoc) {
        if (prevValidLoc == null) {
            prevValidLoc = movingSet.mCursorLoc.copy();
        }
        movingSet.mCursorLoc = prevValidLoc;
        Collections.sort(sMovePOListeners, new MovingSetListenerSorter());
        for (MovingSetListener l : sMovePOListeners) {
            movingSet.mCursorLoc = l.adjustLoc(movingSet, movingSet.mCursorLoc);
        }
        return movingSet.mCursorLoc;
    }

    public static float fireBestRot(MovingSet movingSet) {
        for (MovingSetListener l : sMovePOListeners) {
            float rotate = l.bestRot(movingSet);
            if (rotate == 0.0f) continue;
            return rotate;
        }
        return 0.0f;
    }

    public static void firePlace(MovingSet movingSet, boolean allowHierarchyChange, boolean smartAlign) {
        for (MovingSetListener l : sMovePOListeners) {
            if (!l.place(movingSet, allowHierarchyChange, smartAlign)) continue;
            return;
        }
    }

    public static void restrictMovementInsideParent() {
        restrictAdaptor = new MoveInsideParentAdapter();
        MovingSet.addMovingListener(restrictAdaptor, true);
    }

    public static void restrictOrthogonalMovement() {
        orthogonalAdaptor = new MoveOrthogonalAdapter();
        MovingSet.addMovingListener(orthogonalAdaptor);
    }

    public static void removeRestrictOrthogonalMovement() {
        if (orthogonalAdaptor != null) {
            MovingSet.removeMovingListener(orthogonalAdaptor);
        }
        for (MovingSetListener l : AUtil.linkedList(sMovePOListeners)) {
            if (!(l instanceof MoveOrthogonalAdapter)) continue;
            sMovePOListeners.remove(l);
        }
        orthogonalAdaptor = null;
    }

    public static void removeRestrictMovementInsideParent() {
        if (restrictAdaptor != null) {
            MovingSet.removeMovingListener(restrictAdaptor);
        }
        for (MovingSetListener l : AUtil.linkedList(sMovePOListeners)) {
            if (!(l instanceof MoveInsideParentAdapter)) continue;
            sMovePOListeners.remove(l);
        }
        restrictAdaptor = null;
    }

    public static void setAxuiliaryLine(boolean enable) {
        if (auxiliaryAdapter == null) {
            auxiliaryAdapter = new MoveAuxiliaryAdapter();
        }
        if (enable) {
            MovingSet.addMovingListener(auxiliaryAdapter);
        } else {
            MovingSet.removeMovingListener(auxiliaryAdapter);
        }
    }

    public static void addSnapAdapter() {
        snapAdapter = new MoveSnapAdapter();
        MovingSet.addMovingListener(snapAdapter);
    }

    public static void removeSnapAdapter() {
        if (restrictAdaptor != null) {
            MovingSet.removeMovingListener(restrictAdaptor);
        }
        for (MovingSetListener l : AUtil.linkedList(sMovePOListeners)) {
            if (!(l instanceof MoveSnapAdapter)) continue;
            sMovePOListeners.remove(l);
        }
        restrictAdaptor = null;
    }

    public static void initCopyPersonalityAdapter() {
        copyPersonalityAdaptor = new CopyPersonalityAdapter();
        MovingSet.addMovingListener(copyPersonalityAdaptor);
    }

    public static void stopCopyPersonalityAdapter() {
        if (copyPersonalityAdaptor != null) {
            MovingSet.removeMovingListener(copyPersonalityAdaptor);
        }
        copyPersonalityAdaptor = null;
    }

    public static void initMoveFloorplanAdapter() {
        moveFloorplanAdaptor = new MoveFloorplanAdapter();
        MovingSet.addMovingListener(moveFloorplanAdaptor);
    }

    public static void stopMoveFloorplanAdapter() {
        if (moveFloorplanAdaptor != null) {
            MovingSet.removeMovingListener(moveFloorplanAdaptor);
        }
        moveFloorplanAdaptor = null;
    }

    public void setRotation(float pendingRot) {
        this.mRotate = pendingRot;
    }

    public static class MovingSetListenerSorter
    implements Comparator<MovingSetListener> {
        @Override
        public int compare(MovingSetListener a, MovingSetListener b) {
            return a.getPriority() - b.getPriority();
        }
    }

    public static class MoveFloorplanAdapter
    implements MovingSetListener {
        static long mSnapDist = 0L;

        @Override
        public String validToMove(MovingSet movingSet, String objectType) {
            return null;
        }

        @Override
        public APoint2D chooseOrigin(MovingSet movingSet, APoint2D cursorLoc) {
            mSnapDist = movingSet.maxObjectSize() / 4L;
            return null;
        }

        @Override
        public boolean drawBackground(MovingSet movingSet, Graphics2D g, Rectangle bounds, DesignView2D view) {
            return true;
        }

        @Override
        public boolean drawDbObject(MovingSet movingSet, DevicePath devPath, DbObject dbo, DefaultViewDrawer viewDrawer, Graphics2D g) {
            movingSet.drawDbObjectFloorplan(devPath, dbo, viewDrawer, g);
            return true;
        }

        @Override
        public boolean isValidLoc(MovingSet movingSet) {
            boolean validLoc = movingSet.validPinsAtLoc(mSnapDist, false, PlaceableItemUI.getOverwriteExistingFloorplan(), PlaceableItemUI.getRequirePersonalityMatch(), PlaceableItemUI.getRestrictToParent(), null);
            PlaceableItemUI.DoFloorplan.setValidLoc(validLoc);
            return validLoc;
        }

        @Override
        public APoint2D adjustLoc(MovingSet movingSet, APoint2D prevValidLoc) {
            return movingSet.mCursorLoc.copy();
        }

        @Override
        public float bestRot(MovingSet movingSet) {
            return 0.0f;
        }

        @Override
        public boolean place(MovingSet movingSet, boolean allowHierarchyChange, boolean smartAlign) {
            boolean ans = movingSet.placeFloorplanPins(allowHierarchyChange, smartAlign);
            movingSet.clearSelSet();
            return ans;
        }

        @Override
        public boolean drawDynamicConnections() {
            return false;
        }

        @Override
        public int getPriority() {
            return 0;
        }
    }

    public static class CopyPersonalityAdapter
    implements MovingSetListener {
        static long mSnapDist = 0L;

        @Override
        public String validToMove(MovingSet movingSet, String objectType) {
            return null;
        }

        @Override
        public APoint2D chooseOrigin(MovingSet movingSet, APoint2D cursorLoc) {
            mSnapDist = movingSet.maxObjectSize() / 4L;
            return null;
        }

        @Override
        public boolean drawBackground(MovingSet movingSet, Graphics2D g, Rectangle bounds, DesignView2D view) {
            return true;
        }

        @Override
        public boolean drawDbObject(MovingSet movingSet, DevicePath devPath, DbObject dbo, DefaultViewDrawer viewDrawer, Graphics2D g) {
            return false;
        }

        @Override
        public boolean isValidLoc(MovingSet movingSet) {
            boolean validLoc = movingSet.validPinsAtLoc(mSnapDist, PlaceableItemUI.getAllowMissingSlots(), true, false, false, null);
            PlaceableItemUI.DoPinPersonality.setValidLoc(validLoc);
            return validLoc;
        }

        @Override
        public APoint2D adjustLoc(MovingSet movingSet, APoint2D prevValidLoc) {
            return movingSet.mCursorLoc.copy();
        }

        @Override
        public float bestRot(MovingSet movingSet) {
            return 0.0f;
        }

        @Override
        public boolean place(MovingSet movingSet, boolean allowHierarchyChange, boolean smartAlign) {
            if (!movingSet.validPinsAtLoc(mSnapDist, PlaceableItemUI.getAllowMissingSlots(), true, false, false, null)) {
                return true;
            }
            boolean ans = movingSet.placePersonalities(allowHierarchyChange, smartAlign);
            return ans;
        }

        @Override
        public boolean drawDynamicConnections() {
            return false;
        }

        @Override
        public int getPriority() {
            return 0;
        }
    }

    public static interface MovingSetListener {
        public String validToMove(MovingSet var1, String var2);

        public APoint2D chooseOrigin(MovingSet var1, APoint2D var2);

        public boolean drawDbObject(MovingSet var1, DevicePath var2, DbObject var3, DefaultViewDrawer var4, Graphics2D var5);

        public boolean drawBackground(MovingSet var1, Graphics2D var2, Rectangle var3, DesignView2D var4);

        public boolean drawDynamicConnections();

        public boolean isValidLoc(MovingSet var1);

        public APoint2D adjustLoc(MovingSet var1, APoint2D var2);

        public float bestRot(MovingSet var1);

        public boolean place(MovingSet var1, boolean var2, boolean var3);

        public int getPriority();
    }
}

