/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.dbui.render;

import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;

public class TemplateListRenderer
extends DefaultListCellRenderer {
    private final String textForNull;
    private DeviceTemplate lastPick;

    public TemplateListRenderer() {
        this("");
    }

    public TemplateListRenderer(String textForNull) {
        this.textForNull = textForNull;
    }

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        DeviceTemplate t;
        super.getListCellRendererComponent(list, (Object)null, index, isSelected, cellHasFocus);
        this.lastPick = t = (DeviceTemplate)value;
        if (t == null) {
            this.setText(this.textForNull);
            this.setIcon(null);
            return this;
        }
        this.setIcon(DbExplorerPanel.getIconForTemplate(t));
        this.setText(t.getName());
        return this;
    }

    @Override
    public String getToolTipText() {
        if (this.lastPick != null) {
            DeviceTemplate t = this.lastPick;
            return String.format("(%s) There are %d instances (%s) on Substrate %s", t.getType() == null ? "null" : t.getType().toString(), t.getDeviceInstanceCount(), t.getName(), t.getSubstrate() == null ? "<none>" : t.getSubstrate().getName());
        }
        return null;
    }
}

