/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.netlister;

import com.sigrity.acl.AAlphaNumComp;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Interface;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.InterfaceCmds;
import com.sigrity.orbit.OrbitIO;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class NetLister {
    public static final String NET_COLUMN = "Net";
    public static final String INTERFACE_COLUMN = "Interface";
    public static final String NETDIR_COLUMN = Net.getDirectionFieldName();
    public static final String PINS_COLUMN = "DevicePath,Pins,...";
    public static final String DETAIL_SUB_COLUMN = ",Nets";
    public static final int NUM_DETAIL = 1;
    protected final Db mDb;
    protected Set<Interface> listToAutoAssign = null;
    protected Map<String, Integer> mHeaderIndices = null;
    protected HashMap<HierInst<PinTemplate>, HashMap<String, List<Long>>> mPin2NetName = new HashMap();
    private DevicePath mTopDevPath;
    private boolean mOnlyReadNet = false;
    private boolean mAssignIOPadsToFloorplan = false;
    private int mDepth = 0;
    private boolean mOnlySelectedDevices = false;
    private boolean mOnlySelectedPorts = false;
    private boolean mAbsolutePaths = false;

    public NetLister() {
        this(OrbitIO.getCurDb());
    }

    public NetLister(Db db) {
        this.mDb = db;
    }

    public void setTopDevPath(String topPathString) {
        this.mTopDevPath = DevicePath.fromEscapedString((Db)this.mDb, (String)topPathString);
        if (this.mTopDevPath == null) {
            ALog.logWarn((String)"The device path '%s' does not exist", (Object[])new Object[]{topPathString});
        }
    }

    public void setOnlyReadNet(boolean onlyReadNet) {
        this.mOnlyReadNet = onlyReadNet;
    }

    public void setDepth(int depth) {
        this.mDepth = depth;
    }

    public void setOnlySelectedDevices(boolean onlySelectedDevices) {
        this.mOnlySelectedDevices = onlySelectedDevices;
    }

    public void setOnlySelectedPorts(boolean onlySelectedPorts) {
        this.mOnlySelectedPorts = onlySelectedPorts;
    }

    public void setAbsolutePaths(boolean absolutePaths) {
        this.mAbsolutePaths = absolutePaths;
    }

    public void setAssignIOPadsToFloorplan(boolean assignIOPadsToFloorplan) {
        this.mAssignIOPadsToFloorplan = assignIOPadsToFloorplan;
    }

    public void importCSV(String topPathString, String filePath, boolean netsOnly) {
        this.importCSV(topPathString, filePath, netsOnly, false);
    }

    public void importCSV(String topPathString, String filePath, boolean netsOnly, boolean assignIOPadsToFloorplan) {
        if (this.mDb == null) {
            return;
        }
        this.setTopDevPath(topPathString);
        this.setOnlyReadNet(netsOnly);
        this.setAssignIOPadsToFloorplan(assignIOPadsToFloorplan);
        if (this.mTopDevPath == null) {
            return;
        }
        try (BufferedReader input = new BufferedReader(new FileReader(new File(filePath)));){
            this.importNetList(input);
        }
        catch (IOException e) {
            ALog.logError((Throwable)e, (String)"Unable to read input file '%s'.", (Object[])new Object[]{filePath});
        }
    }

    private String getColumnData(String head, String[] tokens) {
        if (!this.mHeaderIndices.containsKey(head)) {
            return null;
        }
        int index = this.mHeaderIndices.get(head);
        if (index < 0 || index >= tokens.length) {
            return null;
        }
        return tokens[index];
    }

    protected boolean processNetInterfaceLine(DeviceTemplate devTemplate, String line, int lineNumber) {
        String directionStr;
        String[] tokens = line.split(",");
        if (tokens.length == 0) {
            return false;
        }
        String netName = this.getColumnData(NET_COLUMN, tokens);
        String string = netName = netName == null ? "" : netName.trim();
        if (netName.isEmpty()) {
            ALog.logInfo((String)"On line %d there is no net specified", (Object[])new Object[]{lineNumber});
            return false;
        }
        Net theNet = devTemplate.getNet(netName);
        if (theNet == null && (theNet = Net.create((DeviceTemplate)devTemplate, (String)netName)) == null) {
            ALog.logError((String)"There was an error adding net '%s' to device template '%s'.", (Object[])new Object[]{netName, devTemplate.getKeyStr()});
            return false;
        }
        String interfaceStr = this.getColumnData(INTERFACE_COLUMN, tokens);
        if (interfaceStr != null && !interfaceStr.trim().isEmpty()) {
            Interface other;
            interfaceStr = interfaceStr.trim();
            Interface intf = Interface.getOrCreate((Db)theNet.getDb(), (String)interfaceStr);
            DeviceTemplate dt = intf.getNetsReferencedWRT();
            if (dt == null) {
                intf.setNetsReferencedWRT(devTemplate);
            }
            if (devTemplate != dt && dt != null) {
                Net refNet = theNet;
                if ((theNet = NetMap.getConnectedNetsAt((Net)theNet, (DevicePath)((DevicePath)theNet.getDeviceTemplate().getHierarchicalInstances().next()), (DeviceTemplate)dt)) == null) {
                    ALog.logWarn((String)"Unable to find connection from Net '%s' to any instance of key-net DeviceTemplate '%s'. Ignoring interface '%s' assignment on line '%d'.", (Object[])new Object[]{refNet.getKeyStr(), dt.getKeyStr(), interfaceStr, lineNumber});
                    return true;
                }
            }
            if ((other = intf.isNetInAnotherInterface(theNet)) != null) {
                other.removeNet(theNet);
            }
            intf.addNet(theNet);
            if (!this.listToAutoAssign.contains(intf)) {
                this.listToAutoAssign.add(intf);
            }
            intf.resetInterfaceStatus();
        }
        if ((directionStr = this.getColumnData(NETDIR_COLUMN, tokens)) != null && !directionStr.isEmpty()) {
            Net.Direction netDirection = Net.Direction.valueOf((String)directionStr);
            theNet.setValue(Net.getDirectionFieldName(), (Object)netDirection);
        }
        return true;
    }

    protected boolean processNetPortLine(String line, int lineNumber) {
        String[] tokens = line.split(",");
        if (tokens.length == 0) {
            return false;
        }
        if (this.mHeaderIndices.get(NET_COLUMN) != 0) {
            ALog.logError((String)"The %s should be in the first column.\n", (Object[])new Object[]{NET_COLUMN});
            return false;
        }
        String netName = tokens[0];
        if ((netName = netName.trim()).isEmpty()) {
            ALog.logInfo((String)"On line %d there is no net specified", (Object[])new Object[]{lineNumber});
            return false;
        }
        int numberOfPaths = (tokens.length - 1) / 2;
        for (int paths = 0; paths < numberOfPaths; ++paths) {
            String[] ports;
            String pathName = tokens[paths * 2 + 1];
            String portList = tokens[paths * 2 + 2];
            for (String port : ports = portList.split(" ")) {
                this.updateNet(line, lineNumber, netName, pathName, port);
            }
        }
        return true;
    }

    protected void updateNet(String line, int lineNumber, String netName, String pathName, String portName) {
        DevicePath relPath = DevicePath.fromString((Db)this.mDb, (String)pathName, (DeviceTemplate)this.mTopDevPath.getDeviceTemplate(), (boolean)true);
        if (relPath == null) {
            ALog.logWarn((String)"Line %d: Invalid path '%s/%s'.", (Object[])new Object[]{lineNumber, this.mTopDevPath, pathName});
            ALog.logWarn((String)"       > %s", (Object[])new Object[]{line});
            return;
        }
        DeviceTemplate dt = relPath.getDeviceTemplate();
        PinTemplate dtp = dt.getPinByName(portName);
        if (dtp == null) {
            ALog.logWarn((String)"Line %d: Invalid pin '%s' for path '%s/%s'.", (Object[])new Object[]{lineNumber, portName, this.mTopDevPath, pathName});
            ALog.logWarn((String)"       > %s", (Object[])new Object[]{line});
            return;
        }
        DevicePath fullPath = this.mTopDevPath.addPath(relPath);
        PinInstance dPort = fullPath.getDevice() == null ? null : fullPath.getDevice().getPin(dtp);
        this.addImportAssignment((HierInst<PinTemplate>)HierInst.create((DevicePath)fullPath, (DbObject)dtp), netName, lineNumber);
        Net curTopNet = NetMap.getTopmostNet((Net)dtp.getNet(), (DevicePath)relPath);
        if (!(netName.equals(curTopNet.getName()) && curTopNet.getDeviceTemplate() == relPath.getRoot() || dtp.getNet() == null)) {
            String oldNetName = curTopNet.getDeviceTemplate() == relPath.getRoot() ? curTopNet.getName() : "";
            ALog.flogInfo((String)"'%s' '%s' net changed from '%s' to '%s'.", (Object[])new Object[]{pathName.equals(".") || pathName.trim().isEmpty() ? "Pin" : (pathName.startsWith("./") ? pathName.substring(2) : pathName) + " pin", portName, oldNetName, netName});
            if (relPath.isEmpty()) {
                Net net = dt.getNet(netName);
                if (net == null) {
                    net = dt.createNet(netName);
                }
                dtp.setNet(net);
            } else {
                NetMap.mapThroughPath((DevicePath)relPath, (PinInstance)dPort, (String)netName);
            }
            if (dPort != null) {
                dPort.setNetSetterType(PinInstance.NetSetterType.CSV);
            }
        }
    }

    protected void addImportAssignment(HierInst<PinTemplate> hPinT, String netName, long lineNum) {
        Map netName2Lines = this.mPin2NetName.computeIfAbsent(hPinT, k -> new HashMap());
        List lines = netName2Lines.computeIfAbsent(netName, k -> new LinkedList());
        lines.add(lineNum);
    }

    protected void reportImportDuplicates(DeviceTemplate rootDevT) {
        this.mPin2NetName.entrySet().stream().filter(ent -> ((HashMap)ent.getValue()).size() > 1).sorted((a, b) -> a.toString().compareTo(b.toString())).forEach(ent -> {
            HierInst hPinT = (HierInst)ent.getKey();
            HashMap netName2Lines = (HashMap)ent.getValue();
            DevicePath relPath = hPinT.first == null || ((DevicePath)hPinT.first).isEmpty() ? null : ((DevicePath)hPinT.first).getRelativePathFromAnchor(rootDevT);
            String lastNetName = netName2Lines.entrySet().stream().min((a, b) -> -Long.compare(((List)a.getValue()).stream().max(Long::compare).orElse(0L), ((List)b.getValue()).stream().max(Long::compare).orElse(0L))).map(Map.Entry::getKey).orElse("");
            ALog.logWarn((String)"The pin %s%s was specified multiple times with conflicting nets, the last specified Net '%s' was used.", (Object[])new Object[]{relPath == null || relPath.isEmpty() ? "" : String.format("%s ", relPath), ((PinTemplate)hPinT.second).getName(), lastNetName});
            netName2Lines.entrySet().stream().sorted((a, b) -> AAlphaNumComp.comp(a.getKey(), b.getKey())).forEach(netNameAndLines -> {
                String netName = (String)netNameAndLines.getKey();
                List lines = (List)netNameAndLines.getValue();
                ALog.logWarn((String)"  Net '%s' specified at line%s %s.", (Object[])new Object[]{netName, lines.size() == 1 ? "" : "s", lines.stream().map(l -> Long.toString(l)).collect(Collectors.joining(", "))});
            });
        });
    }

    private boolean tryParseHeader(String header) {
        String[] tokens = header.split(",");
        if (tokens.length == 0) {
            return false;
        }
        this.mHeaderIndices = new HashMap<String, Integer>();
        if (this.mOnlyReadNet) {
            for (int i = 0; i < tokens.length; ++i) {
                String token = tokens[i];
                if (token.equals(NET_COLUMN)) {
                    this.mHeaderIndices.put(NET_COLUMN, i);
                    continue;
                }
                if (token.equals(INTERFACE_COLUMN)) {
                    this.mHeaderIndices.put(INTERFACE_COLUMN, i);
                    continue;
                }
                if (token.equals(NETDIR_COLUMN)) {
                    this.mHeaderIndices.put(NETDIR_COLUMN, i);
                    continue;
                }
                return false;
            }
            return true;
        }
        if (header.equals("Net,DevicePath,Pins,...")) {
            this.mHeaderIndices.put(NET_COLUMN, 0);
            return true;
        }
        return false;
    }

    private String useDefaultHeader() {
        int index = 0;
        Object header = NET_COLUMN;
        this.mHeaderIndices = new HashMap<String, Integer>();
        this.mHeaderIndices.put(NET_COLUMN, index);
        ++index;
        if (this.mOnlyReadNet) {
            this.mHeaderIndices.put(INTERFACE_COLUMN, index);
            header = (String)header + ",Interface";
            this.mHeaderIndices.put(NETDIR_COLUMN, ++index);
            ++index;
            header = (String)header + "," + NETDIR_COLUMN;
        } else {
            this.mHeaderIndices.put(PINS_COLUMN, index);
            header = (String)header + ",DevicePath,Pins,...";
            ++index;
        }
        return header;
    }

    public void exportCSV(String topPathString, String filePath, int depth, boolean onlySelectedDevices, boolean onlySelectedPorts, boolean absolutePaths) {
        if (this.mDb == null) {
            return;
        }
        this.setTopDevPath(topPathString);
        this.setDepth(depth);
        this.setOnlySelectedDevices(onlySelectedDevices);
        this.setOnlySelectedPorts(onlySelectedPorts);
        this.setAbsolutePaths(absolutePaths);
        this.exportCSV(filePath);
    }

    public void exportCSV(String filePath) {
        if (this.mTopDevPath == null) {
            return;
        }
        try (PrintStream out = new PrintStream(filePath);){
            ALog.logInfo((String)"The netlist for %s will be written to %s.", (Object[])new Object[]{this.mTopDevPath, filePath});
            this.exportNetPortList(out);
        }
        catch (Exception e) {
            ALog.logWarn((Throwable)e, (String)("Can not open " + filePath), (Object[])new Object[0]);
        }
    }

    public static void cpExportCSV(String topPathString, String filePath, int depth, boolean onlySelectedDevices, boolean onlySelectedPorts, boolean absolutePaths) {
        Cp.exec((String)"_netLister = new com.sigrity.acl.netlister.NetLister(curDb());", (Object[])new Object[0]);
        Cp.exec((String)"_netLister.setTopDevPath(\"%s\");", (Object[])new Object[]{topPathString});
        Cp.exec((String)"_netLister.setDepth(%d)", (Object[])new Object[]{depth});
        Cp.exec((String)"_netLister.setOnlySelectedDevices(%b);", (Object[])new Object[]{onlySelectedDevices});
        Cp.exec((String)"_netLister.setOnlySelectedPorts(%b);", (Object[])new Object[]{onlySelectedPorts});
        Cp.exec((String)"_netLister.setAbsolutePaths(%b);", (Object[])new Object[]{absolutePaths});
        Cp.exec((String)"_netLister.exportCSV(%s);", (Object[])new Object[]{Cp.getFileAsArgument((String)filePath)});
        Cp.exec((String)"unset(\"_netLister\");", (Object[])new Object[0]);
    }

    public static void exportCSV(DevicePath topPath, String filePath, boolean doInterfaces) {
        NetLister.exportCSV(topPath, filePath, doInterfaces, false);
    }

    public static void exportCSV(DevicePath topPath, String filePath, boolean doInterfaces, boolean includeNetDirection) {
        if (topPath == null || topPath.getDb() == null || topPath.isEmpty()) {
            ALog.logError((String)"The specified top device path '%s' is invalid.", (Object[])new Object[]{topPath});
            return;
        }
        try (PrintStream out = new PrintStream(filePath);){
            ALog.logInfo((String)"Writing netlist for '%s' to '%s'.", (Object[])new Object[]{topPath.toString(), filePath});
            NetLister.exportNetInterfaceList(topPath, doInterfaces, includeNetDirection, out);
        }
        catch (FileNotFoundException e) {
            ALog.logWarn((String)("Can not open " + filePath));
        }
    }

    private void importNetList(BufferedReader input) {
        DeviceTemplate devTemplate = this.mTopDevPath.getDeviceTemplate();
        if (devTemplate == null) {
            ALog.logError((String)"No template found for device path '%s'.", (Object[])new Object[]{this.mTopDevPath});
            return;
        }
        try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)this.mDb, (String)"Import Nets CSV");){
            int lineNumber = 1;
            int passCount = 0;
            long startNum = devTemplate.getNetCount();
            String curLine = input.readLine();
            this.listToAutoAssign = new HashSet<Interface>();
            while (curLine != null) {
                if (lineNumber == 1) {
                    if (this.tryParseHeader(curLine)) {
                        ALog.logInfo((String)"Detect CSV header %s successfully.", (Object[])new Object[]{curLine});
                        curLine = input.readLine();
                        ++lineNumber;
                        continue;
                    }
                    String header = this.useDefaultHeader();
                    ALog.logWarn((String)"Failed on parsing header. Use default %s header.", (Object[])new Object[]{header});
                }
                boolean pass = false;
                pass = this.mOnlyReadNet ? this.processNetInterfaceLine(devTemplate, curLine, lineNumber) : this.processNetPortLine(curLine, lineNumber);
                if (pass) {
                    ++passCount;
                }
                curLine = input.readLine();
                ++lineNumber;
            }
            for (Interface intf : this.listToAutoAssign) {
                InterfaceCmds.assignExistingPinsToFloorplan(intf, this.mAssignIOPadsToFloorplan);
            }
            for (Interface intf : this.listToAutoAssign) {
                int minCnt = intf.getNets(true).size();
                if (minCnt > intf.getExpectedIOCount()) {
                    intf.setExpectedIOCount(minCnt);
                }
                intf.adjustAncestorsCountForNetsIfNecessary(true);
            }
            for (Interface intf : this.listToAutoAssign) {
                intf.resetInterfaceStatus();
            }
            if (this.mOnlyReadNet) {
                ALog.logInfo((String)"%s nets processed for device template '%s'.", (Object[])new Object[]{passCount, devTemplate.getKeyStr()});
                ALog.logInfo((String)"%d new nets added to device template '%s'.", (Object[])new Object[]{(long)devTemplate.getNetCount() - startNum, devTemplate.getKeyStr()});
            }
            this.reportImportDuplicates(devTemplate);
        }
        catch (IOException e) {
            ALog.logError((Throwable)e);
        }
    }

    private void exportNetPortList(PrintStream out) {
        Design design = Design.getDesign((Db)this.mDb);
        Selection s = null;
        int totalNetsWritten = 0;
        int totalPinsWritten = 0;
        if (this.mOnlySelectedDevices || this.mOnlySelectedPorts) {
            s = design.getCurSelection();
        }
        String columns = "Net,DevicePath,Pins,...";
        out.println(columns);
        ArrayList<Net> designNets = new ArrayList<Net>();
        for (Net net : this.mTopDevPath.getDeviceTemplate().getNets()) {
            if (net.isUnused()) continue;
            designNets.add(net);
        }
        Collections.sort(designNets, (a, b) -> AAlphaNumComp.get().compare((Object)a.getName(), (Object)b.getName()));
        for (Net net : designNets) {
            PortList apl;
            HashMap<DevicePath, PortList> devicePathToPortList = new HashMap<DevicePath, PortList>();
            PortList pl = new PortList();
            devicePathToPortList.put(this.mTopDevPath, pl);
            for (PinTemplate port : net.getPins()) {
                PinInstance pinInst;
                PinTemplate.Type pinType = port.getType();
                if (pinType == PinTemplate.Type.TOPOLOGYPOINT || pinType == PinTemplate.Type.WIREEND || port.getIsVirtual()) continue;
                Device topDev = this.mTopDevPath.getDevice();
                PinInstance pinInstance = pinInst = topDev == null ? null : PinInstance.getPinInstance((Device)topDev, (PinTemplate)port);
                if (this.mOnlySelectedPorts && !s.contains((DbObject)pinInst) && !s.contains((DbObject)port)) continue;
                pl.add(port);
            }
            for (APair p : NetMap.getDescendantNetsWithPaths((DevicePath)this.mTopDevPath, (Net)net)) {
                DevicePath dp = (DevicePath)p.first;
                int thisDepth = this.mTopDevPath.depthTo(new DevicePath(dp));
                if (this.mDepth > -1 && thisDepth > this.mDepth || this.mOnlySelectedDevices && !s.contains((DbObject)dp.getLast())) continue;
                apl = (PortList)devicePathToPortList.get(dp);
                Net n = (Net)p.second;
                for (PinTemplate port : n.getPins()) {
                    Device d;
                    PinInstance aPinInstance;
                    if (port.getType() == PinTemplate.Type.TOPOLOGYPOINT || port.getType() == PinTemplate.Type.WIREEND || port.getIsVirtual() || (aPinInstance = (d = dp.getLast()).getPin(port)) == null || this.mOnlySelectedPorts && !s.contains((DbObject)aPinInstance)) continue;
                    if (apl == null) {
                        apl = new PortList();
                        devicePathToPortList.put(dp, apl);
                    }
                    apl.add(port);
                }
            }
            ArrayList devicePathsOnThisNet = new ArrayList(devicePathToPortList.keySet());
            if (devicePathsOnThisNet.isEmpty()) continue;
            Collections.sort(devicePathsOnThisNet, (a, b) -> a.toString().compareTo(b.toString()));
            StringBuilder line = new StringBuilder();
            for (DevicePath path : devicePathsOnThisNet) {
                apl = (PortList)devicePathToPortList.get(path);
                if (apl == null || apl.isEmpty()) continue;
                Collections.sort(apl);
                if (line.length() == 0) {
                    line.append(net.getName());
                }
                ++totalNetsWritten;
                line.append(",");
                if (this.mAbsolutePaths) {
                    line.append(path);
                } else {
                    DevicePath child = path;
                    DevicePath rPath = this.mTopDevPath.getRelativePath(child);
                    line.append(rPath.toString());
                }
                line.append(",");
                boolean first = true;
                for (PinTemplate dp : apl) {
                    if (!first) {
                        line.append(" ");
                    }
                    line.append(dp.getName());
                    ++totalPinsWritten;
                    first = false;
                }
            }
            if (line.length() <= 0) continue;
            out.println(line);
        }
        ALog.logInfo((String)"A total of %d nets and %d pins were output.", (Object[])new Object[]{totalNetsWritten, totalPinsWritten});
    }

    private static void exportNetInterfaceList(DevicePath topPath, boolean doInterfaces, boolean includeNetDirection, PrintStream out) {
        Object header = NET_COLUMN;
        if (doInterfaces) {
            header = (String)header + ",Interface";
        }
        if (includeNetDirection) {
            header = (String)header + "," + NETDIR_COLUMN;
        }
        out.println((String)header);
        int totalNetsWritten = 0;
        int totalInterfacesWritten = 0;
        Db db = topPath.getDb();
        List designNets = topPath.getLast().getNets().stream().filter(net -> !net.isUnused()).collect(Collectors.toList());
        Collections.sort(designNets, AAlphaNumComp.get());
        for (Net net2 : designNets) {
            Net.Direction netDirection;
            Interface intf;
            ++totalNetsWritten;
            StringBuilder line = new StringBuilder();
            line.append(net2.getName());
            line.append(",");
            if (doInterfaces && (intf = Interface.findInterface((Db)db, (Net)net2)) != null) {
                ++totalInterfacesWritten;
                line.append(intf.toStringPath());
            }
            line.append(",");
            if (includeNetDirection && (netDirection = net2.getDirection()) != null) {
                line.append(netDirection.toString());
            }
            out.println(line);
        }
        if (doInterfaces) {
            ALog.logInfo((String)"A total of %d nets were written and %d interfaces were written", (Object[])new Object[]{totalNetsWritten, totalInterfacesWritten});
        } else {
            ALog.logInfo((String)"A total of %d nets were written", (Object[])new Object[]{totalNetsWritten});
        }
    }

    static class PortList
    extends ArrayList<PinTemplate> {
        PortList() {
        }
    }
}

