/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.netmap_matrix;

import com.sigrity.acl.AAlphaNumComp;
import com.sigrity.acl.ALog;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.orbit.DevicePath;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.javatuples.Pair;

public class NetMapMatrixOut {
    public static final String DETAIL_SUB_COLUMN = "Nets,";
    public static final int NUM_DETAIL = 1;
    private final Db mDb;
    private DevicePath mTopDevPath;

    public NetMapMatrixOut(Db db) {
        this.mDb = db;
    }

    public static void cpExportCSV(DevicePath topDevPath, String filePath) {
        Cp.exec((String)"_netMapMatrixOut = new com.sigrity.acl.netmap_matrix.NetMapMatrixOut(curDb());", (Object[])new Object[0]);
        Cp.exec((String)"_netMapMatrixOut.setTopDevPath(\"%s\");", (Object[])new Object[]{topDevPath.toString()});
        Cp.exec((String)"_netMapMatrixOut.exportCSV(%s);", (Object[])new Object[]{Cp.getFileAsArgument((String)filePath)});
        Cp.exec((String)"unset(\"_netMapMatrixOut\");", (Object[])new Object[0]);
    }

    public void exportCSV(String filePath) {
        if (this.mTopDevPath == null) {
            return;
        }
        try (PrintStream out = new PrintStream(filePath);){
            ALog.logInfo((String)"The net matrix for %s will be written to %s.", (Object[])new Object[]{this.mTopDevPath, filePath});
            this.exportNetDieMatrix(out);
        }
        catch (Exception e) {
            ALog.logWarn((Throwable)e, (String)("Can not open " + filePath), (Object[])new Object[0]);
        }
    }

    public void setTopDevPath(String topPathString) {
        this.mTopDevPath = DevicePath.fromEscapedString((Db)this.mDb, (String)topPathString);
        if (this.mTopDevPath == null) {
            ALog.logWarn((String)"The device path '%s' does not exist", (Object[])new Object[]{topPathString});
        }
    }

    private void exportNetDieMatrix(PrintStream out) {
        ArrayList<Net> designNets = new ArrayList<Net>();
        for (Net net : this.mTopDevPath.getLast().getNets()) {
            if (net.isUnused()) continue;
            designNets.add(net);
        }
        Collections.sort(designNets, (a, b) -> AAlphaNumComp.get().compare((Object)a.getName(), (Object)b.getName()));
        ArrayList<ArrayList<Pair<Net, Integer>>> outMatrix = new ArrayList<ArrayList<Pair<Net, Integer>>>();
        int curCol = 1;
        StringBuilder pathHeader = new StringBuilder();
        pathHeader.append(this.mTopDevPath);
        this.pathHeaderAddEmptyCell(pathHeader);
        StringBuilder detailHeader = new StringBuilder();
        detailHeader.append(DETAIL_SUB_COLUMN);
        HashMap<DevicePath, Integer> dieTodestinationCol = new HashMap<DevicePath, Integer>();
        for (Net net : designNets) {
            ArrayList<Pair<Net, Integer>> netsNeedToOutPut = new ArrayList<Pair<Net, Integer>>();
            curCol = this.recursiveSearchNetConnection(net, netsNeedToOutPut, pathHeader, detailHeader, dieTodestinationCol, curCol, this.mTopDevPath);
            outMatrix.add(netsNeedToOutPut);
        }
        this.writeMatrixToCsv(pathHeader, detailHeader, outMatrix, designNets, out);
    }

    private void writeMatrixToCsv(StringBuilder pathHeader, StringBuilder detailHeader, List<ArrayList<Pair<Net, Integer>>> outMatrix, List<Net> designNets, PrintStream out) {
        out.println(pathHeader);
        out.println(detailHeader);
        Integer curRow = 0;
        char[] emptycells = new char[1];
        Arrays.fill(emptycells, ',');
        for (ArrayList<Pair<Net, Integer>> row : outMatrix) {
            StringBuilder line = new StringBuilder();
            line.append(designNets.get(curRow).getName());
            line.append(',');
            this.pathHeaderAddEmptyCell(line);
            int curOutCol = 1;
            HashMap recordEachCol = new HashMap();
            for (Pair<Net, Integer> p : row) {
                while (curOutCol < (Integer)p.getValue1()) {
                    line.append(emptycells);
                    ++curOutCol;
                }
                HashSet<Net> colSet = (HashSet<Net>)recordEachCol.get(curOutCol);
                if (colSet == null) {
                    colSet = new HashSet<Net>();
                    colSet.add((Net)p.getValue0());
                } else {
                    if (colSet.contains(p.getValue0())) continue;
                    colSet.add((Net)p.getValue0());
                }
                recordEachCol.put(curOutCol, colSet);
                line.append(' ');
                line.append(((Net)p.getValue0()).getName());
            }
            out.println(line);
            Integer n = curRow;
            Integer n2 = curRow = Integer.valueOf(curRow + 1);
        }
    }

    private int recursiveSearchNetConnection(Net net, List<Pair<Net, Integer>> netsNeedToOutPut, StringBuilder pathHeader, StringBuilder detailHeader, Map<DevicePath, Integer> dieTodestinationCol, Integer c, DevicePath devPath) {
        int curCol = c;
        for (NetMap nm : NetMap.getChildNets((Net)net)) {
            if (nm.getDevice().getType() == DeviceTemplate.Type.BUMP) continue;
            DevicePath childPath = new DevicePath(devPath, nm.getDevice());
            Integer targetCol = dieTodestinationCol.get(childPath);
            if (targetCol == null) {
                dieTodestinationCol.put(childPath, curCol);
                pathHeader.append("," + childPath.toString());
                this.pathHeaderAddEmptyCell(pathHeader);
                detailHeader.append(DETAIL_SUB_COLUMN);
                targetCol = curCol;
                ++curCol;
            }
            netsNeedToOutPut.add((Pair<Net, Integer>)new Pair((Object)nm.getChildNet(), (Object)targetCol));
            curCol = this.recursiveSearchNetConnection(nm.getChildNet(), netsNeedToOutPut, pathHeader, detailHeader, dieTodestinationCol, curCol, childPath);
        }
        netsNeedToOutPut.sort((p1, p2) -> Integer.compare((Integer)p1.getValue1(), (Integer)p2.getValue1()));
        return curCol;
    }

    private void pathHeaderAddEmptyCell(StringBuilder header) {
        char[] array = new char[]{};
        Arrays.fill(array, ',');
        header.append(array);
    }
}

