/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.optimizer;

import java.util.ArrayList;

public class ASpreader {
    long free;
    long numFree;
    ADistributionCurve distributionCurve;

    public void setDistribtionCurve(ADistributionCurve c) {
        this.distributionCurve = c;
    }

    public static ADistributionCurve createConstantSpreadingCurve(int numFree, long sep) {
        ADistributionCurve c = new ADistributionCurve(sep * (long)numFree);
        for (int i = 0; i < numFree; ++i) {
            long d = sep;
            c.add(d);
        }
        return c;
    }

    public static ADistributionCurve createEvenSpreadingCurve(int numFree, long total) {
        ADistributionCurve c = new ADistributionCurve(total);
        double per = 1.0 / (double)numFree;
        for (int i = 0; i < numFree; ++i) {
            long d = (long)(per * (double)total);
            c.add(d);
        }
        return c;
    }

    public static ADistributionCurve createSquish(int numFree, long total, boolean beginning) {
        ADistributionCurve c = new ADistributionCurve(total);
        for (int i = 0; i < numFree - 1; ++i) {
            long d = 0L;
            c.add(d);
        }
        if (beginning) {
            c.add(total);
        } else {
            c.add(0, total);
        }
        return c;
    }

    public static ADistributionCurve createVCurve(int numFree, long total) {
        long d;
        double percent;
        long y;
        int i;
        ADistributionCurve c = new ADistributionCurve(total);
        int cI = numFree / 2;
        long halfTotal = total / 2L;
        long avg = halfTotal / (long)cI;
        long resolution = 100000L;
        double mid = 0.4;
        double halfheight = (1.0 - mid) * (double)resolution / 2.0 + mid * (double)resolution;
        long yPer = (long)((1.0 - mid) * (double)resolution / (double)cI);
        for (i = 0; i < cI; ++i) {
            y = resolution - yPer * (long)i;
            percent = (double)y / halfheight;
            d = (long)(percent * (double)avg);
            c.add(d);
        }
        for (i = 0; i < numFree - cI; ++i) {
            y = (long)(mid * (double)resolution) + yPer * (long)i;
            percent = (double)y / halfheight;
            d = (long)(percent * (double)avg);
            c.add(d);
        }
        return c;
    }

    public static class ADistributionCurve
    extends ArrayList<Long> {
        long sum;

        public ADistributionCurve(long s) {
            this.sum = s;
        }

        public long getArea(int i) {
            return (Long)this.get(i);
        }
    }
}

