/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.optimizer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;

public class BinPacking {
    LinkedList<MyBlock> available = new LinkedList();
    LinkedList<MyBlock> solution = new LinkedList();
    long space = 0L;

    public void set1DSpace(long space) {
        this.space = space;
    }

    public void add1DBlock(Object owner, long size) {
        MyBlock b = new MyBlock(owner, size);
        this.available.add(b);
    }

    public ArrayList<Object> solve1D() {
        if (this.space <= 0L) {
            return null;
        }
        if (this.available.size() == 0) {
            return null;
        }
        Collections.sort(this.available, new AvailbleSorter());
        long spaceLeft = -1L;
        for (int start = 0; start < this.available.size(); ++start) {
            this.solution.clear();
            spaceLeft = this.space;
            int i = start;
            MyBlock next = this.available.get(i);
            while (spaceLeft >= next.size) {
                spaceLeft -= next.size;
                this.solution.add(next);
                while (spaceLeft < next.size && i < this.available.size() - 1) {
                    next = this.available.get(++i);
                }
            }
            if (spaceLeft == 0L) break;
        }
        if (spaceLeft != 0L) {
            return null;
        }
        ArrayList<Object> ret = new ArrayList<Object>();
        for (MyBlock b : this.solution) {
            ret.add(b.owner);
        }
        return ret;
    }

    public static void test() {
        BinPacking bp = new BinPacking();
        bp.set1DSpace(27L);
        Long l0 = 25L;
        Long l1 = 3L;
        bp.add1DBlock(l0, l0);
        bp.add1DBlock(l1, l1);
    }

    protected static class AvailbleSorter
    implements Comparator<MyBlock> {
        protected AvailbleSorter() {
        }

        @Override
        public int compare(MyBlock b0, MyBlock b1) {
            return Long.compare(b1.size, b0.size);
        }
    }

    protected static class MyBlock {
        Object owner;
        long size;

        public MyBlock(Object owner, long size) {
            this.owner = owner;
            this.size = size;
        }
    }
}

