/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.optimizer;

import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class CombinatoricOperator<T>
implements Iterator<T[]>,
Iterable<T[]> {
    protected T[] mElements;
    protected int[] mIndices;
    private BigInteger mNumLeft;
    private BigInteger mTotal;

    protected CombinatoricOperator(T[] elements, int r) {
        assert (0 <= r);
        this.mIndices = new int[r];
        this.mElements = (Object[])elements.clone();
        this.mTotal = this.initialiseTotal(elements.length, r);
        this.reset();
    }

    protected void initialiseIndices() {
        for (int i = 0; i < this.mIndices.length; ++i) {
            this.mIndices[i] = i;
        }
    }

    protected abstract BigInteger initialiseTotal(int var1, int var2);

    public void reset() {
        this.initialiseIndices();
        this.mNumLeft = this.mTotal;
    }

    public BigInteger getNumLeft() {
        return this.mNumLeft;
    }

    public BigInteger getTotal() {
        return this.mTotal;
    }

    @Override
    public boolean hasNext() {
        return this.mNumLeft.compareTo(BigInteger.ZERO) > 0;
    }

    @Override
    public T[] next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (!this.mNumLeft.equals(this.mTotal)) {
            this.computeNext();
        }
        this.mNumLeft = this.mNumLeft.subtract(BigInteger.ONE);
        return this.getResult(this.mIndices);
    }

    protected abstract void computeNext();

    private T[] getResult(int[] indexes) {
        Object[] result = (Object[])Array.newInstance(this.mElements.getClass().getComponentType(), indexes.length);
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.mElements[indexes[i]];
        }
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<T[]> iterator() {
        return this;
    }

    public static BigInteger factorial(int n) {
        BigInteger fact = BigInteger.ONE;
        for (int i = n; i > 1; --i) {
            fact = fact.multiply(BigInteger.valueOf(i));
        }
        return fact;
    }
}

