/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.optimizer;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.optimizer.GoodnessFinder;
import com.sigrity.acl.optimizer.NetCoster;
import com.sigrity.acl.optimizer.NewPermuter;
import com.sigrity.acl.optimizer.PlacementGoodness;
import com.sigrity.acl.optimizer.SiteSearcher;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.automation.experimental.GreedyCluster;
import com.sigrity.orbit.automation.experimental.OrbitToComponent;
import java.io.FileWriter;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;

public class ConstructivePlacement {
    protected ArrayList<DevicePath> mToBePlaced;
    protected long mDevToDevClearance = 0L;
    protected long mDevToParentClearance = 0L;
    protected long mTimetoRun = 0L;
    protected DevicePath mPlaceOnPath;
    protected Device mPlaceOn;
    protected DeviceTemplate mPlaceOnTemplate;
    protected ARect mPlaceOnBound = null;
    protected ArrayList<DevicePath> mObstacles = new ArrayList();
    protected Constraint.SIPSearch mSearch = Constraint.SIPSearch.FAST;
    protected Boolean mMirrorEnable = false;
    protected SiteSearcher mSiteSearcher = null;
    protected Boolean mAnnimation = false;
    protected long mPlacementMode = 0L;
    protected SiteSearcher.Distributor<?> mSiteDistributor = null;
    private PlaceInfos mPlaceInfos = new PlaceInfos();
    private PlaceInfo mBest = new PlaceInfo();
    private double mStartingScore = -1.0;
    private double mBestListScore = -1.0;
    private double mBestScore = 0.0;
    private boolean mScoredAlready = false;
    private int mIterPasses = 1;
    private int mTotalPasses = 1;
    private double mCompleteRatio = 0.0;
    private double mStepRatio;
    protected NetCoster mNetCoster = new NetCoster();
    protected boolean mNeedToUpdateConnects = false;
    protected boolean mJustCount = false;
    protected int mActualIter = 0;
    protected boolean mVerboseMode = true;
    protected static LinkedList<LoadListener> sLoadListener = new LinkedList();
    protected static LinkedList<LoadListener> sImprovementListener = new LinkedList();
    public GreedyCluster mGc;

    public void setPaths(DevicePath placeOnPath) {
        this.mPlaceOn = placeOnPath.getLast();
        this.mPlaceOnPath = new DevicePath(placeOnPath);
        this.mPlaceOnTemplate = this.mPlaceOn.getTemplate();
        this.mPlaceOnBound = this.mPlaceOnTemplate.getBB();
    }

    public boolean getAnimation() {
        return this.mAnnimation;
    }

    public long getMode() {
        return this.mPlacementMode;
    }

    public void setDevToDevClearance(long clearance) {
        this.mDevToDevClearance = clearance;
    }

    public void setDevToParentClearance(long clearance) {
        this.mDevToParentClearance = clearance;
    }

    public long getDevToDevClearance() {
        return this.mDevToDevClearance;
    }

    public long getDevToParentClearance() {
        return this.mDevToParentClearance;
    }

    public void setTimeToRun(long time) {
        this.mTimetoRun = time;
    }

    public long getTimeToRun() {
        return this.mTimetoRun;
    }

    public void setSearch(Constraint.SIPSearch search) {
        this.mSearch = search;
    }

    public void enableMirroring(boolean mirror) {
        this.mMirrorEnable = mirror;
    }

    protected void enableAnnimation(boolean annimation) {
        this.mAnnimation = annimation;
    }

    protected void setMode(long mode) {
        this.mPlacementMode = mode;
    }

    public void setActiveDevices(ArrayList<DevicePath> devices) {
        this.mToBePlaced = new ArrayList<DevicePath>(devices);
        this.mPlaceInfos.clear();
        for (DevicePath dp : this.mToBePlaced) {
            this.mPlaceInfos.add(dp);
        }
        Collections.sort(this.mToBePlaced, new SortSize());
    }

    public void setVerboseMode(boolean verbose) {
        this.mVerboseMode = verbose;
    }

    public void placeAll() {
        ArrayList<ArrayList<DevicePath>> lists;
        assert (this.mToBePlaced != null && !this.mToBePlaced.isEmpty());
        this.init();
        boolean solutionFound = false;
        this.mBestListScore = -1.0;
        int nDevices = this.mToBePlaced.size();
        int mMaxPermuterSize = 4;
        ArrayList<DevicePath> bestOrderList = new ArrayList<DevicePath>();
        this.determineObstacles();
        if (nDevices <= mMaxPermuterSize) {
            lists = this.getPermutedLists(this.mToBePlaced);
            this.mIterPasses = lists.size();
            this.mJustCount = true;
            this.mActualIter = 0;
            for (int iter = 0; iter < 1; ++iter) {
                this.placeList(lists.get(iter));
            }
            this.mJustCount = false;
            this.mStepRatio = 1.0 / (double)this.mActualIter;
            int bestIter = 0;
            this.mActualIter = 0;
            for (int iter = 0; iter < this.mIterPasses; ++iter) {
                double score = this.placeList(lists.get(iter));
                if (score == -1.0 || solutionFound && !(score < this.mBestListScore)) continue;
                this.updateBestPlaceList(score);
                solutionFound = true;
                this.mBestListScore = score;
                bestIter = iter;
            }
            bestOrderList.addAll((Collection)lists.get(bestIter));
        } else {
            lists = this.getSortedList(this.mToBePlaced);
            this.mIterPasses = lists.size();
            this.mJustCount = true;
            this.mActualIter = 0;
            for (int iter = 0; iter < 1; ++iter) {
                this.placeList(lists.get(iter));
            }
            this.mJustCount = false;
            this.mStepRatio = 1.0 / (double)this.mActualIter;
            int bestIter = 0;
            this.mActualIter = 0;
            for (int iter = 0; iter < 1; ++iter) {
                double score = this.placeList(lists.get(iter));
                if (score == -1.0 || solutionFound && !(score < this.mBestListScore)) continue;
                this.updateBestPlaceList(score);
                solutionFound = true;
                this.mBestListScore = score;
                bestIter = iter;
            }
            bestOrderList.addAll((Collection)lists.get(bestIter));
        }
        if (this.mSearch == Constraint.SIPSearch.MEDIUM) {
            if (bestOrderList.isEmpty()) {
                bestOrderList.addAll(this.mToBePlaced);
            }
            solutionFound = this.findForceSitesOnParent(bestOrderList, solutionFound);
        } else if (this.mSearch == Constraint.SIPSearch.EXHAUSTIVE) {
            if (bestOrderList.isEmpty()) {
                bestOrderList.addAll(this.mToBePlaced);
            }
            solutionFound = this.findSitesOnParent(bestOrderList, solutionFound);
        }
        if (!solutionFound) {
            this.mPlaceInfos.restore();
            this.updateProgress(true, 100.0, "Failed to find new solution. Restore original placement.");
            this.initImprovementUpdate();
        } else {
            this.mPlaceInfos.place();
            String s = nDevices > 1 ? " devices are" : " device is";
            this.updateProgress(true, 100.0, "All " + nDevices + s + " placed.");
        }
    }

    private void init() {
        for (DevicePath dp : this.mToBePlaced) {
            this.mNetCoster.addDevice(dp, false);
        }
        this.mNetCoster.addBackground(this.mPlaceOnPath);
        this.mNetCoster.removeSingularities();
        ArrayList<DevicePath> allPlaced = new ArrayList<DevicePath>();
        allPlaced.add(this.mPlaceOnPath);
        for (DevicePath placedDp : this.mToBePlaced) {
            allPlaced.add(placedDp);
        }
        this.mStartingScore = this.mNetCoster.getTotalNetArea();
        this.initImprovementUpdate();
        this.mCompleteRatio = 0.0;
        this.mIterPasses = 1;
        this.mTotalPasses = 1;
        if (this.mSearch != Constraint.SIPSearch.FAST) {
            ++this.mTotalPasses;
        }
        this.mSiteSearcher = new SiteSearcher();
        this.mSiteSearcher.setClr(this.mDevToDevClearance, this.mDevToParentClearance);
    }

    private ArrayList<DevicePath> mutatePath(ArrayList<DevicePath> original) {
        ArrayList<DevicePath> mutated = new ArrayList<DevicePath>();
        Random mRandom = new Random(3141592L);
        int i = mRandom.nextInt(original.size());
        int j = mRandom.nextInt(original.size());
        mutated.addAll(original);
        DevicePath t = (DevicePath)mutated.get(i);
        mutated.set(i, (DevicePath)mutated.get(j));
        mutated.set(j, t);
        return mutated;
    }

    private ArrayList<ArrayList<DevicePath>> getSortedList(ArrayList<DevicePath> list) {
        ArrayList<ArrayList<DevicePath>> lists = new ArrayList<ArrayList<DevicePath>>();
        Collections.sort(list, new SortSmallToBig());
        lists.add(list);
        ArrayList<DevicePath> byCon = this.sortByConnectivity(list);
        lists.add(byCon);
        ArrayList<DevicePath> mutated = this.mutatePath(byCon);
        for (int i = 0; i < 100; ++i) {
            lists.add(mutated);
            mutated = this.mutatePath(byCon);
        }
        return lists;
    }

    private HashSet<Net> getSubstrateNets(DevicePath devicePath) {
        HashSet<Net> substrateNets = new HashSet<Net>();
        for (PinTemplate pt : devicePath.getDeviceTemplate().getPins()) {
            Net substrateNet = NetMap.getNetAt((Net)pt.getNet(), (DevicePath)devicePath, (DeviceTemplate)this.mPlaceOnTemplate);
            if (Net.isPowerNet((Net)substrateNet)) continue;
            substrateNets.add(substrateNet);
        }
        return substrateNets;
    }

    private ArrayList<DevicePath> sortByConnectivity(ArrayList<DevicePath> unsorted) {
        HashSet<DevicePath> unused = new HashSet<DevicePath>();
        ArrayList<DevicePath> sortedList = new ArrayList<DevicePath>();
        unused.addAll(unsorted);
        HashSet<Net> baseNets = new HashSet<Net>();
        while (unused.size() > 0) {
            int mostConnected = 0;
            DevicePath bestDevicePath = null;
            for (DevicePath candidate : unused) {
                int myConnections = this.connectionsToSet(baseNets, candidate);
                if (bestDevicePath != null && myConnections <= mostConnected) continue;
                mostConnected = myConnections;
                bestDevicePath = candidate;
            }
            unused.remove(bestDevicePath);
            sortedList.add(bestDevicePath);
            baseNets.addAll(this.getSubstrateNets(bestDevicePath));
        }
        return sortedList;
    }

    private int connectionsToSet(HashSet<Net> set, DevicePath device) {
        int count = 0;
        HashSet<Net> deviceNets = this.getSubstrateNets(device);
        if (set.isEmpty()) {
            return deviceNets.size();
        }
        for (Net n : deviceNets) {
            if (!set.contains(n)) continue;
            ++count;
        }
        return count;
    }

    private ArrayList<ArrayList<DevicePath>> getPermutedLists(ArrayList<DevicePath> list) {
        ArrayList<ArrayList<DevicePath>> lists = new ArrayList<ArrayList<DevicePath>>();
        for (ArrayList variation : new NewPermuter<DevicePath>(list)) {
            lists.add(variation);
        }
        return lists;
    }

    private double placeList(ArrayList<DevicePath> list) {
        this.prepForPlacingList();
        double totalBestScore = 0.0;
        int failed = 0;
        for (DevicePath dp : list) {
            if (this.placeMe(dp)) {
                totalBestScore = this.mBestScore;
                continue;
            }
            ++failed;
        }
        return failed > 0 ? -1.0 : totalBestScore;
    }

    private void unplaceAll() {
        for (DevicePath dp : this.mToBePlaced) {
            dp.getLast().setIsPlaced(false);
        }
    }

    private boolean findSitesOnParent(ArrayList<DevicePath> bestOrderedList, boolean solutionFound) {
        if (solutionFound) {
            this.mPlaceInfos.setToBest();
        }
        if (!this.setupPlaceSites()) {
            return solutionFound;
        }
        this.prepForPlacingList();
        this.markOutObstacleSites();
        double score = 0.0;
        int failed = 0;
        for (DevicePath dp : bestOrderedList) {
            if (this.relocateMe(dp, solutionFound)) {
                score = this.mBestScore;
                continue;
            }
            ++failed;
        }
        if (failed > 0) {
            score = -1.0;
        }
        if (score != -1.0 && (!solutionFound || score < this.mBestListScore)) {
            this.updateBestPlaceList(score);
            this.mBestListScore = score;
            solutionFound = true;
        }
        return solutionFound;
    }

    private boolean findForceSitesOnParent(ArrayList<DevicePath> bestOrderedList, boolean solutionFound) {
        ArrayList<DevicePath> alreadyPlaced = new ArrayList<DevicePath>();
        alreadyPlaced.add(this.mPlaceOnPath);
        if (solutionFound) {
            this.mPlaceInfos.setToBest();
            alreadyPlaced.addAll(this.mToBePlaced);
        }
        double score = 0.0;
        int failed = 0;
        for (DevicePath dp : bestOrderedList) {
            if (!this.setupPlaceSites()) {
                return solutionFound;
            }
            this.mObstacles.remove(dp);
            this.markOutObstacleSites();
            if (this.relocateMe(dp, solutionFound)) {
                score = this.mBestScore;
                continue;
            }
            if (solutionFound) {
                for (PlaceInfo pi : this.mPlaceInfos.mPlaceInfoList) {
                    if (pi.mPath != dp) continue;
                    pi.setToBest();
                }
                score = this.mNetCoster.getTotalNetArea();
                continue;
            }
            ++failed;
        }
        if (failed > 0) {
            score = -1.0;
        }
        if (score != -1.0 && (!solutionFound || score < this.mBestListScore)) {
            this.updateBestPlaceList(score);
            this.mBestListScore = score;
            solutionFound = true;
        }
        return solutionFound;
    }

    private boolean setupPlaceSites() {
        int percentage = 1;
        this.mSiteDistributor = SiteSearcher.createEvenDistributor(this.mPlaceOnBound, this.mDevToParentClearance, percentage);
        if (this.mSiteDistributor.isEmpty()) {
            this.mCompleteRatio = (double)(this.mTotalPasses - 1) / (double)this.mTotalPasses;
            return false;
        }
        this.mSiteSearcher.setDistributor(this.mSiteDistributor);
        return true;
    }

    private void markOutObstacleSites() {
        for (DevicePath dp : this.mObstacles) {
            DevicePath relative = new DevicePath(dp);
            relative.removeFirst();
            ARect r = relative.getBB();
            this.mSiteSearcher.addObstacleArea(r, this.mDevToDevClearance);
        }
    }

    private void prepForPlacingList() {
        this.unplaceAll();
        this.determineObstacles();
    }

    protected boolean relocateMe(DevicePath dp, boolean solutionFound) {
        Device device = this.initPlace(dp);
        if (device == null) {
            return false;
        }
        String dName = device.getName();
        SiteSearcher.LocDistributor distributor = this.mSiteSearcher.getLocDistributor();
        int steps = distributor.size() * this.mToBePlaced.size();
        int totalSteps = steps * this.mTotalPasses;
        this.mStepRatio = 1.0 / (double)totalSteps;
        for (APoint2D loc : distributor) {
            device.setLoc(loc);
            if (this.canPlaceHere(dp)) {
                this.updateBest(dp);
            }
            this.mCompleteRatio += this.mStepRatio;
            this.updateProgress(false, this.mCompleteRatio, "searching harder for " + dName);
        }
        this.setEndingState(dp);
        return device.getIsPlaced();
    }

    protected boolean placeMe(DevicePath dp) {
        this.mSiteDistributor = SiteSearcher.createObstacleEdgeDistributor(this.mPlaceOnBound, this.mDevToParentClearance);
        this.mSiteSearcher.setDistributor(this.mSiteDistributor);
        for (DevicePath o : this.mObstacles) {
            DevicePath relative = new DevicePath(o);
            relative.removeFirst();
            ARect r = relative.getBB();
            this.mSiteSearcher.addObstacleArea(r, this.mDevToDevClearance);
        }
        if (this.mSiteDistributor.isEmpty()) {
            return false;
        }
        SiteSearcher.EdgeDistributor distributor = (SiteSearcher.EdgeDistributor)this.mSiteDistributor;
        Device device = this.initPlace(dp);
        if (device == null) {
            return false;
        }
        APoint2D center = this.mPlaceOnBound.center();
        this.placeAtCenter(device, center);
        this.tryAllRotsAndMirrorsHere(dp, null, 0);
        long nEdgeSites = distributor.getSitesPerEdge();
        for (SiteSearcher.EdgeSites sites : distributor) {
            int locIndex = 0;
            while ((long)locIndex < nEdgeSites) {
                this.tryAllRotsAndMirrorsHere(dp, sites, locIndex);
                ++locIndex;
            }
        }
        this.setEndingState(dp);
        return device.getIsPlaced();
    }

    private void tryAllRotsAndMirrorsHere(DevicePath dp, SiteSearcher.EdgeSites sites, int locIndex) {
        int mirrors = this.mMirrorEnable != false ? 2 : 1;
        Device device = dp.getLast();
        if (this.mJustCount) {
            for (int i = 0; i < mirrors; ++i) {
                for (float r = 0.0f; r < 360.0f; r += 90.0f) {
                    ++this.mActualIter;
                    this.updateBest(dp);
                }
            }
        } else {
            for (int i = 0; i < mirrors; ++i) {
                if (this.mMirrorEnable.booleanValue()) {
                    device.setMirror(i != 0);
                }
                for (float r = 0.0f; r < 360.0f; r += 90.0f) {
                    device.setRotate(r);
                    if (sites != null) {
                        sites.placeAtSite(dp, this.mPlaceOnPath, locIndex, this.mDevToDevClearance);
                    }
                    if (this.canPlaceHere(dp)) {
                        this.updateBest(dp);
                    }
                    this.mCompleteRatio += this.mStepRatio;
                    this.updateProgress(false, this.mCompleteRatio, "");
                    ++this.mActualIter;
                }
            }
        }
    }

    private Device initPlace(DevicePath dp) {
        this.mBestScore = 0.0;
        this.mBest.resetBest();
        Device device = dp.getLast();
        this.mScoredAlready = false;
        device.setIsPlaced(true);
        return device;
    }

    private void updateBestPlaceList(double newScore) {
        double improvement = (this.mStartingScore - newScore) / this.mStartingScore;
        this.updateImprovement(improvement);
        this.updateBestPlaceList();
    }

    private void updateBestPlaceList() {
        this.mPlaceInfos.updateBestWithCurrent();
    }

    private void placeAtCenter(Device device, APoint2D center) {
        device.setLoc(center);
        DeviceTemplate t = device.getTemplate();
        ARect r = new ARect(t.getBB());
        ARect b = r.transform(device.getLocalTransformMatrix()).getBounds();
        long dx = b.centerX() - center.getX();
        long dy = b.centerY() - center.getY();
        device.moveBy(dx, dy);
    }

    private void setEndingState(DevicePath dp) {
        Device device = dp.getLast();
        if (this.mScoredAlready) {
            device.setLoc(new APoint2D(this.mBest.mBestL));
            device.setRotate(this.mBest.mBestR);
            device.setMirror(this.mBest.mBestM);
            this.mObstacles.add(dp);
            this.mSiteSearcher.addObstacleArea(this.getRectRelativeToParent(dp), this.mDevToDevClearance);
        } else {
            device.setIsPlaced(false);
        }
    }

    protected ARect getRectRelativeToParent(DevicePath dp) {
        DevicePath relative = new DevicePath(dp);
        relative.removeFirst();
        return relative.getBB();
    }

    protected void determineObstacles() {
        this.mObstacles.clear();
        for (DevicePath dp : this.mPlaceOnPath.getChildren()) {
            Device d = dp.getLast();
            if (!d.getIsPlaced() || !this.mPlaceOnBound.contains((AGeom)this.getRectRelativeToParent(dp)) || this.mToBePlaced.contains(dp)) continue;
            this.mObstacles.add(dp);
        }
    }

    private boolean canPlaceHere(DevicePath dp) {
        ARect bound = this.getRectRelativeToParent(dp);
        ARect chkBound = new ARect(bound);
        chkBound.grow(this.mDevToParentClearance - 1L);
        if (!this.mPlaceOnBound.contains((AGeom)chkBound)) {
            return false;
        }
        chkBound.setBounds(bound);
        chkBound.grow(this.mDevToDevClearance - 1L);
        for (DevicePath p : this.mObstacles) {
            ARect b = this.getRectRelativeToParent(p);
            if (!chkBound.intersects(b)) continue;
            return false;
        }
        return true;
    }

    private void updateBest(DevicePath dp) {
        double score;
        if (this.mAnnimation.booleanValue()) {
            this.mPlaceOnPath.getLast().manageMyUnplacedQ();
            OrbitIO.getApp().refreshCurrentView(true);
        }
        Device device = dp.getLast();
        ArrayList<DevicePath> alreadyPlaced = new ArrayList<DevicePath>();
        alreadyPlaced.add(this.mPlaceOnPath);
        for (DevicePath placedDp : this.mToBePlaced) {
            if (!placedDp.getLast().getIsPlaced()) continue;
            alreadyPlaced.add(placedDp);
        }
        if (!this.mJustCount) {
            score = this.mNetCoster.getTotalNetArea();
        } else {
            this.mScoredAlready = false;
            score = 0.0;
        }
        if (!this.mScoredAlready || score < this.mBestScore) {
            this.mBestScore = score;
            this.mScoredAlready = true;
            this.mBest.updateBest(device.getLoc(), device.getRotate(), device.getMirror());
        }
    }

    public static void placeSelected(DevicePath parentPath) {
        DeviceTemplate t = parentPath.getDeviceTemplate();
        Selection selection = Design.getSelection((Db)parentPath.getDb());
        ArrayList<DevicePath> toBePlaced = new ArrayList<DevicePath>();
        for (DevicePath dp : parentPath.getChildren()) {
            if (dp.getLast().getIsFixed() || dp.getSubstrate() != parentPath.getSubstrate()) continue;
            if (selection.contains((DbObject)dp.getLast())) {
                toBePlaced.add(dp);
                dp.getLast().setIsPlaced(true);
                continue;
            }
            dp.getLast().setIsPlaced(false);
        }
        Device.manageAllUnplaceQs();
        PlacementGoodness pg = new PlacementGoodness(parentPath);
        pg.setDomain(t);
        ConstructivePlacement cp = new ConstructivePlacement();
        cp.setPaths(parentPath);
        Personality.getPersonalities((DeviceTemplate)t, (Personality.Type)Personality.Type.DEVICE).forEach(p -> {
            Constraint annimation;
            Constraint mirroring;
            Constraint search;
            Constraint c = Constraint.getConstraint((Db)t.getDb(), (DbObject)p, (Constraint.Descriptor)Constraint.DEVICE_TO_DEVICE_CLEAR);
            if (c != null) {
                cp.setDevToDevClearance((Long)c.getValue());
            }
            if ((c = Constraint.getConstraint((Db)t.getDb(), (DbObject)p, (Constraint.Descriptor)Constraint.DEVICE_TO_PARENT_CLEAR)) != null) {
                cp.setDevToParentClearance((Long)c.getValue());
            }
            if ((search = Constraint.getConstraint((Db)t.getDb(), (DbObject)p, (Constraint.Descriptor)Constraint.SIP_SEARCH)) != null) {
                cp.setSearch((Constraint.SIPSearch)search.getValue());
            }
            if ((mirroring = Constraint.getConstraint((Db)t.getDb(), (DbObject)p, (Constraint.Descriptor)Constraint.MIRROR_ENABLE)) != null) {
                cp.enableMirroring((Boolean)mirroring.getValue());
            }
            if ((annimation = Constraint.getConstraint((Db)t.getDb(), (DbObject)p, (Constraint.Descriptor)Constraint.ANIMATION)) != null) {
                cp.enableAnnimation((Boolean)annimation.getValue());
            }
        });
        cp.setActiveDevices(toBePlaced);
        if (toBePlaced.size() > 0) {
            cp.placeAll();
        }
    }

    public void placeSelectedFromNode(String placeOnPathString, ArrayList<Device> children, String rulesCsvPath) {
        Db db = OrbitIO.getCurDb();
        if (db == null) {
            ALog.logError((String)"Cannot place selected devices, no current database.");
            return;
        }
        DevicePath parentPath = DevicePath.fromEscapedString((Db)db, (String)placeOnPathString);
        if (parentPath == null) {
            ALog.logError((String)"DevicePath '%s' does not exist", (Object[])new Object[]{placeOnPathString});
            return;
        }
        Design design = Design.getDesign((Db)db);
        Selection s = design.getCurSelection();
        for (Device device : s.get(Device.class)) {
            children.add(device);
        }
        try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)db, (String)"Cluster");){
            LinkedList<DevicePath> toBePlaced = new LinkedList<DevicePath>();
            children.stream().forEach(d -> toBePlaced.add(d.getADevicePath()));
            ArrayList<String> listOfNets = OrbitToComponent.generateHashSet(toBePlaced);
            this.mGc = new GreedyCluster();
            this.mGc.setVerboseMode(this.mVerboseMode);
            DeviceTemplate t = parentPath.getDeviceTemplate();
            ConstructivePlacement cp = new ConstructivePlacement();
            cp.setPaths(parentPath);
            Personality.getPersonalities((DeviceTemplate)t, (Personality.Type)Personality.Type.DEVICE).forEach(p -> {
                Constraint.PlacementMode placementmode;
                Constraint annimation;
                Constraint mirroring;
                Constraint time;
                Constraint c = Constraint.getConstraint((Db)t.getDb(), (DbObject)p, (Constraint.Descriptor)Constraint.DEVICE_TO_DEVICE_CLEAR);
                if (c != null) {
                    cp.setDevToDevClearance((Long)c.getValue());
                }
                if ((c = Constraint.getConstraint((Db)t.getDb(), (DbObject)p, (Constraint.Descriptor)Constraint.DEVICE_TO_PARENT_CLEAR)) != null) {
                    cp.setDevToParentClearance((Long)c.getValue());
                }
                if ((time = Constraint.getConstraint((Db)t.getDb(), (DbObject)p, (Constraint.Descriptor)Constraint.TIME_TO_RUN)) != null) {
                    cp.setTimeToRun(((Integer)time.getValue()).intValue());
                }
                if ((mirroring = Constraint.getConstraint((Db)t.getDb(), (DbObject)p, (Constraint.Descriptor)Constraint.MIRROR_ENABLE)) != null) {
                    cp.enableMirroring((Boolean)mirroring.getValue());
                }
                if ((annimation = Constraint.getConstraint((Db)t.getDb(), (DbObject)p, (Constraint.Descriptor)Constraint.ANIMATION)) != null) {
                    cp.enableAnnimation((Boolean)annimation.getValue());
                }
                if ((placementmode = (Constraint.PlacementMode)Constraint.getValue((Db)t.getDb(), (DbObject)p, (Constraint.Descriptor)Constraint.PLACEMENT_MODE)) == Constraint.PlacementMode.SIDES) {
                    cp.setMode(1L);
                } else if (placementmode == Constraint.PlacementMode.PIN) {
                    cp.setMode(2L);
                } else if (placementmode == Constraint.PlacementMode.HYBRID1) {
                    cp.setMode(3L);
                } else if (placementmode == Constraint.PlacementMode.HYBRID2) {
                    cp.setMode(4L);
                }
            });
            for (DevicePath dp : toBePlaced) {
                if (dp.getLast().getIsFixed()) {
                    this.mGc.addFixed(OrbitToComponent.toCompnent(dp, listOfNets));
                    continue;
                }
                this.mGc.addFree(OrbitToComponent.toCompnent(dp, listOfNets));
            }
            if (!children.isEmpty()) {
                this.mGc.setParentBounds(children.get(0).getParent().getBB());
            }
            ALog.logInfo((String)"%s", (Object[])new Object[]{this.mGc});
            this.mGc.go((int)design.getUnit().toUser(cp.getTimeToRun()), (long)design.getUnit().toUser(cp.getDevToDevClearance()), (long)design.getUnit().toUser(cp.getDevToParentClearance()), cp.getAnimation(), rulesCsvPath, cp.getMode());
        }
    }

    public void placeSelectedFromDesign(String placeOnPathString, String rulesCsvPath) {
        this.placeSelectedFromDesignWithLearnParams(placeOnPathString, rulesCsvPath, "", "", "");
    }

    public void placeSelectedFromDesignWithLearnParams(String placeOnPathString, String rulesCsvPath, String dirName, String experimentName, String mode) {
        Db db = OrbitIO.getCurDb();
        if (db == null) {
            ALog.logError((String)"Cannot place selected devices, no current database.");
            return;
        }
        DevicePath parentPath = DevicePath.fromEscapedString((Db)db, (String)placeOnPathString);
        if (parentPath == null) {
            ALog.logError((String)"DevicePath '%s' does not exist", (Object[])new Object[]{placeOnPathString});
            return;
        }
        Design design = Design.getDesign((Db)db);
        ArrayList<Device> children = new ArrayList<Device>();
        Selection s = design.getCurSelection();
        for (Device device : s.get(Device.class)) {
            children.add(device);
        }
        if (children.isEmpty()) {
            ALog.logError((String)"No devices selected, please select the devices you want to place.");
            return;
        }
        try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)db, (String)"Cluster");){
            LinkedList<DevicePath> toBePlaced = new LinkedList<DevicePath>();
            children.stream().forEach(d -> toBePlaced.add(d.getADevicePath()));
            ArrayList<String> listOfNets = OrbitToComponent.generateHashSet(toBePlaced);
            this.mGc = new GreedyCluster();
            this.mGc.setVerboseMode(this.mVerboseMode);
            DeviceTemplate t = parentPath.getDeviceTemplate();
            ConstructivePlacement cp = new ConstructivePlacement();
            cp.setPaths(parentPath);
            Personality.getPersonalities((DeviceTemplate)t, (Personality.Type)Personality.Type.DEVICE).forEach(p -> {
                Constraint annimation;
                Constraint mirroring;
                Constraint time;
                Constraint c = Constraint.getConstraint((Db)t.getDb(), (DbObject)p, (Constraint.Descriptor)Constraint.DEVICE_TO_DEVICE_CLEAR);
                if (c != null) {
                    cp.setDevToDevClearance((Long)c.getValue());
                }
                if ((c = Constraint.getConstraint((Db)t.getDb(), (DbObject)p, (Constraint.Descriptor)Constraint.DEVICE_TO_PARENT_CLEAR)) != null) {
                    cp.setDevToParentClearance((Long)c.getValue());
                }
                if ((time = Constraint.getConstraint((Db)t.getDb(), (DbObject)p, (Constraint.Descriptor)Constraint.TIME_TO_RUN)) != null) {
                    cp.setTimeToRun(((Integer)time.getValue()).intValue());
                }
                if ((mirroring = Constraint.getConstraint((Db)t.getDb(), (DbObject)p, (Constraint.Descriptor)Constraint.MIRROR_ENABLE)) != null) {
                    cp.enableMirroring((Boolean)mirroring.getValue());
                }
                if ((annimation = Constraint.getConstraint((Db)t.getDb(), (DbObject)p, (Constraint.Descriptor)Constraint.ANIMATION)) != null) {
                    cp.enableAnnimation((Boolean)annimation.getValue());
                }
                cp.setMode(1L);
            });
            for (DevicePath dp : toBePlaced) {
                if (dp.getParentDevice() == null) continue;
                if (dp.getLast().getIsFixed()) {
                    this.mGc.addFixed(OrbitToComponent.toCompnent(dp, listOfNets));
                    continue;
                }
                this.mGc.addFree(OrbitToComponent.toCompnent(dp, listOfNets));
            }
            if (!children.isEmpty()) {
                this.mGc.setParentBounds(((Device)children.get(0)).getParent().getBB());
            }
            this.mGc.setLearnParams(dirName, experimentName, mode);
            this.mGc.go(100, (long)design.getUnit().toUser(cp.getDevToDevClearance()), (long)design.getUnit().toUser(cp.getDevToParentClearance()), cp.getAnimation(), rulesCsvPath, 1L);
        }
        try (FileWriter fw = new FileWriter(dirName + "best.csv");){
            LinkedList<Double> best = this.mGc.getBestScores();
            Iterator iterator = best.iterator();
            while (iterator.hasNext()) {
                double b = (Double)iterator.next();
                fw.write(Double.toString(b) + "\n");
            }
            fw.flush();
        }
        catch (IOException e) {
            ALog.logError((Throwable)e, (String)"Cannot write scores into file '%s'", (Object[])new Object[]{dirName + "best.csv"});
        }
    }

    public static boolean placeSelected(String placeOnPathString) {
        Db db = OrbitIO.getCurDb();
        if (db == null) {
            ALog.logError((String)"Cannot place selected devices, no current database.");
            return false;
        }
        DevicePath placeOnPath = DevicePath.fromString((Db)OrbitIO.getCurDb(), (String)placeOnPathString);
        if (placeOnPath == null) {
            ALog.logWarn((String)"DevicePath '%s' does not exist", (Object[])new Object[]{placeOnPathString});
            return false;
        }
        ConstructivePlacement.placeSelected(placeOnPath);
        return true;
    }

    public static boolean addLoadListener(LoadListener l) {
        return sLoadListener.add(l);
    }

    public static boolean removeLoadListener(LoadListener l) {
        return sLoadListener.remove(l);
    }

    public static boolean addImprovementListener(LoadListener l) {
        return sImprovementListener.add(l);
    }

    public static boolean removeImprovementListener(LoadListener l) {
        return sImprovementListener.remove(l);
    }

    protected void firePercentUpdate(int percent, boolean done, String data) {
        for (LoadListener l : sLoadListener) {
            l.stats(percent, done, data);
        }
    }

    private void updateProgress(boolean done, double percent, String data) {
        int iPercent = (int)(percent * 100.0);
        this.firePercentUpdate(iPercent, done, data);
    }

    protected void fireImprovementUpdate(int percent) {
        for (LoadListener l : sImprovementListener) {
            l.stats(Math.abs(percent), false, percent >= 0 ? " better" : " worse");
        }
    }

    private void updateImprovement(double percent) {
        int iPercent = (int)(percent * 100.0);
        this.fireImprovementUpdate(iPercent);
    }

    protected void initImprovementUpdate() {
        for (LoadListener l : sImprovementListener) {
            l.stats(0, true, " ");
        }
    }

    public static interface LoadListener {
        public void stats(int var1, boolean var2, String var3);
    }

    protected class PlacementFinder
    extends GoodnessFinder<DevicePath> {
        protected PlacementFinder(ArrayList<DevicePath> list, PlaceGoodness goodness) {
            super(list, goodness);
        }

        @Override
        public void updateResult(double newScore) {
            ConstructivePlacement.this.updateBestPlaceList(newScore);
        }
    }

    protected class PlaceGoodness
    extends GoodnessFinder.Goodness<DevicePath> {
        protected int iterCount = 0;
        protected boolean foundOneSolution = false;

        protected PlaceGoodness() {
        }

        @Override
        public double getGoodness(AbstractList<DevicePath> list) {
            double score = ConstructivePlacement.this.placeList((ArrayList)list);
            if (score != -1.0) {
                this.foundOneSolution = true;
            }
            return score;
        }

        @Override
        public boolean hasNext() {
            boolean next = this.iterCount < ConstructivePlacement.this.mIterPasses;
            ++this.iterCount;
            return next;
        }
    }

    protected static class PlaceInfos {
        ArrayList<PlaceInfo> mPlaceInfoList = new ArrayList();

        protected PlaceInfos() {
        }

        protected void clear() {
            this.mPlaceInfoList.clear();
        }

        protected void add(DevicePath dp) {
            this.mPlaceInfoList.add(new PlaceInfo(dp));
        }

        protected void setToBest() {
            for (PlaceInfo info : this.mPlaceInfoList) {
                info.setToBest();
            }
        }

        protected void updateBestWithCurrent() {
            for (PlaceInfo pi : this.mPlaceInfoList) {
                pi.updateBestWithCurrent();
            }
        }

        protected void restore() {
            for (PlaceInfo p : this.mPlaceInfoList) {
                p.restore();
            }
        }

        protected void place() {
            for (PlaceInfo p : this.mPlaceInfoList) {
                p.place();
            }
        }
    }

    protected static class PlaceInfo {
        protected DevicePath mPath = null;
        protected APoint2D mLoc = new APoint2D();
        protected float mRotate = 0.0f;
        protected boolean mMirror = false;
        protected boolean mPlaced = false;
        protected APoint2D mBestL = new APoint2D();
        protected float mBestR = 0.0f;
        protected boolean mBestM = false;

        protected PlaceInfo() {
        }

        protected PlaceInfo(DevicePath path) {
            Device d = path.getLast();
            this.mPath = path;
            this.mLoc.setLoc(d.getLoc());
            this.mRotate = d.getRotate();
            this.mMirror = d.getMirror();
            this.mPlaced = d.getIsPlaced();
        }

        protected void updateBest(APoint2D location, float r, boolean m) {
            this.mBestL.setLoc(new APoint2D(location));
            this.mBestR = r;
            this.mBestM = m;
        }

        protected void updateBestWithCurrent() {
            Device d = this.mPath.getLast();
            this.mBestL.setLoc(d.getLoc());
            this.mBestR = d.getRotate();
            this.mBestM = d.getMirror();
        }

        protected void resetBest() {
            this.mBestL.setLoc(0L, 0L);
            this.mBestR = 0.0f;
            this.mBestM = false;
        }

        protected void restore() {
            Device d = this.mPath.getLast();
            d.setLoc(new APoint2D(this.mLoc));
            d.setRotate(this.mRotate);
            d.setMirror(this.mMirror);
            d.setIsPlaced(this.mPlaced);
        }

        protected void setToBest() {
            Device d = this.mPath.getLast();
            d.setLoc(new APoint2D(this.mBestL));
            d.setRotate(this.mBestR);
            d.setMirror(this.mBestM);
        }

        protected void place() {
            Device d = this.mPath.getLast();
            d.setLoc(new APoint2D(this.mBestL));
            d.setRotate(this.mBestR);
            d.setMirror(this.mBestM);
        }
    }

    public static class SortSmallToBig
    implements Comparator<DevicePath> {
        @Override
        public int compare(DevicePath p0, DevicePath p1) {
            Device d0 = p0.getLast();
            Device d1 = p1.getLast();
            return Double.compare(d0.getBB().area(), d1.getBB().area());
        }
    }

    public static class SortSize
    implements Comparator<DevicePath> {
        @Override
        public int compare(DevicePath p0, DevicePath p1) {
            Device d0 = p0.getLast();
            Device d1 = p1.getLast();
            return Double.compare(d0.getBB().area(), d1.getBB().area());
        }
    }
}

