/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.optimizer;

import com.sigrity.acl.ALog;
import com.sigrity.acl.IterableIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;

public class Flooder {
    Stack<FloodSpace> mFrontierStack = new Stack();
    HashMap<FloodSpace, FloodSpace> mFrontierHash = new HashMap();

    public Double add(FloodSpace from, FloodSpace to, double deltaCost, double heuristic) {
        int i;
        if (to == null) {
            return null;
        }
        double costToHere = 0.0;
        if (from != null) {
            costToHere = from.cost;
            to.nth = from.nth + 1;
        }
        double cost = costToHere + deltaCost;
        FloodSpace fs = this.mFrontierHash.get(to);
        if (fs != null) {
            if (fs.cost > cost) {
                this.mFrontierHash.remove(to);
            } else {
                return null;
            }
        }
        this.mFrontierHash.put(to, to);
        to.prevNode = from;
        to.cost = cost;
        to.heuristic = heuristic;
        int size = this.mFrontierStack.size();
        for (i = 0; i < size; ++i) {
            FloodSpace afs = (FloodSpace)this.mFrontierStack.get(i);
            if (afs.cost + afs.heuristic < cost + heuristic) break;
        }
        this.mFrontierStack.add(i, to);
        return cost;
    }

    public FloodSpace pop() {
        if (this.mFrontierStack.size() == 0) {
            return null;
        }
        FloodSpace fs = this.mFrontierStack.pop();
        return fs;
    }

    protected boolean validate() {
        for (int i = 1; i < this.mFrontierStack.size(); ++i) {
            if (!(((FloodSpace)this.mFrontierStack.get((int)(i - 1))).cost < ((FloodSpace)this.mFrontierStack.get((int)i)).cost)) continue;
            ALog.logError((String)"Invalid Frontier");
            return false;
        }
        return true;
    }

    public IterableIterator<FloodSpace> getBestPath(FloodSpace e) {
        return new PathIterator(e);
    }

    public static String toString(int x, int y) {
        return x + "," + y;
    }

    public static class PathIterator
    implements IterableIterator<FloodSpace> {
        private int mNumResults;
        private int mCurResults;
        private ArrayList<FloodSpace> mResultsList;

        public PathIterator(FloodSpace from) {
            this.setFrom(from);
        }

        public void setFrom(FloodSpace from) {
            this.mResultsList = new ArrayList();
            FloodSpace n = from;
            while (n != null) {
                this.mResultsList.add(n);
                n = n.prevNode;
            }
            this.mNumResults = this.mResultsList.size();
            this.mCurResults = 0;
        }

        public boolean hasNext() {
            return this.mCurResults < this.mNumResults;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public FloodSpace next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.mCurResults < this.mNumResults) {
                FloodSpace e = this.mResultsList.get(this.mCurResults);
                ++this.mCurResults;
                return e;
            }
            return null;
        }

        public Iterator<FloodSpace> iterator() {
            return this;
        }
    }

    public static abstract class FloodSpace {
        public int nth;
        public FloodSpace prevNode;
        public double cost;
        public double heuristic;
    }
}

