/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.optimizer;

import java.util.AbstractList;
import java.util.HashMap;

public abstract class GoodnessFinder<E> {
    AbstractList<E> mList;
    Goodness<E> mSorter;
    HashMap<E, Integer> mBestOrderList = new HashMap();
    double mBestListScore = -1.0;

    public abstract void updateResult(double var1);

    public GoodnessFinder(AbstractList<E> list, Goodness<E> f) {
        this.mList = list;
        this.mSorter = f;
    }

    public boolean go() {
        assert (this.mList != null && this.mSorter != null);
        if (this.mList.isEmpty()) {
            return false;
        }
        boolean foundSolution = false;
        while (this.mSorter.hasNext()) {
            this.mSorter.reOrder(this.mList);
            double score = this.mSorter.getGoodness(this.mList);
            if (score == -1.0 || foundSolution && !(score < this.mBestListScore)) continue;
            this.updateResult(score);
            foundSolution = true;
            this.mBestListScore = score;
            this.mBestOrderList.clear();
            int size = this.mList.size();
            for (int i = 0; i < size; ++i) {
                this.mBestOrderList.put(this.mList.get(i), i);
            }
        }
        return foundSolution;
    }

    public void getBestOrderedList(AbstractList<E> bestOrderedList) {
        int size = this.mList.size();
        for (int i = 0; i < size; ++i) {
            E e1 = this.mList.get(i);
            int j = this.mBestOrderList.get(e1);
            if (i == j) continue;
            E e2 = this.mList.get(j);
            this.mList.set(j, e1);
            this.mList.set(i, e2);
        }
    }

    public double getBestListScore() {
        return this.mBestListScore;
    }

    public static abstract class Goodness<E> {
        public abstract double getGoodness(AbstractList<E> var1);

        public abstract boolean hasNext();

        public void reOrder(AbstractList<E> list) {
            int cnt = list.size();
            if (cnt <= 1) {
                return;
            }
            int index1 = 0;
            int index2 = 0;
            while (index1 == index2) {
                index1 = (int)Math.round(Math.random() * (double)cnt);
                index2 = (int)Math.round(Math.random() * (double)cnt);
                if (index1 == cnt) {
                    index1 = cnt - 1;
                }
                if (index2 != cnt) continue;
                index2 = cnt - 1;
            }
            E e1 = list.get(index1);
            E e2 = list.get(index2);
            list.set(index2, e1);
            list.set(index1, e2);
        }
    }
}

