/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.optimizer;

import com.sigrity.acl.ALog;
import com.sigrity.acl.edaMgrs.WasIs;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APoint2D;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class LineCrossingOptimizer<TSWAP> {
    protected ArrayList<ClientLine<TSWAP>> mLines = new ArrayList();
    protected int mIndex;

    public void addLine(ALine l, TSWAP swapObj, String swapGroup) {
        this.addLine(l, null, swapObj, swapGroup);
    }

    public void addLine(ALine l, TSWAP swapObjBase, TSWAP swapObj, String swapGroup) {
        ClientLine fl = new ClientLine();
        fl.mLine.set(l);
        fl.mWasIs.setBase(swapObjBase);
        fl.mWasIs.setIs(swapObj);
        fl.mWasIs.setWas(swapObj);
        fl.mSwapGroup = swapGroup;
        this.mLines.add(fl);
    }

    public boolean optimize() {
        boolean improved = false;
        int costBefore = (int)this.cost();
        while (this.oneGreedyPass()) {
            improved = true;
        }
        int costAfter = (int)this.cost();
        ALog.logInfo((String)("Starting crosses: " + costBefore + "   Ending Crosses: " + costAfter));
        return improved;
    }

    protected void generateExcelFile(String fileName) {
        new File(fileName).delete();
        try (BufferedWriter out = new BufferedWriter(new FileWriter(fileName));){
            int size = this.mLines.size();
            for (int i = 0; i < size; ++i) {
                ALine li = this.mLines.get((int)i).mLine;
                long x0 = li.getP0().getX();
                long y0 = li.getP0().getY();
                long x1 = li.getP1().getX();
                long y1 = li.getP1().getY();
                out.write(x0 + "," + y0);
                out.newLine();
                out.write(x1 + "," + y1);
                out.newLine();
                out.newLine();
            }
        }
        catch (IOException e) {
            ALog.logError((Throwable)e);
        }
    }

    public boolean oneGreedyPass() {
        double costBefore = this.cost();
        int size = this.mLines.size();
        for (int i = 0; i < size; ++i) {
            for (int j = i + 1; j < size; ++j) {
                ALine lj;
                ALine li;
                if (!this.mLines.get((int)i).mSwapGroup.equals(this.mLines.get((int)j).mSwapGroup) || !(li = this.mLines.get((int)i).mLine).intersects((AGeom)(lj = this.mLines.get((int)j).mLine))) continue;
                this.swap(i, j);
            }
        }
        double costAfter = this.cost();
        return costAfter < costBefore;
    }

    public void swap(int i, int j) {
        ALine li = this.mLines.get((int)i).mLine;
        ALine lj = this.mLines.get((int)j).mLine;
        APoint2D temp = new APoint2D(li.getP1());
        li.setP1(lj.getP1());
        lj.setP1(temp);
        ClientLine<TSWAP> flI = this.mLines.get(i);
        ClientLine<TSWAP> flJ = this.mLines.get(j);
        TSWAP t = flI.getWasIs().getIs();
        flI.getWasIs().setIs(flJ.mWasIs.getIs());
        flJ.getWasIs().setIs(t);
    }

    public double cost() {
        double cost = 0.0;
        int size = this.mLines.size();
        for (int i = 0; i < size; ++i) {
            ALine lI = this.mLines.get((int)i).mLine;
            for (int j = i + 1; j < size; ++j) {
                ALine lJ = this.mLines.get((int)j).mLine;
                if (!lI.intersects((AGeom)lJ)) continue;
                cost += 1.0;
            }
        }
        return cost;
    }

    public Iterable<WasIs<TSWAP>> getChanges() {
        return new PairWasIsIterable();
    }

    private class PairWasIsIterable
    implements Iterable<WasIs<TSWAP>> {
        protected PairWasIsIterator mItr;

        @Override
        public Iterator<WasIs<TSWAP>> iterator() {
            this.mItr = new PairWasIsIterator();
            return this.mItr;
        }
    }

    public class PairWasIsIterator
    implements Iterator<WasIs<TSWAP>> {
        int mIndex = 0;

        @Override
        public boolean hasNext() {
            return this.mIndex < LineCrossingOptimizer.this.mLines.size();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public WasIs<TSWAP> next() {
            return LineCrossingOptimizer.this.mLines.get((int)this.mIndex++).mWasIs;
        }
    }

    protected static class ClientLine<E> {
        protected ALine mLine = new ALine();
        protected WasIs<E> mWasIs = new WasIs();
        protected String mSwapGroup;

        protected ClientLine() {
        }

        public WasIs<E> getWasIs() {
            return this.mWasIs;
        }
    }
}

