/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.optimizer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class LineSpringSpreader {
    ArrayList<Obj> mObjectList = new ArrayList();
    long mStart = 0L;
    long mEnd = 0L;
    long mMinSep = 0L;
    OnUnderLoad mOnUnderLoad = OnUnderLoad.MINMOVEMENT;

    public void onUnderLoad(OnUnderLoad oul) {
        this.mOnUnderLoad = oul;
    }

    public void line(long start, long end) {
        if (start < end) {
            this.mStart = start;
            this.mEnd = end;
        } else {
            this.mStart = end;
            this.mEnd = end;
        }
    }

    public void minSep(long minSep) {
        this.mMinSep = minSep;
    }

    public void addObject(Object userObject, long s, long d) {
        Obj object = new Obj();
        object.mUserObject = userObject;
        object.mS = s;
        object.mD = d;
        this.mObjectList.add(object);
    }

    public boolean relax() {
        if (this.mObjectList.size() == 0) {
            return false;
        }
        Collections.sort(this.mObjectList, new LineSorter());
        return this.relaxLine();
    }

    public Long getValue(Object o) {
        for (int i = 0; i < this.mObjectList.size(); ++i) {
            if (this.mObjectList.get((int)i).mUserObject != o) continue;
            return this.mObjectList.get((int)i).mS;
        }
        return null;
    }

    protected boolean relaxLine() {
        long length = this.mEnd - this.mStart;
        int numObj = this.mObjectList.size();
        long spaceRequired = 0L;
        for (int i = 0; i < numObj; ++i) {
            spaceRequired += this.mObjectList.get((int)i).mD;
        }
        if (length < (spaceRequired += (long)numObj * this.mMinSep + this.mMinSep)) {
            this.mOnUnderLoad = OnUnderLoad.EVEN;
        }
        if (this.mOnUnderLoad == OnUnderLoad.MINMOVEMENT) {
            this.relaxLineABit();
        } else {
            long slack = length - spaceRequired;
            long sep = this.mMinSep + slack / (long)(numObj + 1);
            long start = this.mStart + sep;
            for (Obj o : this.mObjectList) {
                o.mS = start;
                start += sep;
                this.mStart += o.mD / 2L;
            }
        }
        return true;
    }

    protected long beforeSlack(int index) {
        long lastS = this.mStart;
        long slack = 0L;
        for (int i = 0; i <= index; ++i) {
            slack += this.mObjectList.get((int)i).mS - lastS;
            lastS = this.mObjectList.get((int)i).mS;
        }
        return slack;
    }

    protected long afterSlack(int index) {
        long lastS = this.mEnd;
        long slack = 0L;
        for (int i = this.mObjectList.size() - 1; i >= index; --i) {
            slack += lastS - this.mObjectList.get((int)i).mS;
            lastS = this.mObjectList.get((int)i).mS;
        }
        return slack;
    }

    protected boolean atMinSep() {
        long lastS = this.mStart;
        for (int i = 0; i < this.mObjectList.size(); ++i) {
            long slack = this.mObjectList.get((int)i).mS - lastS;
            if (slack < this.mMinSep) {
                return false;
            }
            lastS = this.mObjectList.get((int)i).mS;
        }
        return this.mEnd - lastS >= this.mMinSep;
    }

    protected long beforeClr(int i) {
        int last = this.mObjectList.size();
        if (i == last) {
            return this.mEnd - this.mObjectList.get((int)(last - 1)).mS - this.mObjectList.get((int)(last - 1)).mD / 2L;
        }
        if (i == 0) {
            return this.mObjectList.get((int)i).mS - this.mStart - this.mObjectList.get((int)i).mD / 2L;
        }
        return this.mObjectList.get((int)i).mS - this.mObjectList.get((int)(i - 1)).mS - this.mObjectList.get((int)i).mD / 2L - this.mObjectList.get((int)(i - 1)).mD / 2L;
    }

    protected long afterClr(int i) {
        int last = this.mObjectList.size();
        if (i == -1) {
            return this.mObjectList.get((int)0).mS - this.mStart - this.mObjectList.get((int)0).mD / 2L;
        }
        if (i == last - 1) {
            return this.mEnd - this.mObjectList.get((int)i).mS - this.mObjectList.get((int)i).mD / 2L;
        }
        return this.mObjectList.get((int)(i + 1)).mS - this.mObjectList.get((int)i).mS - this.mObjectList.get((int)i).mD / 2L - this.mObjectList.get((int)(i + 1)).mD / 2L;
    }

    protected boolean pushAfter(int i, long ds) {
        boolean canDo = true;
        long currentAfter = this.afterClr(i);
        if (currentAfter < ds + this.mMinSep) {
            canDo = i < this.mObjectList.size() - 1 ? this.pushAfter(i + 1, ds + this.mMinSep - currentAfter) : false;
        }
        this.mObjectList.get((int)i).mS += ds;
        if (this.mObjectList.get((int)i).mS > this.mEnd) {
            this.mObjectList.get((int)i).mS = this.mEnd;
        }
        return canDo;
    }

    protected boolean pushBefore(int i, long ds) {
        boolean canDo = true;
        long currentBefore = this.beforeClr(i);
        if (currentBefore < ds + this.mMinSep) {
            canDo = i > 0 ? this.pushBefore(i - 1, ds + this.mMinSep - currentBefore) : false;
        }
        this.mObjectList.get((int)i).mS -= ds;
        if (this.mObjectList.get((int)i).mS < this.mStart) {
            this.mObjectList.get((int)i).mS = this.mStart;
        }
        return canDo;
    }

    protected boolean relaxLineABit() {
        int i;
        boolean canDoAfter = true;
        boolean canDoBefore = true;
        if (this.mObjectList.size() > 2) {
            int i2;
            boolean canDoCenter = true;
            int center = this.mObjectList.size() / 2;
            for (i2 = center + 1; i2 > 0 && canDoCenter; --i2) {
                if (this.beforeClr(i2) >= this.mMinSep || this.pushBefore(i2 - 1, this.mMinSep - this.beforeClr(i2))) continue;
                canDoCenter = false;
            }
            for (i2 = center; i2 < this.mObjectList.size() - 1 && canDoAfter; ++i2) {
                if (this.afterClr(i2) >= this.mMinSep || this.pushAfter(i2 + 1, this.mMinSep - this.afterClr(i2))) continue;
                canDoCenter = false;
            }
            if (canDoCenter) {
                return true;
            }
        }
        for (i = -1; i < this.mObjectList.size() - 1 && canDoAfter; ++i) {
            if (this.afterClr(i) >= this.mMinSep || this.pushAfter(i + 1, this.mMinSep - this.afterClr(i))) continue;
            canDoAfter = false;
        }
        if (canDoAfter) {
            return true;
        }
        for (i = this.mObjectList.size(); i > 0 && canDoBefore; --i) {
            if (this.beforeClr(i) >= this.mMinSep || this.pushBefore(i - 1, this.mMinSep - this.beforeClr(i))) continue;
            canDoBefore = false;
        }
        if (canDoBefore) {
            return true;
        }
        canDoAfter = true;
        this.mObjectList.get((int)0).mS = this.mStart + this.mMinSep;
        for (i = -1; i < this.mObjectList.size() - 1 && canDoAfter; ++i) {
            if (this.afterClr(i) >= this.mMinSep || this.pushAfter(i + 1, this.mMinSep - this.afterClr(i))) continue;
            canDoAfter = false;
        }
        return canDoAfter;
    }

    public static class LineSorter
    implements Comparator<Obj> {
        @Override
        public int compare(Obj o1, Obj o2) {
            return Long.compare(o1.mS, o2.mS);
        }
    }

    public static enum OnUnderLoad {
        MINMOVEMENT,
        EVEN;

    }

    protected static class Obj {
        Object mUserObject;
        long mOriginalS;
        long mMaxS;
        long mS;
        long mD;

        protected Obj() {
        }
    }
}

