/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.optimizer;

import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierPin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class NetCoster {
    protected HashMap<String, PortList> mNameToPorts = new HashMap();
    protected HashSet<DevicePath> mActiveDevices = new HashSet();
    protected DevicePath mBackgroundDevice = null;

    public double getTotalNetArea() {
        double area = 0.0;
        for (PortList pl : this.mNameToPorts.values()) {
            ARect plRect = null;
            for (HierPin dpp : pl) {
                APoint2D p;
                if (!dpp.getPath().getLast().getIsPlaced() || (p = dpp.getWorldLoc()) == null) continue;
                ARect r = new ARect(p, p);
                if (plRect == null) {
                    plRect = new ARect(r);
                    continue;
                }
                plRect.expand(r);
            }
            if (plRect == null) continue;
            area += Math.pow(plRect.perimeter(), 2.0);
        }
        return Math.sqrt(area);
    }

    protected void addNet(HierPin dpp, String name) {
        if (Net.isPowerNet((Net)dpp.getNet(), (DevicePath)dpp.getPath())) {
            return;
        }
        PortList pl = this.mNameToPorts.get(name);
        if (pl == null) {
            pl = new PortList();
            this.mNameToPorts.put(name, pl);
        }
        pl.add(dpp);
    }

    protected void addPorts(DevicePath dp, boolean background) {
        Device d = dp.getLast();
        for (PinInstance port : d.getPins()) {
            Constraint s;
            Personality personality = port.getPersonality();
            if (personality != null && (s = Constraint.getConstraint((Db)personality.getDb(), (DbObject)personality, (Constraint.Descriptor)Constraint.ALLOW_SWAPPING)) != null && ((Boolean)s.getValue()).booleanValue()) {
                this.addNet(new HierPin(dp, port), "Personality_" + personality.getName());
                continue;
            }
            Net portNet = port.getNet();
            Net n = NetMap.getTopmostNet((Net)portNet, (DevicePath)dp);
            if (n.isUnused()) continue;
            if (background) {
                if (!this.mNameToPorts.containsKey(n.getName())) continue;
                this.addNet(new HierPin(dp, port), n.getName());
                continue;
            }
            this.addNet(new HierPin(dp, port), n.getName());
        }
    }

    public void addBackground(DevicePath dp) {
        this.mBackgroundDevice = dp;
        this.addDevice(dp, true);
    }

    public void addDevice(DevicePath dp, boolean background) {
        if (!this.mActiveDevices.contains(dp)) {
            this.addPorts(dp, background);
            this.mActiveDevices.add(dp);
        }
        for (DevicePath childPath : dp.getChildren()) {
            if (this.mActiveDevices.contains(childPath)) continue;
            this.addPorts(childPath, background);
            this.mActiveDevices.add(childPath);
        }
    }

    public void removeSingularities() {
        ArrayList<String> toBeRemoved = new ArrayList<String>();
        for (String n : this.mNameToPorts.keySet()) {
            PortList pl = this.mNameToPorts.get(n);
            if (pl.size() > 1) continue;
            toBeRemoved.add(n);
        }
        for (String n : toBeRemoved) {
            this.mNameToPorts.remove(n);
        }
    }

    public String getTableString() {
        StringBuilder s = new StringBuilder();
        for (Map.Entry<String, PortList> e : this.mNameToPorts.entrySet()) {
            PortList pl = e.getValue();
            s.append(e.getKey() + "," + pl.size() + "\n");
        }
        return s.toString();
    }

    public static class NetOrPersonalityList
    extends ArrayList<String> {
    }

    public static class PortList
    extends ArrayList<HierPin> {
    }
}

