/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.optimizer;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class NewCombinatoricOperator<T>
implements Iterator<ArrayList<T>>,
Iterable<ArrayList<T>> {
    protected ArrayList<T> mElements;
    protected ArrayList<Integer> mIndices = new ArrayList();
    private BigInteger mNumLeft;
    private BigInteger mTotal;

    protected NewCombinatoricOperator(ArrayList<T> elements, int r) {
        assert (0 <= r);
        this.mElements = new ArrayList<T>(elements);
        this.mTotal = this.initialiseTotal(elements.size(), r);
        this.reset();
    }

    protected void initialiseIndices() {
        for (int i = 0; i < this.mElements.size(); ++i) {
            this.mIndices.add(i);
        }
    }

    protected abstract BigInteger initialiseTotal(int var1, int var2);

    public void reset() {
        this.initialiseIndices();
        this.mNumLeft = this.mTotal;
    }

    public BigInteger getNumLeft() {
        return this.mNumLeft;
    }

    public BigInteger getTotal() {
        return this.mTotal;
    }

    @Override
    public boolean hasNext() {
        return this.mNumLeft.compareTo(BigInteger.ZERO) > 0;
    }

    @Override
    public ArrayList<T> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (!this.mNumLeft.equals(this.mTotal)) {
            this.computeNext();
        }
        this.mNumLeft = this.mNumLeft.subtract(BigInteger.ONE);
        return this.getResult(this.mIndices);
    }

    protected abstract void computeNext();

    protected ArrayList<T> getResult(ArrayList<Integer> indexes) {
        ArrayList<T> result = new ArrayList<T>();
        for (int i = 0; i < indexes.size(); ++i) {
            result.add(this.mElements.get(indexes.get(i)));
        }
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<ArrayList<T>> iterator() {
        return this;
    }

    public static BigInteger factorial(int n) {
        BigInteger fact = BigInteger.ONE;
        for (int i = n; i > 1; --i) {
            fact = fact.multiply(BigInteger.valueOf(i));
        }
        return fact;
    }
}

