/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.optimizer;

import com.sigrity.acl.optimizer.NewCombinatoricOperator;
import java.math.BigInteger;
import java.util.ArrayList;

public class NewPermuter<T>
extends NewCombinatoricOperator<T> {
    public NewPermuter(ArrayList<T> elements) {
        super(elements, elements.size());
    }

    @Override
    protected BigInteger initialiseTotal(int n, int r) {
        return NewPermuter.factorial(n);
    }

    @Override
    protected void computeNext() {
        int i = this.mIndices.size() - 1;
        while ((Integer)this.mIndices.get(i - 1) >= (Integer)this.mIndices.get(i)) {
            --i;
        }
        int j = this.mIndices.size();
        while ((Integer)this.mIndices.get(j - 1) <= (Integer)this.mIndices.get(i - 1)) {
            --j;
        }
        this.swap(i - 1, j - 1);
        ++i;
        for (j = this.mIndices.size(); i < j; ++i, --j) {
            this.swap(i - 1, j - 1);
        }
    }

    private void swap(int a, int b) {
        Integer e1 = (Integer)this.mIndices.get(a);
        Integer e2 = (Integer)this.mIndices.get(b);
        this.mIndices.set(b, e1);
        this.mIndices.set(a, e2);
    }

    public static void test() {
        ArrayList<Integer> data = new ArrayList<Integer>();
        for (int i = 0; i < 3; ++i) {
            data.add(i);
        }
        for (ArrayList arrayList : new NewPermuter(data)) {
            System.out.println(arrayList);
        }
        System.out.println();
    }
}

