/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.optimizer;

import com.sigrity.acl.optimizer.CombinatoricOperator;
import java.math.BigInteger;

public class Permuter<T>
extends CombinatoricOperator<T> {
    public Permuter(T[] elements) {
        super(elements, elements.length);
    }

    @Override
    protected BigInteger initialiseTotal(int n, int r) {
        return Permuter.factorial(n);
    }

    @Override
    protected void computeNext() {
        int i = this.mIndices.length - 1;
        while (this.mIndices[i - 1] >= this.mIndices[i]) {
            --i;
        }
        int j = this.mIndices.length;
        while (this.mIndices[j - 1] <= this.mIndices[i - 1]) {
            --j;
        }
        this.swap(i - 1, j - 1);
        ++i;
        for (j = this.mIndices.length; i < j; ++i, --j) {
            this.swap(i - 1, j - 1);
        }
    }

    private void swap(int a, int b) {
        int temp = this.mIndices[a];
        this.mIndices[a] = this.mIndices[b];
        this.mIndices[b] = temp;
    }

    public static void test() {
        Integer[] data = new Integer[3];
        for (int i = 0; i < data.length; ++i) {
            data[i] = i;
        }
        for (Integer[] integerArray : new Permuter<Integer>(data)) {
            System.out.println("" + integerArray);
        }
        System.out.println();
    }
}

