/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.optimizer;

import com.sigrity.acl.ALog;
import com.sigrity.acl.MutableInteger;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.UserCommands;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;

public class PersonalityAssigner {
    public static int RunSeconds = 10;
    private ArrayList<PRatio> mPRatios = new ArrayList();
    private ArrayList<PinInstance> mActivePorts = new ArrayList();
    private ArrayList<ArrayList<ClusterElement>> mClusters = null;
    private Db mDb;
    private Substrate mSubstrate;
    private Substrate mProximity;
    private DevicePath mProximityPath;
    private boolean mReplace;
    HashMap<HierPin, APoint2D> mPortToLoc = new HashMap();
    HashMap<HierPin, Personality> mDevicePathPortToPersonality = new HashMap();
    ArrayList<HierPin> mActiveDPPs = new ArrayList();
    LinkedList<Personality> mSmallPersonality = new LinkedList();

    public static void assignSelectedRandomly(String dtName) {
        PersonalityAssigner.assignSelected(dtName, null, true);
    }

    public static void assignSelectedRandomly(String dtName, boolean replacePersonalityIfExist) {
        PersonalityAssigner.assignSelected(dtName, null, replacePersonalityIfExist);
    }

    public static void assignSelected(String dtName, String baseDtName) {
        PersonalityAssigner.assignSelected(dtName, baseDtName, true);
    }

    public static void assignSelected(String dtName, String baseDtName, boolean replacePersonalityIfExist) {
        PersonalityAssigner p = new PersonalityAssigner();
        p.assignSelectedMain(dtName, baseDtName, replacePersonalityIfExist);
    }

    public void assignSelectedMain(String dtName, String baseDtName) {
        this.assignSelectedMain(dtName, baseDtName, true);
    }

    public void assignSelectedMain(String dtName, String baseDtName, boolean replacePersonalityIfExist) {
        int totalRatio;
        this.mDb = OrbitIO.getCurDb();
        this.mReplace = replacePersonalityIfExist;
        this.reset();
        this.mSubstrate = Substrate.getSubstrate((Db)this.mDb, (String)dtName);
        if (this.mSubstrate == null) {
            ALog.logError((String)"Substrate '%s' not found", (Object[])new Object[]{dtName});
            return;
        }
        if (baseDtName != null) {
            this.mProximity = Substrate.getSubstrate((Db)this.mDb, (String)baseDtName);
            if (this.mProximity == null) {
                ALog.logError((String)"Substrate '%s' not found", (Object[])new Object[]{baseDtName});
                return;
            }
        } else {
            this.mProximity = null;
        }
        if ((totalRatio = this.loadRatioPersonalities()) == 0) {
            ALog.logError((String)"There is no valid 'Assignment Ratio' personality defined for substrate  '%s'", (Object[])new Object[]{dtName});
            return;
        }
        if (!this.loadActivePorts()) {
            ALog.logError((String)"No ballpads were selected.");
            return;
        }
        if (this.mProximity == null) {
            this.runRandomAssignment(totalRatio);
        } else {
            this.runProximityAssignment(totalRatio);
        }
        for (PRatio r : this.mPRatios) {
            ALog.logInfo((String)"Assigned %d pins to %s whose ratio is %d.", (Object[])new Object[]{r.mAssigned, r.mPersonality.getName(), r.mRatio});
        }
    }

    private void reset() {
        this.mActivePorts.clear();
        this.mPRatios.clear();
    }

    protected void createOutOfDBStructures(ArrayList<PinInstance> ports) {
        this.mPortToLoc.clear();
        this.mDevicePathPortToPersonality.clear();
        for (PinInstance port : ports) {
            long r;
            HierPin dpp = new HierPin(port.getDevice().getADevicePath(), port);
            this.mActiveDPPs.add(dpp);
            this.mPortToLoc.put(dpp, new APoint2D(dpp.getWorldLoc()));
            Personality p = dpp.getPin().getPersonality();
            this.mDevicePathPortToPersonality.put(dpp, p);
            Constraint c = Constraint.getConstraint((Db)this.mDb, (DbObject)p, (Constraint.Descriptor)Constraint.PORT_ASSIGN_RATIO);
            if (c == null || (r = ((Long)c.getValue()).longValue()) > 2L || this.mSmallPersonality.contains(p)) continue;
            this.mSmallPersonality.add(p);
        }
        Object s = "";
        for (Personality p : this.mSmallPersonality) {
            s = (String)s + p.getName() + " ";
        }
        ALog.logInfo((String)("Distributing " + (String)s));
    }

    private void swapPersonalities(HierPin dppI, HierPin dppJ) {
        Personality pI = this.mDevicePathPortToPersonality.get(dppI);
        Personality pJ = this.mDevicePathPortToPersonality.get(dppJ);
        this.mDevicePathPortToPersonality.remove(dppI);
        this.mDevicePathPortToPersonality.remove(dppJ);
        this.mDevicePathPortToPersonality.put(dppI, pJ);
        this.mDevicePathPortToPersonality.put(dppJ, pI);
    }

    private void runRandomAssignment(long totalRatio) {
        OrbitIO.getCurDb().setHistoryEnabled(false);
        this.loadCounts(totalRatio);
        this.assignRandomly(this.mActivePorts);
        this.createOutOfDBStructures(this.mActivePorts);
        LinkedList<Long> distances = this.avgDistanceToNearestNeighbor(this.mActiveDPPs);
        double expectedAverage = 0.0;
        for (Long dist : distances) {
            expectedAverage += (double)dist.longValue();
        }
        double bestScore = this.score(this.mActiveDPPs, expectedAverage /= (double)distances.size());
        UserCommands.unselectAll();
        long runTime = 1000L * (long)RunSeconds;
        long startTime = System.currentTimeMillis();
        long endTime = startTime + runTime;
        long attempts = 0L;
        long accepted = 0L;
        long failureStreak = 0L;
        while (System.currentTimeMillis() < endTime) {
            Personality pj;
            int ith = (int)(Math.random() * (double)this.mActiveDPPs.size());
            HierPin dppI = this.mActiveDPPs.get(ith);
            int jth = (int)(Math.random() * (double)this.mActiveDPPs.size());
            HierPin dppJ = this.mActiveDPPs.get(jth);
            Personality pi = this.mDevicePathPortToPersonality.get(dppI);
            if (pi == (pj = this.mDevicePathPortToPersonality.get(dppJ)) || !this.mSmallPersonality.contains(pi) && !this.mSmallPersonality.contains(pj)) continue;
            ++attempts;
            this.swapPersonalities(dppI, dppJ);
            double thisScore = this.score(this.mActiveDPPs, expectedAverage);
            if (thisScore > bestScore) {
                bestScore = thisScore;
                ++accepted;
                failureStreak = 0L;
                continue;
            }
            this.swapPersonalities(dppI, dppJ);
            if (++failureStreak <= (long)(this.mActiveDPPs.size() * 16)) continue;
            break;
        }
        ALog.logInfo((String)("Attempted: " + attempts + " Accepted: " + accepted + " Score: " + bestScore));
        for (HierPin dpp : this.mActiveDPPs) {
            Personality p = this.mDevicePathPortToPersonality.get(dpp);
            dpp.getPin().assignToPersonality(p);
        }
        OrbitIO.getCurDb().setHistoryEnabled(true);
    }

    private void runProximityAssignment(long totalRatio) {
        this.loadCounts(totalRatio);
        Collections.sort(this.mPRatios);
        this.mProximityPath = null;
        for (Object path : this.mProximity.getInstancePaths()) {
            Device d = path.getLast();
            if (d.getParent().getSubstrate() != this.mSubstrate) continue;
            this.mProximityPath = new DevicePath((DevicePath)path);
        }
        if (this.mProximityPath == null) {
            this.mProximityPath = new DevicePath();
        }
        this.setClusters();
        ArrayList<PinInstance> assigned = new ArrayList<PinInstance>();
        for (PRatio r : this.mPRatios) {
            this.assignClosest(r, assigned);
        }
        int size = this.mActivePorts.size();
        if (assigned.size() < size) {
            ArrayList<PinInstance> ports = new ArrayList<PinInstance>();
            for (int i = 0; i < size; ++i) {
                PinInstance p = this.mActivePorts.get(i);
                if (assigned.contains(p)) continue;
                ports.add(p);
            }
            this.assignRandomly(ports);
        }
    }

    private void assignClosest(PRatio r, ArrayList<PinInstance> assigned) {
        ArrayList<PinInstance> picked = new ArrayList<PinInstance>();
        DevicePath substratePath = this.mProximityPath.getParent();
        boolean assign = true;
        while (assign) {
            for (ArrayList<ClusterElement> eList : this.mClusters) {
                if (eList == null) continue;
                assign = this.assignPort(r, eList, assigned, picked, substratePath);
                if (r.mCount != 0L) continue;
                return;
            }
        }
    }

    private boolean assignPort(PRatio r, ArrayList<ClusterElement> eList, ArrayList<PinInstance> assigned, ArrayList<PinInstance> picked, DevicePath substratePath) {
        int size = this.mActivePorts.size();
        for (ClusterElement e : eList) {
            for (PinInstance dp : e.mDevice.getPins()) {
                PinInstance port;
                Personality p;
                if (picked.contains(dp) || (p = dp.getPersonality()) == null || !p.getName().equalsIgnoreCase(r.mPersonality.getName())) continue;
                long bestDist = Long.MAX_VALUE;
                int bestIndex = -1;
                APoint2D loc = dp.getWorldLoc(e.mPath);
                for (int i = 0; i < size; ++i) {
                    DevicePath activePath;
                    long dist;
                    port = this.mActivePorts.get(i);
                    if (assigned.contains(port) || (dist = port.getWorldLoc(activePath = substratePath.withChild(port.getDevice())).distance(loc)) >= bestDist) continue;
                    bestDist = dist;
                    bestIndex = i;
                }
                port = this.mActivePorts.get(bestIndex);
                port.assignToPersonality(r.mPersonality);
                --r.mCount;
                ++r.mAssigned;
                assigned.add(port);
                return true;
            }
        }
        return false;
    }

    private void setClusters() {
        for (DevicePath path : this.mProximity.getInstancePaths()) {
            Device d = path.getLast();
            if (!d.getPins().hasNext()) continue;
            ClusterElement element = new ClusterElement(path, d);
            int custerGroupIndex = -1;
            if (this.mClusters == null) {
                this.mClusters = new ArrayList();
            }
            for (int groupIndex = 0; groupIndex < this.mClusters.size(); ++groupIndex) {
                boolean touch = false;
                ArrayList<ClusterElement> eList = this.mClusters.get(groupIndex);
                if (eList == null) {
                    eList = new ArrayList();
                }
                for (ClusterElement e : eList) {
                    if (!e.mBound.intersects(element.mBound)) continue;
                    touch = true;
                    break;
                }
                if (!touch) continue;
                if (custerGroupIndex == -1) {
                    custerGroupIndex = groupIndex;
                    eList.add(element);
                    continue;
                }
                this.mClusters.get(custerGroupIndex).addAll(eList);
                this.mClusters.get(groupIndex).clear();
            }
            if (custerGroupIndex != -1) continue;
            ArrayList<ClusterElement> eList = new ArrayList<ClusterElement>();
            eList.add(element);
            this.mClusters.add(eList);
        }
    }

    private void assignRandomly(ArrayList<PinInstance> ports) {
        if (ports.isEmpty()) {
            return;
        }
        int total = 0;
        for (int i = 0; i < this.mPRatios.size(); ++i) {
            total = (int)((long)total + this.mPRatios.get((int)i).mRatio);
        }
        Collections.shuffle(ports);
        for (PinInstance port : ports) {
            boolean assigned = false;
            while (!assigned) {
                int candidate = (int)(Math.random() * (double)total);
                int start = 0;
                PRatio block = null;
                for (int i = 0; i < this.mPRatios.size(); ++i) {
                    if (candidate >= (start = (int)((long)start + this.mPRatios.get((int)i).mRatio))) continue;
                    block = this.mPRatios.get(i);
                    break;
                }
                if (block.mCount <= 0L) continue;
                port.assignToPersonality(block.mPersonality);
                --block.mCount;
                ++block.mAssigned;
                assigned = true;
            }
        }
    }

    private LinkedList<Long> avgDistanceToNearestNeighbor(ArrayList<HierPin> ports) {
        LinkedList<Long> distances = new LinkedList<Long>();
        for (HierPin dpp : ports) {
            Personality p = this.mDevicePathPortToPersonality.get(dpp);
            if (!this.mSmallPersonality.contains(p)) continue;
            long dist = this.distanceToClosestPortOfMyPersonality(ports, dpp);
            distances.add(dist);
        }
        return distances;
    }

    private long distanceToClosestPortOfMyPersonality(ArrayList<HierPin> ports, HierPin me) {
        Long bestDistance = null;
        Personality meP = this.mDevicePathPortToPersonality.get(me);
        APoint2D myPos = this.mPortToLoc.get(me);
        for (HierPin dpp : ports) {
            Personality p;
            if (dpp == me || meP != (p = this.mDevicePathPortToPersonality.get(dpp))) continue;
            APoint2D dppLoc = this.mPortToLoc.get(dpp);
            long distance = dppLoc.distance(myPos);
            if (bestDistance == null) {
                bestDistance = distance;
                continue;
            }
            bestDistance = Math.min(distance, bestDistance);
        }
        return bestDistance;
    }

    protected double deriveArea(ArrayList<PinInstance> ports) {
        ARect r = null;
        for (PinInstance p : ports) {
            APoint2D pt = p.getWorldLoc(p.getDevice().getADevicePath());
            if (r == null) {
                r = new ARect(pt, pt);
                continue;
            }
            r.expand(pt);
        }
        return r.area();
    }

    private double score(ArrayList<HierPin> ports, double expectedAverage) {
        LinkedList<Long> distances = this.avgDistanceToNearestNeighbor(ports);
        double currentAvg = 0.0;
        for (Long dist : distances) {
            currentAvg += (double)dist.longValue();
        }
        return currentAvg /= (double)distances.size();
    }

    private void loadCounts(long totalRatio) {
        int portCount = this.mActivePorts.size();
        int total = 0;
        PRatio highestRatio = null;
        for (PRatio r : this.mPRatios) {
            r.mCount = r.mRatio * (long)portCount / totalRatio;
            total = (int)((long)total + r.mCount);
            if (highestRatio != null && highestRatio.mRatio >= r.mRatio) continue;
            highestRatio = r;
        }
        if (total < portCount) {
            int leftOver = portCount - total;
            ALog.logInfo((String)"Can not evenly distribute personalities to %d pins. Assign %d more pins to %s.", (Object[])new Object[]{portCount, leftOver, highestRatio.mPersonality.getName()});
            highestRatio.mCount += (long)leftOver;
        }
    }

    private boolean loadActivePorts() {
        Selection selects = Design.getSelection((Db)this.mDb);
        for (PinInstance dp : this.mDb.getObjects(PinInstance.class)) {
            Device parent;
            Substrate s;
            if (!this.mReplace && dp.getPersonality() != null || (s = (parent = dp.getDevice()).getSubstrate()) != this.mSubstrate || !selects.contains((DbObject)dp)) continue;
            this.mActivePorts.add(dp);
        }
        return !this.mActivePorts.isEmpty();
    }

    private int loadRatioPersonalities() {
        MutableInteger total = MutableInteger.create((int)0);
        for (DeviceTemplate devTemp : this.mSubstrate.getDeviceTemplates()) {
            Personality.getPersonalities((DeviceTemplate)devTemp, (Personality.Type)Personality.Type.PORT).forEach(p -> {
                long ratio;
                Constraint c = Constraint.getConstraint((Db)this.mDb, (DbObject)p, (Constraint.Descriptor)Constraint.PORT_ASSIGN_RATIO);
                if (c != null && (ratio = ((Long)c.getValue()).longValue()) > 0L) {
                    this.mPRatios.add(new PRatio((Personality)p, ratio));
                    total.set(total.get() + (int)ratio);
                }
            });
        }
        return total.get();
    }

    public static class SortPort
    implements Comparator<PinInstance> {
        private APoint2D mLoc;

        public SortPort(PinInstance port) {
            this.mLoc = port.getLocalLoc();
        }

        @Override
        public int compare(PinInstance p0, PinInstance p1) {
            double distp0 = this.mLoc.distance(p0.getLocalLoc());
            double distp1 = this.mLoc.distance(p1.getLocalLoc());
            return Double.compare(distp1, distp0);
        }
    }

    protected class ClusterElement {
        protected DevicePath mPath;
        protected Device mDevice;
        protected ARect mBound;
        protected APoint2D mLoc;

        protected ClusterElement(DevicePath path, Device device) {
            this.mPath = new DevicePath(PersonalityAssigner.this.mProximityPath, path);
            this.mDevice = device;
            this.mBound = device.getWorldBound(this.mPath.parentPath());
            this.mLoc = device.getWorldLoc(this.mPath.parentPath());
        }
    }

    protected static class PRatio
    implements Comparable<PRatio> {
        protected Personality mPersonality;
        protected long mRatio;
        protected long mCount;
        protected long mAssigned = 0L;

        protected PRatio(Personality personality, long ratio) {
            this.mPersonality = personality;
            this.mRatio = ratio;
        }

        @Override
        public int compareTo(PRatio other) {
            return Long.compare(this.mCount, other.mCount);
        }
    }
}

