/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.optimizer;

import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.ContactLayer;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.NetObject;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.SchedConn;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.edaMgrs.NameGenerator;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.automation.ConnectivityMgmt;
import com.sigrity.orbit.automation.contact_sync.ContactNetSyncEngine;
import com.sigrity.orbit.util.PhysicalNetUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class PinPairConnectionFactory {
    protected LinkedList<SchedConn> mSchedConns = new LinkedList();
    protected String baseName = "NewNet_";
    protected DeviceTemplate commonTemplate = null;
    private boolean isVerifyContactSync = false;
    private ContactNetSyncEngine mSyncEngine;

    public void setIsVerifyContactSync(boolean b) {
        this.isVerifyContactSync = b;
    }

    public void load(SchedConn sc) {
        if (!sc.isValidBoth()) {
            return;
        }
        this.mSchedConns.add(sc);
    }

    public void load(String keyStr) {
        SchedConn sc = (SchedConn)OrbitIO.getCurDb().getByKeyStr(SchedConn.class, keyStr);
        this.mSchedConns.add(sc);
    }

    public void setConnectTemplate(String keyStr) {
        this.setConnectTemplate((DeviceTemplate)OrbitIO.getCurDb().getByKeyStr(DeviceTemplate.class, keyStr));
    }

    public void setConnectTemplate(DeviceTemplate devT) {
        this.commonTemplate = devT;
    }

    public void setBaseName(String name) {
        this.baseName = name;
    }

    private HierInst<Net> getFixedHierNet(SchedConn sc) {
        return new HierInst(sc.getDevicePathA(), (DbObject)sc.getPortA().getPinTemplate().getNet());
    }

    private HierInst<Net> getFreeHierNet(SchedConn sc) {
        return new HierInst(sc.getDevicePathB(), (DbObject)sc.getPortB().getPinTemplate().getNet());
    }

    private Map<SchedConn, List<APair<Device, Net>>> findFreeSideNetMap() {
        HashMap<SchedConn, List<APair<Device, Net>>> priorMapping = new HashMap<SchedConn, List<APair<Device, Net>>>();
        for (SchedConn sc : this.mSchedConns) {
            HierInst<Net> freeNet = this.getFreeHierNet(sc);
            ArrayList<APair> list = new ArrayList<APair>();
            priorMapping.put(sc, list);
            for (NetMap nm : NetMap.getChildNets((Net)((Net)freeNet.second))) {
                Device childDevice = nm.getDevice();
                Net childNet = nm.getChildNet();
                list.add(new APair((Object)childDevice, (Object)childNet));
            }
        }
        return priorMapping;
    }

    private Map<HierInst<PinTemplate>, List<HierInst<NetObject>>> findFreeSideConnected() {
        HashMap<HierInst<PinTemplate>, List<HierInst<NetObject>>> freeConn = new HashMap<HierInst<PinTemplate>, List<HierInst<NetObject>>>();
        for (SchedConn sc : this.mSchedConns) {
            HierInst hip = sc.getAbsDPPB().getHierPinTemplate();
            ArrayList conn = new ArrayList(PhysicalNetUtil.getPhysConnected((HierInst)hip, (boolean)true));
            freeConn.put((HierInst<PinTemplate>)sc.getDPPB().getHierPinTemplate(), conn);
        }
        return freeConn;
    }

    private NetPair getTargetNetPair(SchedConn sc) {
        Net netOnSubA = NetMap.getNetAt((Net)sc.getNetA().orElse(null), (DevicePath)sc.getDevicePathA(), (DeviceTemplate)this.commonTemplate);
        if (netOnSubA.isUnused()) {
            return null;
        }
        boolean searchToCommon = NetMap.getConnectedNetHierarcy((DevicePath)sc.getDevicePathA(), (Net)sc.getNetA().orElse(null)).stream().anyMatch(hNet -> hNet.getPath().getDeviceTemplate() == this.commonTemplate);
        if (!searchToCommon) {
            return null;
        }
        DevicePath freeSubPath = sc.getDevicePathB().pathToSubstrate();
        DeviceTemplate freeSubTemplate = freeSubPath.getDeviceTemplate();
        freeSubPath = freeSubPath.getRelativePathFromAnchor(this.commonTemplate);
        Net netOnSubB = null;
        if (freeSubTemplate == this.commonTemplate) {
            netOnSubB = netOnSubA;
        } else {
            for (HierInst hierNet : NetMap.getDescendantNetsWithPaths((DevicePath)sc.getDevicePathA().pathTo(netOnSubA.getDeviceTemplate()), (Net)netOnSubA)) {
                if (!hierNet.getPath().endsWith(freeSubPath)) continue;
                netOnSubB = (Net)hierNet.second;
                break;
            }
        }
        if (netOnSubB != null && !netOnSubB.isUnused()) {
            assert (netOnSubB.getDeviceTemplate() == freeSubTemplate);
            return new NetPair(netOnSubA, netOnSubB);
        }
        return null;
    }

    private Map<SchedConn, NetPair> findFreeSideNetMapToCommon() {
        HashMap<SchedConn, NetPair> originalMappedTo = new HashMap<SchedConn, NetPair>();
        for (SchedConn sc : this.mSchedConns) {
            NetPair pair = this.getTargetNetPair(sc);
            if (pair == null) continue;
            originalMappedTo.put(sc, pair);
        }
        return originalMappedTo;
    }

    private DeviceTemplate getFromSubstrateTemplate() {
        for (SchedConn sc : this.mSchedConns) {
            DevicePath dp = sc.getDevicePathA();
            if (dp == null) continue;
            return dp.getSubstrateDeviceTemplate();
        }
        return null;
    }

    private DeviceTemplate getToSubstrateTemplate() {
        for (SchedConn sc : this.mSchedConns) {
            DevicePath dp = sc.getDevicePathB();
            if (dp == null) continue;
            return dp.getSubstrateDeviceTemplate();
        }
        return null;
    }

    private int unhookExistedNetMap(Map<SchedConn, NetPair> originalMappedTo) {
        DeviceTemplate toSubstrateTemplate = this.getToSubstrateTemplate();
        LinkedList<HierInst> toBeUnHooked = new LinkedList<HierInst>();
        for (SchedConn sc : this.mSchedConns) {
            if (!originalMappedTo.containsKey(sc)) continue;
            for (HierInst hNet : NetMap.getConnectedNetHierarcy((DevicePath)sc.getDevicePathA(), (Net)sc.getNetA().orElse(null))) {
                if (hNet.getPath().getDeviceTemplate() != toSubstrateTemplate) continue;
                for (HierInst hp : AUtil.linkedList((Iterator)NetMap.getConnectedHierPins((DevicePath)hNet.getPath(), (Net)((Net)hNet.getDbObject())))) {
                    PinTemplate pt;
                    if (hp.getPath().getSubstrateDeviceTemplate() != toSubstrateTemplate || !ConnectivityMgmt.isExternalPin((PinTemplate)(pt = (PinTemplate)hp.second))) continue;
                    toBeUnHooked.add(hp);
                }
            }
        }
        for (HierInst hp : toBeUnHooked) {
            ConnectivityMgmt.unHookPin((DevicePath)((DevicePath)hp.first), (PinTemplate)((PinTemplate)hp.second));
        }
        return toBeUnHooked.size();
    }

    private void setFreeSideNet(HierInst<PinTemplate> hierPinT, Net net, Map<HierInst<PinTemplate>, List<HierInst<NetObject>>> originalConn) {
        assert (((PinTemplate)hierPinT.getDbObject()).getDeviceTemplate() == net.getDeviceTemplate());
        if (((PinTemplate)hierPinT.getDbObject()).getNet() == net) {
            return;
        }
        ((PinTemplate)hierPinT.getDbObject()).setNet(net, true);
        this.fixPhysicalConn(hierPinT, originalConn);
    }

    private void fixPhysicalConn(HierInst<PinTemplate> hierPinT, Map<HierInst<PinTemplate>, List<HierInst<NetObject>>> originalConn) {
        HierInst freeNet = HierInst.create((DevicePath)hierPinT.getPath(), (DbObject)((PinTemplate)hierPinT.getDbObject()).getNet());
        HashMap<DevicePath, HierInst> map = new HashMap<DevicePath, HierInst>();
        for (HierInst hierNet : NetMap.getConnectedNetHierarcy((HierInst)freeNet)) {
            map.put(hierNet.getPath().getRelativePathFromAnchor(this.commonTemplate), hierNet);
        }
        for (HierInst<NetObject> hierNetObj : originalConn.get(hierPinT)) {
            Net net;
            HierInst hierNet;
            NetObject netObj = (NetObject)hierNetObj.getDbObject();
            if (netObj instanceof Wire) {
                Wire wire = (Wire)netObj;
                hierNet = (HierInst)map.get(hierNetObj.getPath().getRelativePathFromAnchor(this.commonTemplate));
                if (hierNet == null) continue;
                net = (Net)hierNet.getDbObject();
                wire.setNet(net);
                continue;
            }
            if (netObj instanceof PinTemplate) {
                PinTemplate pt = (PinTemplate)netObj;
                hierNet = (HierInst)map.get(hierNetObj.getPath().getRelativePathFromAnchor(this.commonTemplate));
                if (hierNet == null || (net = (Net)hierNet.getDbObject()) == pt.getNet()) continue;
                pt.setNet(net, true);
                continue;
            }
            ALog.logError((Throwable)new Exception("Unspport Type"), (String)"PinPairConnection: unspport type for %s\n", (Object[])new Object[]{netObj});
        }
    }

    private void connectFreeSideToCommon(SchedConn sc, Map<SchedConn, NetPair> originalMappedTo, Map<HierInst<PinTemplate>, List<HierInst<NetObject>>> originalConn) {
        DevicePath fromPath = sc.getDevicePathA();
        DevicePath toPath = sc.getDevicePathB();
        String netNameB = null;
        Net netOnSubB = originalMappedTo.get((Object)sc).netB;
        if (netOnSubB == null || netOnSubB.isUnused()) {
            netOnSubB = NetMap.getNetAt((Net)sc.getNetA().orElse(null), (DevicePath)fromPath, (DeviceTemplate)this.commonTemplate);
        }
        netNameB = netOnSubB.getName();
        PinTemplate ptB = sc.getPortB().getPinTemplate();
        boolean setNet = false;
        if (ptB.getNet().isUnused()) {
            DeviceTemplate dt = toPath.getDeviceTemplate();
            String thisPinLowLevelNetName = "Pin";
            if (dt.hasExactlyOneDeviceInstance()) {
                thisPinLowLevelNetName = netNameB;
            }
            Net netOnPin = Net.getOrCreate((DeviceTemplate)dt, (String)thisPinLowLevelNetName);
            this.setFreeSideNet((HierInst<PinTemplate>)sc.getDPPB().getHierPinTemplate(), netOnPin, originalConn);
            setNet = true;
        }
        if (ptB.getDeviceTemplate() == this.commonTemplate && setNet) {
            return;
        }
        if (ptB.getDeviceTemplate().amIASubstrate() && originalMappedTo.get((Object)sc).netB != null && setNet) {
            return;
        }
        DevicePath bPath = new DevicePath(sc.getDevicePathB());
        DevicePath relPath = bPath.getRelativePathFromAnchor(this.commonTemplate);
        if (fromPath.equals((Object)toPath)) {
            DeviceTemplate dt = toPath.getDeviceTemplate();
            Net n = Net.getOrCreate((DeviceTemplate)dt, (String)netNameB);
            this.setFreeSideNet((HierInst<PinTemplate>)sc.getDPPB().getHierPinTemplate(), n, originalConn);
        }
        if (!relPath.isEmpty()) {
            if (originalMappedTo.containsKey(sc)) {
                if (toPath.getDevice().getParent() != netOnSubB.getDeviceTemplate()) {
                    netOnSubB = NetMap.getNetAt((Net)sc.getNetA().orElse(null), (DevicePath)fromPath, (DeviceTemplate)this.commonTemplate);
                }
                NetMap.mapUpTo((DevicePath)toPath, (Net)ptB.getNet(), (Net)netOnSubB);
            } else {
                NetMap.mapToRoot((DevicePath)relPath, (Net)ptB.getNet(), (String)netNameB);
            }
        } else {
            ptB.mapNetUpPath(toPath, this.commonTemplate, netNameB, true);
        }
        Net topNet = NetMap.getTopmostNet((Net)sc.getDPPB().getNet(), (DevicePath)bPath);
        if (topNet.getDeviceTemplate() != this.commonTemplate) {
            Net childNet = topNet;
            Net parentNet = originalMappedTo.get((Object)sc).netA;
            if (childNet != null && parentNet != null && childNet.getDeviceTemplate() != parentNet.getDeviceTemplate()) {
                DevicePath clippedPath = new DevicePath(bPath);
                while (clippedPath.size() > 0 && clippedPath.getDeviceTemplate() != childNet.getDeviceTemplate()) {
                    clippedPath.removeLast();
                }
                NetMap.mapUpTo((DevicePath)clippedPath, (Net)childNet, (Net)parentNet);
            }
        }
        this.fixPhysicalConn((HierInst<PinTemplate>)sc.getDPPB().getHierPinTemplate(), originalConn);
    }

    private void createFreeSideNetMappingToCommon(SchedConn sc, Map<HierInst<PinTemplate>, List<HierInst<NetObject>>> originalConn, NameGenerator ng, DeviceTemplate fromSubstrateTemplate) {
        String netNameA;
        DevicePath fromPath = sc.getDevicePathA();
        DevicePath toPath = sc.getDevicePathB();
        PinTemplate ptA = sc.getPortA().getPinTemplate();
        Net netAtFromTemplate = NetMap.getTopmostNet((Net)ptA.getNet(), (DevicePath)fromPath);
        if (ptA.getNet().isUnused() || netAtFromTemplate.getDeviceTemplate() != fromSubstrateTemplate) {
            DeviceTemplate dt = fromPath.getDeviceTemplate();
            if (dt.hasExactlyOneDeviceInstance()) {
                netNameA = Net.findAUniqueNetName((NameGenerator)ng);
                Net netOnPin = dt.createNet(netNameA, true);
                ptA.setNet(netOnPin, true);
                Net topNet = NetMap.getTopmostNet((Net)sc.getNetA().orElse(null), (DevicePath)fromPath);
                netNameA = topNet.getName();
                ptA.mapNetUpPath(fromPath, this.commonTemplate, netNameA, true);
            } else {
                Net tryB = NetMap.getNetAt((Net)sc.getNetB().orElse(null), (DevicePath)toPath, (DeviceTemplate)this.commonTemplate);
                netNameA = tryB.getDeviceTemplate() == this.commonTemplate ? tryB.getName() : Net.findAUniqueNetName((NameGenerator)ng);
                if (netNameA.equals("NetUnused")) {
                    netNameA = Net.findAUniqueNetName((NameGenerator)ng);
                }
                if (ptA.getNet().isUnused()) {
                    Net netOnPin = dt.createNet(netNameA, true);
                    ptA.setNet(netOnPin, true);
                }
                ptA.mapNetUpPath(fromPath, dt, netNameA, true);
            }
        } else {
            Net topNet = NetMap.getTopmostNet((Net)sc.getNetA().orElse(null), (DevicePath)fromPath);
            netNameA = topNet.getName();
            ptA.mapNetUpPath(fromPath, this.commonTemplate, netNameA, true);
        }
        String netBName = NetMap.getNetAt((Net)sc.getNetA().orElse(null), (DevicePath)fromPath, (DeviceTemplate)this.commonTemplate).getName();
        PinTemplate ptB = sc.getPortB().getPinTemplate();
        if (ptB.getNet().isUnused()) {
            Net netOnPin;
            DeviceTemplate dt = toPath.getDeviceTemplate();
            netNameA = netBName;
            String thisPinLowLevelNetName = "Pin";
            if (dt.hasExactlyOneDeviceInstance()) {
                thisPinLowLevelNetName = netBName;
            }
            if ((netOnPin = dt.getNet(thisPinLowLevelNetName)) == null) {
                netOnPin = dt.createNet(thisPinLowLevelNetName, false);
            }
            this.setFreeSideNet((HierInst<PinTemplate>)sc.getDPPB().getHierPinTemplate(), netOnPin, originalConn);
        }
        ptB.mapNetUpPath(toPath, this.commonTemplate, netNameA, true);
    }

    public void connect() {
        if (this.mSchedConns.isEmpty()) {
            return;
        }
        this.setupContactSyncEngine();
        NameGenerator ng = new NameGenerator(this.baseName);
        ng.setCurrentIndex(0);
        ng.setIncludeBaseName(false);
        Collections.sort(this.mSchedConns);
        DeviceTemplate fromSubstrateTemplate = this.getFromSubstrateTemplate();
        DeviceTemplate toSubstrateTemplate = this.getToSubstrateTemplate();
        Map<SchedConn, List<APair<Device, Net>>> priorMapping = this.findFreeSideNetMap();
        Map<HierInst<PinTemplate>, List<HierInst<NetObject>>> originalConn = this.findFreeSideConnected();
        Map<SchedConn, NetPair> originalMappedTo = this.findFreeSideNetMapToCommon();
        if (fromSubstrateTemplate != toSubstrateTemplate) {
            this.unhookExistedNetMap(originalMappedTo);
        }
        for (SchedConn sc : this.mSchedConns) {
            if (sc.getDevicePathB() == null) continue;
            if (originalMappedTo.containsKey(sc)) {
                this.connectFreeSideToCommon(sc, originalMappedTo, originalConn);
                continue;
            }
            this.createFreeSideNetMappingToCommon(sc, originalConn, ng, fromSubstrateTemplate);
        }
        if (fromSubstrateTemplate == toSubstrateTemplate) {
            for (SchedConn sc : this.mSchedConns) {
                if (priorMapping.get(sc) == null) continue;
                HierInst<Net> freeNet = this.getFreeHierNet(sc);
                HierInst<Net> fixedNet = this.getFixedHierNet(sc);
                if (((Net)freeNet.second).getDeviceTemplate() != this.commonTemplate || ((Net)fixedNet.second).getDeviceTemplate() == this.commonTemplate) continue;
                Net freeCommonNet = NetMap.getNetAt((Net)sc.getNetB().orElse(null), (DevicePath)sc.getDevicePathB(), (DeviceTemplate)this.commonTemplate);
                for (APair<Device, Net> nm : priorMapping.get(sc)) {
                    Device childDevice = (Device)nm.first;
                    Net childNet = (Net)nm.second;
                    NetMap.mapChildNet((Device)childDevice, (Net)childNet, (Net)freeCommonNet);
                }
            }
        }
        this.executeContactSyncEngine();
    }

    private void setupContactSyncEngine() {
        if (!ContactLayer.hasContact((DevicePath)this.mSchedConns.get(0).getDevicePathB())) {
            return;
        }
        this.mSyncEngine = new ContactNetSyncEngine(OrbitIO.getCurDb());
        this.mSyncEngine.setIsVerifySync(this.isVerifyContactSync);
        for (SchedConn sc : this.mSchedConns) {
            Device pinDev = sc.getPathB().getDevice();
            if (pinDev != null && pinDev.isPin() && pinDev.getPin() != null) {
                this.mSyncEngine.addToSyncNetObject((DbObject)pinDev);
                continue;
            }
            this.mSyncEngine.addToSyncNetObject((DbObject)sc.getPortB().getPinTemplate());
        }
    }

    private void executeContactSyncEngine() {
        if (this.mSyncEngine != null) {
            this.mSyncEngine.execute();
        }
    }

    static class NetPair {
        Net netA;
        Net netB;

        public NetPair(Net netA, Net netB) {
            this.netA = netA;
            this.netB = netB;
        }
    }
}

