/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.optimizer;

import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.optimizer.GoodnessCalculator;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierPin;
import java.util.ArrayList;
import java.util.List;

public class PlacementGoodness
extends GoodnessCalculator {
    private DevicePath mDomainPath;
    private double mWorseGoodness;

    public PlacementGoodness(DevicePath domainPath) {
        this.mDomainPath = new DevicePath(domainPath);
    }

    @Override
    public void setDomain(DeviceTemplate t) {
        this.mDomain = t;
        ARect b = t.getBB();
        long pinCount = t.getPinCount();
        this.mWorseGoodness = (b.width() + b.height()) * pinCount;
    }

    public double getWorseGoodness() {
        return this.mWorseGoodness;
    }

    @Override
    public double getGoodness() {
        return this.getNetDevicePortGoodness();
    }

    private double getNetDevicePortGoodness() {
        double total = 0.0;
        DeviceTemplate dt = this.mDomainPath.getDeviceTemplate();
        DevicePath path = dt != this.mDomain ? new DevicePath(this.mDomainPath) : new DevicePath(dt);
        ArrayList<Net> topNets = new ArrayList<Net>();
        for (Net n : dt.getNets()) {
            Net topNet = NetMap.getTopmostNet((Net)n, (DevicePath)path);
            if (topNets.contains(topNet)) continue;
            topNets.add(topNet);
        }
        for (Net n : topNets) {
            ARect bound = this.getNetBound(path, n, null);
            if (bound == null) continue;
            total += (double)(bound.width() + bound.height());
        }
        return total;
    }

    private ARect getNetBound(DevicePath path, Net net, ARect bound) {
        List dpps = NetMap.getConnectedDevicePathPorts((Net)net, (DevicePath)path);
        for (HierPin dpp : dpps) {
            if (bound == null) {
                bound = new ARect(dpp.getWorldBounds());
                continue;
            }
            bound.expand(dpp.getWorldBounds());
        }
        return bound;
    }
}

