/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.optimizer;

import com.google.common.collect.HashBiMap;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.Stopwatch;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Floorplan;
import com.sigrity.acl.db.std.FloorplanPin;
import com.sigrity.acl.db.std.Interface;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.SchedConn;
import com.sigrity.acl.db.std.StoredPath;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.APolygon;
import com.sigrity.acl.geom.ATransform;
import com.sigrity.orbit.AbstractPin;
import com.sigrity.orbit.CandidatePairs;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.DevicePathPortPair;
import com.sigrity.orbit.DiffPairFinder;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.automation.router.InteractiveBundleCreator;
import com.sigrity.orbit.ui.CanConnectRegistry;
import com.sigrity.orbit.ui.PersonalityUI;
import com.sigrity.orbit.util.PinUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.stream.Collectors;

public final class PortPairOpt {
    protected static PortPairOpt mActive = null;
    protected static Map<Db, PortPairOpt> PPToDB = new WeakHashMap<Db, PortPairOpt>();
    protected static boolean treatFromAsIndividuals = false;
    public static boolean removeNetMappingOnToSide = false;
    private static boolean isVerifyContactSync = true;
    protected ArrayList<MyHierPin> mSetAFromUser = new ArrayList();
    protected ArrayList<MyHierPin> mSetBFromUser = new ArrayList();
    protected ArrayList<MyHierPin> mSetA = new ArrayList();
    protected ArrayList<MyHierPin> mSetB = new ArrayList();
    protected double mExpansion = 1.0;
    protected HashMap<HierPin, HierPin> mAToBOrignal = new HashMap();
    protected Map<Long, ClusterClass> mClusterMap = new LinkedHashMap<Long, ClusterClass>();
    protected String mCanConnectFunction;
    protected CanConnectRegistry.CanConnectFunction mCCF;
    protected boolean mSwapDevices;
    protected String mBaseName = "NewNet";
    protected final Db mDb;
    protected boolean mUseOnlyUnusedPortsOnFreeSide = false;
    protected boolean mSortByInstruction = false;
    protected boolean mUseOnlyUsedPortsOnFixedSide = false;
    protected int mMatchNum = 0;
    protected boolean mFilterNets = true;
    protected ArrayList<DevicePathPortPair> mCreated = new ArrayList();
    protected ArrayList<MyHierPin> mCreatedExtra = new ArrayList();
    protected DevicePath mCommonPath;
    protected boolean createFloorplansOnFreeSide = false;
    protected OptimizationStats mOptStats;
    protected ArrayList<HierPin> mDiffPairFroms = new ArrayList();

    public static PortPairOpt getActive(Db db) {
        return PPToDB.get(db);
    }

    public static PortPairOpt getActive() {
        return PPToDB.get(OrbitIO.getCurDb());
    }

    public static void clearActive(Db db) {
        PPToDB.put(db, null);
    }

    public static void reset() {
        PortPairOpt ppo = PortPairOpt.getActive();
        if (ppo != null) {
            ppo.clear();
        }
    }

    public static void setIsVerifyContactSync(boolean b) {
        isVerifyContactSync = b;
    }

    public static void setTreatFromAsIndividuals(boolean mode) {
        treatFromAsIndividuals = mode;
    }

    public static boolean getTreatFromAsIndividuals() {
        return treatFromAsIndividuals;
    }

    public static boolean isRemoveNetMappingOnToSide() {
        return removeNetMappingOnToSide;
    }

    public static void setRemoveNetMappingOnToSide(boolean e) {
        removeNetMappingOnToSide = e;
    }

    public PortPairOpt() {
        this(OrbitIO.getCurDb());
    }

    public PortPairOpt(Db db) {
        this.mDb = db;
        PPToDB.put(this.mDb, this);
    }

    public void clear() {
        this.mSetA.clear();
        this.mSetB.clear();
        this.mSetAFromUser.clear();
        this.mSetBFromUser.clear();
    }

    public void setCreateFloorplansOnFreeSide(boolean create) {
        this.createFloorplansOnFreeSide = create;
    }

    public void setCanConnectFunction(String name) {
        this.mCanConnectFunction = name;
    }

    public void setAPorts(List<HierPin> setA) {
        this.setAPorts(setA, false);
    }

    public void setBPorts(List<HierPin> setB) {
        this.setBPorts(setB, false);
    }

    public void setAPorts(List<HierPin> setA, boolean add) {
        if (!add) {
            this.mSetAFromUser.clear();
        }
        this.mSetA.clear();
        for (HierPin dpp : setA) {
            this.mSetAFromUser.add(new MyHierPin(dpp));
        }
    }

    public void setBPorts(List<HierPin> setB, boolean add) {
        if (!add) {
            this.mSetBFromUser.clear();
        }
        this.mSetB.clear();
        for (HierPin dpp : setB) {
            this.mSetBFromUser.add(new MyHierPin(dpp));
        }
    }

    public void setExpansion(double expansion) {
        this.mExpansion = expansion;
    }

    public double getExpansion() {
        return this.mExpansion;
    }

    public void setExtraPinsMap(Map<Long, ClusterClass> hm) {
        this.mClusterMap = hm;
    }

    public List<HierPin> getAPorts() {
        if (this.mSetB.isEmpty() || treatFromAsIndividuals) {
            return new ArrayList<HierPin>(this.mSetAFromUser);
        }
        return new ArrayList<HierPin>(this.mSetA);
    }

    public List<HierPin> getBPorts() {
        if (this.mSetB.isEmpty()) {
            return new ArrayList<HierPin>(this.mSetBFromUser);
        }
        return new ArrayList<HierPin>(this.mSetB);
    }

    public void setFilter(boolean f) {
        this.mFilterNets = f;
    }

    public void setUseOnlyUnusedPortsOnFreeSide(boolean state) {
        this.mUseOnlyUnusedPortsOnFreeSide = state;
    }

    public void setSortByInstruction(boolean state) {
        this.mSortByInstruction = state;
    }

    public void setUseOnlyUsedPortsOnFixedSide(boolean state) {
        this.mUseOnlyUsedPortsOnFixedSide = state;
    }

    public void setBaseNewNetName(String base) {
        this.mBaseName = base;
    }

    public void setSwapDevices(boolean swapDevices) {
        this.mSwapDevices = swapDevices;
    }

    protected void determineDevicePathPortsForCommon() {
        ArrayList<HierPin> aList = new ArrayList<HierPin>();
        ArrayList<HierPin> bList = new ArrayList<HierPin>();
        Substrate anySubstrate = null;
        for (HierPin hierPin : this.mSetAFromUser) {
            Device d = hierPin.getPath().getLast();
            if (anySubstrate == null) {
                anySubstrate = d.getSubstrate();
            }
            aList.add(new HierPin(hierPin.getPath(), hierPin.getPin()));
        }
        for (HierPin hierPin : this.mSetBFromUser) {
            bList.add(new HierPin(hierPin.getPath(), hierPin.getPin()));
        }
        DevicePath common = null;
        for (HierPin dpp : aList) {
            common = dpp.getPath().commonParent(common);
        }
        for (HierPin dpp : bList) {
            common = dpp.getPath().commonParent(common);
        }
        this.mCommonPath = common != null && !common.isEmpty() ? new DevicePath(common) : null;
    }

    protected boolean saveOriginal() {
        ArrayList<MyHierPin> connectedA = new ArrayList<MyHierPin>();
        ArrayList<MyHierPin> connectedB = new ArrayList<MyHierPin>();
        for (MyHierPin from : this.mSetA) {
            HierInst hn = new HierInst((DevicePath)from.first, (DbObject)((PinInstance)from.second).getNet());
            for (HierInst candidate : NetMap.getConnectedHierPins((HierInst)hn)) {
                MyHierPin bestTo = null;
                for (MyHierPin to : this.mSetB) {
                    if (!to.getPinTemplate().equals(candidate.second) || !to.getPath().equals(candidate.first)) continue;
                    bestTo = to;
                    connectedA.add(from);
                    connectedB.add(to);
                    break;
                }
                if (bestTo == null) continue;
                this.mSetB.remove((Object)bestTo);
            }
        }
        this.mSetA.clear();
        this.mSetB.clear();
        this.mSetA.addAll(connectedA);
        this.mSetB.addAll(connectedB);
        this.mMatchNum = this.mSetA.size();
        return true;
    }

    public void assign() {
        this.mCreated.clear();
        this.mCreatedExtra.clear();
        this.determineDevicePathPortsForCommon();
        if (this.mCommonPath == null) {
            ALog.logError((String)"There is no common substrate to be found for port pair opt");
            return;
        }
        if (this.mFilterNets) {
            this.filterSets();
        } else {
            this.moveUserToSets();
        }
        this.sortSet(this.mSetA, true);
        this.sortSet(this.mSetB, false);
        for (MyHierPin hierPin : this.mSetA) {
            if (Net.isDiffPair((Net)hierPin.getNet(), (DevicePath)hierPin.getPath()) == null) continue;
            this.mDiffPairFroms.add(hierPin);
        }
        if (this.mSwapDevices) {
            this.assignDevices();
        } else {
            this.assignNets();
        }
    }

    private void assignDevices() {
        SwapDevices sd = new SwapDevices();
        sd.doSwapDevices();
        OrbitIO.getApp().refreshCurrentView(false);
    }

    private void assignNets() {
        int i;
        HashSet<Net> before = new HashSet<Net>();
        for (Net n : Net.findDanglingNets((Db)this.mDb)) {
            if (n.isUnused()) continue;
            before.add(n);
        }
        this.createCachedLocations();
        this.greedyAssign();
        ALog.logInfo((String)"Optimizing Connections");
        if (!this.mSortByInstruction) {
            this.optimizeSortedSets();
        }
        InteractiveBundleCreator.ConnectFactory cf = new InteractiveBundleCreator.ConnectFactory();
        DeviceTemplate owner = this.mCommonPath.getDeviceTemplate();
        for (i = 0; i < this.mSetA.size(); ++i) {
            SchedConn sc = new SchedConn();
            MyHierPin fixedPin = this.mSetA.get(i);
            MyHierPin freePin = this.mSetB.get(i);
            sc.setOwner((DbObject)owner);
            sc.setPortA(fixedPin.getPath(), fixedPin.getPinTemplate().getFirstPortTemplate());
            sc.setPortB(freePin.getPath(), freePin.getPinTemplate().getFirstPortTemplate());
            cf.load(sc);
        }
        cf.setBaseName(this.mBaseName);
        cf.setConnectTemplate(this.mCommonPath.getDeviceTemplate());
        cf.setIsVerifyContactSync(isVerifyContactSync);
        cf.connect();
        for (i = 0; i < this.mMatchNum; ++i) {
            HierPin portA = this.mSetA.get(i);
            HierPin portB = this.mSetB.get(i);
            this.mCreated.add(new DevicePathPortPair(portA, portB));
        }
        if (this.createFloorplansOnFreeSide) {
            this.setFloorplanPinsToFreePins(this.mCreated);
            this.setFloorplanPinsToExtraPins(this.mCreatedExtra);
        }
    }

    private void setFloorplanPinsToFreePins(List<DevicePathPortPair> pairs) {
        int size = pairs.size();
        HashMap<Interface, Integer> intrfaceToIOCount = new HashMap<Interface, Integer>();
        for (int i = 0; i < size; ++i) {
            Integer cur;
            DeviceTemplate freeTemplate;
            Floorplan fp;
            Interface iFace;
            PinTemplate pt = ((PinInstance)pairs.get((int)i).getDPPA().second).getPinTemplate();
            FloorplanPin fpp = FloorplanPin.find((PinTemplate)pt, (DevicePath)pairs.get(i).getDPPA().getPath());
            if (fpp == null || (iFace = fpp.getMyInterface()) == null || (fp = iFace.getFloorplan(freeTemplate = ((DevicePath)pairs.get((int)i).getDPPB().first).pathToSubstrate().getDeviceTemplate(), false)) == null) continue;
            fp.setIncludeNoneInIOPersonalityList(true);
            DevicePath devicePath = pairs.get(i).getDPPB().getPath();
            Device d = devicePath.getLast();
            devicePath = devicePath.getRelativePathFromAnchor(freeTemplate);
            StoredPath relativePath = StoredPath.get((DevicePath)devicePath);
            PinTemplate ptb = ((PinInstance)pairs.get((int)i).getDPPB().second).getPinTemplate();
            PinInstance pi = d.getPin(ptb);
            fp.addPin(relativePath, pi);
            Personality curPinPersonality = pi.getPersonality();
            if (curPinPersonality != null) {
                PersonalityUI.addFloorplanToPersonality((DbObject)fp, curPinPersonality, true);
            }
            if ((cur = (Integer)intrfaceToIOCount.get(iFace)) == null) {
                cur = 0;
            }
            Integer n = cur;
            Integer n2 = cur = Integer.valueOf(cur + 1);
            intrfaceToIOCount.put(iFace, cur);
        }
        for (Map.Entry e : intrfaceToIOCount.entrySet()) {
            Interface iFace = (Interface)e.getKey();
            if (iFace.getExpectedIOCount() >= (Integer)e.getValue()) continue;
            iFace.setExpectedIOCount(((Integer)e.getValue()).intValue());
        }
    }

    private void setFloorplanPinsToExtraPins(List<MyHierPin> pins) {
        if (pins == null || pins.isEmpty()) {
            return;
        }
        int size = pins.size();
        HashMap<Interface, Integer> intrfaceToIOCount = new HashMap<Interface, Integer>();
        for (int i = 0; i < size; ++i) {
            Integer cur;
            DeviceTemplate freeTemplate;
            Floorplan fp;
            Interface iFace;
            BigInteger instNum = (BigInteger)pins.get(i).getPin().getValue("autobundle.instruction");
            long bitNum = instNum.getLowestSetBit();
            if (!this.mClusterMap.containsKey(bitNum) || (iFace = this.mClusterMap.get((Object)Long.valueOf((long)bitNum)).intf) == null || (fp = iFace.getFloorplan(freeTemplate = ((DevicePath)pins.get((int)i).first).pathToSubstrate().getDeviceTemplate(), false)) == null) continue;
            DevicePath devicePath = pins.get(i).getPath();
            Device d = devicePath.getLast();
            devicePath = devicePath.getRelativePathFromAnchor(freeTemplate);
            StoredPath relativePath = StoredPath.get((DevicePath)devicePath);
            PinTemplate ptb = ((PinInstance)pins.get((int)i).second).getPinTemplate();
            PinInstance pi = d.getPin(ptb);
            fp.addPin(relativePath, pi);
            Personality curPinPersonality = pi.getPersonality();
            if (curPinPersonality != null) {
                PersonalityUI.addFloorplanToPersonality((DbObject)fp, curPinPersonality, true);
            }
            if ((cur = (Integer)intrfaceToIOCount.get(iFace)) == null) {
                cur = 0;
            }
            Integer n = cur;
            Integer n2 = cur = Integer.valueOf(cur + 1);
            intrfaceToIOCount.put(iFace, cur);
        }
        for (Map.Entry e : intrfaceToIOCount.entrySet()) {
            Interface iFace = (Interface)e.getKey();
            iFace.setExpectedIOCount(iFace.getExpectedIOCount() + (Integer)e.getValue());
        }
    }

    public List<DevicePathPortPair> getCreated() {
        return this.mCreated;
    }

    protected void createCachedLocations() {
        for (MyHierPin dpp : this.mSetA) {
            dpp.cachedPoint = new APoint2D(dpp.getWorldLoc());
        }
        for (MyHierPin dpp : this.mSetB) {
            dpp.cachedPoint = new APoint2D(dpp.getWorldLoc());
        }
    }

    public void optimize(boolean swapDevices) {
        this.mSwapDevices = swapDevices;
        this.mCCF = CanConnectRegistry.getCCF(this.mCanConnectFunction);
        if (this.mCCF == null) {
            ALog.logWarn((String)("There is not Connection Criteria named " + this.mCanConnectFunction));
            return;
        }
        this.assign();
    }

    private void optimizeSortedSets() {
        this.mOptStats = new OptimizationStats();
        this.mOptStats.start();
        this.unCross(false);
        double pNow = this.penalty();
        int itr = 0;
        int numTimesAtThisMinimum = 0;
        while (pNow > 0.0 && numTimesAtThisMinimum <= 2 && itr++ < 100) {
            double pLast = pNow;
            this.unCross(false);
            pNow = this.penalty();
            numTimesAtThisMinimum = pNow == pLast ? ++numTimesAtThisMinimum : 0;
            ALog.logInfo((String)"Phase %d, Penalty: %f", (Object[])new Object[]{itr, pNow});
        }
        this.mOptStats.stop();
        long perSec = Math.round(this.mOptStats.getActionsPerSecond());
        if (perSec > 0L) {
            ALog.logInfo((String)"Optimization done at %d optimizations per second", (Object[])new Object[]{perSec});
        }
    }

    protected void sortSet(List<MyHierPin> pinList, boolean sA) {
        if (this.mSortByInstruction && sA) {
            Collections.sort(pinList, new InstructionSorterBySide());
        } else {
            Collections.sort(pinList);
        }
        if (sA) {
            this.arrangeDiffPair(pinList);
        }
    }

    private void arrangeDiffPair(List<MyHierPin> pinList) {
        ArrayList<MyHierPin> resultList = new ArrayList<MyHierPin>(pinList.size());
        for (int i = 0; i < pinList.size(); ++i) {
            MyHierPin p = pinList.get(i);
            if (p == null) continue;
            resultList.add(p);
            DevicePath path = p.getPath();
            Net net = p.getNet();
            Net mateNet = Net.getDiffPairMate((Net)net, (DevicePath)path);
            if (mateNet == null) continue;
            for (int j = i + 1; j < pinList.size(); ++j) {
                MyHierPin q = pinList.get(j);
                if (q == null || !AUtil.equals((Object)path, (Object)q.getPath()) || !AUtil.equals((Object)q.getNet(), (Object)mateNet)) continue;
                resultList.add(q);
                pinList.set(j, null);
            }
        }
        pinList.clear();
        pinList.addAll(resultList);
    }

    protected void removeNetsOfFreeSide() {
        for (HierPin hierPin : this.mSetB) {
            PinTemplate pinTemplate;
            DevicePath path = hierPin.getPath();
            Device d = path.getLast();
            Net parentNet = NetMap.getParentNet((Device)d, (Net)(pinTemplate = ((PinInstance)hierPin.second).getPinTemplate()).getNet());
            if (parentNet != null) {
                NetMap.unmap((Device)d, (Net)pinTemplate.getNet(), (Net)parentNet);
            }
            pinTemplate.setNet(d.getTemplate().getNetUnused());
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void greedyAssign() {
        void var3_6;
        ALog.logInfo((String)"Beginning Connection Optimization");
        if (removeNetMappingOnToSide) {
            this.removeNetsOfFreeSide();
        }
        ArrayList<HierPin> unused = new ArrayList<HierPin>();
        for (HierPin hierPin : this.mSetA) {
            if (hierPin.getNet().isUnused()) continue;
            unused.add(hierPin);
        }
        ALog.logInfo((String)"Finding Initial Connections");
        int originalASize = this.mSetA.size();
        if (this.mSortByInstruction) {
            this.optimizeByInstruction();
        } else {
            this.optimizeByClosestPin();
        }
        this.mMatchNum = this.mSetA.size();
        boolean bl = false;
        while (var3_6 < this.mSetA.size()) {
            HierPin portA = this.mSetA.get((int)var3_6);
            HierPin portB = this.mSetB.get((int)var3_6);
            portA.getPin().setNetSetterType(PinInstance.NetSetterType.CONNECTION_OPT);
            portB.getPin().setNetSetterType(PinInstance.NetSetterType.CONNECTION_OPT);
            ++var3_6;
        }
        int n = originalASize - this.mMatchNum;
        if (n > 0) {
            ALog.logWarn((String)"%d signal pins could not be allocated on the free side.", (Object[])new Object[]{n});
        }
    }

    protected void optimizeByInstruction() {
        ArrayList<MyHierPin> connectedA = new ArrayList<MyHierPin>();
        ArrayList<MyHierPin> connectedB = new ArrayList<MyHierPin>();
        ArrayList<MyHierPin> extrasB = new ArrayList<MyHierPin>();
        List localB = this.mSetB.stream().distinct().collect(Collectors.toList());
        int pinsMatchedA = 0;
        for (Map.Entry<Long, ClusterClass> entry : this.mClusterMap.entrySet()) {
            long missingPins;
            Long instNum = entry.getKey();
            long numSignalPins = entry.getValue().getSignalPins();
            long numExtraPins = entry.getValue().getExtraPins();
            long numPinsNeeded = numSignalPins + numExtraPins;
            long numPinsObtained = 0L;
            long numDiffPairs = entry.getValue().getDiffPairs();
            String side = entry.getValue().getSide();
            APoint2D avgLoc = entry.getValue().getAvgLoc();
            OptimizerAlgo optAlgo = entry.getValue().getOptimizerAlgo();
            Collections.sort(localB, optAlgo == OptimizerAlgo.CLOSESTPIN ? new PinSorterByClosestPin(avgLoc) : new PinSorterByCorner(side, optAlgo));
            if (numDiffPairs > 0L) {
                String algo = entry.getValue().getDiffPairAlgo();
                long numSingles = numPinsNeeded - 2L * numDiffPairs;
                DiffPairFinder.DistCostFunction costFunction = DiffPairFinder.costToFunction((String)algo);
                ArrayList<AbstractPin> absList = new ArrayList<AbstractPin>();
                APair resultList = null;
                HashBiMap pinMap = HashBiMap.create();
                for (MyHierPin hp : localB) {
                    BigInteger curInst = (BigInteger)hp.getPin().getValue("autobundle.instruction");
                    if (!curInst.testBit(instNum.intValue()) || connectedB.contains((Object)hp) || extrasB.contains((Object)hp)) continue;
                    AbstractPin ap = new AbstractPin((HierPin)hp);
                    absList.add(ap);
                    pinMap.put((Object)hp, (Object)ap);
                }
                if (absList.isEmpty()) {
                    ALog.logInfo((String)("No free pins found for floorplan " + entry.getValue().getInterface().getName()));
                    continue;
                }
                resultList = DiffPairFinder.find((APoint2D)((AbstractPin)absList.get((int)0)).pin.getWorldLoc(), absList, (int)((int)numDiffPairs), (int)((int)numSingles), (double)1.0, (DiffPairFinder.DistCostFunction)costFunction, null);
                long overSize = (long)(((LinkedList)resultList.first).size() * 2 + ((LinkedList)resultList.second).size()) - numPinsNeeded;
                if (overSize > 0L) {
                    ALog.logInfo((String)("DiffPair finder returned " + overSize + " more pins than required."));
                } else {
                    for (CandidatePairs cp : (LinkedList)resultList.first) {
                        connectedB.add((MyHierPin)((Object)pinMap.inverse().get(cp.first)));
                        connectedA.add(this.mSetA.get(pinsMatchedA));
                        connectedB.add((MyHierPin)((Object)pinMap.inverse().get(cp.second)));
                        connectedA.add(this.mSetA.get(++pinsMatchedA));
                        ++pinsMatchedA;
                        numPinsObtained += 2L;
                    }
                    for (AbstractPin ap : (LinkedList)resultList.second) {
                        if (numPinsObtained < numSignalPins) {
                            connectedB.add((MyHierPin)((Object)pinMap.inverse().get((Object)ap)));
                            connectedA.add(this.mSetA.get(pinsMatchedA));
                            ++pinsMatchedA;
                        } else {
                            MyHierPin p = (MyHierPin)((Object)pinMap.inverse().get((Object)ap));
                            extrasB.add(p);
                            PinInstance pi = (PinInstance)p.second;
                            BigInteger val = BigInteger.ZERO;
                            val = val.setBit((int)instNum.longValue());
                            PinUtil.setBigIntValue((PinInstance)pi, (String)"autobundle.instruction", (BigInteger)val);
                        }
                        ++numPinsObtained;
                    }
                }
            } else {
                for (int jthB = 0; jthB < localB.size(); ++jthB) {
                    MyHierPin candidate = (MyHierPin)((Object)localB.get(jthB));
                    BigInteger curInst = (BigInteger)candidate.getPin().getValue("autobundle.instruction");
                    if (!curInst.testBit(instNum.intValue()) || connectedB.contains((Object)candidate) || extrasB.contains((Object)candidate)) continue;
                    if (++numPinsObtained <= numSignalPins && pinsMatchedA < this.mSetA.size()) {
                        connectedB.add(candidate);
                        connectedA.add(this.mSetA.get(pinsMatchedA));
                        ++pinsMatchedA;
                    } else {
                        extrasB.add(candidate);
                        PinInstance pi = (PinInstance)candidate.second;
                        BigInteger val = BigInteger.ZERO;
                        val = val.setBit((int)instNum.longValue());
                        PinUtil.setBigIntValue((PinInstance)pi, (String)"autobundle.instruction", (BigInteger)val);
                    }
                    if (numPinsObtained != numPinsNeeded) {
                        continue;
                    }
                    break;
                }
            }
            if ((missingPins = numPinsNeeded - numPinsObtained) == 0L) continue;
            ALog.logWarn((String)"Could not allocate %d pins for floorplan %s", (Object[])new Object[]{missingPins, entry.getValue().getInterface().getName()});
            if (missingPins <= numExtraPins) continue;
            pinsMatchedA = (int)((long)pinsMatchedA + (missingPins - numExtraPins));
        }
        this.mSetA = connectedA;
        this.mSetB = connectedB;
        this.mCreatedExtra = extrasB;
    }

    protected void optimizeByClosestPin() {
        ArrayList<MyHierPin> connectedA = new ArrayList<MyHierPin>();
        ArrayList<MyHierPin> connectedB = new ArrayList<MyHierPin>();
        HashSet<MyHierPin> inUse = new HashSet<MyHierPin>();
        int originalASize = this.mSetA.size();
        for (int ithA = 0; ithA < originalASize; ++ithA) {
            MyHierPin portA = this.mSetA.get(ithA);
            MyHierPin portB = this.closestValidPin(ithA, inUse);
            if (portB == null) continue;
            connectedA.add(portA);
            connectedB.add(portB);
            inUse.add(portB);
        }
        this.mSetA = connectedA;
        this.mSetB = connectedB;
    }

    boolean canDevicesBeMoved() {
        if (this.mSetB.size() > 1) {
            Device p1;
            Device p0 = this.mSetB.get(0).getPath().getLast();
            return p0 != (p1 = this.mSetB.get(1).getPath().getLast());
        }
        return false;
    }

    protected void moveUserToSets() {
        this.mSetA.clear();
        this.mSetB.clear();
        this.mSetA.addAll(this.mSetAFromUser);
        this.mSetB.addAll(this.mSetBFromUser);
    }

    public void filterSets() {
        Net substrateNet;
        int i;
        this.moveUserToSets();
        if (this.mUseOnlyUsedPortsOnFixedSide) {
            i = 0;
            while (i < this.mSetA.size()) {
                substrateNet = this.mSetA.get(i).getSubstrateNetOrNull();
                if (substrateNet == null || substrateNet.isUnused()) {
                    this.mSetA.remove(i);
                    continue;
                }
                ++i;
            }
        }
        if (this.createFloorplansOnFreeSide) {
            i = 0;
            while (i < this.mSetB.size()) {
                PinTemplate pt = this.mSetB.get(i).getPinTemplate();
                FloorplanPin fpp = FloorplanPin.find((PinTemplate)pt, (DevicePath)((DevicePath)this.mSetB.get((int)i).first));
                if (fpp != null) {
                    this.mSetB.remove(i);
                    continue;
                }
                ++i;
            }
        }
        if (this.mUseOnlyUnusedPortsOnFreeSide) {
            i = 0;
            while (i < this.mSetB.size()) {
                substrateNet = this.mSetB.get(i).getSubstrateNetOrNull();
                if (substrateNet != null && !substrateNet.isUnused()) {
                    this.mSetB.remove(i);
                    continue;
                }
                ++i;
            }
        }
        if (!treatFromAsIndividuals) {
            HashSet<Net> uniqueNets = new HashSet<Net>();
            LinkedList<MyHierPin> froms = new LinkedList<MyHierPin>();
            for (MyHierPin candidate : this.mSetA) {
                Net netAtCommon = this.getNetToCommon(candidate);
                if (!netAtCommon.isUnused() && uniqueNets.contains(netAtCommon)) continue;
                froms.add(candidate);
                uniqueNets.add(netAtCommon);
            }
            this.mSetA.clear();
            this.mSetA.addAll(froms);
        }
    }

    protected double penalty() {
        int penalty = 0;
        for (int i = 0; i < this.mMatchNum - 1; ++i) {
            for (int j = i + 1; j < this.mMatchNum; ++j) {
                if (!this.cross(i, j)) continue;
                ++penalty;
            }
        }
        return penalty;
    }

    protected boolean unCross(boolean ignoreDiffPairs) {
        boolean improved = false;
        for (int i = 0; i < this.mMatchNum; ++i) {
            if (ignoreDiffPairs && this.mDiffPairFroms.contains((Object)this.mSetA.get(i))) continue;
            for (int j = i + 1; j < this.mMatchNum; ++j) {
                if (ignoreDiffPairs && this.mDiffPairFroms.contains((Object)this.mSetA.get(j)) || !this.canSwap(i, j) || !this.cross(i, j)) continue;
                improved = true;
                this.mOptStats.newAction();
                this.swap(i, j);
            }
        }
        return improved;
    }

    protected void swap(int i, int j) {
        this.swapBPos(i, j);
    }

    protected boolean cross(int i, int j) {
        APoint2D pi0 = this.mSetA.get((int)i).cachedPoint;
        APoint2D pi1 = this.mSetB.get((int)i).cachedPoint;
        APoint2D pj0 = this.mSetA.get((int)j).cachedPoint;
        APoint2D pj1 = this.mSetB.get((int)j).cachedPoint;
        ALine lI = new ALine(pi0, pi1);
        ALine lJ = new ALine(pj0, pj1);
        return lI.crossIntersects(lJ);
    }

    protected Net getNetToCommon(HierPin dpp) {
        DevicePath stopPathI = new DevicePath(dpp.getPath());
        if (this.mCommonPath != null) {
            stopPathI = stopPathI.pathToParent(this.mCommonPath);
        }
        return NetMap.getTopmostNet((Net)dpp.getNet(), (DevicePath)stopPathI);
    }

    protected void swapBPos(int i, int j) {
        MyHierPin temp = this.mSetB.get(i);
        this.mSetB.set(i, this.mSetB.get(j));
        this.mSetB.set(j, temp);
    }

    protected MyHierPin closestValidPin(int ithA, HashSet<MyHierPin> inUse) {
        MyHierPin p1 = this.mSetA.get(ithA);
        MyHierPin bestCandidate = null;
        long bestDist = 0L;
        for (int jthB = 0; jthB < this.mSetB.size(); ++jthB) {
            long dist;
            MyHierPin candidate = this.mSetB.get(jthB);
            if (inUse.contains((Object)candidate) || this.mCCF != null && !this.mCCF.canConnect(this.mSetA.get(ithA), this.mSetB.get(jthB)) || (dist = this.calcDistance(p1, candidate)) >= bestDist && bestCandidate != null) continue;
            bestDist = dist;
            bestCandidate = candidate;
        }
        return bestCandidate;
    }

    protected long calcDistance(MyHierPin p1, MyHierPin p2) {
        APoint2D p1Loc = p1.cachedPoint;
        APoint2D p2Loc = p2.cachedPoint;
        return p1Loc.manhattanDistance(p2Loc);
    }

    protected boolean canSwap(int i, int j) {
        if (this.mSetB.get(i).getPin().fixed()) {
            return false;
        }
        if (this.mSetB.get(j).getPin().fixed()) {
            return false;
        }
        if (this.mCCF == null) {
            return true;
        }
        if (!this.mCCF.canConnect(this.mSetA.get(i), this.mSetB.get(j))) {
            return false;
        }
        return j >= this.mSetA.size() || this.mCCF.canConnect(this.mSetA.get(j), this.mSetB.get(i));
    }

    public boolean isPerfect() {
        double cross = this.penalty();
        if (cross != 0.0) {
            ALog.logDebug((String)"Cross %f", (Object[])new Object[]{cross});
            return false;
        }
        LinkedList<ALine> lines = new LinkedList<ALine>();
        int n = this.mSetA.size();
        for (int i = 0; i < n; ++i) {
            lines.add(new ALine(this.mSetA.get((int)i).cachedPoint, this.mSetB.get((int)i).cachedPoint));
        }
        LinkedList<APair> diffPairs = new LinkedList<APair>();
        block1: for (int i = 0; i < this.mSetA.size(); ++i) {
            MyHierPin p = this.mSetA.get(i);
            if (p == null) continue;
            DevicePath path = p.getPath();
            Net net = p.getNet();
            Net mateNet = Net.getDiffPairMate((Net)net, (DevicePath)path);
            if (mateNet == null) continue;
            for (int j = i + 1; j < this.mSetA.size(); ++j) {
                MyHierPin q = this.mSetA.get(j);
                if (q == null || !AUtil.equals((Object)path, (Object)q.getPath()) || !AUtil.equals((Object)q.getNet(), (Object)mateNet)) continue;
                diffPairs.add(new APair((Object)i, (Object)j));
                continue block1;
            }
        }
        for (APair pair : diffPairs) {
            int i = (Integer)pair.getFirst();
            int j = (Integer)pair.getSecond();
            ALine a = (ALine)lines.get(i);
            ALine b = (ALine)lines.get(j);
            APolygon poly = new APolygon(new APoint2D[]{a.getP0(), a.getP1(), b.getP1(), b.getP0()});
            for (int k = 0; k < n; ++k) {
                if (i == k || j == k) continue;
                ALine c = (ALine)lines.get(k);
                APolygon poly2 = new APolygon(new APoint2D[]{c.getP0(), c.getP1(), c.getP0()});
                if (!poly.intersects((AGeom)poly2)) continue;
                ALog.logDebug((String)"Diff pair %s %s fail", (Object[])new Object[]{this.mSetA.get(i), this.mSetA.get(j)});
                return false;
            }
        }
        return true;
    }

    private static class PinSorterByClosestPin
    implements Comparator<MyHierPin> {
        APoint2D loc;

        public PinSorterByClosestPin(APoint2D avgLoc) {
            this.loc = avgLoc;
        }

        @Override
        public int compare(MyHierPin o1, MyHierPin o2) {
            APoint2D loc1 = o1.getWorldLoc();
            APoint2D loc2 = o2.getWorldLoc();
            return Long.compare(this.loc.distance(loc1), this.loc.distance(loc2));
        }
    }

    private static class PinSorterByCorner
    implements Comparator<MyHierPin> {
        String side;
        OptimizerAlgo optAlgo;

        public PinSorterByCorner(String s, OptimizerAlgo algo) {
            this.side = s;
            this.optAlgo = algo;
        }

        @Override
        public int compare(MyHierPin o1, MyHierPin o2) {
            APoint2D loc1 = o1.getWorldLoc();
            APoint2D loc2 = o2.getWorldLoc();
            if (this.side.equals("N") || this.side.equals("NE")) {
                if (this.optAlgo == OptimizerAlgo.CORNERLT) {
                    if (loc1.getX() < loc2.getX()) {
                        return -1;
                    }
                    if (loc1.getX() > loc2.getX()) {
                        return 1;
                    }
                } else {
                    if (loc1.getX() > loc2.getX()) {
                        return -1;
                    }
                    if (loc1.getX() < loc2.getX()) {
                        return 1;
                    }
                }
                if (loc1.getY() < loc2.getY()) {
                    return 1;
                }
                if (loc1.getY() > loc2.getY()) {
                    return -1;
                }
            } else if (this.side.equals("E") || this.side.equals("SE")) {
                if (this.optAlgo == OptimizerAlgo.CORNERLT) {
                    if (loc1.getY() < loc2.getY()) {
                        return 1;
                    }
                    if (loc1.getY() > loc2.getY()) {
                        return -1;
                    }
                } else {
                    if (loc1.getY() > loc2.getY()) {
                        return 1;
                    }
                    if (loc1.getY() < loc2.getY()) {
                        return -1;
                    }
                }
                if (loc1.getX() < loc2.getX()) {
                    return 1;
                }
                if (loc1.getX() > loc2.getX()) {
                    return -1;
                }
            } else if (this.side.equals("S") || this.side.equals("SW")) {
                if (this.optAlgo == OptimizerAlgo.CORNERLT) {
                    if (loc1.getX() < loc2.getX()) {
                        return -1;
                    }
                    if (loc1.getX() > loc2.getX()) {
                        return 1;
                    }
                } else {
                    if (loc1.getX() > loc2.getX()) {
                        return -1;
                    }
                    if (loc1.getX() < loc2.getX()) {
                        return 1;
                    }
                }
                if (loc1.getY() < loc2.getY()) {
                    return -1;
                }
                if (loc1.getY() > loc2.getY()) {
                    return 1;
                }
            } else if (this.side.equals("W") || this.side.equals("NW")) {
                if (this.optAlgo == OptimizerAlgo.CORNERLT) {
                    if (loc1.getY() < loc2.getY()) {
                        return 1;
                    }
                    if (loc1.getY() > loc2.getY()) {
                        return -1;
                    }
                } else {
                    if (loc1.getY() > loc2.getY()) {
                        return 1;
                    }
                    if (loc1.getY() < loc2.getY()) {
                        return -1;
                    }
                }
                if (loc1.getX() < loc2.getX()) {
                    return -1;
                }
                if (loc1.getX() > loc2.getX()) {
                    return 1;
                }
            }
            return 0;
        }
    }

    protected class SwapDevices {
        ArrayList<FromTo> fromTos = new ArrayList();

        protected SwapDevices() {
        }

        protected void populateFromTos() {
            int i;
            PortPairOpt.this.mMatchNum = Math.min(PortPairOpt.this.mSetA.size(), PortPairOpt.this.mSetB.size());
            for (i = 0; i < PortPairOpt.this.mMatchNum; ++i) {
                this.fromTos.add(new FromTo(PortPairOpt.this.mSetA.get(i), PortPairOpt.this.mSetB.get(i)));
            }
            PortPairOpt.this.mSetA.clear();
            PortPairOpt.this.mSetB.clear();
            for (i = 0; i < PortPairOpt.this.mMatchNum; ++i) {
                PortPairOpt.this.mSetA.add(this.fromTos.get((int)i).from);
                PortPairOpt.this.mSetB.add(this.fromTos.get((int)i).to);
            }
        }

        protected boolean canSwap(FromTo a, FromTo b) {
            Device deva = a.to.getPath().getLast();
            Device devb = b.to.getPath().getLast();
            if (deva.getIsFixed()) {
                return false;
            }
            if (devb.getIsFixed()) {
                return false;
            }
            return a.to.getPath().getParent().equals((Object)b.to.getPath().getParent());
        }

        protected boolean cross(FromTo a, FromTo b) {
            APoint2D pi0 = a.from.getWorldLoc();
            APoint2D pi1 = a.to.getWorldLoc();
            APoint2D pj0 = b.from.getWorldLoc();
            APoint2D pj1 = b.to.getWorldLoc();
            ALine lI = new ALine(pi0, pi1);
            ALine lJ = new ALine(pj0, pj1);
            return lI.crossIntersects(lJ);
        }

        protected void swap(FromTo a, FromTo b) {
            Device devi = a.to.getPath().getLast();
            Device devj = b.to.getPath().getLast();
            ATransform t1 = devi.getTransform();
            ATransform t2 = devj.getTransform();
            devi.setTransform(t2);
            devj.setTransform(t1);
        }

        protected double penalty() {
            double penalty = 0.0;
            for (int i = 0; i < PortPairOpt.this.mMatchNum; ++i) {
                for (int j = i + 1; j < PortPairOpt.this.mMatchNum; ++j) {
                    if (!this.cross(this.fromTos.get(i), this.fromTos.get(j))) continue;
                    penalty += 1.0;
                }
            }
            return penalty;
        }

        protected boolean uncross() {
            boolean improved = false;
            for (int i = 0; i < PortPairOpt.this.mMatchNum; ++i) {
                FromTo a = this.fromTos.get(i);
                for (int j = i + 1; j < PortPairOpt.this.mMatchNum; ++j) {
                    FromTo b = this.fromTos.get(j);
                    if (!this.canSwap(a, b) || !this.cross(a, b)) continue;
                    improved = true;
                    this.swap(a, b);
                }
            }
            return improved;
        }

        protected void alignNets() {
            int aSize = PortPairOpt.this.mSetA.size();
            LinkedList<MyHierPin> matchedA = new LinkedList<MyHierPin>();
            LinkedList<MyHierPin> matchedB = new LinkedList<MyHierPin>();
            LinkedList<MyHierPin> unMatchedA = new LinkedList<MyHierPin>(PortPairOpt.this.mSetA);
            LinkedList<MyHierPin> unMatchedB = new LinkedList<MyHierPin>(PortPairOpt.this.mSetB);
            block0: for (int i = 0; i < aSize; ++i) {
                MyHierPin dppA = PortPairOpt.this.mSetA.get(i);
                for (MyHierPin candidate : unMatchedB) {
                    if (!NetMap.isConnected((HierPin)dppA, (HierPin)candidate)) continue;
                    matchedA.add(dppA);
                    matchedB.add(candidate);
                    unMatchedA.remove((Object)dppA);
                    unMatchedB.remove((Object)candidate);
                    PortPairOpt.this.mAToBOrignal.put(dppA, candidate);
                    continue block0;
                }
            }
            PortPairOpt.this.mSetA.clear();
            PortPairOpt.this.mSetB.clear();
            PortPairOpt.this.mSetA.addAll(matchedA);
            PortPairOpt.this.mSetB.addAll(matchedB);
            PortPairOpt.this.mSetA.addAll(unMatchedA);
            PortPairOpt.this.mSetB.addAll(unMatchedB);
            PortPairOpt.this.mMatchNum = matchedA.size();
        }

        public void doSwapDevices() {
            this.alignNets();
            this.populateFromTos();
            this.uncross();
            double pNow = this.penalty();
            int itr = 0;
            int numTimesAtThisMinimum = 0;
            while (pNow > 0.0 && numTimesAtThisMinimum <= 2 && itr++ < 100) {
                double pLast = pNow;
                this.uncross();
                pNow = this.penalty();
                numTimesAtThisMinimum = pNow == pLast ? ++numTimesAtThisMinimum : 0;
                ALog.logInfo((String)("Phase " + itr + " Penalty: " + pNow));
            }
        }
    }

    protected static class FromTo {
        protected MyHierPin from;
        protected MyHierPin to;

        public FromTo(MyHierPin from, MyHierPin to) {
            this.from = from;
            this.to = to;
        }
    }

    private class InstructionSorterBySide
    implements Comparator<MyHierPin> {
        private InstructionSorterBySide() {
        }

        @Override
        public int compare(MyHierPin o1, MyHierPin o2) {
            BigInteger fld1 = (BigInteger)o1.getPin().getValue("autobundle.instruction");
            BigInteger fld2 = (BigInteger)o2.getPin().getValue("autobundle.instruction");
            if (fld1 == null || fld2 == null || fld1.equals(fld2)) {
                return 0;
            }
            long bit1 = fld1.getLowestSetBit();
            long bit2 = fld2.getLowestSetBit();
            int order1 = PortPairOpt.this.mClusterMap.get(bit1).getOrder();
            int order2 = PortPairOpt.this.mClusterMap.get(bit2).getOrder();
            return Integer.compare(order1, order2);
        }
    }

    public static class ClusterClass {
        Interface intf;
        APoint2D avgLoc;
        long signalPins;
        long extraPins;
        long diffPairs;
        String side;
        int order;
        String diffPairAlgo;
        OptimizerAlgo optAlgo;

        public ClusterClass(Interface i, APoint2D a, long s, long e, long n, String si, int o, String dp, OptimizerAlgo al) {
            this.intf = i;
            this.avgLoc = a;
            this.signalPins = s;
            this.extraPins = e;
            this.diffPairs = n;
            this.side = si;
            this.order = o;
            this.diffPairAlgo = dp;
            this.optAlgo = al;
        }

        public Interface getInterface() {
            return this.intf;
        }

        public APoint2D getAvgLoc() {
            return this.avgLoc;
        }

        public long getSignalPins() {
            return this.signalPins;
        }

        public long getExtraPins() {
            return this.extraPins;
        }

        public long getDiffPairs() {
            return this.diffPairs;
        }

        public String getSide() {
            return this.side;
        }

        public int getOrder() {
            return this.order;
        }

        public String getDiffPairAlgo() {
            return this.diffPairAlgo;
        }

        public OptimizerAlgo getOptimizerAlgo() {
            return this.optAlgo;
        }

        public void setOrder(int o) {
            this.order = o;
        }

        public void setOptAlgo(OptimizerAlgo al) {
            this.optAlgo = al;
        }
    }

    static class OptimizationStats {
        protected Stopwatch stopWatch = new Stopwatch();
        protected long actions;

        OptimizationStats() {
        }

        public void start() {
            this.actions = 0L;
            this.stopWatch.start();
        }

        public void stop() {
            this.stopWatch.stop();
        }

        public void newAction() {
            ++this.actions;
        }

        public double getActionsPerSecond() {
            double elapsed = (double)this.stopWatch.elapsed() / 1000.0;
            if (elapsed == 0.0) {
                elapsed = 1.0;
            }
            return (double)this.actions / elapsed;
        }
    }

    protected static class MyHierPin
    extends HierPin {
        protected APoint2D cachedPoint;
        protected Net cachedTopNet;

        public MyHierPin(HierPin hpin) {
            super(hpin);
        }
    }

    public static enum OptimizerAlgo {
        CORNERLT(0),
        CLOSESTPIN(1),
        CORNERRB(2);

        private int priority;

        private OptimizerAlgo(int p) {
            this.priority = p;
        }

        public int priority() {
            return this.priority;
        }
    }
}

