/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.optimizer;

import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.geom.AGeomUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.Neighborhood;
import com.sigrity.orbit.OrbitIO;
import java.util.ArrayList;

public class Relaxer {
    ArrayList<DevicePath> mSet = new ArrayList();

    public void relax(ArrayList<DevicePath> set) {
        for (int i = 0; i < 10; ++i) {
            this.mSet = set;
            for (DevicePath dp : this.mSet) {
                this.relax(dp);
            }
            OrbitIO.getApp().refreshCurrentView(true);
        }
    }

    protected long relaxWB(DevicePath dp) {
        return 0L;
    }

    protected long relax(DevicePath dp) {
        Neighborhood n = Device.closestNeighbor((DevicePath)dp);
        long l = n.getDist(AGeomUtil.CompassDir.W);
        long r = n.getDist(AGeomUtil.CompassDir.E);
        long hMove = (r - l) / 8L;
        long b = n.getDist(AGeomUtil.CompassDir.S);
        long t = n.getDist(AGeomUtil.CompassDir.N);
        long vMove = (t - b) / 8L;
        dp.getLast().moveBy(hMove, vMove);
        return hMove + vMove;
    }

    public static void relaxSelected() {
        ArrayList<DevicePath> set = new ArrayList<DevicePath>();
        Selection s = OrbitIO.getCurDesign().getCurSelection();
        for (Device d : s.get(Device.class)) {
            set.add(d.getADevicePath());
        }
        Relaxer r = new Relaxer();
        r.relax(set);
    }
}

