/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.optimizer;

import com.sigrity.acl.ALog;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.xml.AXDomUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Sequencer {
    protected Element mRootElement = null;

    public Sequencer() {
        this.loadXML();
    }

    public ArrayList<Device> sortForMe(ArrayList<Device> unsortedDevices, String seqName) {
        ArrayList<Device> sorted = new ArrayList<Device>();
        for (Device d : unsortedDevices) {
            d.setMarked(false);
        }
        for (Element e : this.getAllNodes(seqName)) {
            String pString;
            boolean foundCandidate = false;
            String selector = e.getAttribute("selector");
            if (selector.compareToIgnoreCase("personality") == 0) {
                pString = e.getAttribute("value");
                for (Device d : unsortedDevices) {
                    String myPersonality;
                    if (d.getMarked()) continue;
                    if (d.getPersonality() != null && pString != null && (myPersonality = d.getPersonality().getName()).compareTo(pString) == 0) {
                        d.setMarked(true);
                        sorted.add(d);
                        foundCandidate = true;
                    }
                    if (!foundCandidate) continue;
                    break;
                }
            } else if (selector.compareToIgnoreCase("name") == 0) {
                Pattern pattern;
                pString = e.getAttribute("value");
                try {
                    pattern = Pattern.compile(pString);
                }
                catch (PatternSyntaxException pE) {
                    ALog.logError((String)("The value " + pString + " is not a valid pattern"));
                    pattern = Pattern.compile(".*");
                }
                for (Device d : unsortedDevices) {
                    String myName;
                    if (d.getMarked()) continue;
                    if (pString != null && pattern.matcher(myName = d.getName()).find()) {
                        d.setMarked(true);
                        sorted.add(d);
                        foundCandidate = true;
                    }
                    if (!foundCandidate) continue;
                    break;
                }
            }
            if (foundCandidate) continue;
            break;
        }
        return sorted;
    }

    public int SortDevices() {
        return 0;
    }

    public Iterable<String> getAllSequenceNames() {
        NameIterable i = new NameIterable();
        return i;
    }

    public static String getSequencesFileName() {
        Settings s = Settings.getSettings((String)"Automation");
        String fileName = (String)s.getSettingOfClass("SequenceFile", String.class);
        return fileName;
    }

    public static File getUserSequencesFile() {
        return Settings.getConfigFileLoc((String)Sequencer.getSequencesFileName(), (Settings.Type)Settings.Type.User);
    }

    private void loadXML() {
        List files = Settings.findConfigFiles((String)Sequencer.getSequencesFileName());
        this.mRootElement = null;
        if (files.size() < 1) {
            ALog.logError((String)"Unable to open Sequencer sequence configuration file.");
            return;
        }
        for (File f : files) {
            ALog.logDebug((String)"Using sequence configuration file '%s'.", (Object[])new Object[]{f.getAbsolutePath()});
            Element element = AXDomUtil.getDocumentElement((File)f);
            if (element == null) continue;
            if (this.mRootElement == null) {
                this.mRootElement = element;
                continue;
            }
            Sequencer.mergeXml(this.mRootElement, element);
        }
    }

    protected static void mergeXml(Element target, Element source) {
        for (Element srcElem : AXDomUtil.getChildElems((Node)source, (String)"Sequence")) {
            String name = srcElem.getAttribute("name");
            if (name == null) continue;
            XPath xpath = XPathFactory.newInstance().newXPath();
            try {
                String expr = String.format("Sequence[@name='%s']", name);
                Node n = (Node)xpath.evaluate(expr, target, XPathConstants.NODE);
                if (n != null) continue;
                Node newNode = target.getOwnerDocument().importNode(srcElem, true);
                target.appendChild(newNode);
            }
            catch (XPathExpressionException e) {
                ALog.logError((Throwable)e, (String)"mergeXml error.", (Object[])new Object[0]);
            }
        }
    }

    public Iterable<Element> getAllNodes(String sequenceName) {
        NodeIterable i = new NodeIterable();
        i.setName(sequenceName);
        return i;
    }

    public class NodeIterator
    implements Iterator<Element> {
        ArrayList<Element> mElements = new ArrayList();
        int mIndex;
        String mSequenceName;

        public void setName(String sequenceName) {
            this.mSequenceName = sequenceName;
            Element sequenceNode = null;
            if (Sequencer.this.mRootElement != null) {
                for (Element e : AXDomUtil.getChildElems((Node)Sequencer.this.mRootElement)) {
                    String name = e.getAttribute("name");
                    if (name.compareTo(this.mSequenceName) != 0) continue;
                    sequenceNode = e;
                    break;
                }
                if (sequenceNode != null) {
                    for (Element e : AXDomUtil.getChildElems(sequenceNode)) {
                        this.mElements.add(e);
                    }
                }
            }
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Element next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.mIndex >= this.mElements.size()) {
                this.mIndex = 0;
            }
            return this.mElements.get(this.mIndex++);
        }
    }

    private class NodeIterable
    implements Iterable<Element> {
        protected NodeIterator mItr;
        protected String mSequenceName = null;

        private NodeIterable() {
        }

        @Override
        public Iterator<Element> iterator() {
            this.mItr = new NodeIterator();
            this.mItr.setName(this.mSequenceName);
            return this.mItr;
        }

        public void setName(String sequenceName) {
            this.mSequenceName = sequenceName;
        }
    }

    public class NameIterator
    implements Iterator<String> {
        ArrayList<String> mNames = new ArrayList();
        int mIndex;

        public NameIterator() {
            if (Sequencer.this.mRootElement != null) {
                for (Element e : AXDomUtil.getChildElems((Node)Sequencer.this.mRootElement)) {
                    String name = e.getAttribute("name");
                    this.mNames.add(name);
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.mIndex < this.mNames.size();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.mNames.get(this.mIndex++);
        }
    }

    private class NameIterable
    implements Iterable<String> {
        protected NameIterator mItr;

        private NameIterable() {
        }

        @Override
        public Iterator<String> iterator() {
            this.mItr = new NameIterator();
            return this.mItr;
        }
    }
}

