/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.optimizer;

import com.sigrity.acl.ATransformUtil;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;

public class SiteSearcher {
    long mD2D;
    long mD2B;
    protected Distributor<?> mDistributor;

    public void setClr(long d2d, long d2b) {
        this.mD2D = d2d;
        this.mD2B = d2b;
    }

    public void setDistributor(Distributor<?> distributor) {
        this.mDistributor = distributor;
    }

    public LocDistributor getLocDistributor() {
        return this.mDistributor instanceof LocDistributor ? (LocDistributor)this.mDistributor : null;
    }

    public EdgeDistributor getEdgeDistributor() {
        return this.mDistributor instanceof EdgeDistributor ? (EdgeDistributor)this.mDistributor : null;
    }

    public void addObstacleArea(ARect area, long clearance) {
        this.mDistributor.addObstacleArea(area, clearance);
    }

    public static LocDistributor createEvenDistributor(ARect area, long deviceToBoundClearance, long percentage) {
        LocDistributor d = new LocDistributor(area, deviceToBoundClearance);
        long xInc = area.width() * percentage / 100L;
        long yInc = area.height() * percentage / 100L;
        long nSites = 100L / percentage;
        long y = area.bottom();
        int i = 0;
        while ((long)i < nSites) {
            long x = area.left();
            int j = 0;
            while ((long)j < nSites) {
                d.add(new APoint2D(x, y));
                x += xInc;
                ++j;
            }
            y += yInc;
            ++i;
        }
        return d;
    }

    public static EdgeDistributor createObstacleEdgeDistributor(ARect area, long deviceToBoundClearance) {
        EdgeDistributor d = new EdgeDistributor(area, deviceToBoundClearance);
        return d;
    }

    protected static abstract class Distributor<T>
    extends ArrayList<T> {
        ARect mArea;

        public Distributor(ARect area, long deviceToBoundClearance) {
            this.mArea = new ARect(area);
            this.mArea.grow(-deviceToBoundClearance);
        }

        abstract void addObstacleArea(ARect var1, long var2);
    }

    public static class EdgeDistributor
    extends Distributor<EdgeSites> {
        protected int mSitesPerEdge = 3;

        public EdgeDistributor(ARect area, long deviceToBoundClearance) {
            super(area, deviceToBoundClearance);
            ALine l = this.mArea.bottomEdge();
            this.addEdgeSites(l, true);
            l = this.mArea.leftEdge();
            this.addEdgeSites(l, true);
            l = this.mArea.topEdge();
            this.addEdgeSites(l, false);
            l = this.mArea.rightEdge();
            this.addEdgeSites(l, false);
        }

        public int getTotalSize() {
            return this.size() * this.mSitesPerEdge;
        }

        public int getSitesPerEdge() {
            return this.mSitesPerEdge;
        }

        @Override
        public void addObstacleArea(ARect obstacleArea, long devToObstacleClearance) {
            ARect bound = new ARect(obstacleArea);
            ALine l = bound.bottomEdge();
            this.addEdgeSites(l, false);
            l = bound.leftEdge();
            this.addEdgeSites(l, false);
            l = bound.topEdge();
            this.addEdgeSites(l, true);
            l = bound.rightEdge();
            this.addEdgeSites(l, true);
        }

        private void addEdgeSites(ALine edge, boolean alignLowEdge) {
            EdgeSites sites = new EdgeSites(edge, alignLowEdge, this.mSitesPerEdge);
            this.add(sites);
        }
    }

    public static class EdgeSites {
        protected APoint2D[] mLoc;
        protected boolean mVertical;
        protected boolean mAlignLowEdge;

        protected EdgeSites(ALine edge, boolean alignLowEdge, int sitesPerEdge) {
            assert (sitesPerEdge == 3);
            this.mLoc = new APoint2D[sitesPerEdge];
            this.mAlignLowEdge = alignLowEdge;
            APoint2D p0 = edge.getP0();
            APoint2D p1 = edge.getP1();
            boolean bl = this.mVertical = p0.getX() == p1.getX();
            if (this.mVertical) {
                this.mLoc[0] = new APoint2D(p0.getX(), Math.min(p0.getY(), p1.getY()));
                this.mLoc[1] = new APoint2D(p0.getX(), (p0.getY() + p1.getY()) / 2L);
                this.mLoc[2] = new APoint2D(p0.getX(), Math.max(p0.getY(), p1.getY()));
            } else {
                this.mLoc[0] = new APoint2D(Math.min(p0.getX(), p1.getX()), p0.getY());
                this.mLoc[1] = new APoint2D((p0.getX() + p1.getX()) / 2L, p0.getY());
                this.mLoc[2] = new APoint2D(Math.max(p0.getX(), p1.getX()), p0.getY());
            }
        }

        public APoint2D getSite(int index) {
            return this.mLoc[index];
        }

        private APoint2D getAdjustSite(ARect bound, int index, long sep) {
            long offsetx = 0L;
            long offsety = 0L;
            if (this.mVertical) {
                offsetx = this.mAlignLowEdge ? this.mLoc[index].getX() - bound.left() + sep : this.mLoc[index].getX() - bound.right() - sep;
                offsety = index == 0 ? this.mLoc[index].getY() - bound.bottom() : (index == 1 ? this.mLoc[index].getY() - bound.centerY() : this.mLoc[index].getY() - bound.top());
            } else {
                offsety = this.mAlignLowEdge ? this.mLoc[index].getY() - bound.bottom() + sep : this.mLoc[index].getY() - bound.top() - sep;
                offsetx = index == 0 ? this.mLoc[index].getX() - bound.left() : (index == 1 ? this.mLoc[index].getX() - bound.centerX() : this.mLoc[index].getX() - bound.right());
            }
            return new APoint2D(offsetx, offsety);
        }

        public void placeAtSite(DevicePath dp, DevicePath parentPath, int index, long sep) {
            Device device = dp.getLast();
            APoint2D p = new APoint2D(this.mLoc[index]);
            AffineTransform t = parentPath.getTransform();
            AffineTransform tI = ATransformUtil.inverse((AffineTransform)t);
            APoint2D transP = p.transform(tI);
            device.setLoc(transP);
            DevicePath relative = new DevicePath(dp);
            relative.removeFirst();
            ARect bound = relative.getBB();
            APoint2D offset = this.getAdjustSite(bound, index, sep);
            device.moveBy(offset.getX(), offset.getY());
        }
    }

    public static class LocDistributor
    extends Distributor<APoint2D> {
        public LocDistributor(ARect area, long deviceToBoundClearance) {
            super(area, deviceToBoundClearance);
        }

        @Override
        public void addObstacleArea(ARect obstacleArea, long devToObstacleClearance) {
            ARect bound = new ARect(obstacleArea);
            if (!this.mArea.intersects(bound)) {
                return;
            }
            int size = this.size();
            int i = 0;
            while (i < size) {
                if (bound.intersects((APoint2D)this.get(i))) {
                    this.remove(i);
                    --size;
                    continue;
                }
                ++i;
            }
        }
    }
}

