/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.optimizer.genetic;

import com.sigrity.acl.ALog;
import com.sigrity.acl.optimizer.genetic.Chromosome;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Stream;

public class AGeneticOptimizer {
    protected final double percentMate = 1.0;
    public final int DEFAULT_MAX_POPULATION = 64;
    protected final boolean mRunParallel;
    long mTotalGenerations;
    long mCurGeneration;
    long mStartTime;
    long mEndTime;
    long mEvolveEndTime;
    long mCurSeconds;
    long mToRunSeconds;
    boolean mSwitchTimer = false;
    boolean mStopNow = false;
    Double mPerfect = null;
    int mMaxPopulation = 64;
    boolean mAsexual = false;
    boolean mReverseScore = false;
    String mStatus = "";
    Timer pulseTimer;
    boolean timerHasGoneOff;
    Random mRandom = new Random(3141592L);
    LinkedList<Double> bestScores = new LinkedList();
    LinkedList<Individual> mPopulation = new LinkedList();
    protected static LinkedList<GeneticOptimizerStatusListener> sLoadListener = new LinkedList();

    public synchronized void addIndividual(Individual ind) {
        this.mPopulation.add(ind);
    }

    public void addChromosome(Chromosome c, Individual parent) {
        Individual newInd = new Individual();
        newInd.mChromosome = c;
        newInd.mFitness = c.fitness();
        newInd.mBestFitness = parent == null ? newInd.mFitness : (this.mReverseScore ? Math.min(newInd.mFitness, parent.mBestFitness) : Math.max(newInd.mFitness, parent.mBestFitness));
        this.addIndividual(newInd);
    }

    protected void replace(Individual oldI, Individual newI) {
        int oldindex = this.mPopulation.indexOf(oldI);
        this.mPopulation.set(oldindex, newI);
    }

    public void addBetterChromosome(Chromosome c, Individual parent) {
        Individual newInd = new Individual();
        newInd.mChromosome = c;
        newInd.mFitness = c.fitness();
        if (parent == null) {
            newInd.mBestFitness = newInd.mFitness;
        } else if (this.mReverseScore) {
            newInd.mBestFitness = Math.min(newInd.mFitness, parent.mBestFitness);
            if (newInd.mFitness < parent.mFitness) {
                this.replace(parent, newInd);
            }
        } else {
            newInd.mBestFitness = Math.max(newInd.mFitness, parent.mBestFitness);
            if (newInd.mFitness > parent.mFitness) {
                this.replace(parent, newInd);
            }
        }
    }

    public AGeneticOptimizer(boolean asexual, boolean reverseScore, boolean runParallel) {
        this.mRunParallel = runParallel;
        this.mAsexual = asexual;
        this.mReverseScore = reverseScore;
        this.mSwitchTimer = false;
    }

    public AGeneticOptimizer(boolean asexual, boolean reverseScore) {
        this(asexual, reverseScore, true);
    }

    public void setStop(boolean stop) {
        this.mStopNow = stop;
    }

    public void setMaxPopulation(int maxPopulation) {
        this.mMaxPopulation = maxPopulation;
    }

    public int getMaxPopulation() {
        return this.mMaxPopulation;
    }

    public void setASexual(boolean a) {
        this.mAsexual = a;
    }

    public double getReproductionRate() {
        double totalLifeTime = this.mEvolveEndTime - this.mStartTime;
        if (totalLifeTime > 0.0) {
            return (double)this.mCurGeneration / totalLifeTime * 1000.0;
        }
        return 0.0;
    }

    public boolean getIsStoped() {
        return this.mStopNow;
    }

    public void perfect(double p) {
        this.mPerfect = p;
    }

    public void stopEvolution() {
        this.mStopNow = true;
    }

    public void evolveForTime(long seconds) {
        this.evolveForTime(seconds, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evolveForTime(long seconds, boolean genTrainingData) {
        if (seconds == 0L) {
            Chromosome c = this.mPopulation.get((int)0).mChromosome;
            c.fitness();
            ALog.logInfo((String)"%s", (Object[])new Object[]{this.mPopulation.get((int)0).mFitness});
            return;
        }
        this.mToRunSeconds = seconds;
        Double bestScore = null;
        this.pulseTimer = new Timer();
        try {
            this.mStartTime = System.currentTimeMillis();
            boolean stoppingCondition = false;
            this.pulseTimer.schedule((TimerTask)new GeneticOptimizationPulseTask(this), 250L);
            double lastScore = 0.0;
            long generationsAtSameScore = 0L;
            ALog.logInfo((String)("Using " + Runtime.getRuntime().availableProcessors() + " Processors"));
            while (!stoppingCondition) {
                this.evolve();
                this.mEvolveEndTime = System.currentTimeMillis();
                ++this.mCurGeneration;
                this.mCurSeconds = (this.mEvolveEndTime - this.mStartTime) / 1000L;
                if ((double)this.mCurSeconds > (double)this.mToRunSeconds * 0.8) {
                    this.setSwitchTimer(true);
                }
                if (this.mCurSeconds >= seconds) {
                    stoppingCondition = true;
                    this.mStatus = "Time Limit";
                }
                double score = this.mPopulation.get((int)0).mFitness;
                this.bestScores.add(score);
                if (bestScore == null || score < bestScore) {
                    bestScore = score;
                }
                if (score <= 0.0 && this.mReverseScore) {
                    stoppingCondition = true;
                }
                if (this.mStopNow) {
                    this.mStatus = "Stopped by " + System.getProperty("user.name");
                    stoppingCondition = true;
                }
                if (score == lastScore) {
                    ++generationsAtSameScore;
                } else {
                    lastScore = score;
                    generationsAtSameScore = 0L;
                }
                if (!stoppingCondition) {
                    int min = (int)(seconds - this.mCurSeconds) / 60;
                    int sec = (int)(seconds - this.mCurSeconds) - min * 60;
                    this.mStatus = String.format("%d:%2d Remain", min, sec);
                }
                if (this.timerHasGoneOff || stoppingCondition) {
                    this.timerHasGoneOff = false;
                    this.pulseTask();
                    this.pulseTimer.schedule((TimerTask)new GeneticOptimizationPulseTask(this), 1000L);
                }
                if (genTrainingData) {
                    this.mPopulation.forEach(individual -> individual.mChromosome.endOfEpoch());
                    continue;
                }
                this.mPopulation.get((int)0).mChromosome.endOfEpoch();
            }
        }
        finally {
            this.pulseTimer.cancel();
        }
        this.mStatus = this.mStatus + " gps:" + this.getReproductionRate();
        ALog.logInfo((String)this.mStatus);
        ALog.logInfo((String)"gen number: %dl", (Object[])new Object[]{this.mCurGeneration});
        ALog.logInfo((String)"best score: %s", (Object[])new Object[]{bestScore});
        ALog.logInfo((String)"population: %d", (Object[])new Object[]{this.mMaxPopulation});
        AGeneticOptimizer.updateProgress(true, (double)this.mCurSeconds / (double)seconds, this.mStatus);
    }

    public void pulseTask() {
        if (this.mPopulation.get(0) != null) {
            AGeneticOptimizer.updateProgress(false, (double)this.mCurSeconds / (double)this.mToRunSeconds, this.mStatus);
        }
    }

    protected void scoreMe(Individual ind) {
        double fitness;
        Chromosome c = ind.mChromosome;
        ind.mFitness = fitness = c.fitness();
    }

    public void setSwitchTimer(boolean value) {
        this.mSwitchTimer = value;
    }

    public boolean getSwitchTimer() {
        return this.mSwitchTimer;
    }

    protected void evolve() {
        LinkedList<Individual> offspring = new LinkedList<Individual>();
        for (Individual ind2 : this.mPopulation) {
            Chromosome c = ind2.mChromosome;
            Chromosome m = c.mutate();
            Individual newInd = new Individual();
            newInd.mChromosome = m;
            offspring.add(newInd);
        }
        if (this.mRunParallel) {
            ((Stream)offspring.stream().parallel()).forEach(this::scoreMe);
        } else {
            offspring.stream().forEach(this::scoreMe);
        }
        this.mPopulation.addAll(offspring);
        LinkedList<Individual> selectedPopulation = this.selectIndividuals(this.mPopulation, ind -> this.score(ind), y -> this.inverseCDF(y));
        this.mPopulation.clear();
        this.mPopulation.addAll(selectedPopulation);
    }

    public double inverseCDF(double y) {
        if (y < 0.6666666666666666) {
            return 0.75 * y;
        }
        return 0.5 * (2.0 - Math.sqrt(3.0 * (1.0 - y)));
    }

    public double score(Individual ind) {
        return ind.mFitness;
    }

    public LinkedList<Individual> selectIndividuals(LinkedList<Individual> population, final ExtractScore extractScoreInterface, ProbabilityDistribution distribution) {
        LinkedList<Individual> nextGeneration = new LinkedList<Individual>();
        population.sort(new Comparator<Individual>(){

            @Override
            public int compare(Individual ind1, Individual ind2) {
                int d = Double.valueOf(extractScoreInterface.score(ind1)).compareTo(extractScoreInterface.score(ind2));
                if (!AGeneticOptimizer.this.mReverseScore) {
                    d *= -1;
                }
                return d;
            }
        });
        int[] list = new int[this.mMaxPopulation];
        nextGeneration.add(population.getFirst().deepCopy());
        for (int i = 1; i < this.mMaxPopulation; ++i) {
            int index = (int)Math.floor((double)population.size() * distribution.inverseCDF(Math.random()));
            Individual selectedInd = population.get(index).deepCopy();
            nextGeneration.add(selectedInd);
            list[i] = index;
        }
        Arrays.sort(list);
        return nextGeneration;
    }

    public void printPopulation() {
        ALog.logInfo((String)("Generation " + this.mCurGeneration));
        for (Individual ind : this.mPopulation) {
            ALog.logInfo((String)("" + ind.mFitness));
        }
    }

    public LinkedList<Double> getBestScores() {
        return this.bestScores;
    }

    public LinkedList<Individual> getChromosomes() {
        return this.mPopulation;
    }

    public Chromosome getBestIndividual() {
        return this.mPopulation.get((int)0).mChromosome;
    }

    public Chromosome getWorstIndividual() {
        return this.mPopulation.getLast().mChromosome;
    }

    public double getBestScore() {
        return this.mPopulation.get((int)0).mFitness;
    }

    public long getGenerations() {
        return this.mCurGeneration;
    }

    public Chromosome getIndividual(int i) {
        return this.mPopulation.get((int)i).mChromosome;
    }

    public static void removeLoadListers() {
        sLoadListener.clear();
    }

    public static boolean addLoadListener(GeneticOptimizerStatusListener l) {
        return sLoadListener.add(l);
    }

    public static boolean removeLoadListener(GeneticOptimizerStatusListener l) {
        return sLoadListener.remove(l);
    }

    protected static void firePercentUpdate(int percent, boolean done, String data) {
        for (GeneticOptimizerStatusListener l : sLoadListener) {
            l.stats(percent, done, data);
        }
    }

    public static void updateProgress(boolean done, double percent, String data) {
        int iPercent = (int)(percent * 100.0);
        AGeneticOptimizer.firePercentUpdate(iPercent, done, data);
    }

    public static interface GeneticOptimizerStatusListener {
        public void stats(int var1, boolean var2, String var3);
    }

    protected class FitnessSorter
    implements Comparator<Individual> {
        protected FitnessSorter() {
        }

        @Override
        public int compare(Individual i0, Individual i1) {
            int c = 0;
            double d = i0.mFitness - i1.mFitness;
            c = d < 0.0 ? 1 : (d > 0.0 ? -1 : 0);
            if (AGeneticOptimizer.this.mReverseScore) {
                c *= -1;
            }
            return c;
        }
    }

    static interface ExtractScore {
        public double score(Individual var1);
    }

    static interface ProbabilityDistribution {
        public double inverseCDF(double var1);
    }

    public static class Individual {
        Chromosome mChromosome;
        double mFitness;
        double mBestFitness;

        public Individual deepCopy() {
            Individual ind = new Individual();
            ind.mFitness = this.mFitness;
            ind.mBestFitness = this.mBestFitness;
            ind.mChromosome = this.mChromosome.deepCopy();
            return ind;
        }

        public double getCalculatedFitness() {
            return this.mFitness;
        }

        public Chromosome getChromosome() {
            return this.mChromosome;
        }
    }

    class GeneticOptimizationPulseTask
    extends TimerTask {
        AGeneticOptimizer go;

        public GeneticOptimizationPulseTask(AGeneticOptimizer go) {
            this.go = go;
            AGeneticOptimizer.this.timerHasGoneOff = false;
        }

        @Override
        public void run() {
            AGeneticOptimizer.this.timerHasGoneOff = true;
            this.cancel();
        }
    }
}

