/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.optimizer.genetic;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public abstract class AParallelThreadController<O> {
    protected ArrayList<AThread> mThreads = new ArrayList();
    protected ExecutionMode mExecutionMode = ExecutionMode.Sequential;
    protected int mMaxAtATime = 0;
    protected ExecutorService mExecutor;

    public AParallelThreadController(int maxAtATime) {
        this.mMaxAtATime = maxAtATime;
    }

    public void setExecutionMode(ExecutionMode m, int maxAtATime) {
        this.mExecutionMode = m;
        this.mMaxAtATime = maxAtATime;
    }

    public void add(O o) {
        this.mThreads.add(new AThread(o));
    }

    public void clear() {
        this.mThreads.clear();
    }

    public abstract void operation(O var1);

    public void run() {
        if (this.mExecutionMode == ExecutionMode.Parallel) {
            this.mExecutor = Executors.newFixedThreadPool(this.mMaxAtATime);
            for (AThread thread : this.mThreads) {
                this.mExecutor.execute(thread);
            }
            try {
                this.mExecutor.shutdown();
                this.mExecutor.awaitTermination(1L, TimeUnit.HOURS);
            }
            catch (InterruptedException interruptedException) {}
        } else {
            for (AThread thread : this.mThreads) {
                this.operation(thread.o);
            }
        }
    }

    public class AThread
    extends Thread {
        protected O o;

        public AThread(O o) {
            this.o = o;
        }

        @Override
        public void run() {
            AParallelThreadController.this.operation(this.o);
        }
    }

    public static enum ExecutionMode {
        Sequential,
        Parallel;

    }
}

