/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.optimizer.genetic;

import com.sigrity.acl.ALog;
import java.util.ArrayList;
import java.util.concurrent.Semaphore;

public abstract class APipeLineController<O> {
    protected int mMaxParallelThreadsAtATime = 0;
    protected int mMaxThreads = 0;
    protected int mIthLoad = 0;
    protected ArrayList<APipeLine> mPipeLines = new ArrayList();

    public abstract O operation(O var1);

    public APipeLineController(int maxAtATime) {
        this.mMaxParallelThreadsAtATime = maxAtATime;
    }

    public void start(int maxParallelThreadsAtATime, int maxThreads) {
        this.mMaxParallelThreadsAtATime = maxParallelThreadsAtATime;
        this.mMaxThreads = maxThreads;
        for (int i = 0; i < this.mMaxThreads; ++i) {
            try {
                APipeLine c = new APipeLine(i);
                this.mPipeLines.add(c);
                c.start();
                continue;
            }
            catch (InterruptedException e) {
                ALog.logError((Throwable)e);
            }
        }
        this.mIthLoad = 0;
    }

    public void load(int ith, O o) {
        try {
            this.mPipeLines.get(ith).load(o);
        }
        catch (InterruptedException e) {
            ALog.logError((Throwable)e);
        }
    }

    public O getValue(int ith) {
        try {
            return this.mPipeLines.get(ith).getValue();
        }
        catch (InterruptedException e) {
            ALog.logError((Throwable)e);
            return null;
        }
    }

    public static void testMe() {
        class Add10
        extends APipeLineController<Integer> {
            public Add10(int maxAtTime) {
                super(maxAtTime);
            }

            @Override
            public Integer operation(Integer o) {
                Integer i = o;
                try {
                    ALog.logInfo((String)"beginning long calculation");
                    this.wait(5000L);
                    ALog.logInfo((String)"done with long calculation");
                }
                catch (InterruptedException e) {
                    ALog.logError((Throwable)e);
                }
                return i + 10;
            }
        }
        Add10 add10 = new Add10(2);
        add10.start(2, 4);
        for (int i = 0; i < 100; ++i) {
            add10.load(0, i);
            int iplus10 = (Integer)add10.getValue(i);
            ALog.logInfo((String)(i + " " + iplus10));
        }
    }

    public class APipeLine
    extends Thread {
        O o;
        O oPrime;
        int id;
        Semaphore dataReadyForCalculation = new Semaphore(1);
        Semaphore dataCalculated = new Semaphore(1);

        public APipeLine(int id) throws InterruptedException {
            this.id = id;
            this.dataCalculated.acquire();
            this.dataReadyForCalculation.acquire();
        }

        public void load(O o) throws InterruptedException {
            ALog.logInfo((String)"loading ");
            this.o = o;
            this.dataReadyForCalculation.release();
        }

        public O getValue() throws InterruptedException {
            ALog.logInfo((String)"getting value");
            this.dataCalculated.acquire();
            ALog.logInfo((String)"returning value");
            return this.oPrime;
        }

        public void calculate() throws InterruptedException {
            ALog.logInfo((String)"calling calculate");
            this.dataReadyForCalculation.acquire();
            ALog.logInfo((String)"calculating");
            this.oPrime = APipeLineController.this.operation(this.o);
            ALog.logInfo((String)"calculated");
            this.dataCalculated.release();
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        this.calculate();
                    }
                }
                catch (InterruptedException e) {
                    ALog.logError((Throwable)e);
                    continue;
                }
                break;
            }
        }
    }

    public static enum ExecutionMode {
        Sequential,
        Parallel;

    }
}

