/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.optimizer.genetic;

import com.sigrity.acl.ALog;
import com.sigrity.acl.optimizer.genetic.AParallelThreadController;
import com.sigrity.acl.optimizer.genetic.Chromosome;
import com.sigrity.acl.optimizer.genetic.GeneticOptimizerBroker;
import com.sigrity.orbit.OrbitIO;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;

public class GeneticOptimization {
    protected final double percentMate = 1.0;
    long mTotalGenerations;
    long mCurGeneration;
    long mStartTime;
    long mEndTime;
    long mEvolveEndTime;
    long mCurSeconds;
    long mToRunSeconds;
    boolean mStopNow = false;
    Double mPerfect = null;
    GeneticOptimizerBroker mGOGB = null;
    int mMaxPopulation = 2;
    boolean mAsexual = false;
    boolean mReverseScore = false;
    String mStatus = "";
    Timer pulseTimer;
    boolean timerHasGoneOff;
    Random mRandom = new Random(3141592L);
    protected GeneticThreadController<Individual> mGTC = new GeneticThreadController(3);
    ArrayList<Individual> mPopulation = new ArrayList();

    public synchronized void addIndividual(Individual ind) {
        this.mPopulation.add(ind);
    }

    public void addChromosome(Chromosome c, Individual parent) {
        Individual newInd = new Individual();
        newInd.mChromosome = c;
        newInd.mFitness = c.fitness();
        newInd.mBestFitness = parent == null ? newInd.mFitness : (this.mReverseScore ? Math.min(newInd.mFitness, parent.mBestFitness) : Math.max(newInd.mFitness, parent.mBestFitness));
        this.addIndividual(newInd);
    }

    protected void replace(Individual oldI, Individual newI) {
        int oldindex = this.mPopulation.indexOf(oldI);
        this.mPopulation.set(oldindex, newI);
    }

    public void addBetterChromosome(Chromosome c, Individual parent) {
        Individual newInd = new Individual();
        newInd.mChromosome = c;
        newInd.mFitness = c.fitness();
        if (parent == null) {
            newInd.mBestFitness = newInd.mFitness;
        } else if (this.mReverseScore) {
            newInd.mBestFitness = Math.min(newInd.mFitness, parent.mBestFitness);
            if (newInd.mFitness < parent.mFitness) {
                this.replace(parent, newInd);
            }
        } else {
            newInd.mBestFitness = Math.max(newInd.mFitness, parent.mBestFitness);
            if (newInd.mFitness > parent.mFitness) {
                this.replace(parent, newInd);
            }
        }
    }

    public GeneticOptimization(boolean asexual, boolean reverseScore) {
        this.mAsexual = asexual;
        this.mReverseScore = reverseScore;
    }

    public void setMaxPopulation(int maxPopulation) {
        this.mMaxPopulation = maxPopulation;
    }

    public void setASexual(boolean a) {
        this.mAsexual = a;
    }

    public double getReproductionRate() {
        double totalLifeTime = this.mEvolveEndTime - this.mStartTime;
        if (totalLifeTime > 0.0) {
            return (double)this.mCurGeneration / totalLifeTime * 1000.0;
        }
        return 0.0;
    }

    public void perfect(double p) {
        this.mPerfect = p;
    }

    protected void fitTestPopulation() {
        for (Individual ind : this.mPopulation) {
            ind.mFitness = ind.mChromosome.fitness();
        }
        Collections.sort(this.mPopulation, new FitnessSorter());
    }

    public void evolveForGenerations(long generations) {
        this.mStartTime = System.currentTimeMillis();
        this.mCurGeneration = 0L;
        while (this.mCurGeneration < generations) {
            this.evolve();
            this.mEndTime = System.currentTimeMillis();
            if (this.mPerfect != null && this.getBestScore() >= this.mPerfect) break;
            if (this.mCurGeneration % 100L == 0L) {
                // empty if block
            }
            ++this.mCurGeneration;
        }
        this.mEndTime = System.currentTimeMillis();
    }

    public void stopEvolution() {
        this.mStopNow = true;
    }

    public void evolveForTime(long seconds) {
        this.mToRunSeconds = seconds;
        this.pulseTimer = new Timer();
        this.mStartTime = System.currentTimeMillis();
        boolean stoppingCondition = false;
        GeneticOptimizerBroker.clear(OrbitIO.getCurDb().toString());
        GeneticOptimizerBroker.setMaxTime(OrbitIO.getCurDb().toString(), seconds);
        GeneticOptimizerBroker.addConstraintDescriptor(OrbitIO.getCurDb().toString(), "Fitness", Color.MAGENTA, false, 1);
        GeneticOptimizerBroker.addConstraintDescriptor(OrbitIO.getCurDb().toString(), "Improvement %", Color.orange, false, 2);
        GeneticOptimizerBroker.addConstraintDescriptor(OrbitIO.getCurDb().toString(), "gps", Color.GRAY, false, 3);
        this.pulseTimer.schedule((TimerTask)new GeneticOptimizationPulseTask(this), 250L);
        double lastScore = 0.0;
        long generationsAtSameScore = 0L;
        while (!stoppingCondition) {
            int sec;
            int min;
            double bestScore;
            this.evolve();
            this.mEvolveEndTime = System.currentTimeMillis();
            ++this.mCurGeneration;
            this.mCurSeconds = (this.mEvolveEndTime - this.mStartTime) / 1000L;
            if (this.mCurSeconds >= seconds) {
                stoppingCondition = true;
                this.mStatus = "Time Limit";
            }
            if ((bestScore = this.mPopulation.get((int)0).mFitness) == 0.0 && this.mReverseScore) {
                stoppingCondition = true;
            }
            if (this.mStopNow) {
                this.mStatus = "Stopped by " + System.getProperty("user.name");
                stoppingCondition = true;
            }
            if (bestScore == lastScore) {
                ++generationsAtSameScore;
            } else {
                lastScore = bestScore;
                generationsAtSameScore = 0L;
            }
            if (generationsAtSameScore >= (long)(this.mMaxPopulation * 2 * this.mPopulation.get((int)0).mChromosome.length() * 25)) {
                stoppingCondition = true;
                min = (int)(seconds - this.mCurSeconds) / 60;
                sec = (int)(seconds - this.mCurSeconds) - min * 60;
                this.mStatus = String.format("Converged with %d:%2d Remaining", min, sec);
            }
            if (!stoppingCondition) {
                min = (int)(seconds - this.mCurSeconds) / 60;
                sec = (int)(seconds - this.mCurSeconds) - min * 60;
                this.mStatus = String.format("%d:%2d Remain", min, sec);
            }
            if (!this.timerHasGoneOff && !stoppingCondition) continue;
            this.timerHasGoneOff = false;
            this.pulseTask();
            this.pulseTimer.schedule((TimerTask)new GeneticOptimizationPulseTask(this), 1000L);
        }
        this.mPopulation.get((int)0).mChromosome.updateCondition(OrbitIO.getCurDb().toString(), this.mCurSeconds);
        GeneticOptimizerBroker.optimizationFinished(OrbitIO.getCurDb().toString());
    }

    public void pulseTask() {
        this.mPopulation.get((int)0).mChromosome.updateCondition(OrbitIO.getCurDb().toString(), this.mCurSeconds);
        GeneticOptimizerBroker.setConstraintValue(OrbitIO.getCurDb().toString(), "gps", this.mCurSeconds, this.getReproductionRate());
        GeneticOptimizerBroker.updateGraph(OrbitIO.getCurDb().toString(), this.mStatus);
    }

    public ArrayList<Chromosome> getTopOfTheClass(int n) {
        ArrayList<Chromosome> f = new ArrayList<Chromosome>();
        for (int i = 0; i < Math.min(this.mPopulation.size(), n); ++i) {
            f.add(this.mPopulation.get((int)i).mChromosome);
        }
        return f;
    }

    protected void evolve() {
        this.makeNewGeneration();
    }

    protected void removeUnFit() {
        ArrayList<Individual> unfit = new ArrayList<Individual>();
        for (int i = 0; i < this.mPopulation.size(); ++i) {
            for (int j = i + 1; j < this.mPopulation.size(); ++j) {
                if (this.mPopulation.get((int)i).mFitness != this.mPopulation.get((int)j).mFitness || unfit.contains(this.mPopulation.get(j))) continue;
                unfit.add(this.mPopulation.get(j));
            }
        }
        for (Individual ind : unfit) {
            this.mPopulation.remove(ind);
        }
        unfit.clear();
        int newPopulationSize = this.mRandom.nextInt(this.mMaxPopulation);
        for (int i = ++newPopulationSize; i < this.mPopulation.size(); ++i) {
            unfit.add(this.mPopulation.get(i));
        }
        for (Individual ind : unfit) {
            this.mPopulation.remove(ind);
        }
    }

    protected void makeNewGeneration() {
        if (this.mAsexual) {
            this.mGTC.clear();
            int totalPop = this.mPopulation.size();
            int topPercent = (int)((double)totalPop * 1.0);
            topPercent = Math.max(topPercent, 1);
            for (int i = 0; i < topPercent; ++i) {
                this.mGTC.add(this.mPopulation.get(i));
            }
            this.mGTC.run();
        }
        Collections.sort(this.mPopulation, new FitnessSorter());
    }

    protected void printPopulation() {
        ALog.logInfo((String)("Generation " + this.mCurGeneration));
        for (int i = 0; i < this.mPopulation.size(); ++i) {
            ALog.logInfo((String)(i + " " + this.mPopulation.get((int)i).mFitness));
        }
    }

    public Chromosome getBestIndividual() {
        return this.mPopulation.get((int)0).mChromosome;
    }

    public ArrayList<Chromosome> getSolutions() {
        ArrayList<Chromosome> cList = new ArrayList<Chromosome>();
        for (Individual i : this.mPopulation) {
            cList.add(i.mChromosome);
        }
        return cList;
    }

    public double getBestScore() {
        return this.mPopulation.get((int)0).mFitness;
    }

    public long getGenerations() {
        return this.mCurGeneration;
    }

    protected class FitnessSorter
    implements Comparator<Individual> {
        protected FitnessSorter() {
        }

        @Override
        public int compare(Individual i0, Individual i1) {
            int c = 0;
            double d = i0.mFitness - i1.mFitness;
            c = d < 0.0 ? 1 : (d > 0.0 ? -1 : 0);
            if (GeneticOptimization.this.mReverseScore) {
                c *= -1;
            }
            return c;
        }
    }

    public static class Individual {
        Chromosome mChromosome;
        double mFitness;
        double mBestFitness;
    }

    class GeneticThreadController<I>
    extends AParallelThreadController<I> {
        public GeneticThreadController(int maxAtTime) {
            super(maxAtTime);
        }

        @Override
        public void operation(I o) {
            Individual parent = (Individual)o;
            Chromosome mutantC = parent.mChromosome.mutate();
            GeneticOptimization.this.addBetterChromosome(mutantC, parent);
        }
    }

    class GeneticOptimizationPulseTask
    extends TimerTask {
        GeneticOptimization go;

        public GeneticOptimizationPulseTask(GeneticOptimization go) {
            this.go = go;
            GeneticOptimization.this.timerHasGoneOff = false;
        }

        @Override
        public void run() {
            GeneticOptimization.this.timerHasGoneOff = true;
            this.cancel();
        }
    }
}

