/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.parsers;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.parsers.CSVDOMParser;
import com.sigrity.acl.parsers.CSVDocument;
import org.w3c.dom.Element;

public class CSVDbFieldParser {
    private DbObject mDbObject;
    private String mFieldName;
    private CSVDocument mCsvDocument;

    public CSVDbFieldParser(DbObject dbObject, String fieldName) {
        this.mDbObject = dbObject;
        this.mFieldName = fieldName;
    }

    public void saveCsvInDB(String csvFilePath) {
        CSVDocument csvDocument = this.getCsvDocument(csvFilePath);
        if (csvDocument == null) {
            return;
        }
        this.saveCsvInDb(csvDocument);
    }

    public void saveCsvInDb(CSVDocument doc) {
        String[] headers;
        StringBuilder buffer = new StringBuilder();
        for (String h : headers = doc.getAttributeNames()) {
            buffer.append(h.replaceAll(" ", ""));
            buffer.append(",");
        }
        buffer.append("\n");
        for (int i = 0; i < doc.getItemCount(); ++i) {
            Element e = doc.getItem(i);
            for (String h : headers) {
                h = h.replace(" ", "");
                String val = e.getAttribute(h);
                buffer.append(val);
                buffer.append(",");
            }
            buffer.append("\n");
        }
        this.mDbObject.setValue(this.mFieldName, (Object)buffer.toString());
    }

    public CSVDocument getCsvDocument() {
        String buffer = (String)this.mDbObject.getValue(this.mFieldName);
        if (buffer == null) {
            return null;
        }
        String[] lines = buffer.split("\n");
        String[] headers = lines[0].split(",");
        try {
            CSVDocument doc = CSVDocument.newInstance((String[])headers);
            for (int i = 1; i < lines.length; ++i) {
                doc.appendItem();
                String thisLine = lines[i];
                String[] attr = thisLine.split(",");
                for (int j = 0; j < headers.length; ++j) {
                    if (attr.length <= j || attr[j] == null) continue;
                    String h = headers[j].replace(" ", "");
                    doc.setItemValue(i - 1, h, attr[j]);
                }
            }
            return doc;
        }
        catch (CSVDOMParser.CSVDOMException e) {
            ALog.logError((Throwable)e);
            return null;
        }
    }

    public void clear() {
        this.mDbObject.setValue(this.mFieldName, null);
    }

    public int getItemCount() {
        if (this.mCsvDocument == null) {
            this.mCsvDocument = this.getCsvDocument();
        }
        assert (this.mCsvDocument != null);
        if (this.mCsvDocument == null) {
            return 0;
        }
        return this.mCsvDocument.getItemCount();
    }

    public String getValue(String matchCol, String matchValue, String targetCol) {
        if (this.mCsvDocument == null) {
            this.mCsvDocument = this.getCsvDocument();
        }
        assert (this.mCsvDocument != null);
        if (this.mCsvDocument == null) {
            return null;
        }
        for (int i = 0; i < this.mCsvDocument.getItemCount(); ++i) {
            String candidate = this.mCsvDocument.getItemValue(i, CSVDbFieldParser.unifiedString(matchCol)).trim();
            if (!candidate.equalsIgnoreCase(matchValue)) continue;
            return this.mCsvDocument.getItemValue(i, CSVDbFieldParser.unifiedString(targetCol));
        }
        return null;
    }

    public String getHTMLofCSVItem(String matchCol, String matchValue) {
        if (this.mCsvDocument == null) {
            this.mCsvDocument = this.getCsvDocument();
        }
        assert (this.mCsvDocument != null);
        if (this.mCsvDocument == null) {
            return null;
        }
        String[] headers = this.mCsvDocument.getAttributeNames();
        String html = null;
        for (int i = 0; i < this.mCsvDocument.getItemCount(); ++i) {
            String candidate = this.mCsvDocument.getItemValue(i, matchCol).trim();
            if (!candidate.equals(matchValue)) continue;
            for (String header : headers) {
                html = String.format("%s<b>%s</b>:%s<br>", html == null ? "" : html, header, this.mCsvDocument.getItemValue(i, header));
            }
        }
        return String.format("<html>%s</html>", html);
    }

    public void exportCsv(String csvFilePath) {
        if (this.mCsvDocument == null) {
            this.mCsvDocument = this.getCsvDocument();
        }
        assert (this.mCsvDocument != null);
        if (this.mCsvDocument == null) {
            return;
        }
        try {
            this.mCsvDocument.save(csvFilePath, true);
        }
        catch (CSVDOMParser.CSVDOMException e) {
            ALog.logWarn((String)("Problems reading " + csvFilePath));
        }
    }

    private CSVDocument getCsvDocument(String csvFilePath) {
        CSVDocument ruleDoc = null;
        try {
            ruleDoc = CSVDocument.newInstance(null);
            CSVDOMParser parser2 = new CSVDOMParser(true, null);
            parser2.setDataSepExpression(",");
            ruleDoc.setPath(csvFilePath);
            ruleDoc = parser2.parse(csvFilePath);
        }
        catch (CSVDOMParser.CSVDOMException e) {
            ALog.logWarn((String)("Problems reading " + csvFilePath));
            return null;
        }
        return ruleDoc;
    }

    private static String unifiedString(String input) {
        return input.toLowerCase().replace(" ", "");
    }
}

