/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.parsers;

import com.sigrity.acl.APair;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;

public class LEFDEFOrient {

    public static enum ORIENT {
        N("N"){

            @Override
            ARect orientARect(ARect rect) {
                return new ARect(rect);
            }

            @Override
            APoint2D moveOriginByOffset(APoint2D ll, ARect bb) {
                APoint2D corner = bb.getLL();
                return ll.sub(corner);
            }

            @Override
            APair<Long, Boolean> getRotateMirror() {
                return new APair((Object)0L, (Object)false);
            }
        }
        ,
        E("E"){

            @Override
            ARect orientARect(ARect rect) {
                return new ARect(0L, 0L, rect.height(), rect.width());
            }

            @Override
            APoint2D moveOriginByOffset(APoint2D ll, ARect bb) {
                APoint2D corner = bb.getLR();
                corner = new APoint2D(corner.getY(), -corner.getX());
                return ll.sub(corner);
            }

            @Override
            APair<Long, Boolean> getRotateMirror() {
                return new APair((Object)90L, (Object)false);
            }
        }
        ,
        S("S"){

            @Override
            ARect orientARect(ARect rect) {
                return new ARect(rect);
            }

            @Override
            APoint2D moveOriginByOffset(APoint2D ll, ARect bb) {
                APoint2D corner = bb.getUR();
                corner = new APoint2D(-corner.getX(), -corner.getY());
                return ll.sub(corner);
            }

            @Override
            APair<Long, Boolean> getRotateMirror() {
                return new APair((Object)180L, (Object)false);
            }
        }
        ,
        W("W"){

            @Override
            ARect orientARect(ARect rect) {
                return new ARect(0L, 0L, rect.height(), rect.width());
            }

            @Override
            APoint2D moveOriginByOffset(APoint2D ll, ARect bb) {
                APoint2D corner = bb.getUL();
                corner = new APoint2D(-corner.getY(), corner.getX());
                return ll.sub(corner);
            }

            @Override
            APair<Long, Boolean> getRotateMirror() {
                return new APair((Object)270L, (Object)false);
            }
        }
        ,
        FN("FN"){

            @Override
            ARect orientARect(ARect rect) {
                return new ARect(rect);
            }

            @Override
            APoint2D moveOriginByOffset(APoint2D ll, ARect bb) {
                APoint2D corner = bb.getLR();
                corner = new APoint2D(-corner.getX(), corner.getY());
                return ll.sub(corner);
            }

            @Override
            APair<Long, Boolean> getRotateMirror() {
                return new APair((Object)0L, (Object)true);
            }
        }
        ,
        FE("FE"){

            @Override
            ARect orientARect(ARect rect) {
                return new ARect(0L, 0L, rect.height(), rect.width());
            }

            @Override
            APoint2D moveOriginByOffset(APoint2D ll, ARect bb) {
                APoint2D corner = bb.getUR();
                corner = new APoint2D(-corner.getY(), -corner.getX());
                return ll.sub(corner);
            }

            @Override
            APair<Long, Boolean> getRotateMirror() {
                return new APair((Object)270L, (Object)true);
            }
        }
        ,
        FS("FS"){

            @Override
            ARect orientARect(ARect rect) {
                return new ARect(rect);
            }

            @Override
            APoint2D moveOriginByOffset(APoint2D ll, ARect bb) {
                APoint2D corner = bb.getUL();
                corner = new APoint2D(corner.getX(), -corner.getY());
                return ll.sub(corner);
            }

            @Override
            APair<Long, Boolean> getRotateMirror() {
                return new APair((Object)180L, (Object)true);
            }
        }
        ,
        FW("FW"){

            @Override
            ARect orientARect(ARect rect) {
                return new ARect(0L, 0L, rect.height(), rect.width());
            }

            @Override
            APoint2D moveOriginByOffset(APoint2D ll, ARect bb) {
                APoint2D corner = bb.getLL();
                corner = new APoint2D(corner.getY(), corner.getX());
                return ll.sub(corner);
            }

            @Override
            APair<Long, Boolean> getRotateMirror() {
                return new APair((Object)90L, (Object)true);
            }
        };

        private final String text;

        private ORIENT(String text) {
            this.text = text;
        }

        public static ORIENT getOrient(String text) {
            for (ORIENT o : ORIENT.values()) {
                if (!o.toLEFDEFString().equals(text)) continue;
                return o;
            }
            throw new IllegalArgumentException(String.format("Unknown orient:%s", text));
        }

        public String toLEFDEFString() {
            return this.text;
        }

        abstract ARect orientARect(ARect var1);

        abstract APoint2D moveOriginByOffset(APoint2D var1, ARect var2);

        abstract APair<Long, Boolean> getRotateMirror();

        public static ARect orientARect(ARect rect, String orient) {
            for (ORIENT o : ORIENT.values()) {
                if (!o.toLEFDEFString().equals(orient)) continue;
                return o.orientARect(rect);
            }
            throw new IllegalArgumentException(String.format("Unknown orient:%s", orient));
        }

        public static APoint2D moveOriginByOffset(APoint2D ll, ARect bb, String orient) {
            for (ORIENT o : ORIENT.values()) {
                if (!o.toLEFDEFString().equals(orient)) continue;
                return o.moveOriginByOffset(ll, bb);
            }
            throw new IllegalArgumentException(String.format("Unknown orient:%s", orient));
        }

        public static APair<Long, Boolean> getRotateMirror(String orient) {
            if (orient == null) {
                return null;
            }
            for (ORIENT o : ORIENT.values()) {
                if (!o.toLEFDEFString().equals(orient)) continue;
                return o.getRotateMirror();
            }
            throw new IllegalArgumentException(String.format("Unknown orient:%s", orient));
        }

        public static ORIENT getOrient(long rotation, boolean mirror) {
            for (ORIENT o : ORIENT.values()) {
                APair<Long, Boolean> rotateAndMirror = o.getRotateMirror();
                if ((Long)rotateAndMirror.first != rotation || (Boolean)rotateAndMirror.second != mirror) continue;
                return o;
            }
            throw new IllegalArgumentException(String.format("No orient for %d, %b", rotation, mirror));
        }
    }
}

