/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.parsers;

import com.sigrity.acl.AFile;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Metal;
import com.sigrity.acl.db.std.NamedGrid;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.Obstacle;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinLabel;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.db.std.Term;
import com.sigrity.acl.db.std.TermMap;
import com.sigrity.acl.db.std.ViaRuleGenerate;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.AGrid;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APath;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.APolygon;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.parsers.LEFDEFOrient;
import com.sigrity.acl.parsers.LEFDEFSyntax;
import com.sigrity.acl.parsers.TokenParser;
import com.sigrity.lic.LSession;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.SubstrateTemplate;
import com.sigrity.orbit.factory.ViaFactory;
import com.sigrity.orbit.ui.DeviceTemplatePortUI;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.DoubleToLongFunction;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;

public class LEFDEFParser
extends TokenParser {
    public static final int VERBOSITY_ALL_FOR_DEBUG = 0;
    public static final int VERBOSITY_NORMAL = 1;
    public static final int VERBOSITY_ERROR_ONLY = 2;
    boolean doCreateNoPortPin = false;
    boolean doCreateOnyOnePinForAllMacroPinPorts = false;
    public static final boolean StoreMD5Hash = true;
    public static final DeviceTemplate.Type DefaultMacroType = DeviceTemplate.Type.CORE;
    protected static boolean gUseNetPrefixDefault = false;
    public static final String PROPNAME_DEFOUTIGNORE = "oioDefOutIgnore";
    public static final String FLDNAME_IGNOREONWRITE = "LEFDEF.ignoreOnWrite";
    public static final String FLDNAME_MD5 = String.format("%s.%s", LEFDEFParser.class.getName(), "MD5");
    public static final String FLDNAME_LEF58_PROPERTYDEFINITIONS = "LEF58.PROPERTYDEFINITIONS";
    public static final String FLDNAME_DEF58_PROPERTYDEFINITIONS = "DEF58.PROPERTYDEFINITIONS";
    public static final String FLDNAME_LEFDEF_PROPERTY = "LEFDEF.PROPERTY";
    public static final String FLDNAME_LEFDEF_FOREIGN = "LEFDEF.FOREIGN";
    public static final String FLDNAME_LEFDEF_FOREIGN_PT = "LEFDEF.FOREIGN.PT";
    public static final String FLDNAME_LEFDEF_FOREIGN_ORIENT = "LEFDEF.FOREIGN.ORIENT";
    public static final String FLDNAME_DEF_SOURCE = "DEF.SOURCE";
    public static final String SUBSTRATE_DEF_NAME_BASE = "LEF_Substrate";
    private Db mDb;
    protected Context mContext = null;
    private boolean mIsLef;
    protected String mDefUnitName = null;
    protected double mDefDbuPerDefUnit = 1.0;
    private DeviceTemplate mCurrentDeviceTemplate;
    private Net mCurrentNet;
    private APoint2D mDieLL = new APoint2D();
    private Optional<String> mFileMD5 = Optional.empty();
    protected DeviceTemplate mDefReadParent = null;
    protected String mDefReadTemplateName = null;
    private Device mCurrentDie;
    private String mDesignName = null;
    private Design mCurrentDesign;
    private long mInternalToMicron;
    private Pattern mJustMacroPattern;
    private boolean mUniqueify = false;
    private String mDivideChar;
    private static int mVerbosity;
    private boolean mReadBlocks = true;
    private boolean mReadCores = true;
    private boolean mReadCovers = true;
    private boolean mReadEndCaps = true;
    private boolean mReadRings = true;
    private Layer mCurrentLayer;
    private Substrate mSubstrate;
    private boolean mDoneOneDevice = false;
    private String mSubstrateName = "";
    private int mLayerOrder = 0;
    private long mTraceWidth;
    private ArrayList<Layer> mOrderedLayerList = new ArrayList();
    protected int mNextViaName = 0;
    protected boolean mCurrentPortIsIOPad = false;
    protected String mCurrentPortClass = null;
    protected double mScaleFactor = 1.0;
    protected LinkedList<LayerShape> mUnscaledLayerShapes = new LinkedList();
    protected LinkedList<DeviceTemplate> mUnscaledDeviceTemplates = new LinkedList();
    protected HashMap<String, PinTemplate> mNameToViaDef = new HashMap();
    protected boolean mIgnoreExistingTemplates = true;
    protected String mObstacleLayerToRead = null;
    private Pattern mIgnoreLayerPattern = null;
    protected boolean mKeepEmptyPins = true;
    protected boolean mCreateDefaultNetNamesOnPins = false;
    protected boolean mSkipPins = true;
    protected boolean mUseNetPrefix = gUseNetPrefixDefault;
    static final String PadTemplateAdoptContext;
    LinkedList<PropertyValue> deferredDesignProperties = new LinkedList();
    Map<APair<String, String>, DefPropertyDescriptor> propertyDescriptors = new HashMap<APair<String, String>, DefPropertyDescriptor>();
    protected boolean mUpdateExistingTemplates = false;
    private boolean mCreateSubstrate;
    private Set<String> mReplacedLEFs;
    private boolean mReadNets;
    private boolean mReadSpecialNets;
    private boolean mReadWires;
    private boolean mReadSpecialWires;
    private boolean mAddUnusedPins = true;
    public static boolean debugTokenSpeed;
    private Map<String, Set<String>> mNetToEqNets = Collections.emptyMap();
    private Map<String, String> mNetToOrgNet = Collections.emptyMap();
    private Map<Term, PinTemplate> mFirstPinTemplate;
    private Map<String, Term> mNameToTerm;
    private ParserPins parserPins = new ParserPins();
    ParserDefVias parserDefVias = new ParserDefVias();
    private ParserNetsOrSpecialNets parserNetsOrSpecialNets = new ParserNetsOrSpecialNets();
    private ParserLEFPropertyDefinitions parserLEFPropertyDefinitions = new ParserLEFPropertyDefinitions();
    private DeviceTemplate mTopDeviceTemplate = null;
    private long mLastX;
    private long mLastY;
    private ParserBlockages parserBlockages = new ParserBlockages();
    private Map<Device, String> mBumpToPins;
    private ParserComponents parserComponents = new ParserComponents();
    private ParserLayer parserLayer = new ParserLayer();
    private ParserVia parserVia = new ParserVia();
    private ParserDoNondefaultRule parserDoNondefaultRule = new ParserDoNondefaultRule();
    private ReaderLEFDEFViaRule readerLEFViaViaRule = new ReaderLEFDEFViaRule(true);
    private ReaderLEFDEFViaRule readerDEFViaViaRule = new ReaderLEFDEFViaRule(false);
    private ParserLEFViaRule parserLEFViaRule = new ParserLEFViaRule();
    private ParserLEFViaRuleGenerate parserLEFViaRuleGenerate = new ParserLEFViaRuleGenerate();
    private ParserLEFWidth parserLEFWidth = new ParserLEFWidth();
    private ReaderLayerGeometries readerLayerGeometries = new ReaderLayerGeometries();
    private ParserMacro parserMacro = new ParserMacro();
    private ParserDEFPropertyDefinitions parserDEFPropertyDefinitions = new ParserDEFPropertyDefinitions();
    private static final char CHAR_PLUS = '+';
    private static final char CHAR_SEMI = ';';
    private static final char CHAR_DASH = '-';
    TokenParser.TokenInfo mTokenInfo;
    private boolean mFixedMask;
    private char[] mBusBitChar = new char[2];
    private char mDividerChar;
    long mCapacitancePicofaradsConvertFactor = 1L;
    long mDatabaseMicronsConvertFactor = 1L;
    private boolean isUseMinSpacingOBSOn;
    boolean mClearanceMeasureEuclidean;
    long mMaxViaStack;
    String mMaxViaStackBottomLayer;
    String mMaxViaStackTopLayer;
    long mSpacing;
    String mTaperRule;
    long mStyleNum;
    int mMaskNum;

    private static int getNoRehashInitialCapacity(int num) {
        int HASHMAP_LOAD_FACTOR_NUM = 3;
        int HASHMAP_LOAD_FACTOR_DENOM = 4;
        return num / 3 * 4 + 1;
    }

    public void setCreateNoPortPin(boolean v) {
        this.doCreateNoPortPin = v;
    }

    public void setCreateOnyOnePinForAllMacroPinPorts(boolean v) {
        this.doCreateOnyOnePinForAllMacroPinPorts = v;
    }

    private String fmtErrMsg(String error) {
        return this.fmtErrMsg(error, "");
    }

    private String fmtErrMsg(TokenParser.TokenInfo ti, char c) {
        return this.fmtErrMsg(ti.getString(), String.valueOf(c));
    }

    private String fmtErrMsg(TokenParser.TokenInfo ti, char[] c) {
        return this.fmtErrMsg(ti.getString(), String.valueOf(c));
    }

    private String fmtErrMsg(TokenParser.TokenInfo ti, String c) {
        return this.fmtErrMsg(ti.getString(), c);
    }

    private String fmtErrMsg(String error, String expect) {
        if (expect.isEmpty()) {
            return String.format("Error: '%s'. Token: '%s'. Near line %d.", error, this.mTokenInfo.getString(), this.mCurLine);
        }
        return String.format("Error: '%s'. Expect: '%s'. Token: '%s'. Near line %d.", error, expect, this.mTokenInfo.getString(), this.mCurLine);
    }

    public static void setUseNetPrefixDefault(boolean enable) {
        gUseNetPrefixDefault = enable;
    }

    public static boolean importLef(Db db, String filePath, boolean readBlocks, boolean readCores, boolean readCovers, boolean readEndCaps, boolean readRings, int verbosity, boolean newSubstrate) {
        try {
            LEFDEFParser p = new LEFDEFParser(db);
            return p.parseLef(filePath, readBlocks, readCores, readCovers, readEndCaps, readRings, verbosity, newSubstrate);
        }
        catch (LSession.NoLicenseException e) {
            return false;
        }
    }

    public static boolean importDef(Db db, String filePath, int verbosity, boolean uniqueify, boolean preserveHierarchy, boolean readNets, boolean addUnused, boolean readWires, boolean readSpecialWires, String justMacroPattern, boolean readBlocks, boolean readCores) {
        try {
            LEFDEFParser p = new LEFDEFParser(db);
            return p.parseDEF(filePath, verbosity, uniqueify, readNets, addUnused, readWires, readSpecialWires, justMacroPattern);
        }
        catch (LSession.NoLicenseException e) {
            return false;
        }
    }

    public static String getDesignName(String defFilePath) {
        try {
            LEFDEFParser p = new LEFDEFParser();
            return p.parseDefDesignName(defFilePath);
        }
        catch (LSession.NoLicenseException e) {
            return null;
        }
    }

    public LEFDEFParser() throws LSession.NoLicenseException {
        super(64);
        Settings userPrefs = Settings.getSettings((String)"UserPreferences");
        String ignoreLayerLefPattern = (String)userPrefs.getSetting("LefIgnoreLayerPattern", (Object)"VIA.*");
        this.setIgnoreLayerRegExpression(ignoreLayerLefPattern);
    }

    public LEFDEFParser(Db db) throws LSession.NoLicenseException {
        this();
        this.setDb(db);
    }

    public void setDb(Db db) {
        if (db == null) {
            ALog.flogError((String)"Cannot find active database. Need to create design first.", (Object[])new Object[0]);
            return;
        }
        this.mDb = db;
        this.mCurrentDesign = Design.getDesign((Db)this.mDb);
        this.mInternalToMicron = this.mCurrentDesign.getInternalPerMicron();
    }

    public void setContext(Context c) {
        this.mContext = c;
    }

    public Context getContext() {
        if (this.mContext == null) {
            this.mContext = new Context();
        }
        return this.mContext;
    }

    public void setLefUnitName(String name) {
        this.getContext().mLefUnitName = name;
    }

    public void setLefDbuPerLefUnit(double f) {
        this.getContext().mLefDbuPerLefUnit = f;
    }

    public void setDefParent(DeviceTemplate parent) {
        this.mDefReadParent = parent;
    }

    public void setDefTemplateName(String defTemplateName) {
        this.mDefReadTemplateName = defTemplateName;
    }

    public void setScale(double factor) {
        this.mScaleFactor = factor;
    }

    public void setIgnoreExistingTemplates(boolean f) {
        this.mIgnoreExistingTemplates = f;
    }

    public void setUpdateExistingTemplates(boolean f) {
        this.mUpdateExistingTemplates = f;
    }

    public void setSubstrateName(String name) {
        this.mSubstrateName = name;
    }

    public void setKeepEmptyPins(boolean state) {
        this.mKeepEmptyPins = state;
    }

    public void setReadNets(boolean b) {
        this.mReadNets = b;
    }

    public void setReadRegularWires(boolean b) {
        this.mReadWires = b;
    }

    public void setReadSpecialNets(boolean b) {
        this.mReadSpecialNets = b;
    }

    public void setReadSpecialWires(boolean b) {
        this.mReadSpecialWires = b;
    }

    public void setVerbosity(int v) {
        mVerbosity = v;
    }

    public void setAddUnusedPins(boolean b) {
        this.mAddUnusedPins = b;
    }

    public void setUniqueify(boolean b) {
        this.mUniqueify = b;
    }

    public void setJustMacroPattern(String regex) {
        this.setupMacroNameRegexPattern(regex);
    }

    public String getSubstrateName() {
        return this.mSubstrate.getName();
    }

    public void setReadObstaclesOnLayer(String layerString) {
        this.mObstacleLayerToRead = layerString;
    }

    public void setCreateDefaultNetNamesOnPins(boolean s) {
        this.mCreateDefaultNetNamesOnPins = s;
    }

    public void setUseNetPrefix(boolean useNetPrefix) {
        this.mUseNetPrefix = useNetPrefix;
    }

    public void skipPins(boolean s) {
        this.mSkipPins = s;
    }

    public void setCreateSubstrate(boolean b) {
        this.mCreateSubstrate = b;
    }

    public void setReadBlocks(boolean b) {
        this.mReadBlocks = b;
    }

    public void setReadCores(boolean b) {
        this.mReadCores = b;
    }

    public void setReadCovers(boolean b) {
        this.mReadCovers = b;
    }

    public void setReadEndCaps(boolean b) {
        this.mReadEndCaps = b;
    }

    public void setReadRings(boolean b) {
        this.mReadRings = b;
    }

    public Device getDie() {
        return this.mCurrentDie;
    }

    public void setIgnoreLayerRegExpression(String ignoreLayerRegExpression) {
        this.mIgnoreLayerPattern = Pattern.compile(ignoreLayerRegExpression);
    }

    @Deprecated(forRemoval=true)
    public boolean parseLef(String fileName, boolean readBlocks, boolean readCores, boolean readCovers, boolean readEndCaps, boolean readRings, int verbosity, boolean newSubstrate) {
        this.mReadBlocks = readBlocks;
        this.mReadCores = readCores;
        this.mReadCovers = readCovers;
        this.mReadEndCaps = readEndCaps;
        this.mReadRings = readRings;
        mVerbosity = verbosity;
        this.mCreateSubstrate = newSubstrate;
        return this.parseLEF(fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean parseLEF(String fileName) {
        this.mIsLef = true;
        File lefFile = new File(fileName);
        ALog.logInfo((String)"Beginning to import LEF '%s'.", (Object[])new Object[]{lefFile});
        long timeSpent = System.nanoTime();
        this.mFileName = fileName;
        this.mFileMD5 = AFile.getMD5((File)lefFile);
        if (!this.setInFile(fileName)) {
            LEFDEFParser.vError("Can not open file '%s'.", lefFile);
            return false;
        }
        this.mDb.setListenersEnabled(false);
        this.mDb.setHistoryEnabled(false);
        this.mReplacedLEFs = new HashSet<String>();
        try {
            if (this.mCreateSubstrate) {
                String substrateName = Substrate.getUniqueName((Db)this.mDb, (String)SUBSTRATE_DEF_NAME_BASE);
                if (!this.mSubstrateName.isEmpty()) {
                    substrateName = this.mSubstrateName;
                }
                this.mSubstrate = Substrate.getSubstrate((Db)this.mDb, (String)substrateName);
                if (this.mSubstrate == null) {
                    this.mSubstrate = Substrate.create((Db)this.mDb, (String)substrateName);
                } else {
                    LEFDEFParser.vWarn("Substrate '%s' already created!", substrateName);
                }
                this.mSubstrate.setSourceType(DeviceTemplate.SourceType.LEFDEF);
                this.mSubstrate.setSourceFile(fileName);
                this.mSubstrate.setHeight(Design.micronToInternal((Db)this.mDb, (double)100.0));
                this.mSubstrateName = substrateName;
                if (this.mScaleFactor != 1.0) {
                    this.mSubstrate.setScale(Double.valueOf(this.mScaleFactor));
                }
            } else if (!this.mSubstrateName.equals("last")) {
                this.mSubstrate = Substrate.getSubstrate((Db)this.mDb, (String)this.mSubstrateName);
                if (this.mSubstrate == null) {
                    LEFDEFParser.vError("Substrate '%s' not found", this.mSubstrateName);
                    boolean substrateName = false;
                    return substrateName;
                }
            }
            this.mSubstrate.addImportedLEF(fileName);
            try {
                this.next();
                this.eLEF();
            }
            catch (MalformedLEFDEFException e) {
                LEFDEFParser.vError(e, "Error reading LEF: %s", e.getMessage());
            }
            this.mSubstrate.normalizeThickness(false);
            this.updatePinType(this.mUnscaledDeviceTemplates, DeviceTemplate.Type.BUMP, PinTemplate.Type.UNKNOWN, PinTemplate.Type.BUMPPAD);
            int order = 0;
            for (Layer l : this.mOrderedLayerList) {
                l.setOrder(order++);
            }
            if (this.mScaleFactor != 1.0) {
                this.scaleCreatedObjects();
            }
            this.storePropertyDefinitionsToSubstrate(this.mSubstrate);
        }
        finally {
            this.closeFile();
            PadTemplate.releaseAdoptContext((Db)this.mDb, (String)LEFDEFParser.class.getName());
            this.removeReplacedLEFs(this.mSubstrate, this.mReplacedLEFs);
            this.mReplacedLEFs = null;
            this.mDb.setHistoryEnabled(true);
            this.mDb.setListenersEnabled(true);
        }
        timeSpent = System.nanoTime() - timeSpent;
        ALog.logInfo((String)"Done importing LEF, used %.3f seconds.", (Object[])new Object[]{(double)timeSpent / 1.0E9});
        return true;
    }

    private void removeReplacedLEFs(Substrate s, Set<String> replacedLEFs) {
        Set stillReferenced = s.getDeviceTemplates().stream().map(DeviceTemplate::getSourceFile).filter(Objects::nonNull).collect(Collectors.toSet());
        Set toDeleteLEFs = replacedLEFs.stream().filter(lef -> !stillReferenced.contains(lef)).collect(Collectors.toSet());
        LinkedList filtered = s.getImportedLEF().stream().filter(lef -> !toDeleteLEFs.contains(lef)).collect(Collectors.toCollection(LinkedList::new));
        s.setImportedLEF((List)filtered);
    }

    private void updatePinType(List<DeviceTemplate> templates, DeviceTemplate.Type templateType, PinTemplate.Type fromPinType, PinTemplate.Type toPinType) {
        for (DeviceTemplate dt : templates) {
            if (dt.getType() != templateType) continue;
            for (PinTemplate dtp : dt.getPins()) {
                if (dtp.getType() != fromPinType) continue;
                dtp.setType(toPinType);
            }
        }
    }

    private void storePropertyDefinitionsToSubstrate(Substrate sub) {
        Set<String> lefPropertyDefinitions = this.propertyDescriptors.entrySet().stream().map(pd -> {
            DefPropertyDescriptor d = (DefPropertyDescriptor)pd.getValue();
            return d.toString();
        }).collect(Collectors.toSet());
        if (!lefPropertyDefinitions.isEmpty()) {
            Object obj = sub.getValue(FLDNAME_LEF58_PROPERTYDEFINITIONS);
            if (obj != null && obj.getClass() == String.class) {
                this.storePropertyDefinitionsOfStringType(sub, (String)obj, lefPropertyDefinitions);
            } else {
                this.storePropertyDefinitionsOfListType(sub, (List)obj, lefPropertyDefinitions);
            }
        }
    }

    private void storePropertyDefinitionsOfStringType(Substrate sub, String current, Set<String> toAdd) {
        String newString = toAdd.stream().filter(s -> !current.contains((CharSequence)s)).collect(Collectors.joining("\n"));
        newString = current.isEmpty() ? newString : current + "\n" + newString;
        sub.setValue(FLDNAME_LEF58_PROPERTYDEFINITIONS, (Object)newString);
    }

    private void storePropertyDefinitionsOfListType(Substrate sub, List<String> current, Set<String> toAdd) {
        if (current != null) {
            toAdd.addAll(current);
        }
        ArrayList<String> list = new ArrayList<String>(toAdd);
        Collections.sort(list);
        sub.setValue(FLDNAME_LEF58_PROPERTYDEFINITIONS, list);
    }

    private void setupMacroNameRegexPattern(String justMacroPattern) {
        this.mJustMacroPattern = null;
        try {
            if (justMacroPattern != null && !justMacroPattern.isEmpty()) {
                this.mJustMacroPattern = Pattern.compile(justMacroPattern);
            }
        }
        catch (PatternSyntaxException e) {
            LEFDEFParser.vWarn(e, "'%s' is not a valid regex.", justMacroPattern);
        }
    }

    private boolean setupDEFSubstrate() {
        if (this.mDefReadParent != null) {
            this.mSubstrate = this.mDefReadParent.getSubstrate();
            if (this.mSubstrate == null) {
                LEFDEFParser.vWarn(String.format("DeviceTemplate '%s' has no associated substrate!", this.mDefReadParent), new Object[0]);
                return false;
            }
        } else {
            if (this.mSubstrateName == null || this.mSubstrateName.isEmpty()) {
                LEFDEFParser.vWarn("Substrate name is null or empty!", new Object[0]);
                return false;
            }
            this.mSubstrate = Substrate.getSubstrate((Db)this.mDb, (String)this.mSubstrateName);
            if (this.mSubstrate == null) {
                LEFDEFParser.vWarn("There is no substrate named " + this.mSubstrateName, new Object[0]);
                return false;
            }
        }
        return true;
    }

    @Deprecated(forRemoval=true)
    public boolean parseDef(String fileName, int verbosity, boolean uniqueify, boolean preserveHierarchy, boolean readNets, boolean addUnused, boolean readWires, boolean readSpecialWires, String justMacroPattern, boolean readBlocks, boolean readCores) {
        return this.parseDEF(fileName, verbosity, uniqueify, readNets, addUnused, readWires, readSpecialWires, justMacroPattern);
    }

    @Deprecated(forRemoval=true)
    public boolean parseDEF(String fileName, int verbosity, boolean uniqueify, boolean readNets, boolean addUnused, boolean readWires, boolean readSpecialWires, String justMacroPattern) {
        mVerbosity = verbosity;
        this.mReadNets = readNets;
        this.mReadSpecialNets = readNets;
        this.mReadWires = readWires;
        this.mReadSpecialWires = readSpecialWires;
        this.mUniqueify = uniqueify;
        this.mAddUnusedPins = addUnused;
        this.setupMacroNameRegexPattern(justMacroPattern);
        return this.parseDEF(fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean parseDEF(String fileName) {
        this.mIsLef = false;
        this.mDesignName = "Chip";
        this.mDivideChar = "/";
        this.mDefUnitName = null;
        this.mDoneOneDevice = false;
        if (!this.setupDEFSubstrate()) {
            LEFDEFParser.vError("Def read is being aborted", new Object[0]);
            return false;
        }
        File defFile = new File(fileName);
        ALog.logInfo((String)"Beginning to import DEF '%s'.", (Object[])new Object[]{defFile});
        long timeSpent = System.nanoTime();
        this.mDb.setHistoryEnabled(false);
        this.mDb.setListenersEnabled(false);
        try {
            this.mFileName = fileName;
            this.mFileMD5 = AFile.getMD5((File)defFile);
            if (!this.setInFile(fileName)) {
                LEFDEFParser.vError("Can not open file '%s'.", defFile);
                boolean bl = false;
                return bl;
            }
            try {
                this.next();
                this.eDEF();
            }
            catch (MalformedLEFDEFException e) {
                LEFDEFParser.vError(e);
                boolean bl = false;
                this.postDEF();
                this.closeFile();
                if (this.mCurrentDie != null && this.mCurrentDie.getTemplate() != null) {
                    this.mFileMD5.ifPresent(md5 -> this.mCurrentDie.getTemplate().setValue(FLDNAME_MD5, md5));
                }
                this.mDb.setHistoryEnabled(true);
                this.mDb.setListenersEnabled(true);
                return bl;
            }
            this.postReading();
            if (!this.mDoneOneDevice && this.mCurrentDie != null) {
                LinkedList<SubstrateTemplate> dies;
                this.mSubstrate = Substrate.getSubstrate((Db)this.mDb, (String)this.mSubstrateName);
                if (this.mSubstrate == null && !(dies = SubstrateTemplate.getSubstrateInstances(this.mDb, true, false, DeviceTemplate.Type.DIE)).isEmpty()) {
                    this.mSubstrate = (Substrate)dies.getFirst().first;
                }
                DeviceTemplate dieTemplate = this.mCurrentDie.getTemplate();
                dieTemplate.setSubstrate(this.mSubstrate);
                this.updateSubstrateNameIfNeeded(dieTemplate);
                this.mDoneOneDevice = true;
            }
            if (this.mCurrentDie != null) {
                for (PropertyValue pv : this.deferredDesignProperties) {
                    this.mCurrentDie.getTemplate().setValue("DEF." + pv.desc.name, (Object)pv.value);
                }
                this.mCurrentDie.moveToClearArea();
                if (this.mAddUnusedPins) {
                    DeviceTemplatePortUI.addUnusedPins();
                }
            }
            Device.manageAllUnplaceQs();
            this.mCurrentDesign.binAllDevices();
            this.doneReading();
            if (this.mScaleFactor != 1.0) {
                this.scaleCreatedObjects();
            }
        }
        finally {
            this.postDEF();
            this.closeFile();
            if (this.mCurrentDie != null && this.mCurrentDie.getTemplate() != null) {
                this.mFileMD5.ifPresent(md5 -> this.mCurrentDie.getTemplate().setValue(FLDNAME_MD5, md5));
            }
            this.mDb.setHistoryEnabled(true);
            this.mDb.setListenersEnabled(true);
        }
        timeSpent = System.nanoTime() - timeSpent;
        ALog.logInfo((String)"Done importing DEF, used %.3f seconds.", (Object[])new Object[]{(double)timeSpent / 1.0E9});
        return true;
    }

    private void eDEFVersion() throws MalformedLEFDEFException {
        String version = this.read();
        if (!version.startsWith("5.7") && !version.startsWith("5.8")) {
            LEFDEFParser.vWarn("Supported DEF version is 5.7+. This DEF is of version %s. There might be errors.", version);
        }
        this.expect(';');
    }

    private void eDEFRow() {
        this.after(';');
    }

    private void eDEFTracks() {
        this.after(';');
    }

    private void eDEFGCellGrid() {
        this.after(';');
    }

    private void eNamesCaseSensitive() {
        this.after(';');
    }

    private void eNullDEF() {
        while (!this.isEOF()) {
            this.read();
        }
    }

    private void eDEF() throws MalformedLEFDEFException {
        if (debugTokenSpeed) {
            this.eNullDEF();
            return;
        }
        while (!this.isEOF()) {
            if (this.accept(LEFDEFSyntax.KW_VERSION)) {
                this.eDEFVersion();
                continue;
            }
            if (this.accept(LEFDEFSyntax.KW_DIVIDERCHAR)) {
                this.eLEFDividerChar();
                continue;
            }
            if (this.accept(LEFDEFSyntax.KW_BUSBITCHARS)) {
                this.eLEFBusBitChars();
                continue;
            }
            if (this.accept(LEFDEFSyntax.KW_DESIGN)) {
                this.eDesign();
                continue;
            }
            if (this.accept(LEFDEFSyntax.KW_TECHNOLOGY)) {
                this.eDEFTechnology();
                continue;
            }
            if (this.accept(LEFDEFSyntax.KW_UNITS)) {
                this.eDEFUnits();
                continue;
            }
            if (this.accept(LEFDEFSyntax.KW_HISTORY)) {
                this.eHistory();
                continue;
            }
            if (this.accept(LEFDEFSyntax.KW_PROPERTYDEFINITIONS)) {
                this.parserDEFPropertyDefinitions.perform();
                continue;
            }
            if (this.accept(LEFDEFSyntax.KW_DIEAREA)) {
                this.eDieArea();
                continue;
            }
            if (this.accept(LEFDEFSyntax.KW_ROW)) {
                this.eDEFRow();
                continue;
            }
            if (this.accept(LEFDEFSyntax.KW_TRACKS)) {
                this.eDEFTracks();
                continue;
            }
            if (this.accept(LEFDEFSyntax.KW_GCELLGRID)) {
                this.eDEFGCellGrid();
                continue;
            }
            if (this.accept(LEFDEFSyntax.KW_VIAS)) {
                this.parserDefVias.perform();
                continue;
            }
            if (this.accept(LEFDEFSyntax.KW_STYLES)) {
                this.eDEFStyles();
                continue;
            }
            if (this.accept(LEFDEFSyntax.KW_NONDEFAULTRULES)) {
                this.eDEFNonDefaultRules();
                continue;
            }
            if (this.accept(LEFDEFSyntax.KW_REGIONS)) {
                this.eDEFRegions();
                continue;
            }
            if (this.accept(LEFDEFSyntax.KW_COMPONENTMASKSHIFT)) {
                this.eComponentMaskShift();
                continue;
            }
            if (this.accept(LEFDEFSyntax.KW_COMPONENTS)) {
                this.parserComponents.perform();
                continue;
            }
            if (this.accept(LEFDEFSyntax.KW_PINS)) {
                this.parserPins.perform();
                continue;
            }
            if (this.accept(LEFDEFSyntax.KW_PINPROPERTIES)) {
                this.eDEFPinProperties();
                continue;
            }
            if (this.accept(LEFDEFSyntax.KW_BLOCKAGES)) {
                this.parserBlockages.perform();
                continue;
            }
            if (this.accept(LEFDEFSyntax.KW_SLOTS)) {
                this.eDEFSlots();
                continue;
            }
            if (this.accept(LEFDEFSyntax.KW_FILLS)) {
                this.eDEFFills();
                continue;
            }
            if (this.accept(LEFDEFSyntax.KW_SPECIALNETS)) {
                this.doSpecialNets(this.mReadSpecialNets, this.mReadSpecialWires);
                continue;
            }
            if (this.accept(LEFDEFSyntax.KW_NETS)) {
                this.doNets(this.mReadNets, this.mReadWires);
                continue;
            }
            if (this.accept(LEFDEFSyntax.KW_SCANCHAINS)) {
                this.eDEFScanChains();
                continue;
            }
            if (this.accept(LEFDEFSyntax.KW_GROUPS)) {
                this.eDEFGroups();
                continue;
            }
            if (this.accept(LEFDEFSyntax.KW_BEGINEXT)) {
                this.eDEFBeginExt();
                continue;
            }
            if (this.accept(LEFDEFSyntax.KW_NAMESCASESENSITIVE)) {
                this.eNamesCaseSensitive();
                continue;
            }
            if (this.accept(LEFDEFSyntax.KW_END)) {
                this.expect(LEFDEFSyntax.KW_DESIGN);
                break;
            }
            throw new MalformedLEFDEFException(this.fmtErrMsg("Unhandled DEF keyword: " + this.read()));
        }
    }

    private void eDEFRegions() {
        this.after(LEFDEFSyntax.KW_END, LEFDEFSyntax.KW_REGIONS);
    }

    private void eDEFGroups() {
        this.after(LEFDEFSyntax.KW_END, LEFDEFSyntax.KW_GROUPS);
    }

    private void addTermToEqNets(String term, String net) {
        Set eqNets = this.mNetToEqNets.computeIfAbsent(net, k -> {
            HashSet<String> nets = new HashSet<String>();
            nets.add(net);
            return nets;
        });
        if (!term.equals(net)) {
            Set<String> termEqNets = this.mNetToEqNets.get(term);
            if (termEqNets == null) {
                eqNets.add(term);
            } else {
                eqNets.addAll(termEqNets);
            }
            this.mNetToEqNets.put(term, eqNets);
        }
    }

    private void eDEFPinProperties() throws MalformedLEFDEFException {
        int num = this.eInt();
        this.expect(';');
        if (num != 0) {
            while (this.accept('-')) {
                if (this.accept(LEFDEFSyntax.KW_PIN)) {
                    String pinName = this.read();
                    if (this.accept('+')) {
                        this.read();
                        if (this.accept("ORBIT_NET")) {
                            String originalOrbitNetName = this.removeQuotes(this.read());
                            this.buildOrgNetMap(pinName, originalOrbitNetName);
                        }
                    }
                }
                this.after(';');
            }
        }
        this.after(LEFDEFSyntax.KW_END, LEFDEFSyntax.KW_PINPROPERTIES);
    }

    private void buildOrgNetMap(String pinName, String originalOrbitNetName) {
        Set<String> eqNets = this.mNetToEqNets.get(pinName);
        if (eqNets != null && !eqNets.isEmpty()) {
            for (String aliasNet : eqNets) {
                this.mNetToOrgNet.put(aliasNet, originalOrbitNetName);
            }
            eqNets.clear();
        }
    }

    private void eDEFScanChains() {
        this.after(LEFDEFSyntax.KW_END, LEFDEFSyntax.KW_SCANCHAINS);
    }

    private void eDEFSlots() {
        this.after(LEFDEFSyntax.KW_END, LEFDEFSyntax.KW_SLOTS);
    }

    private void eDEFStyles() {
        this.after(LEFDEFSyntax.KW_END, LEFDEFSyntax.KW_STYLES);
    }

    private void eDEFTechnology() throws MalformedLEFDEFException {
        this.read();
        this.expect(';');
    }

    private void eDEFFills() throws MalformedLEFDEFException {
        this.read();
        this.expect(';');
        while (!this.after(LEFDEFSyntax.KW_END, LEFDEFSyntax.KW_FILLS)) {
        }
    }

    private void postDEF() {
        this.mNameToTerm = null;
        this.mBumpToPins = null;
        this.mNetToEqNets = null;
        this.mNetToOrgNet = null;
    }

    private PinTemplate getFirstPinTemplate(Term t) {
        return this.mFirstPinTemplate.computeIfAbsent(t, k -> {
            IterableIterator ii = PinLabel.get((Term)t);
            if (ii.hasNext()) {
                return ((PinLabel)ii.next()).getPin();
            }
            return null;
        });
    }

    private void connectChildTermPin(Device d, String termName) {
        Term ct = d.getTemplate().getTerm();
        Term term = this.mNameToTerm.get(termName);
        this.connectChildTermPin(d, term, ct);
    }

    private void connectChildTermPin(Device d, String termName, String childTermName) {
        Term ct = d.getTemplate().getTerm(childTermName);
        Term term = this.mNameToTerm.get(termName);
        this.connectChildTermPin(d, term, ct);
    }

    private void connectChildTermPin(Device d, Term term, Term ct) {
        PinTemplate pin = this.getFirstPinTemplate(ct);
        if (term == null || pin == null) {
            LEFDEFParser.vError("BUMP_TO_PIN Error: failed to get term: '%s' for child term: '%s' in child device: '%s'", term, ct, d);
        } else {
            TermMap.mapChildTerm((Device)d, (Term)ct, (Net)term.getNet());
            PinLabel pl = PinLabel.get((DeviceTemplate)this.mCurrentDie.getTemplate(), (DevicePath)new DevicePath(this.mCurrentDie.getTemplate(), d), (PinTemplate)pin);
            pl.setTerm(term);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBumpToPins() {
        try {
            this.mFirstPinTemplate = new HashMap<Term, PinTemplate>();
            for (Map.Entry<Device, String> e : this.mBumpToPins.entrySet()) {
                String[] termChildTermPair;
                Device d = e.getKey();
                String value = e.getValue();
                for (String s : termChildTermPair = value.split(",")) {
                    String[] termChildTerm = s.split(":");
                    if (termChildTerm.length == 1) {
                        this.connectChildTermPin(d, termChildTerm[0]);
                        continue;
                    }
                    this.connectChildTermPin(d, termChildTerm[0], termChildTerm[1]);
                }
            }
        }
        catch (Exception e) {
            LEFDEFParser.vError(e, "Failed in building terms", new Object[0]);
        }
        finally {
            this.mFirstPinTemplate = null;
        }
    }

    private void processOrgNets() {
        DeviceTemplate template = this.mCurrentDie.getTemplate();
        this.mNetToOrgNet.entrySet().stream().forEach(e -> {
            String netName = (String)e.getKey();
            String orgNetName = (String)e.getValue();
            Net net = template.getNet(netName);
            if (net != null) {
                net.setName(orgNetName);
            }
        });
    }

    private void postReading() {
        this.processBumpToPins();
        this.processOrgNets();
    }

    public String parseDefDesignName(String defFilePath) {
        block2: {
            this.mIsLef = false;
            this.mFileName = defFilePath;
            if (!this.setInFile(this.mFileName)) {
                LEFDEFParser.vError("Can not open file '%s'.", this.mFileName);
                return null;
            }
            this.next();
            while (this.after(LEFDEFSyntax.KW_DESIGN)) {
                this.mDesignName = this.read();
                if (!this.accept(';')) continue;
                break block2;
            }
            this.mDesignName = "";
        }
        this.closeFile();
        this.doneReading();
        return this.mDesignName;
    }

    private boolean eHistory() {
        return this.after(';');
    }

    private String getUniqueDeviceName(String localName) {
        Object deviceName = this.mUniqueify ? this.mDesignName + this.mDivideChar + localName : localName;
        return deviceName;
    }

    private boolean doSpecialNets(boolean readNets, boolean readWires) {
        if (!readNets) {
            this.after(LEFDEFSyntax.KW_END, LEFDEFSyntax.KW_SPECIALNETS);
            LEFDEFParser.vInfo("[SPECIALNETS] Skipped.", new Object[0]);
            return true;
        }
        this.parserNetsOrSpecialNets.resetWith("SPECIALNETS", readWires, true);
        try {
            return this.parserNetsOrSpecialNets.perform();
        }
        catch (MalformedLEFDEFException e) {
            LEFDEFParser.vError("SPECIALNETS is not compliant with LEFDEF spec. %s", e.getMessage());
            return false;
        }
    }

    private boolean doNets(boolean readNets, boolean readWires) {
        if (!readNets) {
            this.after(LEFDEFSyntax.KW_END, LEFDEFSyntax.KW_NETS);
            LEFDEFParser.vInfo("[NETS] Skipped.", new Object[0]);
            return true;
        }
        this.parserNetsOrSpecialNets.resetWith("NETS", readWires, false);
        try {
            return this.parserNetsOrSpecialNets.perform();
        }
        catch (MalformedLEFDEFException e) {
            LEFDEFParser.vError("NETS is not compliant with LEFDEF spec. %s", e.getMessage());
            return false;
        }
    }

    private static Net getTopmostNet(Net net, DevicePath path) {
        if (path == null) {
            return null;
        }
        path = path.copy();
        net = NetMap.getParentNet((Device)path.getLast(), (Net)net);
        while (net != null) {
            path.removeLast();
            Net topNet = net;
            if (path.size() == 1) {
                return topNet;
            }
            net = NetMap.getParentNet((Device)path.getLast(), (Net)net);
        }
        return null;
    }

    static boolean buildNetMapBottomUp(DevicePath path, PinInstance port, String withName) {
        Net n = port.getNet();
        PinTemplate pinTemplate = port.getPinTemplate();
        boolean usePinName = true;
        if (path.getIsAbsolute() && path.size() == 1) {
            usePinName = false;
        }
        if (n.isUnused()) {
            String lowLevelName = usePinName ? pinTemplate.getName() : withName;
            n = port.getDevice().getTemplate().getNet(lowLevelName);
            if (n == null) {
                n = port.getDevice().getTemplate().createNet(lowLevelName);
            }
            port.setNet(n);
        } else if (!usePinName) {
            n = port.getDevice().getTemplate().getNet(withName);
            if (n == null) {
                n = port.getDevice().getTemplate().createNet(withName);
            }
            port.setNet(n);
        }
        if (path.size() <= 1) {
            return true;
        }
        Device child = path.getLast();
        return LEFDEFParser.netmapBottomUp(path, withName, child, null, n);
    }

    static boolean netmapBottomUp(DevicePath dp, String topNetName, Device device, Device childDevice, Net childNet) {
        if (dp.size() == 1) {
            DeviceTemplate template = device.getTemplate();
            Net topNet = template.getNet(topNetName);
            if (topNet == null) {
                topNet = Net.create((DeviceTemplate)template, (String)topNetName);
            }
            if (childDevice != null) {
                NetMap.mapChildNet((Device)childDevice, (Net)childNet, (Net)topNet);
            }
            return true;
        }
        DevicePath dpWOChild = dp.getParent();
        Device parent = dp.getParentDevice();
        DeviceTemplate parentT = parent.getTemplate();
        List netsUpmapToParent = NetMap.getParentMappings((Device)device).stream().filter(nm -> {
            DeviceTemplate t = nm.getParentNet().getDeviceTemplate();
            return t.equals(parentT);
        }).map(NetMap::getChildNet).collect(Collectors.toList());
        List candidateNets = netsUpmapToParent.stream().filter(n -> {
            Net topNet = LEFDEFParser.getTopmostNet(n, dp);
            return topNet == null || topNet.getName().equals(topNetName);
        }).collect(Collectors.toList());
        if (candidateNets.isEmpty()) {
            DeviceTemplate template = device.getTemplate();
            String[] netNames = new String[]{childNet.getName(), topNetName};
            Net n2 = null;
            boolean found = false;
            for (String netName : netNames) {
                n2 = template.getNet(netName);
                if (n2 != null) continue;
                n2 = Net.create((DeviceTemplate)template, (String)netName);
                found = true;
                break;
            }
            if (!found) {
                throw new IllegalArgumentException(String.format("Unable to create net to top for '%s'. Existing net '%s' and '%s' do not connect to top.", device, topNetName, childNet.getName()));
            }
            if (childDevice != null) {
                NetMap.mapChildNet((Device)childDevice, (Net)childNet, (Net)n2);
            }
            return LEFDEFParser.netmapBottomUp(dpWOChild, topNetName, parent, device, n2);
        }
        for (Net n3 : candidateNets) {
            if (childDevice != null) {
                NetMap.mapChildNet((Device)childDevice, (Net)childNet, (Net)n3);
            }
            if (LEFDEFParser.netmapBottomUp(dpWOChild, topNetName, parent, device, n3)) {
                return true;
            }
            if (childDevice == null) continue;
            NetMap.unmap((Device)childDevice, (Net)childNet, (Net)n3);
        }
        return false;
    }

    protected String removeSpecialChars(String incoming) {
        String processed = incoming;
        return processed.replaceAll("\\\\", "");
    }

    private boolean eManufacturingGrid() throws MalformedLEFDEFException {
        double resolution = this.eDouble();
        long r = (long)(resolution * this.mDefDbuPerDefUnit * (double)Design.getInternalPerMicron((Db)this.mDb));
        AGrid g = new AGrid();
        g.setDelta(r, r);
        g.setOrigin(0L, 0L);
        NamedGrid ng = NamedGrid.get((Substrate)this.mSubstrate, (String)"Manufacturing Grid");
        if (ng == null) {
            NamedGrid.create((Substrate)this.mSubstrate, (String)"Manufacturing Grid", (AGrid)g);
        } else {
            ng.setGrid(g);
        }
        this.expect(';');
        return true;
    }

    private void eDEFUnits() throws MalformedLEFDEFException {
        this.expect(LEFDEFSyntax.KW_DISTANCE);
        this.expect(LEFDEFSyntax.KW_MICRONS);
        this.mDefDbuPerDefUnit = this.eDouble();
        if (!this.mIsLef && this.mDefUnitName == null) {
            this.mDefUnitName = "MICRONS";
        }
        assert (!this.mIsLef) : "Only for DEF";
        this.updateDEFUnitsToTopDevice(this.mDefUnitName, this.mDefDbuPerDefUnit);
        this.expect(';');
    }

    private void updateDEFUnitsToTopDevice(String defUnitName, double dbuPerDefUnit) {
        DeviceTemplate t = this.mCurrentDie.getTemplate();
        t.setValue("sourceUnitName", (Object)defUnitName);
        t.setValue("sourceUnitDbuPer", (Object)dbuPerDefUnit);
    }

    private Device getOrCreateTopDevice() {
        Device d;
        DeviceTemplate parent = this.mDefReadParent != null ? this.mDefReadParent : this.mCurrentDesign;
        Device device = d = parent != null ? parent.getChild(this.mDesignName) : null;
        if (d == null || d.getSubstrate() != this.mSubstrate) {
            d = this.createTopDevice(null);
        }
        return d;
    }

    private Device createTopDevice(ARect r) {
        String templateName = this.mDefReadTemplateName == null ? this.mDesignName : this.mDefReadTemplateName;
        DeviceTemplate t = DeviceTemplate.getDeviceTemplate((Substrate)this.mSubstrate, (String)templateName);
        if (t != null) {
            LEFDEFParser.vError("A DeviceTemplate named '%s' already exists in the design. The DEF read is being aborted.", templateName);
            return null;
        }
        this.mTopDeviceTemplate = t = DeviceTemplate.create((Substrate)this.mSubstrate, (String)templateName, (boolean)false);
        this.mUnscaledDeviceTemplates.add(t);
        this.getContext().mCreatedDeviceTemplates.add(t);
        if (r != null) {
            t.setBounds((AGeom)r);
        }
        DeviceTemplate parent = this.mDefReadParent != null ? this.mDefReadParent : this.mCurrentDesign;
        this.mDesignName = Device.getUniqueName((DeviceTemplate)parent, (String)this.mDesignName);
        Device device = Device.create((String)this.mDesignName, (DeviceTemplate)t, (DeviceTemplate)parent);
        t.setType(DeviceTemplate.Type.DIE);
        t.setSourceType(DeviceTemplate.SourceType.LEFDEF);
        t.setSourceFile(this.mFileName);
        t.setSourceFileModifiedTime(this.getFile().lastModified());
        if (this.mFileMD5.isPresent()) {
            t.setValue(FLDNAME_MD5, (Object)this.mFileMD5.get());
        }
        device.setLoc(new APoint2D(0L, 0L));
        return device;
    }

    private void eDieArea() throws MalformedLEFDEFException {
        APoint2D ll = this.eDEFPoint();
        APoint2D ur = this.eDEFPoint();
        ARect r = ARect.create((APoint2D)ll, (APoint2D)ur);
        this.mDieLL.setLoc(r.getLL());
        this.mCurrentDie.getTemplate().setBounds((AGeom)r);
        this.expect(';');
    }

    private APoint2D ePoint() {
        long x = this.accept('*') ? this.mLastX : this.eLong();
        long y = this.accept('*') ? this.mLastY : this.eLong();
        this.mLastX = x;
        this.mLastY = y;
        return new APoint2D(this.toDB(x), this.toDB(y));
    }

    private APoint2D eDEFPoint() throws MalformedLEFDEFException {
        this.expect('(');
        APoint2D pt = this.ePoint();
        this.expect(')');
        return pt;
    }

    private List<APoint2D> aDEFPoints() throws MalformedLEFDEFException {
        LinkedList<APoint2D> pts = new LinkedList<APoint2D>();
        while (this.accept('(')) {
            APoint2D pt = this.ePoint();
            pts.add(pt);
            this.expect(')');
        }
        return pts;
    }

    private Substrate getSubstrate(String templateName) {
        if (this.mSubstrate == null) {
            for (Substrate s : this.mDb.getObjects(Substrate.class)) {
                DeviceTemplate aT = DeviceTemplate.getDeviceTemplate((Substrate)s, (String)templateName);
                if (aT == null) continue;
                if (this.mSubstrate != null) {
                    LEFDEFParser.vError("A Substrate was not specified and '%s' is present in multiple substrates", templateName);
                    break;
                }
                this.mSubstrate = s;
            }
        }
        return this.mSubstrate;
    }

    private boolean shouldInclude(String templateName) {
        return this.mJustMacroPattern == null || this.mJustMacroPattern.matcher(templateName).matches();
    }

    private void dbgListAllTemplates() {
        List l = this.mDb.getObjects(DeviceTemplate.class).stream().collect(Collectors.toList());
        ALog.flogInfo((String)"---List %d Templates", (Object[])new Object[]{l.size()});
        l.stream().forEach(t -> ALog.flogInfo((String)"Template:'%s'", (Object[])new Object[]{t.getName()}));
    }

    private void updateSubstrateNameIfNeeded(DeviceTemplate refTemplate) {
        if (this.mSubstrate == null) {
            return;
        }
        if (this.mSubstrate.getName().startsWith(SUBSTRATE_DEF_NAME_BASE)) {
            Object newName = refTemplate.getName() + "_Substrate";
            if (Substrate.getSubstrate((Db)this.mSubstrate.getDb(), (String)newName) != null) {
                newName = Substrate.getUniqueName((Db)this.mDb, (String)newName);
            }
            this.mSubstrate.setName((String)newName);
        }
    }

    private List<String> toLEFDEFString(Set<PropertyValue> properties) {
        return properties.stream().map(PropertyValue::toLEFDEFString).collect(Collectors.toList());
    }

    private void eDEFNonDefaultRules() throws MalformedLEFDEFException {
        this.read();
        this.expect(';');
        while (this.accept('-')) {
            this.read();
            this.expect('+');
            if (this.accept(LEFDEFSyntax.KW_HARDSPACING)) {
                this.expect('+');
            }
            while (this.accept(LEFDEFSyntax.KW_LAYER)) {
                this.read();
                this.expect(LEFDEFSyntax.KW_WIDTH);
                this.read();
                if (this.accept(LEFDEFSyntax.KW_DIAGWIDTH)) {
                    this.read();
                }
                if (this.accept(LEFDEFSyntax.KW_SPACING)) {
                    this.read();
                }
                if (this.accept(LEFDEFSyntax.KW_WIREEXT)) {
                    this.read();
                }
                this.accept('+');
            }
            while (this.accept(LEFDEFSyntax.KW_VIA)) {
                this.read();
                this.accept('+');
            }
            while (this.accept(LEFDEFSyntax.KW_VIARULE)) {
                this.read();
                this.accept('+');
            }
            while (this.accept(LEFDEFSyntax.KW_MINCUTS)) {
                this.read();
                this.read();
                this.accept('+');
            }
            while (this.accept(LEFDEFSyntax.KW_PROPERTY)) {
                this.read();
                this.read();
                this.accept('+');
            }
            while (this.accept(LEFDEFSyntax.KW_LEF58_USEVIACUTCLASS)) {
                this.eLEFPropertyLEF58UseViaCutClass();
            }
            this.expect(';');
        }
        this.expect(LEFDEFSyntax.KW_END);
        this.expect(LEFDEFSyntax.KW_NONDEFAULTRULES);
    }

    protected void putDevLLAt(Device d, APoint2D ll) {
        d.setLoc(ll);
        ARect bb = d.getLocalBB();
        long xOff = ll.getX() - bb.getLL().getX();
        long yOff = ll.getY() - bb.getLL().getY();
        if (this.mScaleFactor != 1.0) {
            xOff = (long)((double)xOff / this.mScaleFactor);
            yOff = (long)((double)yOff / this.mScaleFactor);
        }
        APoint2D newPos = new APoint2D(ll.getX() + xOff, ll.getY() + yOff);
        d.setLoc(newPos);
    }

    private Layer getLayer(String layerName) throws MalformedLEFDEFException {
        Layer l = this.mSubstrate.getLayer(layerName);
        if (l == null && (l = Layer.create((Substrate)this.mSubstrate, (String)layerName, (int)this.mLayerOrder++, (long)Design.micronToInternal((Db)this.mDb, (double)2.0))) == null) {
            throw new MalformedLEFDEFException(this.fmtErrMsg("Failed to create layer: " + layerName));
        }
        return l;
    }

    private APolygon eDEFPolygon() throws MalformedLEFDEFException {
        List<APoint2D> pts = this.aDEFPoints();
        if (pts.size() < 2) {
            throw new MalformedLEFDEFException(this.fmtErrMsg("Polygon has less than 2 points"));
        }
        return new APolygon(pts);
    }

    private void eDEFBeginExt() throws MalformedLEFDEFException {
        if (!this.after(LEFDEFSyntax.KW_ENDEXT)) {
            throw new MalformedLEFDEFException(this.fmtErrMsg("Failed to find matching ENDEXT for BEGINEXT"));
        }
    }

    private PARSING_CONTROL tillLEFEOS() throws MalformedLEFDEFException {
        if (!this.after(';')) {
            throw new MalformedLEFDEFException("Failed to find ';'. Near line %d.", this.mCurLine);
        }
        return PARSING_CONTROL.MORE;
    }

    private DefPropertyDescriptor getPropDefn(String objType, String propName) {
        APair key = new APair((Object)objType, (Object)propName);
        return this.propertyDescriptors.computeIfAbsent((APair<String, String>)key, newkey -> {
            LEFDEFParser.vDebug("Unsupport: Missing property definition for '%s'.", propName);
            return new DefPropertyDescriptor(objType, propName, PropertyType.String);
        });
    }

    private PropertyValue parseProperty(String objType) throws MalformedLEFDEFException {
        String name = this.read();
        String val = this.read();
        val = this.removeQuotes(val);
        this.expect(';');
        return new PropertyValue(this.getPropDefn(objType, name), val);
    }

    private String getDesignName() throws MalformedLEFDEFException {
        this.mDesignName = this.read();
        this.expect(';');
        return this.mDesignName;
    }

    private void eDesign() throws MalformedLEFDEFException {
        this.getDesignName();
        this.mCurrentDie = this.getOrCreateTopDevice();
    }

    private long lefToDB(double lefv) {
        return Math.round(lefv * (double)this.mInternalToMicron);
    }

    private long toDB(double lefdefV) {
        return Math.round(lefdefV * (double)this.mInternalToMicron / this.mDefDbuPerDefUnit);
    }

    private long toDEFUnit(double dbV) {
        return Math.round(dbV * this.mDefDbuPerDefUnit / (double)this.mInternalToMicron);
    }

    protected void scaleCreatedObjects() {
        if (this.mScaleFactor == 1.0) {
            return;
        }
        AffineTransform x = AffineTransform.getScaleInstance(this.mScaleFactor, this.mScaleFactor);
        for (LayerShape ls : this.mUnscaledLayerShapes) {
            ls.transform(x);
        }
        this.mUnscaledLayerShapes.clear();
        for (DeviceTemplate dt : this.mUnscaledDeviceTemplates) {
            dt.transform(x);
        }
        this.mUnscaledDeviceTemplates.clear();
    }

    private void next() {
        this.mTokenInfo = this.popTokenInfo();
    }

    private void next(char stop1, char stop2) throws MalformedLEFDEFException {
        this.mTokenInfo = this.popStopCharInfo(stop1, stop2);
        if (this.mTokenInfo == null) {
            throw new MalformedLEFDEFException(this.fmtErrMsg(String.format("Failed to find either '%c' or '%c'.", Character.valueOf(stop1), Character.valueOf(stop2))));
        }
    }

    private boolean isEOF() {
        return this.mTokenInfo == null;
    }

    private boolean accept(String caseSensitiveSymbol) {
        if (this.mTokenInfo.accept(caseSensitiveSymbol)) {
            this.next();
            return true;
        }
        return false;
    }

    private boolean accept(char[] upperCaseSymbol) {
        if (this.mTokenInfo.accept(upperCaseSymbol)) {
            this.next();
            return true;
        }
        return false;
    }

    private boolean accept(char c) {
        if (this.mTokenInfo.accept(c)) {
            this.next();
            return true;
        }
        return false;
    }

    private Long aLong() {
        Long val = this.mTokenInfo.aLong();
        if (val != null) {
            this.next();
        }
        return val;
    }

    private String aOrient() {
        for (LEFDEFSyntax.Orientation o : LEFDEFSyntax.Orientation.values()) {
            if (!this.accept(o.getChars())) continue;
            return o.name();
        }
        return null;
    }

    private Double aDouble() {
        Double val = this.mTokenInfo.aDouble();
        if (val != null) {
            this.next();
        }
        return val;
    }

    private int eInt() {
        int v = this.mTokenInfo.eInt();
        this.next();
        return v;
    }

    private long eLong() {
        long v = this.mTokenInfo.eLong();
        this.next();
        return v;
    }

    private double eDouble() {
        double v = this.mTokenInfo.eDouble();
        this.next();
        return v;
    }

    private void expect(char symbol) throws MalformedLEFDEFException {
        if (!this.accept(symbol)) {
            throw new MalformedLEFDEFException(this.fmtErrMsg(this.mTokenInfo, symbol));
        }
    }

    private void expect(char[] symbol) throws MalformedLEFDEFException {
        if (!this.accept(symbol)) {
            throw new MalformedLEFDEFException(this.fmtErrMsg(this.mTokenInfo, symbol));
        }
    }

    private void expect(String caseSensitiveSymbol) throws MalformedLEFDEFException {
        if (!this.accept(caseSensitiveSymbol)) {
            throw new MalformedLEFDEFException(this.fmtErrMsg(this.mTokenInfo, caseSensitiveSymbol));
        }
    }

    private String read() {
        String token = this.mTokenInfo.getString();
        this.next();
        return token;
    }

    private String peekString() {
        return this.mTokenInfo.getString();
    }

    private TokenParser.TokenInfo peek() {
        return this.mTokenInfo;
    }

    private boolean after(char[] s1, char[] s2) {
        while (this.after(s1)) {
            if (!this.accept(s2)) continue;
            return true;
        }
        return false;
    }

    private boolean after(char[] s1, String s2) {
        while (this.after(s1)) {
            if (!this.accept(s2)) continue;
            return true;
        }
        return false;
    }

    private boolean after(char c) {
        if (this.accept(c)) {
            return true;
        }
        if (this.findChar(c)) {
            this.next();
            return true;
        }
        return false;
    }

    private boolean after(char[] s) {
        if (this.accept(s)) {
            return true;
        }
        if (this.findWord(s)) {
            this.next();
            return true;
        }
        return false;
    }

    private PARSING_CONTROL tillNewObjectOrAttribute() throws MalformedLEFDEFException {
        this.next('-', '+');
        if (this.peek().accept('+')) {
            return PARSING_CONTROL.MORE;
        }
        return PARSING_CONTROL.DONE;
    }

    private void eLEF() throws MalformedLEFDEFException {
        while (!this.isEOF()) {
            if (this.accept(LEFDEFSyntax.KW_VERSION)) {
                if (this.eLEFVersion()) continue;
                return;
            }
            if (this.accept(LEFDEFSyntax.KW_BUSBITCHARS)) {
                this.eLEFBusBitChars();
                continue;
            }
            if (this.accept(LEFDEFSyntax.KW_DIVIDERCHAR)) {
                this.eLEFDividerChar();
                continue;
            }
            if (this.accept(LEFDEFSyntax.KW_UNITS)) {
                this.eLEFUnits();
                continue;
            }
            if (this.accept(LEFDEFSyntax.KW_MANUFACTURINGGRID)) {
                this.eManufacturingGrid();
                continue;
            }
            if (this.accept(LEFDEFSyntax.KW_USEMINSPACING)) {
                this.eLEFUseMinSpacing();
                continue;
            }
            if (this.accept(LEFDEFSyntax.KW_CLEARANCEMEASURE)) {
                this.eLEFClearanceMeasure();
                continue;
            }
            if (this.accept(LEFDEFSyntax.KW_PROPERTYDEFINITIONS)) {
                this.parserLEFPropertyDefinitions.perform();
                continue;
            }
            if (this.accept(LEFDEFSyntax.KW_FIXEDMASK)) {
                this.mFixedMask = true;
                this.expect(';');
                continue;
            }
            if (this.accept(LEFDEFSyntax.KW_LAYER)) {
                this.parserLayer.perform();
                continue;
            }
            if (this.accept(LEFDEFSyntax.KW_MAXVIASTACK)) {
                this.eMaxViaStack();
                continue;
            }
            if (this.accept(LEFDEFSyntax.KW_VIARULE)) {
                this.parserLEFViaRule.perform();
                continue;
            }
            if (this.accept(LEFDEFSyntax.KW_VIA)) {
                this.parserVia.perform();
                continue;
            }
            if (this.accept(LEFDEFSyntax.KW_NONDEFAULTRULE)) {
                this.parserDoNondefaultRule.perform();
                continue;
            }
            if (this.accept(LEFDEFSyntax.KW_SITE)) {
                this.eLEFSite();
                continue;
            }
            if (this.accept(LEFDEFSyntax.KW_MACRO)) {
                this.parserMacro.perform();
                continue;
            }
            if (this.accept(LEFDEFSyntax.KW_BEGINEXT)) {
                this.eLEFBeginExt();
                continue;
            }
            if (this.accept(LEFDEFSyntax.KW_NAMESCASESENSITIVE)) {
                this.eNamesCaseSensitive();
                continue;
            }
            if (this.accept(LEFDEFSyntax.KW_END)) {
                this.expect(LEFDEFSyntax.KW_LIBRARY);
                break;
            }
            String unknown = this.read().toUpperCase();
            LEFDEFParser.vWarn("Unrecognized keyword: '%s' near line %d. Continue parsing after '%s %s'.", unknown, this.mCurLine, "END", unknown);
            this.after(LEFDEFSyntax.KW_END, unknown);
        }
    }

    private boolean eLEFSite() throws MalformedLEFDEFException {
        String siteName = this.read();
        while (true) {
            if (this.accept(LEFDEFSyntax.KW_CLASS)) {
                boolean isCoreSite;
                if (this.accept(LEFDEFSyntax.KW_PAD)) {
                    isCoreSite = false;
                } else if (this.accept(LEFDEFSyntax.KW_CORE)) {
                    isCoreSite = true;
                } else {
                    throw new MalformedLEFDEFException(this.fmtErrMsg("CLASS {PAD | CORE} "));
                }
                this.expect(';');
                continue;
            }
            if (this.accept(LEFDEFSyntax.KW_SYMMETRY)) {
                this.eLEFSymmetry();
                continue;
            }
            if (this.accept(LEFDEFSyntax.KW_ROWPATTERN)) {
                this.eLEFRowPattern();
                continue;
            }
            if (this.accept(LEFDEFSyntax.KW_SIZE)) {
                this.eSize();
                continue;
            }
            if (this.accept(LEFDEFSyntax.KW_END)) break;
        }
        this.expect(siteName);
        return true;
    }

    private void eSize() throws MalformedLEFDEFException {
        try {
            this.read();
            this.expect(LEFDEFSyntax.KW_BY);
            this.read();
            this.expect(';');
        }
        catch (NumberFormatException e) {
            String err = this.fmtErrMsg("SIZE width BY height");
            throw new MalformedLEFDEFException(err);
        }
    }

    private boolean eLEFSymmetry() throws MalformedLEFDEFException {
        do {
            if (this.accept('X') || this.accept('Y') || this.accept(LEFDEFSyntax.KW_R90)) continue;
            throw new MalformedLEFDEFException(this.fmtErrMsg("X | Y | R90"));
        } while (!this.accept(';'));
        return true;
    }

    private boolean eLEFRowPattern() {
        do {
            this.read();
            this.read();
        } while (!this.accept(';'));
        return true;
    }

    private boolean eLEFVersion() throws MalformedLEFDEFException {
        String version = this.read();
        if (!version.startsWith("5.7") && !version.startsWith("5.8")) {
            LEFDEFParser.vWarn("Supported LEF version is 5.7+. This LEF is of version %s. There might be errors.", version);
        }
        this.expect(';');
        return true;
    }

    private boolean eLEFBusBitChars() throws MalformedLEFDEFException {
        String quotedDelimiterPair = this.read();
        if (quotedDelimiterPair.length() != 4) {
            throw new MalformedLEFDEFException("Expect \"delimiterPair\" of 4 characters, but got: '%s', near line %d.", quotedDelimiterPair, this.mCurLine);
        }
        if ('\"' != quotedDelimiterPair.charAt(0) || '\"' != quotedDelimiterPair.charAt(3)) {
            throw new MalformedLEFDEFException("Expect quotes around delimiterPair, but got: '%s', near line %d.", quotedDelimiterPair, this.mCurLine);
        }
        this.mBusBitChar[0] = quotedDelimiterPair.charAt(1);
        this.mBusBitChar[1] = quotedDelimiterPair.charAt(2);
        this.expect(';');
        return true;
    }

    private boolean eLEFDividerChar() throws MalformedLEFDEFException {
        String quotedcharacter = this.read();
        if (quotedcharacter.length() != 3) {
            throw new MalformedLEFDEFException("Expect \"character\" of 3 characters, but got: '%s', near line %d.", quotedcharacter, this.mCurLine);
        }
        if ('\"' != quotedcharacter.charAt(0) || '\"' != quotedcharacter.charAt(2)) {
            throw new MalformedLEFDEFException("Expect quotes around quotedcharacter, but got: '%s', near line %d.", quotedcharacter, this.mCurLine);
        }
        this.mDividerChar = quotedcharacter.charAt(1);
        this.expect(';');
        return true;
    }

    private boolean eLEFUnits() throws MalformedLEFDEFException {
        while (true) {
            if (this.accept(LEFDEFSyntax.KW_TIME)) {
                this.expect(LEFDEFSyntax.KW_NANOSECONDS);
                this.read();
                this.expect(';');
                continue;
            }
            if (this.accept(LEFDEFSyntax.KW_CAPACITANCE)) {
                this.expect(LEFDEFSyntax.KW_PICOFARADS);
                this.mCapacitancePicofaradsConvertFactor = Long.valueOf(this.read());
                this.expect(';');
                continue;
            }
            if (this.accept(LEFDEFSyntax.KW_RESISTANCE)) {
                this.expect(LEFDEFSyntax.KW_OHMS);
                this.read();
                this.expect(';');
                continue;
            }
            if (this.accept(LEFDEFSyntax.KW_POWER)) {
                this.expect(LEFDEFSyntax.KW_MILLIWATTS);
                this.read();
                this.expect(';');
                continue;
            }
            if (this.accept(LEFDEFSyntax.KW_CURRENT)) {
                this.expect(LEFDEFSyntax.KW_MILLIAMPS);
                this.read();
                this.expect(';');
                continue;
            }
            if (this.accept(LEFDEFSyntax.KW_VOLTAGE)) {
                this.expect(LEFDEFSyntax.KW_VOLTS);
                this.read();
                this.expect(';');
                continue;
            }
            if (this.accept(LEFDEFSyntax.KW_DATABASE)) {
                this.expect(LEFDEFSyntax.KW_MICRONS);
                this.mDatabaseMicronsConvertFactor = Long.valueOf(this.read());
                this.processLEFUnit("MICRONS", this.mDatabaseMicronsConvertFactor);
                this.expect(';');
                continue;
            }
            if (!this.accept(LEFDEFSyntax.KW_FREQUENCY)) break;
            this.expect(LEFDEFSyntax.KW_MEGAHERTZ);
            this.read();
            this.expect(';');
        }
        if (!this.accept(LEFDEFSyntax.KW_END)) {
            throw new MalformedLEFDEFException("Not a valid UNIT: '%s', near line %d.", this.read(), this.mCurLine);
        }
        this.expect(LEFDEFSyntax.KW_UNITS);
        return true;
    }

    private void processLEFUnit(String unit, long v) {
        this.mDefDbuPerDefUnit = 1.0;
        this.getContext().mLefUnitName = unit;
        this.getContext().mLefDbuPerLefUnit = v;
        this.getContext().mCreatedDeviceTemplates.stream().filter(t -> !t.hasSoftValue("sourceUnitName")).forEach(t -> {
            t.setValue("sourceUnitName", (Object)this.getContext().mLefUnitName);
            t.setValue("sourceUnitDbuPer", (Object)this.getContext().mLefDbuPerLefUnit);
        });
    }

    private boolean eLEFBeginExt() {
        this.read();
        while (!this.accept(LEFDEFSyntax.KW_ENDEXT)) {
            this.read();
            this.read();
        }
        return true;
    }

    private boolean eLEFUseMinSpacing() throws MalformedLEFDEFException {
        this.expect(LEFDEFSyntax.KW_OBS);
        if (this.accept(LEFDEFSyntax.KW_ON)) {
            this.isUseMinSpacingOBSOn = true;
        } else if (this.accept(LEFDEFSyntax.KW_OFF)) {
            this.isUseMinSpacingOBSOn = false;
        } else {
            throw new MalformedLEFDEFException(this.fmtErrMsg("Expect ON or OFF"));
        }
        this.expect(';');
        return true;
    }

    private boolean eLEFClearanceMeasure() throws MalformedLEFDEFException {
        if (this.accept(LEFDEFSyntax.KW_MAXXY)) {
            this.mClearanceMeasureEuclidean = false;
        } else if (this.accept(LEFDEFSyntax.KW_EUCLIDEAN)) {
            this.mClearanceMeasureEuclidean = true;
        } else {
            throw new MalformedLEFDEFException(String.format("Expect %s or %s, but got:'%s'. Near line %d.", LEFDEFSyntax.KW_MAXXY, LEFDEFSyntax.KW_EUCLIDEAN, this.read(), this.mCurLine));
        }
        this.expect(';');
        return true;
    }

    private boolean eMaxViaStack() throws MalformedLEFDEFException {
        this.mMaxViaStack = Long.valueOf(this.read());
        if (this.accept(LEFDEFSyntax.KW_RANGE)) {
            this.mMaxViaStackBottomLayer = this.read();
            this.mMaxViaStackTopLayer = this.read();
        }
        this.expect(';');
        return true;
    }

    private boolean aTaper() {
        this.mTaperRule = null;
        if (this.accept(LEFDEFSyntax.KW_TAPER)) {
            this.mTaperRule = "";
        } else if (this.accept(LEFDEFSyntax.KW_TAPERRULE)) {
            this.mTaperRule = this.read();
        } else {
            return false;
        }
        return true;
    }

    private boolean aStyle() {
        this.mStyleNum = -1L;
        if (!this.accept(LEFDEFSyntax.KW_STYLE)) {
            return false;
        }
        this.mStyleNum = this.eLong();
        return true;
    }

    private boolean aMask() {
        if (this.accept(LEFDEFSyntax.KW_MASK)) {
            this.mMaskNum = this.eInt();
            return true;
        }
        return false;
    }

    private void eMask() throws MalformedLEFDEFException {
        this.expect(LEFDEFSyntax.KW_MASK);
        this.mMaskNum = this.eInt();
    }

    private boolean aPropertyRowCol() throws MalformedLEFDEFException {
        try {
            if (this.accept(LEFDEFSyntax.KW_ROWCOL)) {
                this.read();
                this.read();
                return true;
            }
            return false;
        }
        catch (NumberFormatException e) {
            String err = this.fmtErrMsg("ROWCOL numCutRows numCutCols");
            throw new MalformedLEFDEFException(err);
        }
    }

    private PARSING_CONTROL eLEFPropertyLEF58UseViaCutClass() throws MalformedLEFDEFException {
        this.read();
        this.expect(';');
        return PARSING_CONTROL.MORE;
    }

    private String removeQuotes(String s) {
        if (s.startsWith("\"") && s.endsWith("\"")) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    private void eComponentMaskShift() {
        this.after(';');
    }

    private static void vDetails(String msg, Object ... args) {
        if (mVerbosity <= 0) {
            ALog.flogInfo((String)msg, (Object[])args);
        }
    }

    private static void vInfo(String msg, Object ... args) {
        if (mVerbosity <= 1) {
            ALog.flogInfo((String)msg, (Object[])args);
        }
    }

    private static void vError(Exception e) {
        ALog.logError((Throwable)e);
    }

    private static void vError(String msg, Object ... args) {
        ALog.flogError((String)msg, (Object[])args);
    }

    private static void vError(Exception e, String msg, Object ... args) {
        ALog.flogError((Throwable)e, (String)msg, (Object[])args);
    }

    private static void vWarn(String msg, Object ... args) {
        if (mVerbosity <= 1) {
            ALog.flogWarn((String)msg, (Object[])args);
        }
    }

    private static void vWarn(Exception e, String msg, Object ... args) {
        if (mVerbosity <= 1) {
            ALog.flogWarn((Throwable)e, (String)msg, (Object[])args);
        }
    }

    private static void vDebug(String msg, Object ... args) {
        ALog.flogDebug((String)msg, (Object[])args);
    }

    static {
        PadTemplateAdoptContext = LEFDEFParser.class.getName();
        debugTokenSpeed = false;
    }

    private class ParserDEFPropertyDefinitions
    implements ParserLEFDEFStatement {
        private ParserDEFPropertyDefinitions() {
        }

        @Override
        public boolean perform() throws MalformedLEFDEFException {
            LEFDEFParser.this.propertyDescriptors = new HashMap<APair<String, String>, DefPropertyDescriptor>();
            while (true) {
                if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_END)) break;
                String objectType = LEFDEFParser.this.read();
                PropertyValue pv = this.parsePropertyDefinition(objectType);
                if (!objectType.equals("DESIGN") || pv == null) continue;
                LEFDEFParser.this.deferredDesignProperties.add(pv);
            }
            LEFDEFParser.this.expect(LEFDEFSyntax.KW_PROPERTYDEFINITIONS);
            return true;
        }

        private PropertyValue parsePropertyDefinition(String objectType) throws MalformedLEFDEFException {
            String propName = LEFDEFParser.this.read();
            String propType = LEFDEFParser.this.read();
            PropertyType pt = PropertyType.fromDefKeyword(propType);
            if (pt == null) {
                throw new MalformedLEFDEFException(LEFDEFParser.this.fmtErrMsg("Unsupported property type: " + propType));
            }
            double min = Double.NaN;
            double max = Double.NaN;
            if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_RANGE)) {
                min = LEFDEFParser.this.eDouble();
                max = LEFDEFParser.this.eDouble();
            }
            DefPropertyDescriptor pd = new DefPropertyDescriptor(objectType, propName, pt, min, max);
            LEFDEFParser.this.propertyDescriptors.put((APair<String, String>)new APair((Object)objectType, (Object)propName), pd);
            if (!LEFDEFParser.this.accept(';')) {
                String val = LEFDEFParser.this.read();
                LEFDEFParser.this.expect(';');
                return new PropertyValue(pd, val);
            }
            return null;
        }
    }

    private class ReaderLayerGeometries
    implements ParserLEFDEFStatement {
        Map<String, Dispatch> dispatch;
        boolean exceptPGNet = false;
        double minSpacing = Double.NaN;
        double designRuleWidth = Double.NaN;
        double width = Double.NaN;
        List<LayerGeometry> layerGeometries = null;
        LayerGeometry layerGeometry = null;
        String mLayerName;

        private ReaderLayerGeometries() {
            this.dispatch = Map.ofEntries(Map.entry("PATH", this::ePath), Map.entry("RECT", this::eRect), Map.entry("POLYGON", this::ePolygon));
        }

        private void eExceptPGNet() {
            this.exceptPGNet = true;
        }

        private void eSpacing() {
            this.minSpacing = LEFDEFParser.this.eDouble();
        }

        private void eDesignRuleWidth() {
            this.designRuleWidth = LEFDEFParser.this.eDouble();
        }

        private void eWidth() throws MalformedLEFDEFException {
            this.width = LEFDEFParser.this.eDouble();
            LEFDEFParser.this.expect(';');
        }

        private PARSING_CONTROL ePath() throws MalformedLEFDEFException {
            LEFDEFParser.this.aMask();
            boolean isIterate = LEFDEFParser.this.accept(LEFDEFSyntax.KW_ITERATE);
            List<APoint2D> pts = this.aLEFPoints(x$0 -> LEFDEFParser.this.lefToDB(x$0));
            StepPattern sp = isIterate ? this.getStepPattern() : null;
            LayerGeometry lg = this.getLayerGeometry();
            LayerGeometryShape shape = new LayerGeometryShape(APath.class, pts, sp);
            lg.addShape(shape);
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL eRect() throws MalformedLEFDEFException {
            LEFDEFParser.this.aMask();
            boolean isIterate = LEFDEFParser.this.accept(LEFDEFSyntax.KW_ITERATE);
            List<APoint2D> pts = this.aLEFPoints(x$0 -> LEFDEFParser.this.lefToDB(x$0));
            StepPattern sp = isIterate ? this.getStepPattern() : null;
            LayerGeometry lg = this.getLayerGeometry();
            LayerGeometryShape shape = new LayerGeometryShape(ARect.class, pts, sp);
            lg.addShape(shape);
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL ePolygon() throws MalformedLEFDEFException {
            LEFDEFParser.this.aMask();
            boolean isIterate = LEFDEFParser.this.accept(LEFDEFSyntax.KW_ITERATE);
            List<APoint2D> pts = this.aLEFPoints(x$0 -> LEFDEFParser.this.lefToDB(x$0));
            StepPattern sp = isIterate ? this.getStepPattern() : null;
            LayerGeometry lg = this.getLayerGeometry();
            LayerGeometryShape shape = new LayerGeometryShape(APolygon.class, pts, sp);
            lg.addShape(shape);
            return PARSING_CONTROL.MORE;
        }

        public List<LayerGeometry> getLayerGeometries() {
            return this.layerGeometries;
        }

        private LayerGeometry getLayerGeometry() {
            if (this.layerGeometry == null) {
                this.layerGeometry = new LayerGeometry(this.exceptPGNet, LEFDEFParser.this.lefToDB(this.minSpacing), LEFDEFParser.this.lefToDB(this.designRuleWidth), LEFDEFParser.this.lefToDB(this.width), this.mLayerName);
            }
            return this.layerGeometry;
        }

        private StepPattern getStepPattern() throws MalformedLEFDEFException {
            LEFDEFParser.this.expect(LEFDEFSyntax.KW_DO);
            Long numX = LEFDEFParser.this.aLong();
            LEFDEFParser.this.expect(LEFDEFSyntax.KW_BY);
            Long numY = LEFDEFParser.this.aLong();
            LEFDEFParser.this.expect(LEFDEFSyntax.KW_STEP);
            Double spaceX = LEFDEFParser.this.aDouble();
            Double spaceY = LEFDEFParser.this.aDouble();
            if (numX == null || numY == null || spaceX == null || spaceY == null) {
                throw new MalformedLEFDEFException(LEFDEFParser.this.fmtErrMsg("Failed to parse stepPattern", "DO numX BY numY STEP spaceX spaceY"));
            }
            return new StepPattern(numX, numY, LEFDEFParser.this.lefToDB(spaceX), LEFDEFParser.this.lefToDB(spaceY));
        }

        private void parserObjectLevel() throws MalformedLEFDEFException {
            PARSING_CONTROL parsingLevel = PARSING_CONTROL.MORE;
            while (parsingLevel == PARSING_CONTROL.MORE) {
                parsingLevel = this.parseAttributeLevel();
            }
        }

        private PARSING_CONTROL parseAttributeLevel() throws MalformedLEFDEFException {
            String keyword = LEFDEFParser.this.peekString().toUpperCase();
            Dispatch r = this.dispatch.get(keyword);
            if (r == null) {
                return PARSING_CONTROL.DONE;
            }
            LEFDEFParser.this.read();
            return r.run();
        }

        @Override
        public boolean perform() throws MalformedLEFDEFException {
            this.layerGeometries = new LinkedList<LayerGeometry>();
            while (true) {
                this.prepareForNewLayerGeometry();
                if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_LAYER)) {
                    this.eLayer();
                    continue;
                }
                if (!LEFDEFParser.this.accept(LEFDEFSyntax.KW_VIA)) break;
                this.eVia();
            }
            return true;
        }

        private void prepareForNewLayerGeometry() {
            this.mLayerName = null;
            this.exceptPGNet = false;
            this.designRuleWidth = Double.NaN;
            this.minSpacing = Double.NaN;
            this.width = Double.NaN;
            this.layerGeometry = null;
        }

        private void eLayer() throws MalformedLEFDEFException {
            this.mLayerName = LEFDEFParser.this.read();
            if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_EXCEPTPGNET)) {
                this.eExceptPGNet();
            }
            if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_SPACING)) {
                this.eSpacing();
            } else if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_DESIGNRULEWIDTH)) {
                this.eDesignRuleWidth();
            }
            LEFDEFParser.this.expect(';');
            if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_WIDTH)) {
                this.eWidth();
            }
            this.parserObjectLevel();
            if (this.layerGeometry != null) {
                this.layerGeometries.add(this.layerGeometry);
            }
        }

        private void eVia() throws MalformedLEFDEFException {
            LEFDEFParser.this.aMask();
            boolean isIterate = LEFDEFParser.this.accept(LEFDEFSyntax.KW_ITERATE);
            APoint2D pt = this.aLEFPoint(x$0 -> LEFDEFParser.this.lefToDB(x$0));
            String viaName = LEFDEFParser.this.read();
            StepPattern sp = isIterate ? this.getStepPattern() : null;
            LayerGeometry lg = this.getLayerGeometry();
            LayerGeometryVia via = new LayerGeometryVia(viaName, pt, sp);
            lg.addVia(via);
            LEFDEFParser.this.expect(';');
            if (this.layerGeometry != null) {
                this.layerGeometries.add(this.layerGeometry);
            }
        }

        private List<APoint2D> aLEFPoints(DoubleToLongFunction unitConvert) throws MalformedLEFDEFException {
            LinkedList<APoint2D> pts = new LinkedList<APoint2D>();
            while (!LEFDEFParser.this.accept(';')) {
                APoint2D pt = this.aLEFPoint(unitConvert);
                if (pt == null) {
                    return pts;
                }
                pts.add(pt);
            }
            return pts;
        }

        private APoint2D aLEFPoint(DoubleToLongFunction unitConvert) throws MalformedLEFDEFException {
            Double dX = LEFDEFParser.this.aDouble();
            if (dX == null) {
                return null;
            }
            Double dY = LEFDEFParser.this.aDouble();
            if (dY == null) {
                throw new MalformedLEFDEFException(LEFDEFParser.this.fmtErrMsg("Failed to find y of a point"));
            }
            long x = unitConvert.applyAsLong(dX);
            long y = unitConvert.applyAsLong(dY);
            return new APoint2D(x, y);
        }
    }

    private class LayerGeometry {
        final String layerName;
        private final List<LayerGeometryShape> mShapes = new LinkedList<LayerGeometryShape>();
        private final List<LayerGeometryVia> mVias = new LinkedList<LayerGeometryVia>();
        final boolean exceptPGNet;
        final long minSpacing;
        final long designRuleWidth;
        final long width;

        private LayerGeometry() {
            throw new IllegalArgumentException("Need to use the other constructor!");
        }

        public boolean isEmpty() {
            return this.mShapes.isEmpty() && this.mVias.isEmpty();
        }

        LayerGeometry(boolean exceptPGNet, long minSpacing, long designRuleWidth, long width, String layerName) {
            this.exceptPGNet = exceptPGNet;
            this.minSpacing = minSpacing;
            this.designRuleWidth = designRuleWidth;
            this.width = width;
            this.layerName = layerName;
        }

        public String getLayerName() {
            return this.layerName;
        }

        public List<LayerGeometryShape> getShapes() {
            return this.mShapes;
        }

        public List<LayerGeometryVia> getVias() {
            return this.mVias;
        }

        public boolean getExceptPGNet() {
            return this.exceptPGNet;
        }

        public double getMinSpacing() {
            return this.minSpacing;
        }

        public double getDesignRuleWidth() {
            return this.designRuleWidth;
        }

        public double getWidth() {
            return this.width;
        }

        public void addShape(LayerGeometryShape shape) {
            this.mShapes.add(shape);
        }

        public void addVia(LayerGeometryVia via) {
            this.mVias.add(via);
        }

        public List<LayerShape> convertToLayerShapes(Layer layer) throws MalformedLEFDEFException {
            LayerShape ls;
            LinkedList<LayerShape> shapes = new LinkedList<LayerShape>();
            long w = this.width <= 0L ? layer.getWidth() : this.width;
            for (LayerGeometryShape s : this.mShapes) {
                ls = s.convertToLayerShape(layer, w);
                if (ls == null) continue;
                shapes.add(ls);
            }
            for (LayerGeometryVia v : this.mVias) {
                ls = v.convertToLayerShape(layer, w);
                if (ls == null) continue;
                shapes.add(ls);
            }
            return shapes;
        }
    }

    private static class LayerGeometryVia {
        private final String viaName;
        private final APoint2D pt;
        private final StepPattern stepPattern;

        LayerGeometryVia(String viaName, APoint2D pt, StepPattern stepPattern) {
            this.viaName = viaName;
            this.pt = pt;
            this.stepPattern = stepPattern;
        }

        public APoint2D getPt() {
            return this.pt;
        }

        public StepPattern getStepPattern() {
            return this.stepPattern;
        }

        public LayerShape convertToLayerShape(Layer layer, long width) {
            LEFDEFParser.vWarn("VIA in PORT of MACRO PIN is not supported yet. VIA name: '%s'.", this.viaName);
            return null;
        }
    }

    private class LayerGeometryShape {
        final Class<? extends AGeom> type;
        final List<APoint2D> pts;
        final StepPattern stepPattern;

        LayerGeometryShape(Class<? extends AGeom> type, List<APoint2D> pts, StepPattern stepPattern) {
            this.type = type;
            this.pts = pts;
            this.stepPattern = stepPattern;
        }

        public List<APoint2D> getPts() {
            return this.pts;
        }

        public StepPattern getStepPattern(StepPattern pattern) {
            return this.stepPattern;
        }

        public LayerShape convertToLayerShape(Layer layer, long width) throws MalformedLEFDEFException {
            if (this.type.equals(APolygon.class)) {
                APolygon poly = new APolygon(this.pts);
                return LayerShape.create(null, (Layer)layer, null, (AGeom)poly);
            }
            if (this.type.equals(APath.class)) {
                APath path = new APath(width, this.pts);
                return LayerShape.create(null, (Layer)layer, null, (AGeom)path);
            }
            if (this.type.equals(ARect.class)) {
                ARect rect = ARect.create((APoint2D)this.pts.get(0), (APoint2D)this.pts.get(1));
                return LayerShape.create(null, (Layer)layer, null, (AGeom)rect);
            }
            throw new MalformedLEFDEFException(LEFDEFParser.this.fmtErrMsg("Unrecognized geometry type:" + this.type));
        }
    }

    private class StepPattern {
        long numX;
        long numY;
        long spaceX;
        long spaceY;

        StepPattern(long numX, long numY, long spaceX, long spaceY) {
            this.numX = numX;
            this.numY = numY;
            this.spaceX = spaceX;
            this.spaceY = spaceY;
        }
    }

    private class ParserMacro
    implements ParserLEFDEFStatement {
        long templateDx = 0L;
        long templateDy = 0L;
        boolean doNotAdd = false;
        DeviceTemplate mDeviceTemplate = null;
        Map<String, Dispatch> dispatch = Map.ofEntries(Map.entry("CLASS", this::eClass), Map.entry("FIXEDMASK", this::eFixedMask), Map.entry("FOREIGN", this::eForeign), Map.entry("ORIGIN", this::eOrigin), Map.entry("EEQ", this::eEEQ), Map.entry("SIZE", this::eSize), Map.entry("SYMMETRY", this::eSymmetry), Map.entry("SITE", this::eSite), Map.entry("PIN", this::ePin), Map.entry("OBS", this::eOBS), Map.entry("DENSITY", this::eDensity), Map.entry("PROPERTY", this::eProperty), Map.entry("END", this::eEnd));
        ParserMacroPin parserMacroPin = null;
        private Pattern readOBSLayers = null;
        private Set<String> mDidShowSkipInfo = new HashSet<String>();
        String section;
        String mMacroName;

        DeviceTemplate getTemplate() {
            return this.mDeviceTemplate;
        }

        private ParserMacro() {
        }

        private PARSING_CONTROL eClass() throws MalformedLEFDEFException {
            String type = LEFDEFParser.this.read().toUpperCase();
            if (type.equals("COVER")) {
                this.processClassCover();
            } else if (type.equals("RING")) {
                this.processClassRing();
            } else if (type.equals("BLOCK")) {
                this.processClassBlock();
            } else if (type.equals("PAD")) {
                this.processClassPad();
            } else if (type.equals("CORE")) {
                this.processClassCore();
            } else if (type.equals("ENDCAP")) {
                this.processClassEndcap();
            } else {
                throw new MalformedLEFDEFException(LEFDEFParser.this.fmtErrMsg("Unknown CLASS: " + type + " in MACRO " + this.mDeviceTemplate.getName()));
            }
            LEFDEFParser.this.expect(';');
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL eFixedMask() throws MalformedLEFDEFException {
            LEFDEFParser.this.expect(';');
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL eForeign() throws MalformedLEFDEFException {
            try {
                String foreignCellName = LEFDEFParser.this.read();
                if (!foreignCellName.isEmpty()) {
                    APoint2D pt = null;
                    String orient = "";
                    Double v = LEFDEFParser.this.aDouble();
                    if (v != null) {
                        long ptx = LEFDEFParser.this.toDB(v);
                        long pty = LEFDEFParser.this.toDB(LEFDEFParser.this.eDouble());
                        pt = new APoint2D(ptx, pty);
                        if (!LEFDEFParser.this.accept(';')) {
                            orient = LEFDEFParser.this.read();
                            LEFDEFParser.this.expect(';');
                        }
                    } else {
                        LEFDEFParser.this.expect(';');
                    }
                    this.mDeviceTemplate.setValue(LEFDEFParser.FLDNAME_LEFDEF_FOREIGN, (Object)foreignCellName);
                    if (pt != null) {
                        this.mDeviceTemplate.setValue(LEFDEFParser.FLDNAME_LEFDEF_FOREIGN_PT, pt);
                    }
                    if (!orient.isEmpty()) {
                        this.mDeviceTemplate.setValue(LEFDEFParser.FLDNAME_LEFDEF_FOREIGN_ORIENT, (Object)orient);
                    }
                    return PARSING_CONTROL.MORE;
                }
                throw new MalformedLEFDEFException(LEFDEFParser.this.fmtErrMsg("Failed to find foreignCellName in " + this.section));
            }
            catch (NumberFormatException e) {
                String err = LEFDEFParser.this.fmtErrMsg("pt");
                throw new MalformedLEFDEFException(err);
            }
        }

        private PARSING_CONTROL eOrigin() throws MalformedLEFDEFException {
            this.processOrigin();
            LEFDEFParser.this.expect(';');
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL eEEQ() throws MalformedLEFDEFException {
            LEFDEFParser.this.read();
            LEFDEFParser.this.expect(';');
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL eSize() throws MalformedLEFDEFException {
            this.processSize();
            LEFDEFParser.this.expect(';');
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL eSymmetry() throws MalformedLEFDEFException {
            LEFDEFParser.this.eLEFSymmetry();
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL eSite() throws MalformedLEFDEFException {
            LEFDEFParser.this.read();
            if (!LEFDEFParser.this.accept(';')) {
                LEFDEFParser.this.read();
                LEFDEFParser.this.expect(';');
            }
            return PARSING_CONTROL.MORE;
        }

        private ParserMacroPin getParserMacroPin() {
            if (this.parserMacroPin == null) {
                this.parserMacroPin = new ParserMacroPin(this);
            }
            return this.parserMacroPin;
        }

        private PARSING_CONTROL ePin() throws MalformedLEFDEFException {
            this.parserMacroPin = this.getParserMacroPin();
            this.parserMacroPin.perform();
            return PARSING_CONTROL.MORE;
        }

        Pattern getReadOBSLayers() {
            if (this.readOBSLayers == null) {
                this.readOBSLayers = Pattern.compile(LEFDEFParser.this.mObstacleLayerToRead);
            }
            return this.readOBSLayers;
        }

        private boolean isOBSLayer(String layerName) {
            if (LEFDEFParser.this.mObstacleLayerToRead == null) {
                return false;
            }
            return this.getReadOBSLayers().matcher(layerName).find();
        }

        private PARSING_CONTROL eOBS() throws MalformedLEFDEFException {
            LEFDEFParser.this.readerLayerGeometries.perform();
            List<LayerGeometry> lgs = LEFDEFParser.this.readerLayerGeometries.getLayerGeometries();
            LinkedList<LayerGeometry> doLgs = new LinkedList<LayerGeometry>();
            for (LayerGeometry lg : lgs) {
                String layerName = lg.getLayerName();
                if (layerName == null || layerName.isEmpty()) continue;
                boolean doLayer = this.isOBSLayer(layerName);
                if (!doLayer && !this.mDidShowSkipInfo.contains(layerName)) {
                    this.mDidShowSkipInfo.add(layerName);
                    LEFDEFParser.vDetails("Skip layer %s as it is not in read OBS layers pattern.", layerName);
                    continue;
                }
                doLgs.add(lg);
            }
            LEFDEFParser.this.expect(LEFDEFSyntax.KW_END);
            this.applyOBS(doLgs);
            return PARSING_CONTROL.MORE;
        }

        private void applyOBS(List<LayerGeometry> lgs) throws MalformedLEFDEFException {
            if (lgs.isEmpty()) {
                return;
            }
            Obstacle obs = Obstacle.create((Db)LEFDEFParser.this.mDb, (Obstacle.ObstacleType)Obstacle.ObstacleType.Routing, (DeviceTemplate)LEFDEFParser.this.mCurrentDeviceTemplate);
            for (LayerGeometry lg : lgs) {
                String layerName = lg.getLayerName();
                Layer l = LEFDEFParser.this.getLayer(layerName);
                List<LayerShape> s = lg.convertToLayerShapes(l);
                for (LayerShape ls : s) {
                    obs.addLayerShape(ls);
                }
            }
        }

        private PARSING_CONTROL eDensity() {
            LEFDEFParser.this.after(LEFDEFSyntax.KW_END);
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL eProperty() throws MalformedLEFDEFException {
            this.processProperty();
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL eEnd() throws MalformedLEFDEFException {
            LEFDEFParser.this.expect(this.mMacroName);
            return PARSING_CONTROL.DONE;
        }

        private void parserObjectLevel() throws MalformedLEFDEFException {
            PARSING_CONTROL parsingLevel = PARSING_CONTROL.MORE;
            while (parsingLevel == PARSING_CONTROL.MORE) {
                parsingLevel = this.parseAttributeLevel();
            }
        }

        private PARSING_CONTROL parseAttributeLevel() throws MalformedLEFDEFException {
            String keyword;
            while (";".equals(keyword = LEFDEFParser.this.read())) {
                LEFDEFParser.vError("UNEXPECTED ';' near line %d.", LEFDEFParser.this.mCurLine);
            }
            Dispatch r = this.dispatch.get(keyword.toUpperCase());
            if (r == null) {
                LEFDEFParser.vWarn("Error parsing 'MACRO %s'! Keyword '%s' is not in LEF spec. Near line %d. Skipped.", this.mMacroName, keyword, LEFDEFParser.this.mCurLine);
                return LEFDEFParser.this.tillLEFEOS();
            }
            return r.run();
        }

        @Override
        public boolean perform() throws MalformedLEFDEFException {
            this.mMacroName = LEFDEFParser.this.read();
            if (this.mMacroName.isEmpty()) {
                throw new MalformedLEFDEFException(LEFDEFParser.this.fmtErrMsg("No macroName found!", "MACRO macroName"));
            }
            this.section = "MACRO " + this.mMacroName;
            this.templateDx = 0L;
            this.templateDy = 0L;
            this.doNotAdd = false;
            LEFDEFParser.vDebug("Reading template '%s'.", this.mMacroName);
            DeviceTemplate existingTemplate = DeviceTemplate.getDeviceTemplate((Substrate)LEFDEFParser.this.mSubstrate, (String)this.mMacroName);
            if (existingTemplate != null && LEFDEFParser.this.mIgnoreExistingTemplates) {
                LEFDEFParser.vDebug("DeviceTemplate '%s' already exists, ignore the macro by that name.", this.mMacroName);
                LEFDEFParser.this.mCurrentDeviceTemplate = null;
                return LEFDEFParser.this.after(LEFDEFSyntax.KW_END, this.mMacroName);
            }
            this.mDeviceTemplate = DeviceTemplate.create((Substrate)LEFDEFParser.this.mSubstrate, (String)this.mMacroName, (!LEFDEFParser.this.mIgnoreExistingTemplates ? 1 : 0) != 0);
            LEFDEFParser.this.mUnscaledDeviceTemplates.add(this.mDeviceTemplate);
            Context context = LEFDEFParser.this.getContext();
            context.mCreatedDeviceTemplates.add(this.mDeviceTemplate);
            if (context.mLefUnitName != null) {
                this.mDeviceTemplate.setValue("sourceUnitName", (Object)context.mLefUnitName);
            }
            if (context.mLefDbuPerLefUnit != null) {
                this.mDeviceTemplate.setValue("sourceUnitDbuPer", (Object)context.mLefDbuPerLefUnit);
            }
            if (!this.mDeviceTemplate.getName().equals(this.mMacroName) && !LEFDEFParser.this.mUpdateExistingTemplates) {
                LEFDEFParser.vDebug("The template '%s' already exists in the design, the macro is being read into a new template named '%s'. The existing template will be replaced momentarily.", this.mMacroName, this.mDeviceTemplate.getName());
            }
            this.mDeviceTemplate.setSourceType(DeviceTemplate.SourceType.LEFDEF);
            this.mDeviceTemplate.setSourceFile(LEFDEFParser.this.mFileName);
            this.mDeviceTemplate.setSourceFileModifiedTime(LEFDEFParser.this.getFile().lastModified());
            LEFDEFParser.this.mFileMD5.ifPresent(md5 -> this.mDeviceTemplate.setValue(FLDNAME_MD5, md5));
            LEFDEFParser.this.mCurrentDeviceTemplate = this.mDeviceTemplate;
            LEFDEFParser.this.mCurrentDeviceTemplate.setType(DefaultMacroType);
            this.mDeviceTemplate.setSubstrate(LEFDEFParser.this.mSubstrate);
            this.parserObjectLevel();
            int pinsCountWithNoArea = 0;
            if (LEFDEFParser.this.mCurrentDeviceTemplate.getBounds() == null) {
                LEFDEFParser.vWarn("Macro '%s' does not seem to have any SIZE defined. The bounds will be defined by PIN extents.", this.mMacroName);
                ARect fake = new ARect(0L, 0L, 0L, 0L);
                for (PinTemplate pt : LEFDEFParser.this.mCurrentDeviceTemplate.getPins()) {
                    ARect r = pt.getBounds();
                    if (r != null) {
                        fake.expand(pt.getBounds());
                        continue;
                    }
                    ++pinsCountWithNoArea;
                }
                if (pinsCountWithNoArea > 0) {
                    LEFDEFParser.vWarn("Macro " + this.mMacroName + " has " + pinsCountWithNoArea + " pins with no area defined.", new Object[0]);
                }
                LEFDEFParser.this.mCurrentDeviceTemplate.setBounds((AGeom)fake);
            }
            if (this.doNotAdd) {
                LEFDEFParser.this.getContext().mCreatedDeviceTemplates.remove(LEFDEFParser.this.mCurrentDeviceTemplate);
                LEFDEFParser.this.mCurrentDeviceTemplate.deleteFromDb();
            } else if (!this.mDeviceTemplate.getName().equals(this.mMacroName) && LEFDEFParser.this.mUpdateExistingTemplates) {
                this.markSourceReplaced(existingTemplate);
                existingTemplate.replaceWith(this.mDeviceTemplate);
                existingTemplate.deleteFromDb();
                this.mDeviceTemplate.setName(this.mMacroName);
            }
            return true;
        }

        private void markSourceReplaced(DeviceTemplate dt) {
            LEFDEFParser.this.mReplacedLEFs.add(dt.getSourceFile());
        }

        private void processSize() throws MalformedLEFDEFException {
            try {
                double xSize = LEFDEFParser.this.eDouble();
                LEFDEFParser.this.expect(LEFDEFSyntax.KW_BY);
                double ySize = LEFDEFParser.this.eDouble();
                APoint2D ll = APoint2D.Zero();
                APoint2D ur = new APoint2D(LEFDEFParser.this.lefToDB(xSize), LEFDEFParser.this.lefToDB(ySize));
                ARect r = ARect.create((APoint2D)ll, (APoint2D)ur);
                r.moveBy(-this.templateDx, -this.templateDy);
                LEFDEFParser.this.mCurrentDeviceTemplate.setBounds((AGeom)r);
            }
            catch (NumberFormatException e) {
                String err = LEFDEFParser.this.fmtErrMsg("SIZE width BY height");
                throw new MalformedLEFDEFException(err);
            }
        }

        private void processClassCover() {
            DeviceTemplate.Type type = LEFDEFParser.this.accept(LEFDEFSyntax.KW_BUMP) ? DeviceTemplate.Type.BUMP : DeviceTemplate.Type.COVER;
            boolean bl = this.doNotAdd = !LEFDEFParser.this.mReadCovers;
            if (LEFDEFParser.this.mReadCovers) {
                LEFDEFParser.this.mCurrentDeviceTemplate.setType(type);
            }
        }

        private void processClassRing() {
            boolean bl = this.doNotAdd = !LEFDEFParser.this.mReadRings;
            if (LEFDEFParser.this.mReadRings) {
                LEFDEFParser.this.mCurrentDeviceTemplate.setType(DeviceTemplate.Type.RING);
            }
        }

        private void processClassBlock() {
            boolean bl = this.doNotAdd = !LEFDEFParser.this.mReadBlocks;
            if (LEFDEFParser.this.mReadBlocks) {
                if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_BLOCK_BLACKBOX)) {
                    LEFDEFParser.this.mCurrentDeviceTemplate.setType(DeviceTemplate.Type.HARDMACRO);
                } else if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_BLOCK_SOFT)) {
                    LEFDEFParser.this.mCurrentDeviceTemplate.setType(DeviceTemplate.Type.SOFTMACRO);
                } else {
                    LEFDEFParser.this.mCurrentDeviceTemplate.setType(DeviceTemplate.Type.BLOCK);
                }
            }
        }

        private void processClassPad() {
            if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_INPUT) || LEFDEFParser.this.accept(LEFDEFSyntax.KW_OUTPUT) || LEFDEFParser.this.accept(LEFDEFSyntax.KW_INOUT) || LEFDEFParser.this.accept(LEFDEFSyntax.KW_POWER) || LEFDEFParser.this.accept(LEFDEFSyntax.KW_SPACER) || LEFDEFParser.this.accept(LEFDEFSyntax.KW_AREAIO)) {
                // empty if block
            }
            LEFDEFParser.this.mCurrentDeviceTemplate.setType(DeviceTemplate.Type.PAD);
        }

        private void processClassCore() {
            if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_FEEDTHRU) || LEFDEFParser.this.accept(LEFDEFSyntax.KW_TIEHIGH) || LEFDEFParser.this.accept(LEFDEFSyntax.KW_TIELOW) || LEFDEFParser.this.accept(LEFDEFSyntax.KW_SPACER) || LEFDEFParser.this.accept(LEFDEFSyntax.KW_ANTENNACELL) || LEFDEFParser.this.accept(LEFDEFSyntax.KW_WELLTAP)) {
                // empty if block
            }
            boolean bl = this.doNotAdd = !LEFDEFParser.this.mReadCores;
            if (LEFDEFParser.this.mReadCores) {
                LEFDEFParser.this.mCurrentDeviceTemplate.setType(DeviceTemplate.Type.CORE);
            }
        }

        private void processClassEndcap() throws MalformedLEFDEFException {
            if (!(LEFDEFParser.this.accept(LEFDEFSyntax.KW_PRE) || LEFDEFParser.this.accept(LEFDEFSyntax.KW_POST) || LEFDEFParser.this.accept(LEFDEFSyntax.KW_TOPLEFT) || LEFDEFParser.this.accept(LEFDEFSyntax.KW_TOPRIGHT) || LEFDEFParser.this.accept(LEFDEFSyntax.KW_BOTTOMLEFT) || LEFDEFParser.this.accept(LEFDEFSyntax.KW_BOTTOMRIGHT))) {
                throw new MalformedLEFDEFException(LEFDEFParser.this.fmtErrMsg(LEFDEFParser.this.read(), "PRE | POST | TOPLEFT | TOPRIGHT | BOTTOMLEFT | BOTTOMRIGHT"));
            }
            boolean bl = this.doNotAdd = !LEFDEFParser.this.mReadEndCaps;
            if (LEFDEFParser.this.mReadEndCaps) {
                LEFDEFParser.this.mCurrentDeviceTemplate.setType(DeviceTemplate.Type.ENDCAP);
            }
        }

        private void processOrigin() throws MalformedLEFDEFException {
            try {
                this.templateDx = LEFDEFParser.this.lefToDB(LEFDEFParser.this.eDouble());
                this.templateDy = LEFDEFParser.this.lefToDB(LEFDEFParser.this.eDouble());
                ARect r = LEFDEFParser.this.mCurrentDeviceTemplate.getBB();
                r.moveBy(-this.templateDx, -this.templateDy);
                LEFDEFParser.this.mCurrentDeviceTemplate.setBounds((AGeom)new ARect(r));
            }
            catch (NumberFormatException e) {
                String err = LEFDEFParser.this.fmtErrMsg("ORIGIN pt ");
                throw new MalformedLEFDEFException(err);
            }
        }

        private void processProperty() throws MalformedLEFDEFException {
            PropertyValue pv = LEFDEFParser.this.parseProperty("MACRO");
            if (pv.getDesc() != null && pv.getDesc().name.equals(LEFDEFParser.PROPNAME_DEFOUTIGNORE) && Integer.parseInt(pv.getValue()) != 0) {
                this.mDeviceTemplate.setValue(LEFDEFParser.FLDNAME_IGNOREONWRITE, (Object)true);
            }
        }
    }

    private class ParserMacroPin
    implements ParserLEFDEFStatement {
        Map<String, Dispatch> dispatch;
        ParserMacro mParentParser = null;
        private Set<String> mDidShowSkipInfo;
        String mPinName = "";
        Term mTerm = null;
        Net mNet = null;
        boolean didCreatePinTemplate = false;

        private ParserMacroPin() {
            throw new IllegalArgumentException("Do NOT call this constructor! Should call the other one with parent parser supplied.");
        }

        ParserMacroPin(ParserMacro parentParser) {
            this.mParentParser = parentParser;
            this.dispatch = Map.ofEntries(Map.entry("TAPERRULE", this::parseTaperRule), Map.entry("DIRECTION", this::parseDirection), Map.entry("USE", this::parseUse), Map.entry("NETEXPR", this::parseNetExpr), Map.entry("SUPPLYSENSITIVITY", this::parseSupplySensitivity), Map.entry("GROUNDSENSITIVITY", this::parseGroundSensitivity), Map.entry("SHAPE", this::parseShape), Map.entry("MUSTJOIN", this::parseMustJoin), Map.entry("PORT", this::parsePort), Map.entry("PROPERTY", this::parseProperty), Map.entry("END", this::parseEnd), Map.entry("ANTENNAPARTIALMETALAREA", this::parseAntennaPartialMetalArea), Map.entry("ANTENNAPARTIALMETALSIDEAREA", this::parseAntennaPartialMetalSideArea), Map.entry("ANTENNAPARTIALCUTAREA", this::parseAntennaPartialCutArea), Map.entry("ANTENNADIFFAREA", this::parseAntennaDiffArea), Map.entry("ANTENNAMODEL", this::parseAntennaModel), Map.entry("ANTENNAGATEAREA", this::parseAntennaGateArea), Map.entry("ANTENNAMAXAREACAR", this::parseAntennaMaxAreaCAR), Map.entry("ANTENNAMAXSIDEAREACAR", this::parseAntennaMaxSideAreaCAR), Map.entry("ANTENNAMAXCUTCAR", this::parseAntennaMaxCutCAR));
            this.mDidShowSkipInfo = new HashSet<String>();
        }

        private PARSING_CONTROL parseTaperRule() throws MalformedLEFDEFException {
            String ruleName = LEFDEFParser.this.read();
            if (ruleName.isEmpty()) {
                throw new MalformedLEFDEFException(LEFDEFParser.this.fmtErrMsg("Failed to find ruleName", "TAPERRULE ruleName"));
            }
            LEFDEFParser.this.expect(';');
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL parseDirection() throws MalformedLEFDEFException {
            String token = LEFDEFParser.this.read();
            String direction = token.toUpperCase();
            if ("OUTPUT".equals(direction)) {
                LEFDEFParser.this.accept(LEFDEFSyntax.KW_TRISTATE);
            }
            if (this.mTerm != null) {
                this.mTerm.setType(LEFDEFSyntax.PinDirection.getTermType(direction));
            }
            LEFDEFParser.this.expect(';');
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL parseUse() throws MalformedLEFDEFException {
            String token = LEFDEFParser.this.read();
            String use = token.toUpperCase();
            if (this.mTerm != null) {
                this.mTerm.setUse(LEFDEFSyntax.PinUse.getTermUse(use));
            }
            LEFDEFParser.this.expect(';');
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL parseNetExpr() throws MalformedLEFDEFException {
            LEFDEFParser.this.read();
            LEFDEFParser.this.expect(';');
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL parseSupplySensitivity() throws MalformedLEFDEFException {
            LEFDEFParser.this.read();
            LEFDEFParser.this.expect(';');
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL parseGroundSensitivity() throws MalformedLEFDEFException {
            LEFDEFParser.this.read();
            LEFDEFParser.this.expect(';');
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL parseShape() throws MalformedLEFDEFException {
            LEFDEFParser.this.read();
            LEFDEFParser.this.expect(';');
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL parseMustJoin() throws MalformedLEFDEFException {
            LEFDEFParser.this.read();
            LEFDEFParser.this.expect(';');
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL parsePort() throws MalformedLEFDEFException {
            String portClass = null;
            if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_CLASS)) {
                portClass = LEFDEFParser.this.read();
                LEFDEFParser.this.expect(';');
            }
            LEFDEFParser.this.readerLayerGeometries.perform();
            List<LayerGeometry> lgs = LEFDEFParser.this.readerLayerGeometries.getLayerGeometries();
            LinkedList<LayerGeometry> doLgs = new LinkedList<LayerGeometry>();
            for (LayerGeometry lg : lgs) {
                String layerName = lg.getLayerName();
                if (layerName == null || layerName.isEmpty()) continue;
                boolean doLayer = this.isLayerUsable(layerName);
                if (!doLayer && !this.mDidShowSkipInfo.contains(layerName)) {
                    this.mDidShowSkipInfo.add(layerName);
                    LEFDEFParser.vDetails("Skip layer %s as it is in ignored pattern.", layerName);
                    continue;
                }
                doLgs.add(lg);
            }
            LEFDEFParser.this.expect(LEFDEFSyntax.KW_END);
            this.applyPort(portClass, doLgs);
            return PARSING_CONTROL.MORE;
        }

        private void applyPort(String portClass, List<LayerGeometry> lgs) throws MalformedLEFDEFException {
            Function<List, ARect> getCumulativeBB = shapes -> {
                ARect bb = null;
                for (LayerShape shape : shapes) {
                    if (bb == null) {
                        bb = new ARect(shape.getBounds());
                        continue;
                    }
                    bb.expand(shape.getBounds());
                }
                return bb;
            };
            LinkedList<LayerShape> shapes2 = new LinkedList<LayerShape>();
            for (LayerGeometry lg : lgs) {
                String layerName = lg.getLayerName();
                Layer l = LEFDEFParser.this.getLayer(layerName);
                List<LayerShape> s = lg.convertToLayerShapes(l);
                shapes2.addAll(s);
            }
            ARect bb = getCumulativeBB.apply(shapes2);
            if (bb != null) {
                PinTemplate pinTemplate = this.createPinTemplate(portClass);
                this.createPortTemplate(pinTemplate, portClass, bb, shapes2);
                PinLabel pl = PinLabel.get((PinTemplate)pinTemplate);
                pl.setTerm(this.mTerm);
            }
        }

        private PinTemplate createPinTemplate(String portClass) {
            PinTemplate pinTemplate = null;
            if (LEFDEFParser.this.doCreateOnyOnePinForAllMacroPinPorts) {
                pinTemplate = this.mNet.getPinTemplate(this.mPinName);
            }
            if (pinTemplate == null) {
                pinTemplate = PinTemplate.create((Net)this.mNet, (String)this.mPinName);
                if (this.mTerm != null) {
                    pinTemplate.setDirection(LEFDEFSyntax.PinDirection.getPinTemplateDirection(this.mTerm.getType()));
                    pinTemplate.setUse(LEFDEFSyntax.PinUse.getPinTemplateUse(this.mTerm.getUse()));
                }
                if ("BUMP".equalsIgnoreCase(portClass)) {
                    pinTemplate.setType(PinTemplate.Type.IOPAD);
                } else if ("CORE".equalsIgnoreCase(portClass)) {
                    pinTemplate.setType(PinTemplate.Type.CORE);
                }
            }
            this.didCreatePinTemplate = true;
            return pinTemplate;
        }

        private PortTemplate createPortTemplate(PinTemplate pinTemplate, String portClass, ARect bb, List<LayerShape> shapes) {
            PadTemplate padTemplate = PadTemplate.create((Db)LEFDEFParser.this.mDb, (Substrate)LEFDEFParser.this.mSubstrate, (String)"P");
            for (LayerShape shape : shapes) {
                shape.getGeom().moveBy(-bb.centerX(), -bb.centerY());
                shape.setOwner((DbObject)padTemplate);
                LEFDEFParser.this.mDb.add((DbObject)shape);
                LEFDEFParser.this.mUnscaledLayerShapes.add(shape);
            }
            PortTemplate portTemplate = PortTemplate.create((PinTemplate)pinTemplate);
            portTemplate.setLoc(bb.center());
            portTemplate.setPadTemplate(padTemplate);
            if (portClass != null) {
                portTemplate.setValue("DieAbstract.CLASS", (Object)portClass);
            }
            return portTemplate;
        }

        private PARSING_CONTROL parseProperty() throws MalformedLEFDEFException {
            this.processProperty();
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL parseEnd() throws MalformedLEFDEFException {
            LEFDEFParser.this.expect(this.mPinName);
            return PARSING_CONTROL.DONE;
        }

        private PARSING_CONTROL parseAntennaPartialMetalArea() throws MalformedLEFDEFException {
            return LEFDEFParser.this.tillLEFEOS();
        }

        private PARSING_CONTROL parseAntennaPartialMetalSideArea() throws MalformedLEFDEFException {
            return LEFDEFParser.this.tillLEFEOS();
        }

        private PARSING_CONTROL parseAntennaPartialCutArea() throws MalformedLEFDEFException {
            return LEFDEFParser.this.tillLEFEOS();
        }

        private PARSING_CONTROL parseAntennaDiffArea() throws MalformedLEFDEFException {
            return LEFDEFParser.this.tillLEFEOS();
        }

        private PARSING_CONTROL parseAntennaModel() throws MalformedLEFDEFException {
            return LEFDEFParser.this.tillLEFEOS();
        }

        private PARSING_CONTROL parseAntennaGateArea() throws MalformedLEFDEFException {
            return LEFDEFParser.this.tillLEFEOS();
        }

        private PARSING_CONTROL parseAntennaMaxAreaCAR() throws MalformedLEFDEFException {
            return LEFDEFParser.this.tillLEFEOS();
        }

        private PARSING_CONTROL parseAntennaMaxSideAreaCAR() throws MalformedLEFDEFException {
            return LEFDEFParser.this.tillLEFEOS();
        }

        private PARSING_CONTROL parseAntennaMaxCutCAR() throws MalformedLEFDEFException {
            return LEFDEFParser.this.tillLEFEOS();
        }

        private void processProperty() throws MalformedLEFDEFException {
            PropertyValue pv = LEFDEFParser.this.parseProperty("PIN");
            if (pv.getDesc() != null && pv.getDesc().name.equals(LEFDEFParser.PROPNAME_DEFOUTIGNORE) && Integer.parseInt(pv.getValue()) != 0) {
                this.mParentParser.getTemplate().setValue(LEFDEFParser.FLDNAME_IGNOREONWRITE, (Object)true);
            }
        }

        private void parserObjectLevel() throws MalformedLEFDEFException {
            PARSING_CONTROL parsingLevel = PARSING_CONTROL.MORE;
            while (parsingLevel == PARSING_CONTROL.MORE) {
                parsingLevel = this.parseAttributeLevel();
            }
        }

        private PARSING_CONTROL parseAttributeLevel() throws MalformedLEFDEFException {
            String keyword = LEFDEFParser.this.read();
            Dispatch r = this.dispatch.get(keyword.toUpperCase());
            if (r == null) {
                LEFDEFParser.vWarn("Error parsing 'PIN %s'! '%s' is not in LEF 5.7/5.8 spec. Near line %d. Skipped.", this.mPinName, keyword, LEFDEFParser.this.mCurLine);
                return LEFDEFParser.this.tillLEFEOS();
            }
            return r.run();
        }

        @Override
        public boolean perform() throws MalformedLEFDEFException {
            this.mPinName = LEFDEFParser.this.read();
            if (this.mPinName.isEmpty()) {
                throw new MalformedLEFDEFException(LEFDEFParser.this.fmtErrMsg("Failed to find pinName", "PIN pinName"));
            }
            this.mNet = LEFDEFParser.this.mCurrentDeviceTemplate.getNetUnused();
            if (LEFDEFParser.this.mCreateDefaultNetNamesOnPins) {
                String netname = String.format("%s%s", LEFDEFParser.this.mUseNetPrefix ? "Net" : "", this.mPinName);
                this.mNet = Net.getOrCreate((DeviceTemplate)LEFDEFParser.this.mCurrentDeviceTemplate, (String)netname);
                if (this.mNet == null) {
                    String err = String.format("Can not add net '%s', in parsing 'PIN %s', near line %d.", netname, this.mPinName, LEFDEFParser.this.mCurLine);
                    LEFDEFParser.vError(err, new Object[0]);
                    throw new IllegalArgumentException(err);
                }
            }
            this.didCreatePinTemplate = false;
            this.mTerm = this.mNet.isNC() ? null : Term.create((String)this.mPinName, (Net)this.mNet);
            this.parserObjectLevel();
            if (LEFDEFParser.this.doCreateNoPortPin && !this.didCreatePinTemplate) {
                PinTemplate pinTemplate = this.createPinTemplate("NONE");
                PinLabel pl = PinLabel.get((PinTemplate)pinTemplate);
                pl.setTerm(this.mTerm);
                LEFDEFParser.vWarn("Create no shape pin: %s", this.mPinName);
            }
            if (this.mTerm != null && !LEFDEFParser.this.mKeepEmptyPins && !this.didCreatePinTemplate) {
                this.mTerm.deleteFromDb();
            }
            return true;
        }

        private boolean isLayerUsable(String layerName) {
            if (LEFDEFParser.this.mIgnoreLayerPattern == null) {
                return true;
            }
            return !LEFDEFParser.this.mIgnoreLayerPattern.matcher(layerName).matches();
        }
    }

    private class ParserLEFWidth
    implements ParserLEFDEFStatement {
        double minWidth;
        double maxWidth;

        private ParserLEFWidth() {
        }

        double getMinWidth() {
            return this.minWidth;
        }

        double getMaxWidth() {
            return this.maxWidth;
        }

        @Override
        public boolean perform() throws MalformedLEFDEFException {
            this.minWidth = LEFDEFParser.this.eDouble();
            LEFDEFParser.this.expect(LEFDEFSyntax.KW_TO);
            this.maxWidth = LEFDEFParser.this.eDouble();
            LEFDEFParser.this.expect(';');
            return true;
        }
    }

    private class ParserLEFViaRuleGenerate
    implements ParserLEFDEFStatement {
        ViaRuleGenerate vrg = null;
        String viaRuleName;

        private ParserLEFViaRuleGenerate() {
        }

        public void setViaRuleName(String name) {
            this.viaRuleName = name;
        }

        @Override
        public boolean perform() throws MalformedLEFDEFException {
            ViaRuleGenerate.get((Substrate)LEFDEFParser.this.mSubstrate, (String)this.viaRuleName);
            this.vrg = ViaRuleGenerate.get((Substrate)LEFDEFParser.this.mSubstrate, (String)this.viaRuleName);
            if (this.vrg == null) {
                this.vrg = ViaRuleGenerate.create((Substrate)LEFDEFParser.this.mSubstrate, (String)this.viaRuleName);
            }
            if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_DEFAULT)) {
                this.vrg.setIsDefault(true);
            }
            boolean firstRoutingLayer = true;
            for (int i = 0; i < 3; ++i) {
                LEFDEFParser.this.expect(LEFDEFSyntax.KW_LAYER);
                String layerName = LEFDEFParser.this.read();
                Layer l = LEFDEFParser.this.mSubstrate.getLayer(layerName);
                if (l == null) {
                    LEFDEFParser.vWarn("LEF VIARULE, LAYER '%s' is not defined. Near line %d.", layerName, LEFDEFParser.this.mCurLine);
                }
                LEFDEFParser.this.expect(';');
                if (l != null && l.getType() == Layer.LayerType.Cut) {
                    this.eCutLayer(l);
                    continue;
                }
                this.eRoutingLayer(firstRoutingLayer, l);
                firstRoutingLayer = false;
            }
            LEFDEFParser.this.expect(LEFDEFSyntax.KW_END);
            LEFDEFParser.this.expect(this.viaRuleName);
            return true;
        }

        private void eRoutingLayer(boolean firstRoutingLayer, Layer l) throws MalformedLEFDEFException {
            if (l != null) {
                this.vrg.setLayer(firstRoutingLayer, l);
            }
            LEFDEFParser.this.expect(LEFDEFSyntax.KW_ENCLOSURE);
            double overhang1 = LEFDEFParser.this.eDouble();
            double overhang2 = LEFDEFParser.this.eDouble();
            LEFDEFParser.this.expect(';');
            this.vrg.setOverhang1(firstRoutingLayer, LEFDEFParser.this.toDB(overhang1));
            this.vrg.setOverhang2(firstRoutingLayer, LEFDEFParser.this.toDB(overhang2));
            if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_WIDTH) && LEFDEFParser.this.parserLEFWidth.perform()) {
                this.vrg.setMaxWidth(firstRoutingLayer, LEFDEFParser.this.toDB(LEFDEFParser.this.parserLEFWidth.getMaxWidth()));
                this.vrg.setMinWidth(firstRoutingLayer, LEFDEFParser.this.toDB(LEFDEFParser.this.parserLEFWidth.getMinWidth()));
            }
        }

        private void eCutLayer(Layer l) throws MalformedLEFDEFException {
            if (l != null) {
                this.vrg.setLayerCut(l);
            }
            LEFDEFParser.this.expect(LEFDEFSyntax.KW_RECT);
            this.processRect();
            LEFDEFParser.this.expect(LEFDEFSyntax.KW_SPACING);
            this.processSpacing();
            if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_RESISTANCE)) {
                double rpc = LEFDEFParser.this.eDouble();
                LEFDEFParser.this.expect(';');
                this.vrg.setResistancePerCut(rpc);
            }
        }

        private void processRect() throws MalformedLEFDEFException {
            double x = LEFDEFParser.this.eDouble();
            double y = LEFDEFParser.this.eDouble();
            APoint2D ll = new APoint2D(LEFDEFParser.this.toDB(x), LEFDEFParser.this.toDB(y));
            x = LEFDEFParser.this.eDouble();
            y = LEFDEFParser.this.eDouble();
            APoint2D ur = new APoint2D(LEFDEFParser.this.toDB(x), LEFDEFParser.this.toDB(y));
            ARect r = ARect.create((APoint2D)ll, (APoint2D)ur);
            this.vrg.setCutRect(r);
            LEFDEFParser.this.expect(';');
        }

        private void processSpacing() throws MalformedLEFDEFException {
            double x = LEFDEFParser.this.eDouble();
            LEFDEFParser.this.expect(LEFDEFSyntax.KW_BY);
            double y = LEFDEFParser.this.eDouble();
            APoint2D spacing = new APoint2D(LEFDEFParser.this.toDB(x), LEFDEFParser.this.toDB(y));
            this.vrg.setCutSpacing(spacing);
            LEFDEFParser.this.expect(';');
        }
    }

    private class ParserLEFViaRule
    implements ParserLEFDEFStatement {
        ViaRule mViaRule = null;

        private ParserLEFViaRule() {
        }

        @Override
        public boolean perform() throws MalformedLEFDEFException {
            String viaRuleName = LEFDEFParser.this.read();
            if (viaRuleName.isEmpty()) {
                throw new MalformedLEFDEFException(LEFDEFParser.this.fmtErrMsg("Failed to find viaRuleName", "VIARULE viaRuleName"));
            }
            if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_GENERATE)) {
                LEFDEFParser.this.parserLEFViaRuleGenerate.setViaRuleName(viaRuleName);
                return LEFDEFParser.this.parserLEFViaRuleGenerate.perform();
            }
            this.mViaRule = null;
            LEFDEFParser.this.expect(LEFDEFSyntax.KW_LAYER);
            this.eLayer(true);
            LEFDEFParser.this.expect(LEFDEFSyntax.KW_LAYER);
            this.eLayer(true);
            this.aVia();
            if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_PROPERTY)) {
                this.eProperty();
            }
            LEFDEFParser.this.expect(LEFDEFSyntax.KW_END);
            LEFDEFParser.this.expect(viaRuleName);
            return true;
        }

        private ViaRule getViaRule() {
            if (this.mViaRule == null) {
                this.mViaRule = new ViaRule();
            }
            return this.mViaRule;
        }

        void eLayer(boolean firstLayer) throws MalformedLEFDEFException {
            String layerName = LEFDEFParser.this.read();
            LEFDEFParser.this.expect(';');
            LEFDEFParser.this.expect(LEFDEFSyntax.KW_DIRECTION);
            String direction = LEFDEFParser.this.read();
            LEFDEFParser.this.expect(';');
            if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_WIDTH)) {
                if (LEFDEFParser.this.parserLEFWidth.perform()) {
                    this.getViaRule().addViaRuleLayer(layerName, direction.equalsIgnoreCase("HORIZONTAL"), LEFDEFParser.this.parserLEFWidth.getMinWidth(), LEFDEFParser.this.parserLEFWidth.getMaxWidth());
                }
            } else {
                this.getViaRule().addViaRuleLayer(layerName, direction.equalsIgnoreCase("HORIZONTAL"));
            }
        }

        void aVia() throws MalformedLEFDEFException {
            ViaRule vr = this.getViaRule();
            while (LEFDEFParser.this.accept(LEFDEFSyntax.KW_VIA)) {
                String viaName = LEFDEFParser.this.read();
                vr.addVia(viaName);
                LEFDEFParser.this.expect(';');
            }
        }

        void eProperty() throws MalformedLEFDEFException {
            ViaRule vr = this.getViaRule();
            while (LEFDEFParser.this.accept(LEFDEFSyntax.KW_PROPERTY)) {
                String propName = LEFDEFParser.this.read();
                String propVal = LEFDEFParser.this.read();
                vr.addProperty(propName, propVal);
                LEFDEFParser.this.expect(';');
            }
        }
    }

    private class ReaderLEFDEFViaRule
    implements StatementParser {
        final VoidFunction readEOS;
        final DoubleToLongFunction unitConvert;
        final String mSyntaxKeyword;
        Map<String, VoidFunction> dispatch;
        MandatorySetRule msr = new MandatorySetRule();
        String viaRuleName;
        String viaName;
        long cutX;
        long cutY;
        String botMetalLayer;
        String cutLayer;
        String topMetalLayer;
        long cutDx;
        long cutDy;
        long xBotEnc;
        long yBotEnc;
        long xTopEnc;
        long yTopEnc;
        long row;
        long col;
        long xOffset;
        long yOffset;
        long xBotOffset;
        long yBotOffset;
        long xTopOffset;
        long yTopOffset;
        String pattern;

        ReaderLEFDEFViaRule(boolean forLEF) {
            if (forLEF) {
                this.readEOS = () -> LEFDEFParser.this.expect(';');
                this.unitConvert = x -> LEFDEFParser.this.toDB(x);
                this.mSyntaxKeyword = "VIARULE";
                this.dispatch = Map.ofEntries(Map.entry("CUTSIZE", this.msr.add(this::eCutSize)), Map.entry("LAYERS", this.msr.add(this::eLayers)), Map.entry("CUTSPACING", this.msr.add(this::eCutSpacing)), Map.entry("ENCLOSURE", this.msr.add(this::eEnclosure)), Map.entry("ROWCOL", this::eRowCol), Map.entry("ORIGIN", this::eOrigin), Map.entry("OFFSET", this::eOffset), Map.entry("PATTERN", this::ePattern));
                this.msr.lock();
            } else {
                this.readEOS = () -> {};
                this.unitConvert = x -> LEFDEFParser.this.toDB(x);
                this.mSyntaxKeyword = "VIARULE";
                this.dispatch = Map.ofEntries(Map.entry("CUTSIZE", this.msr.add(this::eCutSize)), Map.entry("LAYERS", this.msr.add(this::eLayers)), Map.entry("CUTSPACING", this.msr.add(this::eCutSpacing)), Map.entry("ENCLOSURE", this.msr.add(this::eEnclosure)), Map.entry("ROWCOL", this::eRowCol), Map.entry("ORIGIN", this::eOrigin), Map.entry("OFFSET", this::eOffset), Map.entry("PATTERN", this::ePattern));
                this.msr.lock();
            }
        }

        @Override
        public String getSyntaxKeyword() {
            return this.mSyntaxKeyword;
        }

        public void setViaName(String viaName) {
            this.viaName = viaName;
        }

        private void resetAll() {
            this.msr.reset();
            this.resetMandatory();
            this.resetOptional();
        }

        private void resetMandatory() {
            this.cutX = Long.MAX_VALUE;
            this.cutY = Long.MAX_VALUE;
            this.cutDx = Long.MAX_VALUE;
            this.cutDy = Long.MAX_VALUE;
            this.yTopEnc = Long.MAX_VALUE;
            this.xTopEnc = Long.MAX_VALUE;
            this.yBotEnc = Long.MAX_VALUE;
            this.xBotEnc = Long.MAX_VALUE;
            this.topMetalLayer = "";
            this.cutLayer = "";
            this.botMetalLayer = "";
        }

        private void resetOptional() {
            this.col = 1L;
            this.row = 1L;
            this.yOffset = 0L;
            this.xOffset = 0L;
            this.yTopOffset = 0L;
            this.xTopOffset = 0L;
            this.yBotOffset = 0L;
            this.xBotOffset = 0L;
            this.pattern = "";
        }

        private boolean isMandatorySet() {
            return this.msr.isOK();
        }

        @Override
        public String parse() throws MalformedLEFDEFException {
            String nextKeyword;
            this.viaRuleName = LEFDEFParser.this.read();
            this.readEOS.run();
            this.resetAll();
            while (true) {
                LEFDEFParser.this.accept('+');
                nextKeyword = LEFDEFParser.this.peekString().toUpperCase();
                VoidFunction r = this.dispatch.get(nextKeyword);
                if (r == null) break;
                LEFDEFParser.this.read();
                r.run();
            }
            if (!this.isMandatorySet()) {
                throw new MalformedLEFDEFException("Some mandatory statements are not specified in VIA " + this.viaName + " VIARULE " + this.viaRuleName);
            }
            this.apply();
            return nextKeyword;
        }

        private void apply() {
            ViaFactory vf = new ViaFactory();
            vf.setOpening(this.cutX, this.cutY);
            vf.setLayers(this.topMetalLayer, this.cutLayer, this.botMetalLayer);
            vf.setCutDxDy(this.cutDx, this.cutDy);
            vf.setEnclosure(this.xBotEnc, this.yBotEnc, this.xTopEnc, this.yTopEnc);
            if (!this.pattern.isEmpty()) {
                vf.setPattern(this.pattern);
            }
            if (this.xOffset != Long.MAX_VALUE) {
                vf.setOrigin(this.xOffset, this.yOffset);
            }
            if (this.xBotOffset != Long.MAX_VALUE) {
                vf.setOffset(this.xBotOffset, this.yBotOffset, this.xTopOffset, this.yTopOffset);
            }
            vf.setRowCol(this.row, this.col);
            PadTemplate pt = vf.makeViaFromFactoryByColLEFDEF(LEFDEFParser.this.mSubstrate, this.viaName);
            if (pt != null) {
                for (LayerShape ls : pt.getLayerShapes()) {
                    LEFDEFParser.this.mUnscaledLayerShapes.add(ls);
                }
                ViaFactory.setViaMaker(pt, PadTemplate.ViaMakerType.Def);
                pt.setValue("VIARULE", (Object)this.viaRuleName);
                pt.setValue("CUTSIZE", (Object)AUtil.arrayList((Object[])new Long[]{LEFDEFParser.this.toDEFUnit(this.cutX), LEFDEFParser.this.toDEFUnit(this.cutY)}));
                pt.setValue("LAYERS", (Object)AUtil.arrayList((Object[])new String[]{this.botMetalLayer, this.cutLayer, this.topMetalLayer}));
                pt.setValue("CUTSPACING", (Object)AUtil.arrayList((Object[])new Long[]{LEFDEFParser.this.toDEFUnit(this.cutDx), LEFDEFParser.this.toDEFUnit(this.cutDy)}));
                pt.setValue("ENCLOSURE", (Object)AUtil.arrayList((Object[])new Long[]{LEFDEFParser.this.toDEFUnit(this.xBotEnc), LEFDEFParser.this.toDEFUnit(this.yBotEnc), LEFDEFParser.this.toDEFUnit(this.xTopEnc), LEFDEFParser.this.toDEFUnit(this.yTopEnc)}));
                if (this.row != 1L || this.col != 1L) {
                    pt.setValue("ROWCOL", (Object)AUtil.arrayList((Object[])new Long[]{this.row, this.col}));
                }
                if (this.xOffset != 0L || this.yOffset != 0L) {
                    pt.setValue("ORIGIN", (Object)AUtil.arrayList((Object[])new Long[]{LEFDEFParser.this.toDEFUnit(this.xOffset), LEFDEFParser.this.toDEFUnit(this.yOffset)}));
                }
                if (this.xBotOffset != 0L || this.yBotOffset != 0L || this.xTopOffset != 0L || this.yTopOffset != 0L) {
                    pt.setValue("OFFSET", (Object)AUtil.arrayList((Object[])new Long[]{LEFDEFParser.this.toDEFUnit(this.xBotOffset), LEFDEFParser.this.toDEFUnit(this.yBotOffset), LEFDEFParser.this.toDEFUnit(this.xTopOffset), LEFDEFParser.this.toDEFUnit(this.yTopOffset)}));
                }
                if (!this.pattern.isEmpty()) {
                    pt.setValue("PATTERN", (Object)this.pattern);
                }
            }
        }

        private void eCutSize() throws MalformedLEFDEFException {
            try {
                Double valX = LEFDEFParser.this.eDouble();
                Double valY = LEFDEFParser.this.eDouble();
                this.readEOS.run();
                this.cutX = this.unitConvert.applyAsLong(valX);
                this.cutY = this.unitConvert.applyAsLong(valY);
            }
            catch (NumberFormatException e) {
                String err = LEFDEFParser.this.fmtErrMsg("Failed on CUTSIZE in VIARULE " + this.viaRuleName, "CUTSIZE xSize ySize");
                throw new MalformedLEFDEFException(err);
            }
        }

        private void eLayers() throws MalformedLEFDEFException {
            this.botMetalLayer = LEFDEFParser.this.read();
            this.cutLayer = LEFDEFParser.this.read();
            this.topMetalLayer = LEFDEFParser.this.read();
            this.readEOS.run();
            if (this.botMetalLayer.isEmpty() || this.cutLayer.isEmpty() || this.topMetalLayer.isEmpty()) {
                throw new MalformedLEFDEFException(LEFDEFParser.this.fmtErrMsg("Failed on LAYERS in VIARULE " + this.viaRuleName, "LAYERS botMetalLayer cutLayer topMetalLayer"));
            }
        }

        private void eCutSpacing() throws MalformedLEFDEFException {
            try {
                Double valx = LEFDEFParser.this.eDouble();
                Double valy = LEFDEFParser.this.eDouble();
                this.readEOS.run();
                this.cutDx = this.unitConvert.applyAsLong(valx);
                this.cutDy = this.unitConvert.applyAsLong(valy);
            }
            catch (NumberFormatException e) {
                String err = LEFDEFParser.this.fmtErrMsg("Failed on CUTSPACING in VIARULE " + this.viaRuleName, "CUTSPACING xCutSpacing yCutSpacing");
                throw new MalformedLEFDEFException(err);
            }
        }

        private void eEnclosure() throws MalformedLEFDEFException {
            try {
                Double val1 = LEFDEFParser.this.eDouble();
                Double val2 = LEFDEFParser.this.eDouble();
                Double val3 = LEFDEFParser.this.eDouble();
                Double val4 = LEFDEFParser.this.eDouble();
                this.readEOS.run();
                this.xBotEnc = this.unitConvert.applyAsLong(val1);
                this.yBotEnc = this.unitConvert.applyAsLong(val2);
                this.xTopEnc = this.unitConvert.applyAsLong(val3);
                this.yTopEnc = this.unitConvert.applyAsLong(val4);
            }
            catch (NumberFormatException e) {
                String err = LEFDEFParser.this.fmtErrMsg("Failed on ENCLOSURE in VIARULE " + this.viaRuleName, "ENCLOSURE xBotEnc yBotEnc xTopEnc yTopEnc");
                throw new MalformedLEFDEFException(err);
            }
        }

        private void eRowCol() throws MalformedLEFDEFException {
            try {
                Long val1 = LEFDEFParser.this.eLong();
                Long val2 = LEFDEFParser.this.eLong();
                this.readEOS.run();
                this.row = val1;
                this.col = val2;
            }
            catch (NumberFormatException e) {
                String err = LEFDEFParser.this.fmtErrMsg("Failed on ROWCOL in VIARULE " + this.viaRuleName, "ROWCOL numCutRows numCutCols");
                throw new MalformedLEFDEFException(err);
            }
        }

        private void eOrigin() throws MalformedLEFDEFException {
            try {
                Double val1 = LEFDEFParser.this.eDouble();
                Double val2 = LEFDEFParser.this.eDouble();
                this.readEOS.run();
                this.xOffset = this.unitConvert.applyAsLong(val1);
                this.yOffset = this.unitConvert.applyAsLong(val2);
            }
            catch (NumberFormatException e) {
                String err = LEFDEFParser.this.fmtErrMsg("Failed on ORIGIN in VIARULE " + this.viaRuleName, "ORIGIN xOffset yOffset");
                throw new MalformedLEFDEFException(err);
            }
        }

        private void eOffset() throws MalformedLEFDEFException {
            try {
                Double val1 = LEFDEFParser.this.eDouble();
                Double val2 = LEFDEFParser.this.eDouble();
                Double val3 = LEFDEFParser.this.eDouble();
                Double val4 = LEFDEFParser.this.eDouble();
                this.readEOS.run();
                this.xBotOffset = this.unitConvert.applyAsLong(val1);
                this.yBotOffset = this.unitConvert.applyAsLong(val2);
                this.xTopOffset = this.unitConvert.applyAsLong(val3);
                this.yTopOffset = this.unitConvert.applyAsLong(val4);
            }
            catch (NumberFormatException e) {
                String err = LEFDEFParser.this.fmtErrMsg("Failed on OFFSET in VIARULE " + this.viaRuleName, "OFFSET xBotOffset yBotOffset xTopOffset yTopOffset");
                throw new MalformedLEFDEFException(err);
            }
        }

        private void ePattern() throws MalformedLEFDEFException {
            this.pattern = LEFDEFParser.this.read();
            if (this.pattern.isEmpty()) {
                throw new MalformedLEFDEFException(LEFDEFParser.this.fmtErrMsg("Failed on PATTERN in VIARULE " + this.viaRuleName, "PATTERN cutPattern"));
            }
            this.readEOS.run();
        }
    }

    static interface StatementParser {
        public String parse() throws MalformedLEFDEFException;

        public String getSyntaxKeyword();
    }

    private static class ViaRule {
        List<ViaRuleLayer> vrls = new ArrayList<ViaRuleLayer>();
        List<String> vias = new LinkedList<String>();
        Map<String, String> properties = new HashMap<String, String>();

        ViaRule() {
        }

        void addViaRuleLayer(String layerName, boolean isHorizontal, double minWidth, double maxWidth) {
            this.vrls.add(new ViaRuleLayer(layerName, isHorizontal, minWidth, maxWidth));
        }

        void addViaRuleLayer(String layerName, boolean isHorizontal) {
            this.vrls.add(new ViaRuleLayer(layerName, isHorizontal));
        }

        void addVia(String viaName) {
            this.vias.add(viaName);
        }

        void addProperty(String propName, String propVal) {
            this.properties.put(propName, propVal);
        }

        static class ViaRuleLayer {
            final String name;
            final boolean horizontal;
            final double minWidth;
            final double maxWidth;

            ViaRuleLayer(String name, boolean horizontal, double minWidth, double maxWidth) {
                this.name = name;
                this.horizontal = horizontal;
                this.minWidth = minWidth;
                this.maxWidth = maxWidth;
            }

            ViaRuleLayer(String name, boolean horizontal) {
                this.name = name;
                this.horizontal = horizontal;
                this.minWidth = Double.NaN;
                this.maxWidth = Double.NaN;
            }
        }
    }

    public static class MandatorySetRule {
        private static final int STARTING_BIT = 0x40000000;
        int designatedBit = 0x40000000;
        int accumulated = 0;
        int accumulatedCopy;

        int getDesignatedBit() {
            int x = this.designatedBit;
            assert (x != 0) : "MandatorySetRule can only support up to 31 functions! Consider using long version!";
            this.accumulated |= x;
            this.designatedBit >>= 1;
            return x;
        }

        void lock() {
            this.accumulatedCopy = this.accumulated;
        }

        void reset() {
            this.accumulated = this.accumulatedCopy;
        }

        void setBit(int bit2set) {
            this.accumulated ^= bit2set;
        }

        VoidFunction add(VoidFunction f) {
            int bit2set = this.getDesignatedBit();
            return () -> {
                this.setBit(bit2set);
                f.run();
            };
        }

        boolean isOK() {
            return this.accumulated == 0;
        }
    }

    private class ParserDoNondefaultRule
    implements ParserLEFDEFStatement {
        Map<String, Dispatch> dispatch = Map.ofEntries(Map.entry("HARDSPACING", this::eHardSpacing), Map.entry("LAYER", this::eLayer), Map.entry("VIA", this::eVia), Map.entry("USEVIA", this::eUseVia), Map.entry("USEVIARULE", this::eUseViaRule), Map.entry("MINCUTS", this::eMinCuts), Map.entry("PROPERTY", this::eProperty), Map.entry("END", this::eEnd));
        String mRuleName;
        ViaRuleGenerate vrg;

        private ParserDoNondefaultRule() {
        }

        private PARSING_CONTROL eHardSpacing() throws MalformedLEFDEFException {
            LEFDEFParser.this.expect(';');
            return PARSING_CONTROL.MORE;
        }

        private void eLayerWidth() throws MalformedLEFDEFException {
            try {
                LEFDEFParser.this.expect(LEFDEFSyntax.KW_WIDTH);
                LEFDEFParser.this.read();
                LEFDEFParser.this.expect(';');
            }
            catch (NumberFormatException e) {
                String err = LEFDEFParser.this.fmtErrMsg("WIDTH width");
                throw new MalformedLEFDEFException(err);
            }
        }

        private void aLayerDiagWidth() throws MalformedLEFDEFException {
            try {
                if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_DIAGWIDTH)) {
                    LEFDEFParser.this.read();
                    LEFDEFParser.this.expect(';');
                }
            }
            catch (NumberFormatException e) {
                String err = LEFDEFParser.this.fmtErrMsg("DIAGWIDTH diagWidth");
                throw new MalformedLEFDEFException(err);
            }
        }

        private void aLayerSpacing() throws MalformedLEFDEFException {
            try {
                if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_SPACING)) {
                    LEFDEFParser.this.read();
                    LEFDEFParser.this.expect(';');
                }
            }
            catch (NumberFormatException e) {
                String err = LEFDEFParser.this.fmtErrMsg("SPACING minSpacing");
                throw new MalformedLEFDEFException(err);
            }
        }

        private void aLayerWireExtension() throws MalformedLEFDEFException {
            try {
                if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_WIREEXTENSION)) {
                    LEFDEFParser.this.read();
                    LEFDEFParser.this.expect(';');
                }
            }
            catch (NumberFormatException e) {
                String err = LEFDEFParser.this.fmtErrMsg("WIREEXTENSION value");
                throw new MalformedLEFDEFException(err);
            }
        }

        private PARSING_CONTROL eLayer() throws MalformedLEFDEFException {
            String layerName = LEFDEFParser.this.read();
            Layer l = LEFDEFParser.this.mSubstrate.getLayer(layerName);
            if (l != null) {
                if (l.getType().equals((Object)Layer.LayerType.Cut)) {
                    this.vrg.setLayerCut(l);
                } else if (this.vrg.getLayerA() == null) {
                    this.vrg.setLayerA(l);
                } else {
                    this.vrg.setLayerB(l);
                }
            }
            this.eLayerWidth();
            this.aLayerDiagWidth();
            this.aLayerSpacing();
            this.aLayerWireExtension();
            LEFDEFParser.this.expect(LEFDEFSyntax.KW_END);
            LEFDEFParser.this.expect(layerName);
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL eVia() throws MalformedLEFDEFException {
            LEFDEFParser.this.parserVia.perform();
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL eUseVia() throws MalformedLEFDEFException {
            LEFDEFParser.this.read();
            LEFDEFParser.this.expect(';');
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL eUseViaRule() throws MalformedLEFDEFException {
            LEFDEFParser.this.read();
            LEFDEFParser.this.expect(';');
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL eMinCuts() throws MalformedLEFDEFException {
            LEFDEFParser.this.read();
            LEFDEFParser.this.read();
            LEFDEFParser.this.expect(';');
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL eProperty() throws MalformedLEFDEFException {
            if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_LEF58_USEVIACUTCLASS)) {
                return LEFDEFParser.this.eLEFPropertyLEF58UseViaCutClass();
            }
            LEFDEFParser.this.read();
            LEFDEFParser.this.read();
            LEFDEFParser.this.expect(';');
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL eEnd() throws MalformedLEFDEFException {
            LEFDEFParser.this.expect(this.mRuleName);
            return PARSING_CONTROL.DONE;
        }

        private void parserObjectLevel() throws MalformedLEFDEFException {
            PARSING_CONTROL parsingLevel = PARSING_CONTROL.MORE;
            while (parsingLevel == PARSING_CONTROL.MORE) {
                parsingLevel = this.parseAttributeLevel();
            }
        }

        private PARSING_CONTROL parseAttributeLevel() throws MalformedLEFDEFException {
            String keyword = LEFDEFParser.this.read();
            Dispatch r = this.dispatch.get(keyword.toUpperCase());
            if (r == null) {
                LEFDEFParser.vError("Error parsing 'NONDEFAULTRULE %s'! Keyword '%s' is not in LEF spec. Near line %d. Skipped.", this.mRuleName, keyword, LEFDEFParser.this.mCurLine);
                return LEFDEFParser.this.tillLEFEOS();
            }
            return r.run();
        }

        @Override
        public boolean perform() throws MalformedLEFDEFException {
            this.mRuleName = LEFDEFParser.this.read();
            if (!this.mRuleName.isEmpty()) {
                ViaRuleGenerate.get((Substrate)LEFDEFParser.this.mSubstrate, (String)this.mRuleName);
                this.vrg = ViaRuleGenerate.get((Substrate)LEFDEFParser.this.mSubstrate, (String)this.mRuleName);
                if (this.vrg == null) {
                    this.vrg = ViaRuleGenerate.create((Substrate)LEFDEFParser.this.mSubstrate, (String)this.mRuleName);
                }
                this.parserObjectLevel();
                return true;
            }
            throw new MalformedLEFDEFException(LEFDEFParser.this.fmtErrMsg("Failed to find ruleName", "NONDEFAULTRULE ruleName"));
        }
    }

    private class ParserVia
    implements ParserLEFDEFStatement {
        private boolean isDefaultVia = false;
        String viaName;

        private ParserVia() {
        }

        public boolean isDefaultVia() {
            return this.isDefaultVia;
        }

        private boolean parseLayer(boolean toApply) throws MalformedLEFDEFException {
            LEFDEFParser.this.readerLayerGeometries.perform();
            List<LayerGeometry> lgs = LEFDEFParser.this.readerLayerGeometries.getLayerGeometries();
            for (LayerGeometry lg : lgs) {
                String layerName = lg.getLayerName();
                if (layerName == null || layerName.isEmpty()) {
                    return false;
                }
                if (!toApply || lg.isEmpty()) continue;
                this.applyLayerShapes(layerName, lg);
            }
            return !lgs.isEmpty();
        }

        private void applyLayerShapes(String layerName, LayerGeometry lg) throws MalformedLEFDEFException {
            Layer l = LEFDEFParser.this.getLayer(layerName);
            List<LayerShape> shapes = lg.convertToLayerShapes(l);
            PadTemplate padTemplate = PadTemplate.get((Db)LEFDEFParser.this.mDb, (Substrate)LEFDEFParser.this.mSubstrate, (String)this.viaName);
            if (padTemplate == null) {
                padTemplate = PadTemplate.create((Db)LEFDEFParser.this.mDb, (Substrate)LEFDEFParser.this.mSubstrate, (String)this.viaName);
            }
            for (LayerShape shape : shapes) {
                shape.setOwner((DbObject)padTemplate);
                LEFDEFParser.this.mDb.add((DbObject)shape);
                LEFDEFParser.this.mUnscaledLayerShapes.add(shape);
            }
        }

        private boolean parseProperty(boolean toApply) throws MalformedLEFDEFException {
            LEFDEFParser.this.read();
            LEFDEFParser.this.read();
            LEFDEFParser.this.expect(';');
            return true;
        }

        private boolean parseViaName() throws MalformedLEFDEFException {
            this.viaName = LEFDEFParser.this.read();
            if (!this.viaName.isEmpty()) {
                this.isDefaultVia = LEFDEFParser.this.accept(LEFDEFSyntax.KW_DEFAULT);
                return this.removeExistingPadTemplate(this.viaName);
            }
            throw new MalformedLEFDEFException(LEFDEFParser.this.fmtErrMsg("Failed to find viaName", "VIA viaName"));
        }

        private boolean removeExistingPadTemplate(String viaName) {
            PadTemplate existing = PadTemplate.get((Db)LEFDEFParser.this.mDb, (Substrate)LEFDEFParser.this.mSubstrate, (String)viaName);
            if (existing != null) {
                LEFDEFParser.vDetails("Remove same-named VIA pad template: %s.", viaName);
                return existing.deleteFromDb();
            }
            return true;
        }

        @Override
        public boolean perform() throws MalformedLEFDEFException {
            this.parseViaName();
            if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_VIARULE)) {
                LEFDEFParser.this.readerLEFViaViaRule.parse();
            } else {
                this.aResistance();
                while (this.parseLayer(true)) {
                }
            }
            while (LEFDEFParser.this.accept(LEFDEFSyntax.KW_PROPERTY)) {
                this.parseProperty(true);
            }
            this.aResistance();
            LEFDEFParser.this.expect(LEFDEFSyntax.KW_END);
            LEFDEFParser.this.expect(this.viaName);
            return true;
        }

        private void aResistance() throws MalformedLEFDEFException {
            if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_RESISTANCE)) {
                LEFDEFParser.this.read();
                LEFDEFParser.this.expect(';');
            }
        }
    }

    private class ParserLayer
    implements ParserLEFDEFStatement {
        Layer l = null;

        private ParserLayer() {
        }

        @Override
        public boolean perform() throws MalformedLEFDEFException {
            String layerName = LEFDEFParser.this.read();
            if (layerName.isEmpty()) {
                return false;
            }
            this.l = LEFDEFParser.this.getLayer(layerName);
            if (!LEFDEFParser.this.mOrderedLayerList.contains(this.l)) {
                LEFDEFParser.this.mOrderedLayerList.add(this.l);
            }
            HashSet<PropertyValue> properties = new HashSet<PropertyValue>();
            String layerType = "";
            while (true) {
                boolean unknown = true;
                if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_END)) break;
                if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_WIDTH)) {
                    long width = this.eLayerWidth();
                    LEFDEFParser.this.expect(';');
                    this.l.setWidth(width);
                    unknown = false;
                }
                if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_SPACING)) {
                    if (layerType.equals("CUT")) {
                        this.eLEFCutLayerSpacing();
                    } else if (layerType.equals("IMPLANT")) {
                        this.eLEFImplantLayerSpacing();
                    } else if (layerType.equals("ROUTING")) {
                        this.eLEFRoutingLayerSpacing();
                    } else {
                        this.eLEFUnknownLayerSpacing();
                    }
                    unknown = false;
                }
                if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_SPACINGTABLE)) {
                    LEFDEFParser.this.after(';');
                    unknown = false;
                }
                if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_RESISTANCE)) {
                    if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_RPERSQ)) {
                        double r = LEFDEFParser.this.eDouble();
                        LEFDEFParser.this.expect(';');
                        this.l.setResistance(r);
                    } else {
                        LEFDEFParser.this.after(';');
                    }
                    unknown = false;
                }
                if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_CAPACITANCE)) {
                    if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_CPERSQDIST)) {
                        double c = LEFDEFParser.this.eDouble();
                        LEFDEFParser.this.expect(';');
                        this.l.setCapacitance(c);
                    } else {
                        LEFDEFParser.this.after(';');
                    }
                    unknown = false;
                }
                if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_WIREEXTENSION)) {
                    this.eWireExtension();
                    unknown = false;
                }
                if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_TYPE)) {
                    layerType = LEFDEFParser.this.read();
                    LEFDEFParser.this.expect(';');
                    this.l.setType(this.getLayerTypeFrom(layerType.toUpperCase()));
                    unknown = false;
                }
                if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_DIRECTION)) {
                    String direction = LEFDEFParser.this.read();
                    LEFDEFParser.this.expect(';');
                    this.l.setValue("direction", (Object)direction);
                    unknown = false;
                }
                if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_PITCH)) {
                    this.ePitch();
                    unknown = false;
                }
                if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_PROPERTY)) {
                    PropertyValue prop = LEFDEFParser.this.parseProperty("LAYER");
                    properties.add(prop);
                    unknown = false;
                }
                if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_ENCLOSURE)) {
                    this.eLEFEnclosure();
                    unknown = false;
                }
                if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_ACCURRENTDENSITY)) {
                    this.eLEFAccurrentDensity();
                    unknown = false;
                }
                if (!unknown) continue;
                LEFDEFParser.this.after(';');
            }
            LEFDEFParser.this.expect(layerName);
            if (!properties.isEmpty()) {
                this.l.setValue(LEFDEFParser.FLDNAME_LEFDEF_PROPERTY, LEFDEFParser.this.toLEFDEFString(properties));
            }
            return true;
        }

        private boolean eLEFEnclosure() throws MalformedLEFDEFException {
            if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_ABOVE) || LEFDEFParser.this.accept(LEFDEFSyntax.KW_BELOW)) {
                // empty if block
            }
            LEFDEFParser.this.read();
            LEFDEFParser.this.read();
            if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_WIDTH)) {
                LEFDEFParser.this.read();
                if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_EXCEPTEXTRACUT)) {
                    LEFDEFParser.this.read();
                }
            } else if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_LENGTH)) {
                LEFDEFParser.this.read();
            }
            LEFDEFParser.this.expect(';');
            return true;
        }

        private boolean eLEFAccurrentDensity() throws MalformedLEFDEFException {
            LEFDEFParser.this.read();
            if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_FREQUENCY)) {
                LEFDEFParser.this.after(';');
                if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_WIDTH)) {
                    LEFDEFParser.this.after(';');
                } else if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_CUTAREA)) {
                    LEFDEFParser.this.after(';');
                }
                LEFDEFParser.this.expect(LEFDEFSyntax.KW_TABLEENTRIES);
                LEFDEFParser.this.after(';');
            } else {
                LEFDEFParser.this.read();
                LEFDEFParser.this.expect(';');
            }
            return true;
        }

        private void eWireExtension() throws MalformedLEFDEFException {
            long ext = LEFDEFParser.this.toDB(LEFDEFParser.this.eDouble());
            LEFDEFParser.this.expect(';');
            if (ext == 0L) {
                Constraint.setConstraint((DbObject)this.l, (Constraint.Descriptor)Constraint.WIRE_EXTENSION_MODEL, (Object)Constraint.WireExtensionModel.ZERO.name());
            } else {
                Constraint.setConstraint((DbObject)this.l, (Constraint.Descriptor)Constraint.WIRE_EXTENSION_MODEL, (Object)Constraint.WireExtensionModel.SPECIAL.name());
                Constraint.setConstraint((DbObject)this.l, (Constraint.Descriptor)Constraint.WIRE_EXTENSION_LEN, (Object)Long.toString(ext));
            }
        }

        private void ePitch() throws MalformedLEFDEFException {
            double dist1 = LEFDEFParser.this.eDouble();
            this.l.setValue("pitch1", (Object)dist1);
            if (LEFDEFParser.this.peek().accept(';')) {
                LEFDEFParser.this.expect(';');
            } else {
                double dist2 = LEFDEFParser.this.eDouble();
                this.l.setValue("pitch2", (Object)dist2);
            }
        }

        private Layer.LayerType getLayerTypeFrom(String defKeyword) {
            if (defKeyword.equals("ROUTING")) {
                return Layer.LayerType.Route;
            }
            if (defKeyword.equals("CUT")) {
                return Layer.LayerType.Cut;
            }
            if (defKeyword.equals("OVERLAP")) {
                return Layer.LayerType.Overlap;
            }
            if (defKeyword.equals("MASTERSLICE")) {
                return Layer.LayerType.MasterSlice;
            }
            if (defKeyword.equals("IMPLANT")) {
                return Layer.LayerType.Implant;
            }
            LEFDEFParser.vDebug("Unsupport layer type from '%s' in LEF", defKeyword);
            return Layer.LayerType.Unknown;
        }

        private boolean eLEFImplantLayerSpacing() throws MalformedLEFDEFException {
            LEFDEFParser.this.mSpacing = this.eLayerSpacing();
            if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_LAYER)) {
                LEFDEFParser.this.read();
            }
            LEFDEFParser.this.expect(';');
            return true;
        }

        private boolean eLEFRoutingLayerSpacing() throws MalformedLEFDEFException {
            LEFDEFParser.this.mSpacing = this.eLayerSpacing();
            if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_RANGE)) {
                this.eLEFRange();
                if (!LEFDEFParser.this.accept(LEFDEFSyntax.KW_USELENGTHTHRESHOLD)) {
                    if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_INFLUENCE)) {
                        this.eLayerInfluence();
                    } else if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_RANGE)) {
                        this.eLEFRange();
                    }
                }
            } else if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_LENGTHTHRESHOLD)) {
                this.eLayerLengthThreshold();
            } else if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_ENDOFLINE)) {
                this.eLayerEndOfLine();
                if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_PARALLELEDGE)) {
                    this.eLayerParallelEdge();
                }
            } else if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_SAMENET)) {
                LEFDEFParser.this.accept(LEFDEFSyntax.KW_PGONLY);
            } else if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_NOTCHLENGTH)) {
                this.eNotchLength();
            } else if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_ENDOFNOTCHWIDTH)) {
                this.eLayerEndOfNotchWidth();
            }
            LEFDEFParser.this.expect(';');
            return true;
        }

        private boolean eLEFUnknownLayerSpacing() throws MalformedLEFDEFException {
            LEFDEFParser.this.mSpacing = this.eLayerWidth();
            LEFDEFParser.this.accept(LEFDEFSyntax.KW_CENTERTOCENTER);
            if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_SAMENET)) {
                LEFDEFParser.this.accept(LEFDEFSyntax.KW_PGONLY);
            }
            if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_LAYER)) {
                LEFDEFParser.this.read();
                LEFDEFParser.this.accept(LEFDEFSyntax.KW_STACK);
            } else if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_ADJACENTCUTS)) {
                this.eLayerAdjacentCuts();
            } else if (!LEFDEFParser.this.accept(LEFDEFSyntax.KW_PARALLELOVERLAP) && LEFDEFParser.this.accept(LEFDEFSyntax.KW_AREA)) {
                this.eLayerArea();
            }
            LEFDEFParser.this.after(';');
            return true;
        }

        private boolean eLEFCutLayerSpacing() throws MalformedLEFDEFException {
            LEFDEFParser.this.mSpacing = this.eLayerSpacing();
            LEFDEFParser.this.accept(LEFDEFSyntax.KW_CENTERTOCENTER);
            LEFDEFParser.this.accept(LEFDEFSyntax.KW_SAMENET);
            if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_LAYER)) {
                LEFDEFParser.this.read();
                LEFDEFParser.this.accept(LEFDEFSyntax.KW_STACK);
            } else if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_ADJACENTCUTS)) {
                this.eLayerAdjacentCuts();
            } else if (!LEFDEFParser.this.accept(LEFDEFSyntax.KW_PARALLELOVERLAP) && !LEFDEFParser.this.accept(LEFDEFSyntax.KW_AREA)) {
                if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_RANGE)) {
                    this.eLEFRange();
                    if (!LEFDEFParser.this.accept(LEFDEFSyntax.KW_USELENGTHTHRESHOLD)) {
                        if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_INFLUENCE)) {
                            this.eLayerInfluence();
                        } else if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_RANGE)) {
                            this.eLEFRange();
                        }
                    }
                } else if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_LENGTHTHRESHOLD)) {
                    this.eLayerLengthThreshold();
                } else if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_ENDOFLINE)) {
                    this.eLayerEndOfLine();
                    if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_PARALLELEDGE)) {
                        this.eLayerParallelEdge();
                    }
                } else if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_SAMENET)) {
                    LEFDEFParser.this.accept(LEFDEFSyntax.KW_PGONLY);
                } else if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_NOTCHLENGTH)) {
                    this.eNotchLength();
                } else if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_ENDOFNOTCHWIDTH)) {
                    this.eLayerEndOfNotchWidth();
                }
            }
            LEFDEFParser.this.expect(';');
            return true;
        }

        private void eLayerLengthThreshold() throws MalformedLEFDEFException {
            try {
                LEFDEFParser.this.read();
                if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_RANGE)) {
                    this.eLEFRange();
                }
            }
            catch (NumberFormatException e) {
                String err = LEFDEFParser.this.fmtErrMsg("LENGTHTHRESHOLD maxLength [RANGE minWidth maxWidth]");
                throw new MalformedLEFDEFException(err);
            }
        }

        private void eLayerEndOfNotchWidth() throws MalformedLEFDEFException {
            try {
                LEFDEFParser.this.read();
                LEFDEFParser.this.expect(LEFDEFSyntax.KW_NOTCHSPACING);
                LEFDEFParser.this.read();
                LEFDEFParser.this.expect(LEFDEFSyntax.KW_NOTCHLENGTH);
                LEFDEFParser.this.read();
            }
            catch (NumberFormatException e) {
                String err = LEFDEFParser.this.fmtErrMsg("ENDOFNOTCHWIDTH endOfNotchWidth NOTCHSPACING minNotchSpacing NOTCHLENGTH minNotchLength");
                throw new MalformedLEFDEFException(err);
            }
        }

        private void eLayerEndOfLine() throws MalformedLEFDEFException {
            try {
                LEFDEFParser.this.read();
                LEFDEFParser.this.expect(LEFDEFSyntax.KW_WITHIN);
                LEFDEFParser.this.read();
            }
            catch (NumberFormatException e) {
                String err = LEFDEFParser.this.fmtErrMsg("ENDOFLINE eolWidth WITHIN eolWithin");
                throw new MalformedLEFDEFException(err);
            }
        }

        private void eLayerParallelEdge() throws MalformedLEFDEFException {
            try {
                LEFDEFParser.this.read();
                LEFDEFParser.this.expect(LEFDEFSyntax.KW_WITHIN);
                LEFDEFParser.this.read();
                LEFDEFParser.this.accept(LEFDEFSyntax.KW_TWOEDGES);
            }
            catch (NumberFormatException e) {
                String err = LEFDEFParser.this.fmtErrMsg("PARALLELEDGE parSpace WITHIN parWithin [TWOEDGES]");
                throw new MalformedLEFDEFException(err);
            }
        }

        private void eNotchLength() throws MalformedLEFDEFException {
            try {
                LEFDEFParser.this.read();
            }
            catch (NumberFormatException e) {
                String err = LEFDEFParser.this.fmtErrMsg("NOTCHLENGTH minNotchLength");
                throw new MalformedLEFDEFException(err);
            }
        }

        private void eLayerInfluence() throws MalformedLEFDEFException {
            try {
                LEFDEFParser.this.read();
                if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_RANGE)) {
                    this.eLEFRange();
                }
            }
            catch (NumberFormatException e) {
                String err = LEFDEFParser.this.fmtErrMsg("INFLUENCE value [RANGE stubMinWidth stubMaxWidth]");
                throw new MalformedLEFDEFException(err);
            }
        }

        private long eLayerSpacing() throws MalformedLEFDEFException {
            try {
                return LEFDEFParser.this.toDB(LEFDEFParser.this.eDouble());
            }
            catch (NumberFormatException e) {
                String err = LEFDEFParser.this.fmtErrMsg("SPACING spacing");
                throw new MalformedLEFDEFException(err);
            }
        }

        private void eLayerAdjacentCuts() throws MalformedLEFDEFException {
            try {
                LEFDEFParser.this.read();
                LEFDEFParser.this.expect(LEFDEFSyntax.KW_WITHIN);
                LEFDEFParser.this.read();
                LEFDEFParser.this.accept(LEFDEFSyntax.KW_EXCEPTSAMEPGNET);
            }
            catch (NumberFormatException e) {
                String err = LEFDEFParser.this.fmtErrMsg("{ 2 | 3 | 4 } WITHIN cutWithin");
                throw new MalformedLEFDEFException(err);
            }
        }

        private void eLayerArea() throws MalformedLEFDEFException {
            try {
                LEFDEFParser.this.read();
            }
            catch (NumberFormatException e) {
                String err = LEFDEFParser.this.fmtErrMsg("AREA cutAre");
                throw new MalformedLEFDEFException(err);
            }
        }

        private APair<Double, Double> eLEFRange() throws MalformedLEFDEFException {
            try {
                double minWidth = LEFDEFParser.this.eDouble();
                double maxWidth = LEFDEFParser.this.eDouble();
                return new APair((Object)minWidth, (Object)maxWidth);
            }
            catch (NumberFormatException e) {
                String err = LEFDEFParser.this.fmtErrMsg("RANGE minWidth maxWidth");
                throw new MalformedLEFDEFException(err);
            }
        }

        private long eLayerWidth() throws MalformedLEFDEFException {
            try {
                return LEFDEFParser.this.toDB(LEFDEFParser.this.eDouble());
            }
            catch (NumberFormatException e) {
                String err = LEFDEFParser.this.fmtErrMsg("WIDTH minWidth");
                throw new MalformedLEFDEFException(err);
            }
        }
    }

    private class ParserComponents
    implements ParserLEFDEFStatement {
        String section = "COMPONENTS";
        private Device mCurrentDevice;
        long devicesCreated = 0L;
        Map<String, Dispatch> dispatch;
        Set<PropertyValue> properties = new HashSet<PropertyValue>();
        boolean mPlacementHandled;
        private Map<String, DeviceTemplate> mTemplateMap;

        ParserComponents() {
            this.dispatch = Map.ofEntries(Map.entry("EEQMASTER", this::eEEQMaster), Map.entry("SOURCE", this::eSource), Map.entry("FIXED", this::eFixed), Map.entry("COVER", this::eCover), Map.entry("PLACED", this::ePlaced), Map.entry("UNPLACED", this::eUnplaced), Map.entry("MASKSHIFT", this::eMaskShift), Map.entry("HALO", this::eHalo), Map.entry("ROUTEHALO", this::eRouteHalo), Map.entry("WEIGHT", this::eWeight), Map.entry("REGION", this::eRegion), Map.entry("PROPERTY", this::eProperty), Map.entry(";", this::eDone));
        }

        private PARSING_CONTROL eEEQMaster() {
            LEFDEFParser.this.read();
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL eSource() throws MalformedLEFDEFException {
            String source = LEFDEFParser.this.read();
            if (source.isEmpty()) {
                throw new MalformedLEFDEFException("Expect source after 'SOURCE', when parsing COMPONENTS section, near line %d.", LEFDEFParser.this.mCurLine);
            }
            if (this.mCurrentDevice != null) {
                this.mCurrentDevice.setValue(LEFDEFParser.FLDNAME_DEF_SOURCE, (Object)source);
            }
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL eFixed() throws MalformedLEFDEFException {
            this.mPlacementHandled = true;
            APoint2D p = LEFDEFParser.this.eDEFPoint();
            String orient = LEFDEFParser.this.read();
            if (orient.isEmpty()) {
                throw new MalformedLEFDEFException(LEFDEFParser.this.fmtErrMsg("Failed to read orient in parsing FIXED"));
            }
            this.mCurrentDevice.setIsPlaced(true);
            this.mCurrentDevice.setIsFixed(true);
            this.setDeviceOrientation(this.mCurrentDevice, orient);
            LEFDEFParser.this.putDevLLAt(this.mCurrentDevice, p);
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL eCover() throws MalformedLEFDEFException {
            this.mPlacementHandled = true;
            APoint2D p = LEFDEFParser.this.eDEFPoint();
            String orient = LEFDEFParser.this.read();
            if (orient.isEmpty()) {
                throw new MalformedLEFDEFException(LEFDEFParser.this.fmtErrMsg("Failed to read orient in parsing COVER"));
            }
            this.mCurrentDevice.setIsPlaced(true);
            this.mCurrentDevice.setIsFixed(true);
            this.setDeviceOrientation(this.mCurrentDevice, orient);
            LEFDEFParser.this.putDevLLAt(this.mCurrentDevice, p);
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL ePlaced() throws MalformedLEFDEFException {
            this.mPlacementHandled = true;
            APoint2D p = LEFDEFParser.this.eDEFPoint();
            String orient = LEFDEFParser.this.read();
            if (orient.isEmpty()) {
                throw new MalformedLEFDEFException(LEFDEFParser.this.fmtErrMsg("Failed to read orient in parsing PLACED"));
            }
            this.mCurrentDevice.setIsPlaced(true);
            this.mCurrentDevice.setIsFixed(false);
            this.setDeviceOrientation(this.mCurrentDevice, orient);
            LEFDEFParser.this.putDevLLAt(this.mCurrentDevice, p);
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL eUnplaced() {
            this.mPlacementHandled = true;
            this.mCurrentDevice.setIsPlaced(false);
            this.mCurrentDevice.setIsFixed(false);
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL eMaskShift() {
            LEFDEFParser.this.read();
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL eHalo() throws MalformedLEFDEFException {
            LEFDEFParser.this.next('+', ';');
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL eRouteHalo() throws MalformedLEFDEFException {
            LEFDEFParser.this.next('+', ';');
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL eWeight() {
            LEFDEFParser.this.read();
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL eRegion() {
            LEFDEFParser.this.read();
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL eProperty() {
            Set<PropertyValue> pvs = this.parseDEFProperty("COMPONENT");
            this.properties.addAll(pvs);
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL eDone() {
            return PARSING_CONTROL.DONE;
        }

        private void afterThisComponentStatement() {
            TokenParser.TokenInfo ti;
            do {
                LEFDEFParser.this.after(';');
            } while (!(ti = LEFDEFParser.this.peek()).accept('-') && !ti.accept(LEFDEFSyntax.KW_END));
        }

        private void parserObjectLevel() throws MalformedLEFDEFException {
            this.mPlacementHandled = false;
            if (!this.parseCompName()) {
                this.afterThisComponentStatement();
                return;
            }
            PARSING_CONTROL parsingLevel = PARSING_CONTROL.MORE;
            while (parsingLevel == PARSING_CONTROL.MORE) {
                parsingLevel = this.parseAttributeLevel();
            }
            this.postObject();
        }

        private void postObject() {
            this.applyDeferredAttributes(this.mCurrentDevice);
            if (!this.mPlacementHandled) {
                this.mCurrentDevice.setIsPlaced(false);
                this.mCurrentDevice.setIsFixed(false);
            }
        }

        private void applyDeferredAttributes(Device d) {
            for (PropertyValue pv : this.properties) {
                String noQuotesValue = LEFDEFParser.this.removeQuotes(pv.value);
                d.setValue("DEF." + pv.desc.name, (Object)noQuotesValue);
                if (!"BUMP_TO_PIN".equals(pv.desc.name)) continue;
                LEFDEFParser.this.mBumpToPins.put(d, noQuotesValue);
            }
        }

        private boolean performWithCache() throws MalformedLEFDEFException {
            int numDevices;
            if (LEFDEFParser.this.mCurrentDie == null) {
                throw new MalformedLEFDEFException("There is no DIEAREA defined. Exiting Read.");
            }
            this.section = "[COMPONENTS]";
            try {
                numDevices = LEFDEFParser.this.eInt();
                if (numDevices <= 0) {
                    throw new MalformedLEFDEFException(String.format("%s Error! A larger than 0 number is expected, but got %d. Near line %d.", this.section, numDevices, LEFDEFParser.this.mCurLine));
                }
            }
            catch (NumberFormatException e) {
                String err = LEFDEFParser.this.fmtErrMsg(String.format("%s Error! A number is expected after 'COMPONENTS', but not found.", this.section));
                throw new MalformedLEFDEFException(err);
            }
            LEFDEFParser.this.expect(';');
            this.openCache(numDevices);
            LEFDEFParser.this.mBumpToPins = new HashMap<Device, String>(LEFDEFParser.getNoRehashInitialCapacity(numDevices));
            while (LEFDEFParser.this.accept('-')) {
                this.parserObjectLevel();
            }
            if (!LEFDEFParser.this.accept(LEFDEFSyntax.KW_END)) {
                throw new MalformedLEFDEFException(LEFDEFParser.this.fmtErrMsg(LEFDEFParser.this.read(), "Unhandled DEF keyword"));
            }
            LEFDEFParser.this.expect(LEFDEFSyntax.KW_COMPONENTS);
            if (this.devicesCreated != (long)numDevices) {
                LEFDEFParser.vInfo("%s: Read in %d components when there should be %d.", this.section, this.devicesCreated, numDevices);
            } else {
                LEFDEFParser.vInfo("%s: Read in %d components.", this.section, numDevices);
            }
            return true;
        }

        private DeviceTemplate getDeviceTemplate(Substrate s, String templateName) {
            if (this.mTemplateMap.containsKey(templateName)) {
                return this.mTemplateMap.get(templateName);
            }
            DeviceTemplate t = DeviceTemplate.getDeviceTemplate((Substrate)s, (String)templateName);
            this.mTemplateMap.put(templateName, t);
            return t;
        }

        private void openCache(int numDevices) {
            this.mTemplateMap = new HashMap<String, DeviceTemplate>(LEFDEFParser.getNoRehashInitialCapacity(numDevices));
        }

        private void closeCache() {
            this.mTemplateMap = null;
        }

        @Override
        public boolean perform() throws MalformedLEFDEFException {
            boolean r = false;
            try {
                r = this.performWithCache();
            }
            finally {
                this.closeCache();
            }
            return r;
        }

        private PARSING_CONTROL parseAttributeLevel() throws MalformedLEFDEFException {
            LEFDEFParser.this.accept('+');
            String keyword = LEFDEFParser.this.read();
            Dispatch r = this.dispatch.get(keyword.toUpperCase());
            if (r == null) {
                throw new MalformedLEFDEFException(LEFDEFParser.this.fmtErrMsg(this.section + " Error! No Handling of " + keyword + ". Skipped."));
            }
            return r.run();
        }

        private boolean parseCompName() throws MalformedLEFDEFException {
            this.mCurrentDevice = null;
            this.properties = new HashSet<PropertyValue>();
            String compName = LEFDEFParser.this.read();
            if (compName.isEmpty()) {
                throw new MalformedLEFDEFException("%s Error! Failed to get compName. Near line %d.", this.section, LEFDEFParser.this.mCurLine);
            }
            String devName = LEFDEFParser.this.getUniqueDeviceName(compName);
            String templateName = LEFDEFParser.this.read();
            if (templateName.isEmpty()) {
                throw new MalformedLEFDEFException("%s Error! Failed to get modelName. Near line %d.", this.section, LEFDEFParser.this.mCurLine);
            }
            if (LEFDEFParser.this.shouldInclude(templateName)) {
                DeviceTemplate t = null;
                LEFDEFParser.this.getSubstrate(templateName);
                t = this.getDeviceTemplate(LEFDEFParser.this.mSubstrate, templateName);
                if (t == LEFDEFParser.this.mTopDeviceTemplate) {
                    throw new MalformedLEFDEFException(LEFDEFParser.this.fmtErrMsg(String.format("'%s' can not be used for component '%s' as it's the same as design name which is not allowed", templateName, compName)));
                }
                if (t != null) {
                    if (!this.shouldSkip(t)) {
                        if (!LEFDEFParser.this.mDoneOneDevice) {
                            LEFDEFParser.this.mSubstrate = t.getSubstrate();
                            DeviceTemplate dieTemplate = LEFDEFParser.this.mCurrentDie.getTemplate();
                            dieTemplate.setSubstrate(LEFDEFParser.this.mSubstrate);
                            LEFDEFParser.this.updateSubstrateNameIfNeeded(dieTemplate);
                            LEFDEFParser.this.mDoneOneDevice = true;
                        }
                        this.mCurrentDevice = Device.create((String)devName, (DeviceTemplate)t, (DeviceTemplate)LEFDEFParser.this.mCurrentDie.getTemplate());
                        ++this.devicesCreated;
                    } else {
                        LEFDEFParser.vDetails("Skip component '%s' of type '%s'.", compName, t.getType());
                    }
                } else {
                    LEFDEFParser.vError("No macro '%s' for component '%s'.", templateName, devName);
                }
            }
            return this.mCurrentDevice != null;
        }

        private boolean shouldSkip(DeviceTemplate t) {
            DeviceTemplate.Type type = t.getType();
            return !LEFDEFParser.this.mReadBlocks && (type == DeviceTemplate.Type.BLOCK || type == DeviceTemplate.Type.HARDMACRO || type == DeviceTemplate.Type.SOFTMACRO) || !LEFDEFParser.this.mReadCores && type == DeviceTemplate.Type.CORE || !LEFDEFParser.this.mReadCovers && (type == DeviceTemplate.Type.COVER || type == DeviceTemplate.Type.BUMP && LEFDEFParser.this.mReadCovers) || !LEFDEFParser.this.mReadEndCaps && type == DeviceTemplate.Type.ENDCAP || !LEFDEFParser.this.mReadRings && type == DeviceTemplate.Type.RING;
        }

        private Set<PropertyValue> parseDEFProperty(String objType) {
            TokenParser.TokenInfo ti;
            HashSet<PropertyValue> pvs = new HashSet<PropertyValue>();
            do {
                String name = LEFDEFParser.this.read();
                String val = LEFDEFParser.this.read();
                PropertyValue pv = new PropertyValue(LEFDEFParser.this.getPropDefn(objType, name), val);
                pvs.add(pv);
            } while (!(ti = LEFDEFParser.this.peek()).accept('+') && !ti.accept(';'));
            return pvs;
        }

        private boolean setDeviceOrientation(Device device, String orient) {
            try {
                APair<Long, Boolean> rotateAndMirror = LEFDEFOrient.ORIENT.getRotateMirror(orient);
                device.setRotate((float)((Long)rotateAndMirror.first).longValue());
                device.setMirror(((Boolean)rotateAndMirror.second).booleanValue());
                return true;
            }
            catch (Exception e) {
                LEFDEFParser.vError("Failed setDeviceOrientation for '%s' with orient '%s'", device, orient);
                return false;
            }
        }
    }

    @FunctionalInterface
    static interface VoidFunction {
        public void run() throws MalformedLEFDEFException;
    }

    @FunctionalInterface
    static interface Dispatch {
        public PARSING_CONTROL run() throws MalformedLEFDEFException;
    }

    static enum PARSING_CONTROL {
        DONE,
        MORE;

    }

    private class ParserBlockages
    implements ParserLEFDEFStatement {
        int blockagesCreated = 0;
        Obstacle mObstacle = null;
        Map<String, Dispatch> dispatchLayer = Map.ofEntries(Map.entry("SLOTS", this::eSlots), Map.entry("FILLS", this::eFills), Map.entry("PUSHDOWN", this::ePushdown), Map.entry("EXCEPTPGNET", this::eExceptPGNet), Map.entry("COMPONENT", this::eComponent), Map.entry("SPACING", this::eSpacing), Map.entry("DESIGNRULEWIDTH", this::eDesignRuleWidth), Map.entry("MASKNUM", this::eMaskNum), Map.entry("RECT", this::eRect), Map.entry("POLYGON", this::ePolygon), Map.entry(";", this::doneSubstatement));
        Map<String, Dispatch> dispatchPlacement = Map.ofEntries(Map.entry("SOFT", this::eSoft), Map.entry("PARTIAL", this::ePartial), Map.entry("PUSHDOWN", this::ePushdown), Map.entry("COMPONENT", this::eComponent), Map.entry("RECT", this::eRect), Map.entry(";", this::doneSubstatement));
        Layer mLayer;

        ParserBlockages() {
        }

        private PARSING_CONTROL eSlots() {
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL eFills() {
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL ePushdown() {
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL eExceptPGNet() {
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL eComponent() {
            LEFDEFParser.this.read();
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL eSpacing() {
            LEFDEFParser.this.read();
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL eDesignRuleWidth() {
            LEFDEFParser.this.read();
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL eMaskNum() {
            LEFDEFParser.this.read();
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL eRect() throws MalformedLEFDEFException {
            APoint2D ll = LEFDEFParser.this.eDEFPoint();
            APoint2D ur = LEFDEFParser.this.eDEFPoint();
            ARect r = ARect.create((APoint2D)ll, (APoint2D)ur);
            this.addLayerShapeToBlockage(LEFDEFParser.this.mDb, this.mObstacle, this.mLayer, (AGeom)r);
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL ePolygon() throws MalformedLEFDEFException {
            APolygon poly = LEFDEFParser.this.eDEFPolygon();
            this.addLayerShapeToBlockage(LEFDEFParser.this.mDb, this.mObstacle, this.mLayer, (AGeom)poly);
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL eSoft() {
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL ePartial() {
            LEFDEFParser.this.read();
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL doneSubstatement() {
            return PARSING_CONTROL.DONE;
        }

        private void parserObjectLevel(Map<String, Dispatch> dispatch) throws MalformedLEFDEFException {
            PARSING_CONTROL parsingLevel = PARSING_CONTROL.MORE;
            while (parsingLevel == PARSING_CONTROL.MORE) {
                parsingLevel = this.parserAttributeLevel(dispatch);
            }
        }

        private PARSING_CONTROL parserAttributeLevel(Map<String, Dispatch> dispatch) throws MalformedLEFDEFException {
            LEFDEFParser.this.accept('+');
            String keyword = LEFDEFParser.this.read();
            Dispatch r = dispatch.get(keyword.toUpperCase());
            if (r == null) {
                throw new MalformedLEFDEFException(LEFDEFParser.this.fmtErrMsg("No handling of " + keyword + " in BLOCKAGES"));
            }
            return r.run();
        }

        private Obstacle createRoutingBlockage() {
            Obstacle obs = Obstacle.create((Db)LEFDEFParser.this.mDb, (Obstacle.ObstacleType)Obstacle.ObstacleType.DefBlockageLayer, (DeviceTemplate)LEFDEFParser.this.mCurrentDie.getTemplate());
            if (obs == null) {
                return null;
            }
            obs.setId(LEFDEFParser.this.mCurLine + 1L);
            return obs;
        }

        private Obstacle createPlacementBlockage() {
            Obstacle obs = Obstacle.create((Db)LEFDEFParser.this.mDb, (Obstacle.ObstacleType)Obstacle.ObstacleType.DefBlockagePlacement, (DeviceTemplate)LEFDEFParser.this.mCurrentDie.getTemplate());
            if (obs == null) {
                return null;
            }
            obs.setId(LEFDEFParser.this.mCurLine + 1L);
            return obs;
        }

        @Override
        public boolean perform() throws MalformedLEFDEFException {
            long numBlockages;
            block8: {
                try {
                    numBlockages = LEFDEFParser.this.eLong();
                }
                catch (NumberFormatException e) {
                    String err = LEFDEFParser.this.fmtErrMsg("Failed to find numBlockages", "BLOCKAGES numBlockages ;");
                    throw new MalformedLEFDEFException(err);
                }
                LEFDEFParser.this.expect(';');
                this.blockagesCreated = 0;
                while (true) {
                    if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_END)) break block8;
                    LEFDEFParser.this.expect('-');
                    if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_LAYER)) {
                        String layerName = LEFDEFParser.this.read();
                        this.mLayer = LEFDEFParser.this.getLayer(layerName);
                        this.mObstacle = this.createRoutingBlockage();
                        if (this.mObstacle == null) {
                            throw new IllegalArgumentException(LEFDEFParser.this.fmtErrMsg("Failed to create obstacle for DEF BLOCKAGE."));
                        }
                        ++this.blockagesCreated;
                        this.parserObjectLevel(this.dispatchLayer);
                        continue;
                    }
                    if (!LEFDEFParser.this.accept(LEFDEFSyntax.KW_PLACEMENT)) break;
                    this.mObstacle = this.createPlacementBlockage();
                    if (this.mObstacle == null) {
                        throw new IllegalArgumentException(LEFDEFParser.this.fmtErrMsg("Failed to create obstacle for DEF BLOCKAGE."));
                    }
                    ++this.blockagesCreated;
                    this.parserObjectLevel(this.dispatchPlacement);
                }
                throw new MalformedLEFDEFException(LEFDEFParser.this.fmtErrMsg("No handling of " + LEFDEFParser.this.read()));
            }
            LEFDEFParser.this.expect(LEFDEFSyntax.KW_BLOCKAGES);
            if ((long)this.blockagesCreated != numBlockages) {
                LEFDEFParser.vWarn("[BLOCKAGES] Read in %d blockages where there should be %d.", this.blockagesCreated, numBlockages);
            } else {
                LEFDEFParser.vInfo("[BLOCKAGES] Read in %d blockages.", numBlockages);
            }
            return true;
        }

        private void addLayerShapeToBlockage(Db db, Obstacle o, Layer l, AGeom geom) {
            if (l == null) {
                this.addShapeForAllLayers(db, o, geom);
            } else {
                o.addLayerShape(db, l, geom);
            }
        }

        private void addShapeForAllLayers(Db db, Obstacle o, AGeom geom) {
            try {
                LEFDEFParser.this.mSubstrate.getLayers().stream().forEach(l -> o.addLayerShape(db, l, geom));
            }
            catch (Exception e) {
                LEFDEFParser.vError("Failed to add shape:%s to all layers of substrate: %s. Exception:%s", geom, LEFDEFParser.this.mSubstrate, e);
            }
        }
    }

    private static class RoutingPoint5
    implements RoutingPoint {
        final APoint2D xy;

        RoutingPoint5(APoint2D v) {
            this.xy = v;
        }

        @Override
        public APoint2D getPoint() {
            return this.xy;
        }

        @Override
        public boolean isVirtual() {
            return true;
        }

        public String toString() {
            return "Virtual: " + this.xy.toString();
        }
    }

    private static class RoutingPoint4
    implements RoutingPoint {
        final ARect delta;
        int maskNum = -1;

        RoutingPoint4(ARect v) {
            this.delta = v;
        }

        void setMaskNum(int v) {
            this.maskNum = v;
        }

        @Override
        public ARect getRect() {
            return this.delta;
        }

        @Override
        public int getMaskNum() {
            return this.maskNum;
        }

        public String toString() {
            return this.delta.toString();
        }
    }

    private static class RoutingPoint3
    implements RoutingPoint {
        final String viaName;
        String orient = "N";
        String viaMaskNum = "";
        long numX = 0L;
        long numY = 0L;
        long stepX = 0L;
        long stepY = 0L;

        RoutingPoint3(String v) {
            this.viaName = v;
        }

        void setOrient(String v) {
            this.orient = v;
        }

        void setViaMaskNum(String v) {
            this.viaMaskNum = v;
        }

        @Override
        public String getViaName() {
            return this.viaName;
        }

        @Override
        public String getOrient() {
            return this.orient;
        }

        @Override
        public String getViaMaskNum() {
            return this.viaMaskNum;
        }

        @Override
        public long getNumX() {
            return this.numX;
        }

        @Override
        public long getNumY() {
            return this.numY;
        }

        @Override
        public long getStepX() {
            return this.stepX;
        }

        @Override
        public long getStepY() {
            return this.stepY;
        }

        public String toString() {
            return String.format("[VIA '%s' '%s', %d, %d, %d, %s]", this.viaName, this.orient, this.numX, this.numY, this.stepX, this.stepY);
        }
    }

    private static class RoutingPoint2
    implements RoutingPoint {
        final APoint2D xy;
        long extValue = -1L;
        int maskNum = -1;

        RoutingPoint2(APoint2D pt) {
            this.xy = pt;
        }

        void setExtValue(long v) {
            this.extValue = v;
        }

        void setMaskNum(int v) {
            this.maskNum = v;
        }

        @Override
        public APoint2D getPoint() {
            return this.xy;
        }

        @Override
        public long getExtValue() {
            return this.extValue;
        }

        @Override
        public int getMaskNum() {
            return this.maskNum;
        }

        public String toString() {
            return this.xy.toString();
        }
    }

    private static class RoutingPoint1
    implements RoutingPoint {
        final APoint2D xy;
        long extValue = -1L;

        RoutingPoint1(APoint2D pt) {
            this.xy = pt;
        }

        void setExtValue(long v) {
            this.extValue = v;
        }

        @Override
        public APoint2D getPoint() {
            return this.xy;
        }

        @Override
        public long getExtValue() {
            return this.extValue;
        }

        public String toString() {
            return this.xy.toString();
        }
    }

    private static interface RoutingPoint {
        default public APoint2D getPoint() {
            return null;
        }

        default public long getExtValue() {
            return -1L;
        }

        default public int getMaskNum() {
            return -1;
        }

        default public String getViaMaskNum() {
            return null;
        }

        default public String getViaName() {
            return null;
        }

        default public String getOrient() {
            return "N";
        }

        default public ARect getRect() {
            return null;
        }

        default public boolean isVirtual() {
            return false;
        }

        default public long getNumX() {
            return 0L;
        }

        default public long getNumY() {
            return 0L;
        }

        default public long getStepX() {
            return 0L;
        }

        default public long getStepY() {
            return 0L;
        }
    }

    private class ParserLEFPropertyDefinitions
    implements ParserLEFDEFStatement {
        private ParserLEFPropertyDefinitions() {
        }

        @Override
        public boolean perform() throws MalformedLEFDEFException {
            LEFDEFParser.this.propertyDescriptors = new HashMap<APair<String, String>, DefPropertyDescriptor>();
            while (true) {
                if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_END)) break;
                this.eLEFPropertyDefinition();
            }
            LEFDEFParser.this.expect(LEFDEFSyntax.KW_PROPERTYDEFINITIONS);
            return true;
        }

        private boolean eLEFPropertyDefinition() throws MalformedLEFDEFException {
            String objectType = LEFDEFParser.this.read();
            String propName = LEFDEFParser.this.read();
            String propType = LEFDEFParser.this.read();
            PropertyType pt = PropertyType.fromDefKeyword(propType);
            if (pt == null) {
                throw new MalformedLEFDEFException(LEFDEFParser.this.fmtErrMsg("Unsupported property type: " + propType));
            }
            double min = Double.NaN;
            double max = Double.NaN;
            if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_RANGE)) {
                min = Double.valueOf(LEFDEFParser.this.read());
                max = Double.valueOf(LEFDEFParser.this.read());
            }
            DefPropertyDescriptor pd = new DefPropertyDescriptor(objectType, propName, pt, min, max);
            LEFDEFParser.this.propertyDescriptors.put((APair<String, String>)new APair((Object)objectType, (Object)propName), pd);
            if (LEFDEFParser.this.accept(';')) {
                return true;
            }
            PropertyValue propertyValue = null;
            String val = LEFDEFParser.this.read();
            if (!val.isEmpty()) {
                propertyValue = new PropertyValue(pd, val);
            }
            LEFDEFParser.this.expect(';');
            return true;
        }
    }

    private class ParserNetsOrSpecialNets
    implements ParserLEFDEFStatement {
        String section;
        boolean readWires;
        boolean isSpecial;
        Map<String, Pattern> cachePattern = null;
        List<Device> cacheRootChildren = null;
        private List<APoint2D> mPoints;
        private List<RoutingPoint> mRoutingPoints;
        Set<String> createdNets = new HashSet<String>();
        long nCreated = 0L;
        LEFDEFSyntax.WireType mWireType;

        private ParserNetsOrSpecialNets() {
        }

        void resetWith(String section, boolean readWires, boolean isSpecial) {
            this.section = section;
            this.readWires = readWires;
            this.isSpecial = isSpecial;
        }

        private Pattern getPattern(String regex) {
            return this.cachePattern.computeIfAbsent(regex, key -> {
                String javaPattern = regex.replace("*", ".*");
                return Pattern.compile(javaPattern);
            });
        }

        private List<Device> getRootChildren() {
            if (this.cacheRootChildren == null) {
                this.cacheRootChildren = LEFDEFParser.this.mCurrentDie.getChildren().stream().collect(Collectors.toList());
            }
            return this.cacheRootChildren;
        }

        private void openCache() {
            this.cachePattern = new HashMap<String, Pattern>();
            this.mPoints = new LinkedList<APoint2D>();
            this.mRoutingPoints = new LinkedList<RoutingPoint>();
        }

        private void closeCache() {
            this.cachePattern = null;
            this.cacheRootChildren = null;
            this.createdNets = null;
            this.mPoints = null;
            this.mRoutingPoints = null;
        }

        @Override
        public boolean perform() throws MalformedLEFDEFException {
            boolean r = false;
            this.openCache();
            try {
                r = this.performWithCache();
            }
            finally {
                this.closeCache();
            }
            return r;
        }

        private List<DevicePath> findMatchingDevices(Device rootDevice, String deviceName) {
            DevicePath rootpath = new DevicePath(rootDevice);
            DeviceTemplate rootTemplate = rootDevice.getTemplate();
            LinkedList<DevicePath> dps = new LinkedList<DevicePath>();
            if (deviceName.contains("*")) {
                Pattern pattern = this.getPattern(deviceName);
                this.getRootChildren().stream().forEach(d -> {
                    if (pattern.matcher(d.getName()).matches()) {
                        try {
                            dps.add(new DevicePath(rootpath, d));
                        }
                        catch (Exception e) {
                            LEFDEFParser.vWarn("Can not new a devicepath with '%s' and '%s'", rootpath, d);
                        }
                    }
                });
            } else {
                Device device = Device.get((Db)LEFDEFParser.this.mDb, (String)deviceName, (DeviceTemplate)rootTemplate);
                if (device != null) {
                    dps.add(new DevicePath(rootpath, device));
                }
            }
            return dps;
        }

        private String genMustJoinNetName() {
            return "MUSTJOIN_NET_" + System.nanoTime();
        }

        private void aCompPins(String netName) throws MalformedLEFDEFException {
            while (LEFDEFParser.this.accept('(')) {
                String compName = LEFDEFParser.this.read();
                String deviceName = LEFDEFParser.this.getUniqueDeviceName(compName);
                String pinName = LEFDEFParser.this.read();
                if (LEFDEFParser.this.accept('+')) {
                    LEFDEFParser.this.expect(LEFDEFSyntax.KW_SYNTHESIZED);
                }
                LEFDEFParser.this.expect(')');
                if (LEFDEFParser.this.mCurrentNet.isUnused()) {
                    LEFDEFParser.vWarn("Skip (device:%s,pin:%s) as netmap to NetUnused is not allowed. Near line %d.", compName, pinName, LEFDEFParser.this.mCurLine);
                    continue;
                }
                if (!compName.equals("PIN")) {
                    List<DevicePath> devicePaths = this.findMatchingDevices(LEFDEFParser.this.mCurrentDie, deviceName);
                    if (devicePaths.isEmpty()) {
                        LEFDEFParser.vWarn("%s Cannot find inst '%s' for net '%s'.", this.section, compName, netName);
                        continue;
                    }
                    boolean isCompNamePattern = deviceName.contains("*");
                    this.createTermNetAndMapUp(isCompNamePattern, devicePaths, pinName);
                    continue;
                }
                Term term = this.getTerm(pinName);
                if (term == null) continue;
                term.setNet(LEFDEFParser.this.mCurrentNet);
            }
        }

        private Term getTerm(String termName) {
            Term term = null;
            if (LEFDEFParser.this.mNameToTerm != null) {
                term = LEFDEFParser.this.mNameToTerm.get(termName);
            }
            if (term == null) {
                term = LEFDEFParser.this.mCurrentDie.getTemplate().getTerm(termName);
            }
            return term;
        }

        private void createTermNetAndMapUp(boolean isCompNamePattern, List<DevicePath> devicePaths, String pinName) {
            for (DevicePath dpath : devicePaths) {
                Device device = dpath.getDevice();
                DeviceTemplate t = device.getTemplate();
                Term term = t.getTerm(pinName);
                if (term != null) {
                    TermMap.mapChildTerm((Device)device, (Term)term, (Net)LEFDEFParser.this.mCurrentNet);
                    continue;
                }
                if (isCompNamePattern) continue;
                LEFDEFParser.vWarn("%s Can not find term '%s' on macro '%s'.", this.section, pinName, t.getName());
            }
        }

        private void eDEFNet() throws MalformedLEFDEFException {
            boolean isMustJoin = LEFDEFParser.this.accept(LEFDEFSyntax.KW_MUSTJOIN);
            try {
                String netName;
                if (isMustJoin) {
                    netName = this.genMustJoinNetName();
                    LEFDEFParser.this.expect('(');
                    LEFDEFParser.this.read();
                    LEFDEFParser.this.read();
                    LEFDEFParser.this.expect(')');
                } else {
                    netName = LEFDEFParser.this.read();
                }
                if (!this.createdNets.add(netName)) {
                    LEFDEFParser.vDetails("%s Net '%s' appeared more than once.", this.section, netName);
                } else {
                    ++this.nCreated;
                }
                LEFDEFParser.this.mCurrentNet = this.getOrCreateNet(this.section, netName);
                if (!isMustJoin) {
                    this.aCompPins(netName);
                }
                while (!LEFDEFParser.this.accept(';')) {
                    LEFDEFParser.this.expect('+');
                    if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_SOURCE)) {
                        LEFDEFParser.this.read();
                        continue;
                    }
                    if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_USE)) {
                        LEFDEFParser.this.read();
                        continue;
                    }
                    if (LEFDEFParser.this.mCurrentNet != null && this.readWires) {
                        if (this.isSpecial) {
                            if (this.aSpecialWiring()) continue;
                            LEFDEFParser.this.next('+', ';');
                            continue;
                        }
                        if (this.aRegularWiring()) continue;
                        LEFDEFParser.this.next('+', ';');
                        continue;
                    }
                    LEFDEFParser.this.next('+', ';');
                }
            }
            catch (NumberFormatException e) {
                throw new MalformedLEFDEFException(LEFDEFParser.this.fmtErrMsg("Error parsing a number!"));
            }
        }

        public boolean performWithCache() throws MalformedLEFDEFException {
            int numNets;
            block7: {
                block6: {
                    this.section = String.format("[%s]", this.section);
                    try {
                        numNets = LEFDEFParser.this.eInt();
                    }
                    catch (NumberFormatException e) {
                        String err = "NETS numNets";
                        throw new MalformedLEFDEFException(err);
                    }
                    LEFDEFParser.this.expect(';');
                    this.createdNets = new HashSet<String>(numNets / 3 * 4);
                    this.nCreated = 0L;
                    while (true) {
                        if (LEFDEFParser.this.accept('-')) {
                            this.eDEFNet();
                            continue;
                        }
                        if (!LEFDEFParser.this.accept(LEFDEFSyntax.KW_END)) break block6;
                        if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_NETS) || LEFDEFParser.this.accept(LEFDEFSyntax.KW_SPECIALNETS)) break;
                    }
                    break block7;
                }
                throw new MalformedLEFDEFException(LEFDEFParser.this.fmtErrMsg("Unhandled " + LEFDEFParser.this.read()));
            }
            if ((long)numNets != this.nCreated) {
                LEFDEFParser.vInfo("%s Read in %d nets when there should be %d.", this.section, this.nCreated, numNets);
            } else {
                LEFDEFParser.vInfo("%s Read in %d nets.", this.section, numNets);
            }
            return true;
        }

        private boolean eSpeciaWiringType1() throws MalformedLEFDEFException {
            if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_SHAPE)) {
                LEFDEFParser.this.read();
                LEFDEFParser.this.accept('+');
            }
            if (LEFDEFParser.this.aMask()) {
                LEFDEFParser.this.accept('+');
            }
            if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_POLYGON)) {
                LEFDEFParser.this.read();
                LEFDEFParser.this.aDEFPoints();
            } else if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_RECT)) {
                LEFDEFParser.this.read();
                this.eDEFTwoPointsRect();
            } else if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_VIA)) {
                LEFDEFParser.this.read();
                LEFDEFParser.this.aOrient();
                LEFDEFParser.this.aDEFPoints();
            }
            return true;
        }

        private boolean eSpeciaWiringType2() throws MalformedLEFDEFException {
            do {
                String layerName = LEFDEFParser.this.read();
                long routeWidth = LEFDEFParser.this.toDB(LEFDEFParser.this.eLong());
                while (LEFDEFParser.this.accept('+')) {
                    if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_SHAPE)) {
                        LEFDEFParser.this.read();
                        continue;
                    }
                    if (!LEFDEFParser.this.accept(LEFDEFSyntax.KW_STYLE)) continue;
                    LEFDEFParser.this.read();
                }
                List<RoutingPoint> rps = this.eRoutingPoints();
                this.applyLayerNWidth(layerName, routeWidth);
                this.processRPS(rps);
            } while (LEFDEFParser.this.accept(LEFDEFSyntax.KW_NEW));
            return true;
        }

        private boolean aSpecialWiring() throws MalformedLEFDEFException {
            if (!this.aWireType()) {
                return false;
            }
            if (LEFDEFParser.this.accept('+')) {
                return this.eSpeciaWiringType1();
            }
            return this.eSpeciaWiringType2();
        }

        private void applyLayerNWidth(String layerName, Long width) throws MalformedLEFDEFException {
            LEFDEFParser.this.mCurrentLayer = LEFDEFParser.this.getLayer(layerName);
            LEFDEFParser.this.mTraceWidth = width == null ? LEFDEFParser.this.mCurrentLayer.getWidth() : width.longValue();
        }

        private boolean aRegularWiring() throws MalformedLEFDEFException {
            if (!this.aWireType()) {
                return false;
            }
            do {
                String layerName = LEFDEFParser.this.read();
                LEFDEFParser.this.aTaper();
                LEFDEFParser.this.aStyle();
                List<RoutingPoint> rps = this.eRoutingPoints();
                this.applyLayerNWidth(layerName, null);
                this.processRPS(rps);
            } while (LEFDEFParser.this.accept(LEFDEFSyntax.KW_NEW));
            return true;
        }

        private Constraint.EndCapType determineWireEndCapType(APath path) {
            ALine lastSeg = path.getLastSegment();
            if (lastSeg != null && !lastSeg.isOrthogonal()) {
                return Constraint.EndCapType.ROUND;
            }
            return Constraint.EndCapType.NONE;
        }

        private boolean isForViaLocation(List<APoint2D> pts) {
            return pts.size() == 1;
        }

        private void createWire(List<APoint2D> pts) {
            if (pts.isEmpty()) {
                return;
            }
            if (this.isForViaLocation(pts)) {
                return;
            }
            APath path = new APath(pts);
            Constraint.EndCapType ect = this.determineWireEndCapType(path);
            this.createAWire(path, ect);
        }

        private void processRPS(List<RoutingPoint> rps) {
            if (rps.isEmpty()) {
                return;
            }
            this.mPoints.clear();
            List<APoint2D> pts = this.mPoints;
            APoint2D last = null;
            for (RoutingPoint rp : rps) {
                Class<?> rpc = rp.getClass();
                if (rpc == RoutingPoint1.class || rpc == RoutingPoint2.class) {
                    last = rp.getPoint();
                    pts.add(rp.getPoint());
                    continue;
                }
                if (rpc == RoutingPoint3.class) {
                    this.createWire(pts);
                    pts.clear();
                    PadTemplate via = PadTemplate.get((Db)LEFDEFParser.this.mDb, (Substrate)LEFDEFParser.this.mCurrentNet.getSubstrate(), (String)rp.getViaName());
                    if (via != null) {
                        this.createAVia(via, last);
                        Layer top = via.getTopLayer();
                        LEFDEFParser.this.mCurrentLayer = LEFDEFParser.this.mCurrentLayer == top ? via.getBottomLayer() : top;
                        continue;
                    }
                    LEFDEFParser.vWarn("No VIA has defined for '%s' ", rp.getViaName());
                    continue;
                }
                if (rpc == RoutingPoint4.class) {
                    this.createWire(pts);
                    pts.clear();
                    Metal.create((Net)LEFDEFParser.this.mCurrentNet, (Layer)LEFDEFParser.this.mCurrentLayer, (AGeom)rp.getRect().offset(last));
                    continue;
                }
                if (rpc != RoutingPoint5.class) continue;
                this.createWire(pts);
                pts.clear();
            }
            this.createWire(pts);
        }

        private boolean aWireType() {
            if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_COVER)) {
                this.mWireType = LEFDEFSyntax.WireType.COVER;
            } else if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_FIXED)) {
                this.mWireType = LEFDEFSyntax.WireType.FIXED;
            } else if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_ROUTED)) {
                this.mWireType = LEFDEFSyntax.WireType.ROUTED;
            } else if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_NOSHIELD)) {
                this.mWireType = LEFDEFSyntax.WireType.NOSHIELD;
            } else if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_SHIELD)) {
                LEFDEFParser.this.read();
            } else {
                return false;
            }
            return true;
        }

        private void eRoutingPointMaskType(List<RoutingPoint> rps) throws MalformedLEFDEFException {
            int maskOrViaMask = -1;
            if (LEFDEFParser.this.aMask()) {
                maskOrViaMask = LEFDEFParser.this.mMaskNum;
            }
            if (LEFDEFParser.this.accept('(')) {
                RoutingPoint rp = this.eRoutingPoint(maskOrViaMask);
                rps.add(rp);
            } else if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_RECT)) {
                ARect rect = this.eDEFRect();
                RoutingPoint4 rp = new RoutingPoint4(rect);
                rp.setMaskNum(maskOrViaMask);
                rps.add(rp);
            } else {
                String viaName = LEFDEFParser.this.read();
                String orient = LEFDEFParser.this.aOrient();
                RoutingPoint3 rp = new RoutingPoint3(viaName);
                if (orient != null) {
                    rp.setOrient(orient);
                }
                if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_DO)) {
                    LEFDEFParser.this.read();
                    LEFDEFParser.this.expect(LEFDEFSyntax.KW_BY);
                    LEFDEFParser.this.read();
                    LEFDEFParser.this.expect(LEFDEFSyntax.KW_STEP);
                    LEFDEFParser.this.read();
                    LEFDEFParser.this.read();
                }
                rps.add(rp);
            }
        }

        private boolean isRoutingPointsEnd() {
            TokenParser.TokenInfo ti = LEFDEFParser.this.peek();
            return ti.accept(LEFDEFSyntax.KW_NEW) || ti.accept('+') || ti.accept(';');
        }

        private List<RoutingPoint> eRoutingPoints() throws MalformedLEFDEFException {
            this.mRoutingPoints.clear();
            List<RoutingPoint> rps = this.mRoutingPoints;
            LEFDEFParser.this.expect('(');
            RoutingPoint rp = this.eRoutingPoint();
            rps.add(rp);
            while (!this.isRoutingPointsEnd()) {
                if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_VIRTUAL)) {
                    APoint2D xy = LEFDEFParser.this.eDEFPoint();
                    rps.add(new RoutingPoint5(xy));
                    continue;
                }
                this.eRoutingPointMaskType(rps);
            }
            return rps;
        }

        private Wire createAWire(APath path, Constraint.EndCapType ect) {
            path.setWidth(LEFDEFParser.this.mTraceWidth);
            assert (LEFDEFParser.this.mCurrentNet != null);
            assert (LEFDEFParser.this.mCurrentLayer != null);
            Wire wire = Wire.create((Net)LEFDEFParser.this.mCurrentNet, (Layer)LEFDEFParser.this.mCurrentLayer, (APath)path);
            wire.setEndCapType(ect);
            return wire;
        }

        private PinTemplate createAVia(PadTemplate via, APoint2D viaLocation) {
            String pinName = via.getName() + "_" + LEFDEFParser.this.mNextViaName;
            ++LEFDEFParser.this.mNextViaName;
            PinTemplate dtp = PinTemplate.create((Net)LEFDEFParser.this.mCurrentNet, (String)pinName);
            dtp.setType(PinTemplate.Type.VIA);
            PortTemplate.create((PinTemplate)dtp, (APoint2D)viaLocation, (float)0.0f, (boolean)false, (PadTemplate)via);
            ViaFactory.setViaInfo(dtp, via.getName(), this.isSpecial);
            PinInstance.create((Db)LEFDEFParser.this.mDb, (String)pinName, (Device)LEFDEFParser.this.mCurrentDie, (PinTemplate)dtp);
            return dtp;
        }

        private Net getOrCreateNet(String section, String netName) {
            String processedNetName = LEFDEFParser.this.removeSpecialChars(netName);
            return Net.getOrCreate((DeviceTemplate)LEFDEFParser.this.mCurrentDie.getTemplate(), (String)processedNetName);
        }

        private ARect eDEFRect() throws MalformedLEFDEFException {
            LEFDEFParser.this.expect('(');
            long deltax1 = LEFDEFParser.this.toDB(LEFDEFParser.this.eLong());
            long deltay1 = LEFDEFParser.this.toDB(LEFDEFParser.this.eLong());
            long deltax2 = LEFDEFParser.this.toDB(LEFDEFParser.this.eLong());
            long deltay2 = LEFDEFParser.this.toDB(LEFDEFParser.this.eLong());
            LEFDEFParser.this.expect(')');
            return ARect.create((long)deltax1, (long)deltay1, (long)deltax2, (long)deltay2);
        }

        private ARect eDEFTwoPointsRect() throws MalformedLEFDEFException {
            APoint2D ll = LEFDEFParser.this.eDEFPoint();
            APoint2D ur = LEFDEFParser.this.eDEFPoint();
            return ARect.create((APoint2D)ll, (APoint2D)ur);
        }

        private RoutingPoint eRoutingPoint() throws MalformedLEFDEFException {
            APoint2D pt = LEFDEFParser.this.ePoint();
            long extValue = -1L;
            Long v = LEFDEFParser.this.aLong();
            if (v != null) {
                extValue = LEFDEFParser.this.toDB(v.longValue());
            }
            LEFDEFParser.this.expect(')');
            RoutingPoint1 rp = new RoutingPoint1(pt);
            rp.setExtValue(extValue);
            return rp;
        }

        private RoutingPoint eRoutingPoint(int maskNum) throws MalformedLEFDEFException {
            APoint2D pt = LEFDEFParser.this.ePoint();
            long extValue = -1L;
            Long v = LEFDEFParser.this.aLong();
            if (v != null) {
                extValue = LEFDEFParser.this.toDB(v.longValue());
            }
            LEFDEFParser.this.expect(')');
            RoutingPoint2 rp = new RoutingPoint2(pt);
            rp.setExtValue(extValue);
            rp.setMaskNum(maskNum);
            return rp;
        }
    }

    private class ParserDefVias
    implements ParserLEFDEFStatement {
        String viaName = "";
        Map<String, Dispatch> dispatch = Map.ofEntries(Map.entry("VIARULE", this::eViaRule), Map.entry("RECT", this::eRect), Map.entry("POLYGON", this::ePolygon), Map.entry(";", this::eEnd));
        long created = 0L;

        ParserDefVias() {
        }

        private PARSING_CONTROL eViaRule() throws MalformedLEFDEFException {
            LEFDEFParser.this.readerDEFViaViaRule.setViaName(this.viaName);
            LEFDEFParser.this.readerDEFViaViaRule.parse();
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL eRect() throws MalformedLEFDEFException {
            this.processRect();
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL ePolygon() throws MalformedLEFDEFException {
            this.processPolygon();
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL eEnd() {
            return PARSING_CONTROL.DONE;
        }

        private PARSING_CONTROL parseAttributeLevel() throws MalformedLEFDEFException {
            LEFDEFParser.this.accept('+');
            String keyword = LEFDEFParser.this.read();
            Dispatch r = this.dispatch.get(keyword.toUpperCase());
            if (r == null) {
                throw new MalformedLEFDEFException(LEFDEFParser.this.fmtErrMsg("Unsupported statement: " + keyword + " in VIAS."));
            }
            return r.run();
        }

        private void parserObjectLevel() throws MalformedLEFDEFException {
            this.parseViaName();
            PARSING_CONTROL parsingLevel = PARSING_CONTROL.MORE;
            while (parsingLevel == PARSING_CONTROL.MORE) {
                parsingLevel = this.parseAttributeLevel();
            }
        }

        private boolean parseViaName() throws MalformedLEFDEFException {
            this.viaName = LEFDEFParser.this.read();
            if (!this.viaName.isEmpty()) {
                ++this.created;
                return true;
            }
            throw new MalformedLEFDEFException(LEFDEFParser.this.fmtErrMsg("Unexpected empty viaName"));
        }

        @Override
        public boolean perform() throws MalformedLEFDEFException {
            int numVias;
            block4: {
                if (LEFDEFParser.this.mSubstrate == null) {
                    LEFDEFParser.vWarn("No substrate! Can not handle VIAS statement in DEF", new Object[0]);
                    return false;
                }
                numVias = LEFDEFParser.this.eInt();
                LEFDEFParser.this.expect(';');
                this.created = 0L;
                while (true) {
                    if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_END)) break block4;
                    if (!LEFDEFParser.this.accept('-')) break;
                    this.parserObjectLevel();
                }
                throw new MalformedLEFDEFException(LEFDEFParser.this.fmtErrMsg("Unhandled " + LEFDEFParser.this.read()));
            }
            LEFDEFParser.this.expect(LEFDEFSyntax.KW_VIAS);
            if ((long)numVias != this.created) {
                LEFDEFParser.vWarn("[VIAS] Read in %d VIAs when there should be %d.", this.created, numVias);
            } else {
                LEFDEFParser.vInfo("[VIAS] Read in %d VIAs.", numVias);
            }
            return true;
        }

        private boolean processPolygon() throws MalformedLEFDEFException {
            String layerName = LEFDEFParser.this.read();
            Layer l = LEFDEFParser.this.getLayer(layerName);
            if (LEFDEFParser.this.accept('+')) {
                LEFDEFParser.this.eMask();
            }
            APolygon poly = LEFDEFParser.this.eDEFPolygon();
            PadTemplate padTemplate = PadTemplate.getOrCreate((Db)LEFDEFParser.this.mDb, (Substrate)LEFDEFParser.this.mSubstrate, (String)this.viaName);
            ViaFactory.setViaMaker(padTemplate, PadTemplate.ViaMakerType.Def);
            LayerShape ls = LayerShape.create((Db)LEFDEFParser.this.mDb, (Layer)l, (DbObject)padTemplate, (AGeom)poly);
            LEFDEFParser.this.mUnscaledLayerShapes.add(ls);
            return true;
        }

        private boolean processRect() throws MalformedLEFDEFException {
            String layerName = LEFDEFParser.this.read();
            Layer l = LEFDEFParser.this.getLayer(layerName);
            if (LEFDEFParser.this.accept('+')) {
                LEFDEFParser.this.eMask();
            }
            APoint2D ll = LEFDEFParser.this.eDEFPoint();
            APoint2D ur = LEFDEFParser.this.eDEFPoint();
            ARect r = ARect.create((APoint2D)ll, (APoint2D)ur);
            PadTemplate padTemplate = PadTemplate.getOrCreate((Db)LEFDEFParser.this.mDb, (Substrate)LEFDEFParser.this.mSubstrate, (String)this.viaName);
            ViaFactory.setViaMaker(padTemplate, PadTemplate.ViaMakerType.Def);
            LayerShape ls = LayerShape.create((Db)LEFDEFParser.this.mDb, (Layer)l, (DbObject)padTemplate, (AGeom)r);
            LEFDEFParser.this.mUnscaledLayerShapes.add(ls);
            return true;
        }
    }

    private class ParserPins
    implements ParserLEFDEFStatement {
        String mPinName = "";
        String mNetName = "";
        Net mNet = null;
        PinTemplate mPin = null;
        Term.Type mTermType = Term.TYPE_DEFAULT;
        Term.Use mTermUse = Term.USE_DEFAULT;
        long nCreated = 0L;
        Map<String, Dispatch> dispatch = Map.ofEntries(Map.entry("NET", this::eNet), Map.entry("SPECIAL", this::eSpecial), Map.entry("DIRECTION", this::eDirection), Map.entry("NETEXPR", this::eNetExpr), Map.entry("SUPPLYSENSITIVITY", this::eSupplySensitivity), Map.entry("GROUNDSENSITIVITY", this::eGroundSensitivity), Map.entry("USE", this::eUse), Map.entry("ANTENNAPINPARTIALMETALAREA", this::eAntennaPinPartialMetalArea), Map.entry("ANTENNAPINPARTIALMETALSIDEAREA", this::eAntennaPinPartialMetalSideArea), Map.entry("ANTENNAPINPARTIALCUTAREA", this::eAntennaPinPartialCutArea), Map.entry("ANTENNAPINDIFFAREA", this::eAntennaPinDiffArea), Map.entry("ANTENNAMODEL", this::eAntennaModel), Map.entry("ANTENNAPINGATEAREA", this::eAntennaPinGateArea), Map.entry("ANTENNAPINMAXAREACAR", this::eAntennaPinMaxAreaCAR), Map.entry("ANTENNAPINMAXSIDEAREACAR", this::eAntennaPinMaxSideAreaCAR), Map.entry("ANTENNAPINMAXCUTCAR", this::eAntennaPinMaxCutCAR), Map.entry("PORT", this::ePort), Map.entry("LAYER", this::eLayer), Map.entry("POLYGON", this::ePolygon), Map.entry("VIA", this::eVia), Map.entry("COVER", this::eCover), Map.entry("FIXED", this::eFixed), Map.entry("PLACED", this::ePlaced), Map.entry(";", this::eEnd));
        String section;
        Term mTerm = null;
        private int mPinCnt;
        private DevicePath relativePathToDevice = null;

        ParserPins() {
        }

        private PARSING_CONTROL eEnd() {
            return PARSING_CONTROL.DONE;
        }

        private PARSING_CONTROL eNet() {
            this.mNetName = LEFDEFParser.this.read();
            LEFDEFParser.this.addTermToEqNets(this.mPinName, this.mNetName);
            this.mNet = Net.getOrCreate((DeviceTemplate)LEFDEFParser.this.mCurrentDie.getTemplate(), (String)this.mNetName);
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL eSpecial() {
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL eDirection() {
            String d = LEFDEFParser.this.read();
            this.mTermType = LEFDEFSyntax.PinDirection.getTermType(d);
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL eNetExpr() {
            LEFDEFParser.this.read();
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL eSupplySensitivity() {
            LEFDEFParser.this.read();
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL eGroundSensitivity() {
            LEFDEFParser.this.read();
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL eUse() {
            String u = LEFDEFParser.this.read();
            this.mTermUse = LEFDEFSyntax.PinUse.getTermUse(u);
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL eAntennaPinPartialMetalArea() throws MalformedLEFDEFException {
            return LEFDEFParser.this.tillNewObjectOrAttribute();
        }

        private PARSING_CONTROL eAntennaPinPartialMetalSideArea() throws MalformedLEFDEFException {
            return LEFDEFParser.this.tillNewObjectOrAttribute();
        }

        private PARSING_CONTROL eAntennaPinPartialCutArea() throws MalformedLEFDEFException {
            return LEFDEFParser.this.tillNewObjectOrAttribute();
        }

        private PARSING_CONTROL eAntennaPinDiffArea() throws MalformedLEFDEFException {
            return LEFDEFParser.this.tillNewObjectOrAttribute();
        }

        private PARSING_CONTROL eAntennaModel() throws MalformedLEFDEFException {
            return LEFDEFParser.this.tillNewObjectOrAttribute();
        }

        private PARSING_CONTROL eAntennaPinGateArea() throws MalformedLEFDEFException {
            return LEFDEFParser.this.tillNewObjectOrAttribute();
        }

        private PARSING_CONTROL eAntennaPinMaxAreaCAR() throws MalformedLEFDEFException {
            return LEFDEFParser.this.tillNewObjectOrAttribute();
        }

        private PARSING_CONTROL eAntennaPinMaxSideAreaCAR() throws MalformedLEFDEFException {
            return LEFDEFParser.this.tillNewObjectOrAttribute();
        }

        private PARSING_CONTROL eAntennaPinMaxCutCAR() throws MalformedLEFDEFException {
            return LEFDEFParser.this.tillNewObjectOrAttribute();
        }

        private PARSING_CONTROL ePort() throws MalformedLEFDEFException {
            this.mPin = this.createPinTemplate(this.mPinName);
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL eLayer() throws MalformedLEFDEFException {
            String name = LEFDEFParser.this.read();
            if (name.isEmpty()) {
                throw new MalformedLEFDEFException(LEFDEFParser.this.fmtErrMsg(String.format("Expect layerName after 'LAYER', for pin: '%s'.", this.mPinName)));
            }
            LEFDEFParser.this.aMask();
            if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_SPACING)) {
                LEFDEFParser.this.read();
            } else if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_DESIGNRULEWIDTH)) {
                LEFDEFParser.this.read();
            }
            APoint2D pt1 = LEFDEFParser.this.eDEFPoint();
            APoint2D pt2 = LEFDEFParser.this.eDEFPoint();
            PinTemplate pin = this.getPin();
            PadTemplate pad = pin.getPadTemplate();
            Layer l = LEFDEFParser.this.getLayer(name);
            ARect r = ARect.create((APoint2D)pt1, (APoint2D)pt2);
            LayerShape ls = LayerShape.create((Db)LEFDEFParser.this.mDb, (Layer)l, (DbObject)pad, (AGeom)r);
            LEFDEFParser.this.mUnscaledLayerShapes.add(ls);
            return PARSING_CONTROL.MORE;
        }

        private PinTemplate getPin() throws MalformedLEFDEFException {
            if (this.mPin == null) {
                this.mPin = this.createPinTemplate(this.mPinName);
            }
            return this.mPin;
        }

        private PARSING_CONTROL ePolygon() throws MalformedLEFDEFException {
            String name = LEFDEFParser.this.read();
            if (name.isEmpty()) {
                throw new MalformedLEFDEFException("Expect layerName after 'POLYGON', when parsing %s, near line %d.", this.mPinName, LEFDEFParser.this.mCurLine);
            }
            LEFDEFParser.this.aMask();
            if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_SPACING)) {
                LEFDEFParser.this.read();
            } else if (LEFDEFParser.this.accept(LEFDEFSyntax.KW_DESIGNRULEWIDTH)) {
                LEFDEFParser.this.read();
            }
            APolygon poly = LEFDEFParser.this.eDEFPolygon();
            PinTemplate pin = this.getPin();
            PadTemplate pad = pin.getPadTemplate();
            Layer l = LEFDEFParser.this.getLayer(name);
            LayerShape ls = LayerShape.create((Db)LEFDEFParser.this.mDb, (Layer)l, (DbObject)pad, (AGeom)poly);
            LEFDEFParser.this.mUnscaledLayerShapes.add(ls);
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL eVia() throws MalformedLEFDEFException {
            return LEFDEFParser.this.tillNewObjectOrAttribute();
        }

        private PARSING_CONTROL eCover() throws MalformedLEFDEFException {
            APoint2D pt = LEFDEFParser.this.eDEFPoint();
            String orient = LEFDEFParser.this.aOrient();
            if (orient == null) {
                throw new MalformedLEFDEFException(LEFDEFParser.this.fmtErrMsg(String.format("Failed to read orient, for pin: '%s'", this.mPinName)));
            }
            APair<Long, Boolean> rotateAndMirror = LEFDEFOrient.ORIENT.getRotateMirror(orient);
            PinTemplate pin = this.getPin();
            pin.setLoc(pt);
            pin.setRotate((float)((Long)rotateAndMirror.first).longValue());
            pin.setMirror(((Boolean)rotateAndMirror.second).booleanValue());
            pin.setType(PinTemplate.Type.BUMPPAD);
            PinInstance p = PinInstance.getPinInstance((Device)LEFDEFParser.this.mCurrentDie, (PinTemplate)pin);
            p.fixed(true);
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL eFixed() throws MalformedLEFDEFException {
            APoint2D pt = LEFDEFParser.this.eDEFPoint();
            String orient = LEFDEFParser.this.aOrient();
            if (orient == null) {
                throw new MalformedLEFDEFException(LEFDEFParser.this.fmtErrMsg(String.format("Failed to read orient, for pin: '%s'", this.mPinName)));
            }
            APair<Long, Boolean> rotateAndMirror = LEFDEFOrient.ORIENT.getRotateMirror(orient);
            PinTemplate pin = this.getPin();
            pin.setLoc(pt);
            pin.setRotate((float)((Long)rotateAndMirror.first).longValue());
            pin.setMirror(((Boolean)rotateAndMirror.second).booleanValue());
            PinInstance p = PinInstance.getPinInstance((Device)LEFDEFParser.this.mCurrentDie, (PinTemplate)pin);
            p.fixed(true);
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL ePlaced() throws MalformedLEFDEFException {
            APoint2D pt = LEFDEFParser.this.eDEFPoint();
            String orient = LEFDEFParser.this.aOrient();
            if (orient == null) {
                throw new MalformedLEFDEFException(LEFDEFParser.this.fmtErrMsg(String.format("Failed to read orient, for pin: '%s'", this.mPinName)));
            }
            APair<Long, Boolean> rotateAndMirror = LEFDEFOrient.ORIENT.getRotateMirror(orient);
            PinTemplate pin = this.getPin();
            pin.setLoc(pt);
            pin.setRotate((float)((Long)rotateAndMirror.first).longValue());
            pin.setMirror(((Boolean)rotateAndMirror.second).booleanValue());
            return PARSING_CONTROL.MORE;
        }

        private PARSING_CONTROL eAttributeLevel() throws MalformedLEFDEFException {
            LEFDEFParser.this.accept('+');
            String keyword = LEFDEFParser.this.read();
            Dispatch r = this.dispatch.get(keyword.toUpperCase());
            if (r == null) {
                throw new MalformedLEFDEFException(LEFDEFParser.this.fmtErrMsg(String.format("%s Error! No handling of '%s' for pin: '%s'!", this.section, keyword, this.mPinName)));
            }
            return r.run();
        }

        private void parserObjectLevel() throws MalformedLEFDEFException {
            this.parsePinName();
            PARSING_CONTROL parsingLevel = PARSING_CONTROL.MORE;
            while (parsingLevel == PARSING_CONTROL.MORE) {
                parsingLevel = this.eAttributeLevel();
            }
            this.postObject();
        }

        private void applyDeferredAttributes(Term term) {
        }

        private boolean parsePinName() throws MalformedLEFDEFException {
            this.mPinName = LEFDEFParser.this.read();
            if (this.mPinName.isEmpty()) {
                throw new MalformedLEFDEFException("%s Error! Failed to get pinName. Near line %d.", this.section, LEFDEFParser.this.mCurLine);
            }
            return this.parserPin();
        }

        @Override
        public boolean perform() throws MalformedLEFDEFException {
            int numPins;
            if (LEFDEFParser.this.mCurrentDie == null) {
                throw new MalformedLEFDEFException("There is no DIEAREA defined. Exiting Read.");
            }
            if (LEFDEFParser.this.mSkipPins) {
                LEFDEFParser.this.after(LEFDEFSyntax.KW_END, LEFDEFSyntax.KW_PINS);
                LEFDEFParser.vInfo("[PINS] Skipped.", new Object[0]);
                return true;
            }
            this.section = "[PINS]";
            try {
                numPins = LEFDEFParser.this.eInt();
                if (numPins <= 0) {
                    throw new MalformedLEFDEFException(String.format("%s Error! A larger than 0 number is expected, but got %d. Near line %d.", this.section, numPins, LEFDEFParser.this.mCurLine));
                }
            }
            catch (NumberFormatException e) {
                String err = LEFDEFParser.this.fmtErrMsg("A number is expected after 'PINS', but not found");
                throw new MalformedLEFDEFException(err);
            }
            LEFDEFParser.this.expect(';');
            LEFDEFParser.this.mNameToTerm = new HashMap<String, Term>(LEFDEFParser.getNoRehashInitialCapacity(numPins));
            LEFDEFParser.this.mNetToEqNets = new HashMap<String, Set<String>>(LEFDEFParser.getNoRehashInitialCapacity(numPins));
            LEFDEFParser.this.mNetToOrgNet = new HashMap<String, String>(LEFDEFParser.getNoRehashInitialCapacity(numPins));
            while (LEFDEFParser.this.accept('-')) {
                this.parserObjectLevel();
            }
            if (!LEFDEFParser.this.accept(LEFDEFSyntax.KW_END)) {
                throw new MalformedLEFDEFException(LEFDEFParser.this.fmtErrMsg("Unhandled: " + LEFDEFParser.this.read()));
            }
            LEFDEFParser.this.expect(LEFDEFSyntax.KW_PINS);
            if ((long)numPins != this.nCreated) {
                LEFDEFParser.vInfo("[PINS] Read in %d pins when there should be %d.", this.nCreated, numPins);
            } else {
                LEFDEFParser.vInfo("[PINS] Read in %d pins.", this.nCreated);
            }
            return true;
        }

        private boolean parserPin() {
            this.mNet = null;
            this.mPin = null;
            this.mTermType = Term.TYPE_DEFAULT;
            this.mTermUse = Term.USE_DEFAULT;
            this.mTerm = null;
            this.mPinCnt = 0;
            return true;
        }

        private Term getTerm() throws MalformedLEFDEFException {
            if (this.mTerm == null) {
                if (this.mNet == null) {
                    throw new MalformedLEFDEFException("Failed to find 'NET netName', when parsing %s, near line %d.", this.mPinName, LEFDEFParser.this.mCurLine);
                }
                this.mTerm = Term.create((String)this.mPinName, (Net)this.mNet);
                this.mTerm.setType(this.mTermType);
                this.mTerm.setUse(this.mTermUse);
                LEFDEFParser.this.mNameToTerm.put(this.mPinName, this.mTerm);
            }
            return this.mTerm;
        }

        private void setPinLabel(PinTemplate pt) throws MalformedLEFDEFException {
            Term term = this.getTerm();
            PinLabel pl = PinLabel.get((DeviceTemplate)LEFDEFParser.this.mCurrentDie.getTemplate(), (DevicePath)this.getRelativePathToDevice(), (PinTemplate)pt);
            pl.setTerm(term);
            if (!pl.getTerm().equals(term)) {
                LEFDEFParser.vError("DEF PIN %s: Failed to set term:%s to pinlabel of pin:%s", this.mPinName, term.getName(), pt.getName());
            }
        }

        private void postObject() throws MalformedLEFDEFException {
            ++this.nCreated;
            this.applyDeferredAttributes(this.getTerm());
        }

        private final DevicePath getRelativePathToDevice() {
            if (this.relativePathToDevice == null) {
                this.relativePathToDevice = new DevicePath(LEFDEFParser.this.mCurrentDie.getTemplate());
            }
            return this.relativePathToDevice;
        }

        private PinTemplate createPinTemplate(String name) throws MalformedLEFDEFException {
            if (this.mPinCnt > 0) {
                name = (String)name + this.mPinCnt;
            }
            ++this.mPinCnt;
            PinTemplate pinT = PinTemplate.create((Net)this.mNet, (String)"", (String)name);
            PinInstance.create((Db)LEFDEFParser.this.mDb, (String)name, (Device)LEFDEFParser.this.mCurrentDie, (PinTemplate)pinT);
            pinT.setType(PinTemplate.Type.UNKNOWN);
            this.setPinLabel(pinT);
            this.createPort(pinT);
            return pinT;
        }

        private PortTemplate createPort(PinTemplate pinT) {
            PadTemplate pad = PadTemplate.create((Db)LEFDEFParser.this.mDb, (Substrate)LEFDEFParser.this.mSubstrate, (String)this.mPinName);
            PortTemplate port = PortTemplate.create((PinTemplate)pinT);
            port.setPadTemplate(pad);
            return port;
        }
    }

    static class PropertyValue {
        protected DefPropertyDescriptor desc;
        protected String value;

        public PropertyValue(DefPropertyDescriptor d, String v) {
            this.desc = d;
            this.value = v;
        }

        public DefPropertyDescriptor getDesc() {
            return this.desc;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.format("Prop[%s=%s]", this.desc.name, this.value);
        }

        public String toLEFDEFString() {
            if (this.desc.type.equals((Object)PropertyType.String)) {
                return String.format("%s \"%s\"", this.desc.name, this.value);
            }
            LEFDEFParser.vError("Unhandled type:%s. Continue with %s.", new Object[]{this.desc.type, this.toString()});
            return this.toString();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof PropertyValue)) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            PropertyValue other = (PropertyValue)obj;
            return this.desc.equals(other.desc) && this.value.equals(other.value);
        }

        public int hashCode() {
            return this.desc.hashCode() * 31 + this.value.hashCode();
        }
    }

    class DefPropertyDescriptor {
        protected String objectType;
        protected String name;
        protected PropertyType type;
        private double min;
        private double max;

        public DefPropertyDescriptor(String objType, String name, PropertyType type) {
            this(objType, name, type, Double.NaN, Double.NaN);
        }

        public DefPropertyDescriptor(String objType, String name, PropertyType type, double min, double max) {
            this.objectType = objType;
            this.name = name;
            this.type = type;
            this.min = min;
            this.max = max;
        }

        public String getObjectType() {
            return this.objectType;
        }

        public String getName() {
            return this.name;
        }

        public PropertyType getType() {
            return this.type;
        }

        public boolean hasRange() {
            return this.min != Double.NaN && this.max != Double.NaN;
        }

        public double getMin() {
            if (!this.hasRange()) {
                throw new IllegalArgumentException(String.format("%s property %s has no range!", this.objectType, this.name));
            }
            return this.min;
        }

        public double getMax() {
            if (!this.hasRange()) {
                throw new IllegalArgumentException(String.format("%s property %s has no range!", this.objectType, this.name));
            }
            return this.max;
        }

        public String toString() {
            return this.objectType + " " + this.name + " " + this.type.toString().toUpperCase() + " ; ";
        }
    }

    public static enum PropertyType {
        String,
        Real,
        Integer;


        public static PropertyType fromDefKeyword(String defKeyword) {
            defKeyword = ((String)defKeyword).length() <= 1 ? ((String)defKeyword).toUpperCase() : ((String)defKeyword).substring(0, 1).toUpperCase() + ((String)defKeyword).substring(1).toLowerCase();
            try {
                return PropertyType.valueOf((String)defKeyword);
            }
            catch (IllegalArgumentException iae) {
                return null;
            }
        }
    }

    public static class Context {
        protected String mLefUnitName = null;
        protected Double mLefDbuPerLefUnit = null;
        protected LinkedList<DeviceTemplate> mCreatedDeviceTemplates = new LinkedList();

        public static Context create() {
            return new Context();
        }
    }

    static interface ParserLEFDEFStatement {
        public boolean perform() throws MalformedLEFDEFException;
    }

    public static class MalformedLEFDEFException
    extends Exception {
        private final String mDetailedMessage;

        public MalformedLEFDEFException(String message) {
            this.mDetailedMessage = message;
        }

        public MalformedLEFDEFException(String format, Object ... args) {
            this(String.format(format, args));
        }

        @Override
        public String getMessage() {
            String msg = super.getMessage();
            return msg == null || msg.isEmpty() ? this.mDetailedMessage : this.mDetailedMessage + msg;
        }
    }
}

