/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.parsers;

import com.sigrity.acl.AFile;
import com.sigrity.acl.ALog;
import com.sigrity.acl.AString;
import com.sigrity.acl.util.IntCircularQueue;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;

public class RecDecParser {
    private static LinkedHashSet<LoadListener> sLoadListener = new LinkedHashSet();
    protected int mLastPercent = -1;
    protected Date mLastTime = new Date();
    protected long mLastRead = 0L;
    protected String mFileName;
    protected File mFile;
    protected BufferedReader mFileReader;
    private FileChannel mFileChannel;
    protected long mFileSize;
    protected long mCurLine = 0L;
    private boolean mLineBegin = true;
    protected IntCircularQueue mQ;
    protected StringBuilder mParsedTerminal = new StringBuilder();
    protected char mQuoteChar = (char)34;
    protected boolean mUserFileHandle = false;
    protected boolean mPoundKeyBeginningOnly = false;

    public static boolean addLoadListener(LoadListener l) {
        return sLoadListener.add(l);
    }

    public static boolean removeLoadListener(LoadListener l) {
        return sLoadListener.remove(l);
    }

    static boolean isWhitespace(char c) {
        return c == ' ' || c == '\t' || c == '\n' || c == '\r';
    }

    static boolean isEOF(char c) {
        return c == '\uffff';
    }

    public RecDecParser() {
        this(10240);
    }

    public RecDecParser(int size) {
        this.mQ = new IntCircularQueue(size);
    }

    private void fireDbCreated(int percent, int kBytesPerSecond, boolean done, String fileName) {
        for (LoadListener l : sLoadListener) {
            l.stats(percent, kBytesPerSecond, done, fileName);
        }
    }

    private void updateProgress(boolean done) {
        long readSoFar;
        if (done) {
            this.fireDbCreated(100, 0, true, this.mFileName);
            return;
        }
        if (sLoadListener.isEmpty()) {
            return;
        }
        Date now = new Date();
        if (now.getTime() - this.mLastTime.getTime() < 2000L) {
            return;
        }
        try {
            readSoFar = this.mFileChannel.position();
        }
        catch (IOException e) {
            readSoFar = 0L;
        }
        double percent = (double)readSoFar / (double)this.mFileSize;
        int iPercent = (int)(percent * 100.0);
        if (iPercent != this.mLastPercent) {
            this.mLastPercent = iPercent;
            double seconds = (double)(now.getTime() - this.mLastTime.getTime()) / 1000.0;
            long bytes = readSoFar - this.mLastRead;
            this.mLastTime = now;
            this.mLastRead = readSoFar;
            int kbps = seconds == 0.0 ? 0 : (int)((double)bytes / seconds) / 1000;
            this.fireDbCreated(iPercent, kbps, done, this.mFileName);
        }
    }

    public void pushToken(String s) {
        for (int i = 0; i < s.length(); ++i) {
            this.mQ.put((int)s.charAt(i));
        }
        this.mQ.put(32);
    }

    @Deprecated(forRemoval=true)
    public String getParsedTerminal() {
        return this.mParsedTerminal.toString();
    }

    public void setParsedTerminal(String token) {
        this.mParsedTerminal.setLength(0);
        this.mParsedTerminal.append(token);
    }

    public int getParseState() {
        return this.mQ.getReadPoint();
    }

    public void setParseState(int s) {
        this.mQ.setReadPoint(s);
    }

    public int saveState() {
        return this.mQ.saveState();
    }

    public void restoreState() {
        this.mQ.restoreState();
    }

    public void restoreState(int to) {
        this.mQ.restoreState(to);
    }

    public void closeFile() {
        try {
            this.mFileReader.close();
            this.mFileChannel.close();
        }
        catch (IOException e) {
            ALog.logError((String)"Can not close file");
        }
    }

    private boolean openGZIP() {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.mFile);
            this.mFileChannel = fis.getChannel();
            this.mFileReader = new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(fis), StandardCharsets.US_ASCII), 32768);
            return true;
        }
        catch (IOException e) {
            try {
                if (this.mFileReader != null) {
                    this.mFileReader.close();
                }
                if (this.mFileChannel != null) {
                    this.mFileChannel.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception e1) {
                ALog.logDebug((Throwable)e1, (String)"Unable to close '%s'", (Object[])new Object[]{this.mFile});
            }
            return false;
        }
    }

    private boolean openASCIIText() {
        try {
            this.mFileChannel = AFile.openAndLockWithTimeout((Path)this.mFile.toPath(), (boolean)true, (OpenOption[])new OpenOption[]{StandardOpenOption.READ});
            this.mFileReader = new BufferedReader(Channels.newReader((ReadableByteChannel)this.mFileChannel, StandardCharsets.US_ASCII), 32768);
            return true;
        }
        catch (AFile.InUseException | IOException | InterruptedException e) {
            ALog.logError((Throwable)e, (String)"Can not open '%s' for reading.", (Object[])new Object[]{this.mFile.getAbsolutePath()});
            try {
                if (this.mFileReader != null) {
                    this.mFileReader.close();
                }
                if (this.mFileChannel != null) {
                    this.mFileChannel.close();
                }
            }
            catch (Exception e1) {
                ALog.logDebug((Throwable)e1, (String)"Unable to close '%s'", (Object[])new Object[]{this.mFile});
            }
            return false;
        }
    }

    private boolean openInputFile(String filename) {
        if (!this.mUserFileHandle) {
            this.mFile = new File(filename);
        }
        return this.openGZIP() || this.openASCIIText();
    }

    public boolean setInFile(String filename) {
        this.mCurLine = 0L;
        if (!this.openInputFile(filename)) {
            return false;
        }
        this.mFileSize = this.mFile.length();
        this.mLastTime = new Date();
        this.mQ.reset();
        this.hasNextChar();
        return true;
    }

    public void setFile(File file) {
        this.mFile = file;
        this.mUserFileHandle = true;
    }

    public File getFile() {
        return this.mFile;
    }

    protected String parseKeywords(List<String> tokens) {
        this.mQ.saveState();
        while (this.hasNextChar()) {
            this.popWhitespaces();
            if (!this.hasNextChar()) break;
            for (String e : tokens) {
                if (!this.popToken(e)) continue;
                this.mQ.discardState();
                return e;
            }
            this.nextChar();
            if (!this.hasNextChar()) break;
            this.popNonWhitespaces();
        }
        this.mQ.restoreState();
        return null;
    }

    protected boolean anythingAndStopAt(String stop) {
        return this.findAnyStopAt(List.of(stop)) != null;
    }

    protected String findAnyStopAt(List<String> stops) {
        return this.findAnyStopAt(this.newSpacedKeywordParser(stops));
    }

    protected String findAnyStopAt(SpacedKeywordParser skp) {
        this.mQ.saveState();
        String token = skp.parseIgnoreCase();
        if (token.isEmpty()) {
            this.mQ.restoreState();
            return null;
        }
        this.mQ.discardState();
        return token;
    }

    protected boolean findWord(String word) {
        this.mQ.saveState();
        while (true) {
            if (this.popToken(word)) {
                this.mQ.discardState();
                return true;
            }
            this.nextChar();
            if (!this.hasNextChar()) break;
            this.popNonWhitespaces();
        }
        this.mQ.restoreState();
        return false;
    }

    protected boolean popNonWhitespaces() {
        boolean found = false;
        char c = this.nextChar();
        while (!RecDecParser.isEOF(c) && !RecDecParser.isWhitespace(c)) {
            found = true;
            c = this.nextChar();
        }
        this.mQ.decrReadPoint();
        return found;
    }

    protected boolean popWhitespaces() {
        boolean found = false;
        char c = this.nextChar();
        while (!RecDecParser.isEOF(c) && RecDecParser.isWhitespace(c)) {
            found = true;
            c = this.nextChar();
        }
        this.mQ.decrReadPoint();
        return found;
    }

    protected boolean peekWhitespace() {
        this.mQ.saveState();
        boolean isWhiteSpace = this.popWhitespaces();
        this.mQ.restoreState();
        return isWhiteSpace;
    }

    protected boolean popChar(char target) {
        assert (!RecDecParser.isWhitespace(target));
        this.mQ.saveState();
        this.popWhitespaces();
        char c = this.nextChar();
        if (c == target) {
            this.mQ.discardState();
            return true;
        }
        this.mQ.restoreState();
        return false;
    }

    public double forcePopDouble() {
        if (!this.popNoSpaceTerminal()) {
            return Double.NaN;
        }
        Double v = AString.parseDouble((StringBuilder)this.mParsedTerminal);
        if (v != null) {
            return v;
        }
        return Double.NaN;
    }

    public double popDouble() {
        this.mQ.saveState();
        double v = this.forcePopDouble();
        if (!Double.isNaN(v)) {
            return v;
        }
        this.mQ.restoreState();
        return Double.NaN;
    }

    public Long popLong() {
        this.mQ.saveState();
        if (!this.popNoSpaceTerminal()) {
            this.mQ.restoreState();
            return null;
        }
        Long ret = AString.parseLong((StringBuilder)this.mParsedTerminal);
        if (ret != null) {
            return ret;
        }
        this.mQ.restoreState();
        return null;
    }

    protected boolean popLine() {
        this.mQ.saveState();
        this.mParsedTerminal.setLength(0);
        this.popWhitespaces();
        char c = this.nextChar();
        if (RecDecParser.isEOF(c)) {
            this.mQ.discardState();
            return false;
        }
        while (c != '\n' && !RecDecParser.isEOF(c)) {
            this.mParsedTerminal.append(c);
            c = this.nextChar();
        }
        if (this.mParsedTerminal.length() > 0) {
            if (this.mParsedTerminal.charAt(this.mParsedTerminal.length() - 1) == '\r') {
                this.mParsedTerminal.setLength(this.mParsedTerminal.length() - 1);
            }
            this.mQ.discardState();
            return true;
        }
        this.mQ.restoreState();
        return false;
    }

    protected boolean popNoSpaceTerminal() {
        this.mParsedTerminal.setLength(0);
        this.mQ.saveState();
        this.popWhitespaces();
        char c = this.nextChar();
        while (!RecDecParser.isWhitespace(c) && !RecDecParser.isEOF(c)) {
            this.mParsedTerminal.append(c);
            c = this.nextChar();
        }
        if (this.mParsedTerminal.length() > 0) {
            this.mQ.discardState();
            this.mQ.decrReadPoint();
        } else {
            this.mQ.restoreState();
        }
        return this.mParsedTerminal.length() > 0;
    }

    public String popANoSpaceTerminal() {
        this.popNoSpaceTerminal();
        return this.mParsedTerminal.toString();
    }

    public boolean popToken() {
        this.mParsedTerminal.setLength(0);
        this.mQ.saveState();
        this.popWhitespaces();
        char c = this.nextChar();
        if (c == this.mQuoteChar) {
            do {
                this.mParsedTerminal.append(c);
            } while (this.hasNextChar() && (c = this.nextChar()) != this.mQuoteChar && !RecDecParser.isEOF(c));
            if (c == this.mQuoteChar) {
                this.mParsedTerminal.append(c);
                this.nextChar();
            } else {
                this.mParsedTerminal.setLength(0);
            }
        } else {
            while (!RecDecParser.isWhitespace(c) && !RecDecParser.isEOF(c)) {
                this.mParsedTerminal.append(c);
                if (!this.hasNextChar()) break;
                c = this.nextChar();
            }
        }
        if (this.mParsedTerminal.length() > 0) {
            this.mQ.discardState();
            this.mQ.decrReadPoint();
        } else {
            this.mQ.restoreState();
        }
        return this.mParsedTerminal.length() > 0;
    }

    protected boolean popQuotedString() {
        this.mQ.saveState();
        this.mParsedTerminal.setLength(0);
        this.popWhitespaces();
        char c = this.nextChar();
        if (RecDecParser.isEOF(c)) {
            this.mQ.restoreState();
            return false;
        }
        this.hasNextChar();
        if (c == this.mQuoteChar) {
            c = this.nextChar();
            if (RecDecParser.isEOF(c)) {
                this.mQ.restoreState();
                return false;
            }
            this.hasNextChar();
            while (c != this.mQuoteChar) {
                this.mParsedTerminal.append(c);
                c = this.nextChar();
                if (RecDecParser.isEOF(c)) {
                    this.mQ.restoreState();
                    return false;
                }
                this.hasNextChar();
            }
            this.mQ.discardState();
            return true;
        }
        this.mQ.restoreState();
        return false;
    }

    protected boolean popToken(String token) {
        this.mQ.saveState();
        this.popWhitespaces();
        int len = token.length();
        for (int i = 0; i < len; ++i) {
            char c = this.nextChar();
            if (c != token.charAt(i)) {
                this.mQ.restoreState();
                return false;
            }
            this.hasNextChar();
        }
        this.mQ.discardState();
        return true;
    }

    protected boolean popStopChar(char stop1, char stop2) {
        this.mQ.saveState();
        while (this.hasNextChar()) {
            char c = this.nextChar();
            if (c != stop1 && c != stop2) continue;
            this.mParsedTerminal.setLength(0);
            this.mParsedTerminal.append(c);
            this.mQ.discardState();
            return true;
        }
        this.mQ.restoreState();
        return false;
    }

    protected boolean hasNextChar() {
        int c = -1;
        if (this.mQ.empty()) {
            try {
                c = this.mFileReader.read();
                char cc = (char)c;
                if (cc == '#' && (this.mLineBegin || !this.mPoundKeyBeginningOnly)) {
                    while (cc != '\n') {
                        c = this.mFileReader.read();
                        cc = (char)c;
                    }
                }
                this.mQ.put((int)cc);
                if (cc == '\n') {
                    ++this.mCurLine;
                    this.mLineBegin = true;
                } else {
                    this.mLineBegin = false;
                }
                this.updateProgress(false);
            }
            catch (IOException e) {
                c = -1;
            }
        } else {
            c = this.mQ.peek();
        }
        if (c == -1) {
            this.updateProgress(true);
        }
        return c != -1;
    }

    protected char nextChar() {
        if (!this.hasNextChar()) {
            return '\uffff';
        }
        return (char)this.mQ.pop();
    }

    public void doneReading() {
        this.updateProgress(true);
    }

    SpacedKeywordParser newSpacedKeywordParser(List<String> keywords) {
        return new SpacedKeywordParser(keywords);
    }

    class SpacedKeywordParser {
        Map<List<String>, String> mTuple2Keywords = new HashMap<List<String>, String>();
        List<List<String>> tuples = new LinkedList<List<String>>();

        private void setup(List<String> keywords) {
            for (String w : keywords) {
                String[] noSpaced = w.split(" ");
                List tuple = Arrays.stream(noSpaced).filter(s -> !s.isEmpty()).collect(Collectors.toList());
                if (this.mTuple2Keywords.put(tuple, w) != null) {
                    throw new IllegalArgumentException(String.format("There are duplicates in %s. One of them is:%s", String.join((CharSequence)",", keywords), w));
                }
                this.tuples.add(tuple);
            }
        }

        private SpacedKeywordParser(List<String> keywords) {
            this.setup(keywords);
        }

        String parseIgnoreCase() {
            return this.parse(true);
        }

        String parse() {
            return this.parse(false);
        }

        private String parse(boolean ignoreCase) {
            String terminal;
            RecDecParser.this.mQ.saveState();
            while (!(terminal = RecDecParser.this.popANoSpaceTerminal()).isEmpty()) {
                int ptrNextTerminal = RecDecParser.this.mQ.getReadPoint();
                String kw = this.match(terminal, this.tuples, 0, ignoreCase);
                if (kw == null) {
                    RecDecParser.this.mQ.setReadPoint(ptrNextTerminal);
                    continue;
                }
                if (kw.isEmpty()) break;
                RecDecParser.this.mQ.discardState();
                return kw;
            }
            RecDecParser.this.mQ.restoreState();
            return "";
        }

        private String match(String token, List<List<String>> matchedTuples, int index, boolean ignoreCase) {
            BiFunction<String, String, Boolean> isSame = (a, b) -> ignoreCase ? a.equalsIgnoreCase((String)b) : a.equals(b);
            LinkedList<List<String>> matched = new LinkedList<List<String>>();
            for (List<String> tuple : matchedTuples) {
                if (!isSame.apply(tuple.get(index), token).booleanValue()) continue;
                matched.add(tuple);
            }
            ++index;
            int numMatched = matched.size();
            if (numMatched == 0) {
                return null;
            }
            if (numMatched == 1 && ((List)matched.get(0)).size() == index) {
                return this.mTuple2Keywords.get(matched.get(0));
            }
            token = RecDecParser.this.popANoSpaceTerminal();
            if (token.isEmpty()) {
                return "";
            }
            return this.match(token, matched, index, ignoreCase);
        }
    }

    public static interface LoadListener {
        public void stats(int var1, int var2, boolean var3, String var4);
    }
}

