/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.parsers;

import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.zip.GZIPInputStream;

public class TokenParser {
    private static LinkedHashSet<LoadListener> sLoadListener = new LinkedHashSet();
    protected int mLastPercent = -1;
    protected Date mLastTime = new Date();
    protected long mLastRead = 0L;
    protected String mFileName;
    protected File mFile;
    protected BufferedReader mFileReader;
    private FileChannel mFileChannel;
    protected long mFileSize;
    protected long mCurLine = 0L;
    private CircularQueue mQ;
    private static final char QUOTE_CHAR = '\"';
    protected boolean mUserFileHandle = false;
    static final int LONGEST_LEFDEF_IDENTIFIER = 2048;

    public static boolean addLoadListener(LoadListener l) {
        return sLoadListener.add(l);
    }

    public static boolean removeLoadListener(LoadListener l) {
        return sLoadListener.remove(l);
    }

    static boolean isWhitespace(char c) {
        return c == ' ' || c == '\t' || c == '\n' || c == '\r';
    }

    public TokenParser(int size) {
        int bufferLimit = size * 2048 / 4;
        char[] buffer = new char[bufferLimit + 2048];
        this.mQ = CircularQueue.newWithBuffer(size, buffer, bufferLimit);
    }

    private void fireDbCreated(int percent, int kBytesPerSecond, boolean done, String fileName) {
        for (LoadListener l : sLoadListener) {
            l.stats(percent, kBytesPerSecond, done, fileName);
        }
    }

    private void updateProgress(boolean done) {
        long readSoFar;
        if (done) {
            this.fireDbCreated(100, 0, true, this.mFileName);
            return;
        }
        if (sLoadListener.isEmpty()) {
            return;
        }
        Date now = new Date();
        if (now.getTime() - this.mLastTime.getTime() < 2000L) {
            return;
        }
        try {
            readSoFar = this.mFileChannel.position();
        }
        catch (IOException e) {
            readSoFar = 0L;
        }
        double percent = (double)readSoFar / (double)this.mFileSize;
        int iPercent = (int)(percent * 100.0);
        if (iPercent != this.mLastPercent) {
            this.mLastPercent = iPercent;
            double seconds = (double)(now.getTime() - this.mLastTime.getTime()) / 1000.0;
            long bytes = readSoFar - this.mLastRead;
            this.mLastTime = now;
            this.mLastRead = readSoFar;
            int kbps = seconds == 0.0 ? 0 : (int)((double)bytes / seconds) / 1000;
            this.fireDbCreated(iPercent, kbps, done, this.mFileName);
        }
    }

    public void closeFile() {
        try {
            this.mFileReader.close();
            this.mFileChannel.close();
        }
        catch (IOException e) {
            ALog.logError((String)"Can not close file");
        }
    }

    private boolean openGZIP() {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.mFile);
            this.mFileChannel = fis.getChannel();
            this.mFileReader = new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(fis), StandardCharsets.US_ASCII), 32768);
            return true;
        }
        catch (IOException e) {
            try {
                if (this.mFileReader != null) {
                    this.mFileReader.close();
                }
                if (this.mFileChannel != null) {
                    this.mFileChannel.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception e1) {
                ALog.logDebug((Throwable)e1, (String)"Unable to close '%s'", (Object[])new Object[]{this.mFile});
            }
            return false;
        }
    }

    private boolean openASCIIText() {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.mFile);
            this.mFileChannel = fis.getChannel();
            this.mFileReader = new BufferedReader(new InputStreamReader(fis), 32768);
            return true;
        }
        catch (IOException e) {
            ALog.logError((Throwable)e, (String)"Can not open '%s' for reading.", (Object[])new Object[]{this.mFile.getAbsolutePath()});
            try {
                if (this.mFileReader != null) {
                    this.mFileReader.close();
                }
                if (this.mFileChannel != null) {
                    this.mFileChannel.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception e1) {
                ALog.logDebug((Throwable)e1, (String)"Unable to close '%s'", (Object[])new Object[]{this.mFile});
            }
            return false;
        }
    }

    private boolean openInputFile(String filename) {
        if (!this.mUserFileHandle) {
            this.mFile = new File(filename);
        }
        return this.openGZIP() || this.openASCIIText();
    }

    public boolean setInFile(String filename) {
        this.mCurLine = 0L;
        if (!this.openInputFile(filename)) {
            return false;
        }
        this.mFileSize = this.mFile.length();
        this.mLastTime = new Date();
        this.mQ.reset();
        this.hasNextToken();
        return true;
    }

    public void setFile(File file) {
        this.mFile = file;
        this.mUserFileHandle = true;
    }

    public File getFile() {
        return this.mFile;
    }

    protected boolean findChar(char c) {
        TokenInfo ti;
        do {
            if ((ti = this.nextToken()) != null) continue;
            return false;
        } while (!ti.acceptCS(c));
        return true;
    }

    protected boolean findWord(char[] word) {
        TokenInfo ti;
        do {
            if ((ti = this.nextToken()) != null) continue;
            return false;
        } while (!ti.accept(word));
        return true;
    }

    public String popToken() {
        String token = "";
        TokenInfo ti = this.nextToken();
        if (ti != null) {
            token = ti.getString();
        }
        return token;
    }

    protected TokenInfo popTokenInfo() {
        return this.nextToken();
    }

    protected TokenInfo popStopCharInfo(char stop1, char stop2) {
        TokenInfo ti;
        while ((ti = this.nextToken()) != null) {
            if (ti.len != 1 || !ti.acceptCS(stop1) && !ti.acceptCS(stop2)) continue;
            return ti;
        }
        return null;
    }

    private void skipComment() throws IOException {
        char cc;
        while ((cc = (char)this.mFileReader.read()) != '\n') {
        }
        ++this.mCurLine;
    }

    private boolean hasNextToken() {
        if (this.mQ.empty()) {
            try {
                char last = '\n';
                while (true) {
                    char cc;
                    if ((cc = (char)this.mFileReader.read()) == '\n') {
                        ++this.mCurLine;
                    }
                    if (cc == '#' && TokenParser.isWhitespace(last)) {
                        this.skipComment();
                        cc = '\n';
                    } else if (cc == '\"') {
                        this.mQ.putQuotedBegin();
                        while (true) {
                            last = cc;
                            cc = (char)this.mFileReader.read();
                            if (cc == '#' && TokenParser.isWhitespace(last)) {
                                this.skipComment();
                                cc = '\n';
                                continue;
                            }
                            if (cc == '\n') {
                                ++this.mCurLine;
                            }
                            if (this.mQ.putQuoted(cc)) break;
                        }
                    } else if (cc == '\uffff' || this.mQ.put(cc)) break;
                    last = cc;
                }
                this.updateProgress(false);
            }
            catch (IOException e) {
                ALog.logError((Throwable)e);
            }
        }
        return !this.mQ.empty();
    }

    private TokenInfo nextToken() {
        if (!this.hasNextToken()) {
            return null;
        }
        return this.mQ.pop();
    }

    public void doneReading() {
        this.updateProgress(true);
    }

    public static interface LoadListener {
        public void stats(int var1, int var2, boolean var3, String var4);
    }

    private static class CircularQueue {
        private final int[] mCharsLen;
        private final int[] mCharsStart;
        private final TokenInfo[] mTokenInfo;
        private final char[] mBuffer;
        private int mSize;
        private int mIn;
        private int mInStart;
        private int mInPtr;
        private final int mBufferLimit;
        private int mOut;
        static final int EOF_I = -1;
        static final char EOF = '\uffff';

        public static CircularQueue newWithBuffer(int size, char[] buffer, int bufferLimit) {
            return new CircularQueue(size, buffer, bufferLimit);
        }

        public CircularQueue(int size, char[] buffer, int bufferLimit) {
            this.mBuffer = buffer;
            this.mBufferLimit = bufferLimit;
            this.mCharsLen = new int[size];
            this.mCharsStart = new int[size];
            this.mTokenInfo = new TokenInfo[size];
            TokenInfo.initWithBuffer(buffer);
            for (int i = 0; i < size; ++i) {
                this.mTokenInfo[i] = new TokenInfo();
            }
            this.mSize = size;
            this.mIn = 0;
            this.mOut = 0;
            this.mInStart = 0;
            this.mInPtr = 0;
        }

        public boolean empty() {
            return this.mIn == this.mOut;
        }

        private boolean closeCurrent() {
            if (this.mInPtr == this.mInStart) {
                return false;
            }
            this.mCharsStart[this.mIn] = this.mInStart;
            this.mCharsLen[this.mIn] = this.mInPtr - this.mInStart;
            if (this.mInPtr > this.mBufferLimit) {
                this.mInPtr = 0;
            }
            this.mInStart = this.mInPtr;
            ++this.mIn;
            if (this.mIn == this.mSize) {
                this.mIn = 0;
            }
            if (this.mIn == this.mOut) {
                throw new IllegalStateException("Sorry, default capacity of circular queue is too small");
            }
            return true;
        }

        public boolean put(char c) {
            if (!TokenParser.isWhitespace(c)) {
                this.mBuffer[this.mInPtr] = c;
                ++this.mInPtr;
                return false;
            }
            return this.closeCurrent();
        }

        public void putQuotedBegin() {
            this.closeCurrent();
            this.mBuffer[this.mInPtr] = 34;
            ++this.mInPtr;
        }

        public boolean putQuoted(char c) {
            this.mBuffer[this.mInPtr] = c;
            ++this.mInPtr;
            if (c == '\"') {
                return this.closeCurrent();
            }
            return false;
        }

        public TokenInfo pop() {
            TokenInfo ti = this.mTokenInfo[this.mOut];
            ti.init(this.mCharsStart[this.mOut], this.mCharsLen[this.mOut]);
            this.incReadPoint();
            return ti;
        }

        private void incReadPoint() {
            ++this.mOut;
            if (this.mOut == this.mSize) {
                this.mOut = 0;
            }
        }

        public void reset() {
            this.mOut = 0;
            this.mIn = 0;
        }
    }

    protected static class TokenInfo {
        private static char[] mBuffer;
        int start;
        int len;
        private String str;

        protected TokenInfo() {
        }

        static void initWithBuffer(char[] buffer) {
            mBuffer = buffer;
        }

        void init(int start, int l) {
            this.len = l;
            this.str = null;
            this.start = start;
        }

        private boolean matchCI(char[] upperCaseSymbol) {
            if (this.len != upperCaseSymbol.length) {
                return false;
            }
            int idx = 0;
            while (idx < this.len) {
                char c2;
                char c1 = mBuffer[this.start + idx];
                if (c1 == (c2 = upperCaseSymbol[idx++]) || Character.toUpperCase(c1) == c2) continue;
                return false;
            }
            return true;
        }

        boolean accept(String caseSensitiveSymbol) {
            return this.getString().equals(caseSensitiveSymbol);
        }

        boolean accept(char[] upperCaseSymbol) {
            return this.matchCI(upperCaseSymbol);
        }

        boolean accept(char c) {
            return this.len == 1 && (mBuffer[this.start] == c || Character.toUpperCase(mBuffer[this.start]) == c);
        }

        boolean acceptCS(char c) {
            return this.len == 1 && mBuffer[this.start] == c;
        }

        String getString() {
            if (this.str == null) {
                this.str = new String(mBuffer, this.start, this.len);
            }
            return this.str;
        }

        Double aDouble() {
            return AUtil.parseDouble((String)this.getString());
        }

        Integer aInt() {
            return AUtil.parseInt((String)this.getString());
        }

        Long aLong() {
            return AUtil.parseLong((String)this.getString());
        }

        double eDouble() {
            return Double.parseDouble(this.getString());
        }

        int eInt() {
            return Integer.parseInt(this.getString());
        }

        long eLong() {
            return Long.parseLong(this.getString());
        }

        String read() {
            return this.getString();
        }
    }
}

