/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.reporter;

import com.sigrity.acl.ALog;
import com.sigrity.acl.app.AApp;
import com.sigrity.acl.xml.AXDomUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AReport {
    public static final String CHARSET_ENCODING = "UTF-8";
    Document mDoc;
    Element mRoot;
    Stack<Element> mSectionStack = new Stack();

    public AReport(String name) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            this.mDoc = docBuilder.newDocument();
            this.mRoot = this.mDoc.createElement(name);
            this.mDoc.appendChild(this.mRoot);
            this.mSectionStack.push(this.mRoot);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public Element push(String section) {
        Element childElement = this.mDoc.createElement("section");
        childElement.setAttribute("sectionName", section);
        this.mSectionStack.peek().appendChild(childElement);
        this.mSectionStack.push(childElement);
        return childElement;
    }

    public void pop() {
        this.mSectionStack.pop();
    }

    public void nameValuePair(String lineType, String lineValue) {
        this.mSectionStack.peek().setAttribute(lineType, lineValue);
    }

    public void print(File template, Writer out) {
        try {
            InputStreamReader r = new InputStreamReader((InputStream)new FileInputStream(template), CHARSET_ENCODING);
            this.print(r, out);
        }
        catch (Exception e) {
            ALog.logError((String)"Unable to open file %s : %s", (Object[])new Object[]{template.getAbsolutePath(), e.getMessage()});
        }
    }

    public void print(String template, Writer out) {
        this.print(new StringReader(template), out);
    }

    public void print(Reader template, Writer out) {
        try {
            String sXML = AXDomUtil.serialize((Node)this.mRoot);
            StreamSource stSrc = new StreamSource(new StringReader(new String(sXML.getBytes(), CHARSET_ENCODING)));
            StreamSource stTpl = new StreamSource(template);
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer(stTpl);
            transformer.transform(stSrc, new StreamResult(out));
        }
        catch (Exception e) {
            ALog.logError((String)e.getMessage());
        }
    }

    public static void test(Writer out) {
        String xslDemo = "examples/ORI_DDR_Demo/report_demo.xsl";
        AReport r = new AReport("Test");
        r.push("Section 1");
        r.nameValuePair("year", "2008");
        r.nameValuePair("month", "January");
        r.push("Section 1.1");
        r.nameValuePair("language", "java");
        r.pop();
        r.pop();
        r.push("Section 2");
        r.nameValuePair("year", "2009");
        try {
            File f = new File(AApp.getInstallDir(), "examples/ORI_DDR_Demo/report_demo.xsl");
            r.print(f, out);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }
}

