/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.scriptui;

import com.sigrity.acl.ALog;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.app.AApp;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.script.AScriptMgr;
import com.sigrity.acl.scriptui.AScriptEngineSelector;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.FileReader;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class AEvaluationUI
extends JPanel {
    protected static final int MAX_SAVED_COMMANDS = 256;
    public static final String SETTING_SECTION = "AScriptingUI";
    public static final String SETTING_PREFIX_COMMAND = "Command";
    protected Evaluator mEvaluator;
    protected JComboBox<String> mCboCommands;
    protected DefaultComboBoxModel<String> mCommands;
    protected KeyListener mKeyListener = new KeyAdapter(){

        @Override
        public void keyTyped(KeyEvent e) {
            super.keyTyped(e);
            char key = e.getKeyChar();
            if (key == '\n') {
                String cmd = (String)AEvaluationUI.this.mCboCommands.getSelectedItem();
                if (cmd != null) {
                    cmd = cmd.trim();
                }
                if (cmd == null || cmd.length() == 0) {
                    return;
                }
                int idx = AEvaluationUI.this.mCommands.getIndexOf(cmd);
                if (idx >= 0) {
                    AEvaluationUI.this.mCommands.removeElementAt(idx);
                }
                AEvaluationUI.this.mCommands.insertElementAt(cmd, 0);
                AEvaluationUI.this.mCommands.setSelectedItem(null);
                AEvaluationUI.this.saveCommands();
                ALog.logInfo((String)"[%s] '%s'", (Object[])new Object[]{AEvaluationUI.this.mEvaluator.getName(), cmd});
                try {
                    AEvaluationUI.this.mEvaluator.eval(cmd);
                }
                catch (Throwable t) {
                    String msg = t.getMessage();
                    if (msg == null) {
                        msg = t.toString();
                    }
                    ALog.logError((Throwable)t, (String)"Error: %s.", (Object[])new Object[]{msg});
                }
            }
        }
    };

    public static void logRegisteredEngines() {
        for (String s : AEvaluationUI.getRegisteredEngineInfos()) {
            ALog.logInfo((String)s);
        }
    }

    public static IterableIterator<String> getRegisteredEngineInfos() {
        return AScriptMgr.getDefault().getEngineInfos();
    }

    public static AEvaluationUI createFor(final ScriptEngine scriptEngine) {
        return new AEvaluationUI(new Evaluator(){

            @Override
            public String getName() {
                return scriptEngine.getFactory().getEngineName();
            }

            @Override
            public Object eval(String s) throws Throwable {
                return scriptEngine.eval(s);
            }

            @Override
            public Object source(String filePath) throws Throwable {
                FileReader fr = new FileReader(filePath);
                return scriptEngine.eval(fr);
            }
        });
    }

    public static void showDialog(String engineName) {
        ScriptEngineManager sem = AScriptMgr.getDefault().getScriptEngineManager();
        ScriptEngine se = sem.getEngineByName(engineName);
        if (se == null) {
            ALog.logError((String)"Could not find a registered script engine named '%s'.", (Object[])new Object[]{engineName});
            return;
        }
        AEvaluationUI.showDialog(se);
    }

    public static void showDialog(ScriptEngine se) {
        ADialog dlg = new ADialog(AApp.getApp() == null ? null : AApp.getApp().getMainWin());
        dlg.setTitle(String.format("Language '%s'", se.getFactory().getLanguageName()));
        GridBagManager l = GridBagManager.layout((JDialog)dlg);
        AEvaluationUI evalUi = AEvaluationUI.createFor(se);
        l.add((Component)evalUi, (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        l.addFillY();
        dlg.pack();
        Dimension prefDim = dlg.getPreferredSize();
        dlg.setMinimumSize(prefDim);
        dlg.setPreferredSize(new Dimension(prefDim.width * 2, prefDim.height));
        dlg.pack();
        UIUtil.center((Component)dlg);
        dlg.setVisible(true);
    }

    public static void showDialog() {
        ScriptEngineFactory sef = AScriptEngineSelector.selectScriptEngine();
        if (sef != null) {
            AEvaluationUI.showDialog(sef.getScriptEngine());
        }
    }

    public AEvaluationUI(Evaluator evaluator) {
        if (evaluator == null) {
            throw new NullPointerException();
        }
        this.mEvaluator = evaluator;
        this.setBorder(null);
        GridBagManager l = GridBagManager.layout((Container)this);
        this.mCboCommands = new JComboBox();
        this.mCboCommands.setEditable(true);
        l.add(this.mCboCommands, (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        Dimension ps = this.mCboCommands.getPreferredSize();
        this.mCboCommands.setMinimumSize(new Dimension(ps.height, 20));
        this.mCboCommands.getEditor().getEditorComponent().addKeyListener(this.mKeyListener);
        this.mCommands = (DefaultComboBoxModel)this.mCboCommands.getModel();
        this.restoreCommands();
        this.mCboCommands.setSelectedIndex(-1);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                AEvaluationUI.this.mCboCommands.requestFocusInWindow();
            }
        });
    }

    public String getSettingSectionName() {
        return String.format("%s-%s", SETTING_SECTION, this.mEvaluator.getName().replace(' ', '_'));
    }

    protected void saveCommands() {
        Settings s = Settings.getSettings((String)this.getSettingSectionName());
        s.removeAll(Settings.Type.User);
        for (int i = 0; i < this.mCommands.getSize() && i < 256; ++i) {
            s.putSetting(SETTING_PREFIX_COMMAND + i, (Object)this.mCommands.getElementAt(i));
        }
        s.save();
    }

    protected void restoreCommands() {
        String cmd;
        Settings mruSettings = Settings.getSettings((String)this.getSettingSectionName());
        for (int i = 0; i < 256 && (cmd = (String)mruSettings.getSettingOfClass(SETTING_PREFIX_COMMAND + i, String.class)) != null; ++i) {
            if ((cmd = cmd.trim()).length() == 0) continue;
            this.mCommands.addElement(cmd);
        }
    }

    public static interface Evaluator {
        public String getName();

        public Object eval(String var1) throws Throwable;

        public Object source(String var1) throws Throwable;
    }
}

