/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.scriptui;

import com.sigrity.acl.MutableBoolean;
import com.sigrity.acl.app.AApp;
import com.sigrity.acl.script.AScriptMgr;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JScrollPane;

public class AScriptEngineSelector {
    public static ScriptEngineFactory selectScriptEngine() {
        ScriptEngineManager sem = AScriptMgr.getDefault().getScriptEngineManager();
        List<ScriptEngineFactory> factories = sem.getEngineFactories();
        final ADialog dlg = new ADialog(AApp.getApp() == null ? null : AApp.getApp().getMainWin());
        dlg.setTitle("Select Script Engine");
        dlg.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        GridBagManager l = GridBagManager.layout((JDialog)dlg);
        JList<Object> lstEngines = new JList<Object>();
        lstEngines.setSelectionMode(0);
        l.add((Component)new JScrollPane(lstEngines), (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
        lstEngines.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                ScriptEngineFactory sef = (ScriptEngineFactory)value;
                this.setText(String.format("%s (%s)", sef.getLanguageName(), sef.getEngineName()));
                return this;
            }
        });
        l.newline();
        l.push((GridBagConstraints)GridBagManager.FILLX_REMAINX);
        l.addFillX();
        final JButton btnOk = (JButton)l.add((Component)new JButton("OK"));
        JButton btnCancelButton = (JButton)l.add((Component)new JButton("Cancel"));
        l.pop();
        dlg.pack();
        Dimension prefDim = dlg.getPreferredSize();
        dlg.setMinimumSize(prefDim);
        dlg.setPreferredSize(new Dimension(prefDim.width * 2, prefDim.height));
        UIUtil.enableEscCloseDefaultMinSize((JDialog)dlg, (AbstractButton)btnCancelButton, (JButton)btnOk);
        dlg.pack();
        UIUtil.center((Component)dlg);
        final MutableBoolean accepted = new MutableBoolean(false);
        btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                accepted.setValue(true);
                UIUtil.closeWindow((Window)dlg);
            }
        });
        lstEngines.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    return;
                }
                if (e.getButton() == 1 && e.getClickCount() == 2) {
                    btnOk.doClick();
                }
            }
        });
        DefaultListModel lm = new DefaultListModel();
        factories.stream().sorted((a, b) -> a.getLanguageName().compareTo(b.getLanguageName())).forEach(f -> lm.addElement(f));
        lstEngines.setModel(lm);
        dlg.setVisible(true);
        if (!accepted.getValue()) {
            return null;
        }
        ScriptEngineFactory sef = (ScriptEngineFactory)lstEngines.getSelectedValue();
        if (sef == null) {
            return null;
        }
        return sef;
    }
}

