/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.topology.fUniverse;

import com.sigrity.acl.topology.fUniverse.AForceVector;
import com.sigrity.acl.topology.fUniverse.AParticle;

public abstract class AForce<V, E> {
    protected AParticle<V, E> oA;
    protected AParticle<V, E> oB;
    protected E oS;

    public abstract AForceVector forceVector(AParticle<V, E> var1);

    public long dx() {
        long x0 = this.oA.p.x;
        long x1 = this.oB.p.x;
        return x1 - x0;
    }

    public long dy() {
        long y0 = this.oA.p.y;
        long y1 = this.oB.p.y;
        return y1 - y0;
    }

    public double angle() {
        return Math.atan2(this.dy(), this.dx());
    }

    public long length() {
        return (long)Math.hypot(this.dx(), this.dy());
    }

    public AParticle<V, E> getOA() {
        return this.oA;
    }

    public void setOA(AParticle<V, E> oa) {
        this.oA = oa;
    }

    public AParticle<V, E> getOB() {
        return this.oB;
    }

    public void setOB(AParticle<V, E> ob) {
        this.oB = ob;
    }
}

