/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.topology.fUniverse;

import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.topology.fUniverse.AForce;
import com.sigrity.acl.topology.fUniverse.AForceUniverseDrawer;
import com.sigrity.acl.topology.fUniverse.AForceUpdateListener;
import com.sigrity.acl.topology.fUniverse.ForceUniverse;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import javax.swing.JComponent;

public class AForceOverlay<V, E>
implements AForceUpdateListener {
    DesignView2D mView;
    Db mDb;
    Design mDesign;
    public Overlay mOverlay;
    boolean mDrawing = false;
    ForceUniverse<V, E> su;
    AForceUniverseDrawer<V, E> drawer;

    public AForceOverlay(DesignView2D view, ForceUniverse<V, E> su, AForceUniverseDrawer<V, E> d) {
        this.drawer = d;
        this.mView = view;
        this.su = su;
        this.mDb = view.getDb();
        this.mDesign = Design.getDesign((Db)this.mDb);
        if (!(view instanceof DesignView2D)) {
            return;
        }
        DesignView2D v2 = view;
        this.mOverlay = new Overlay();
        v2.addOverlay(this.mOverlay);
    }

    @Override
    public void update() {
        this.mOverlay.paintImmediately(this.mOverlay.getBounds());
    }

    public class Overlay
    extends JComponent {
        protected DesignCanvas2D.XForm w2s;
        Graphics2D g;

        public Overlay() {
            this.setOpaque(false);
            this.setDoubleBuffered(true);
            this.setBackground(new Color(0, 0, 0, 0));
        }

        protected void drawSpringUniverse() {
            this.g.setColor(new Color(255, 0, 0, 64));
            ArrayList vs = AForceOverlay.this.su.getVs();
            for (Object v : vs) {
                AForceOverlay.this.drawer.drawV(v, this.g, this.w2s);
            }
            for (AForce aForce : AForceOverlay.this.su.getEs()) {
                AForceOverlay.this.drawer.drawE(aForce, this.g, this.w2s);
            }
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            if (AForceOverlay.this.mDrawing) {
                return;
            }
            AForceOverlay.this.mDrawing = true;
            this.g = (Graphics2D)graphics;
            DesignView2D v2 = AForceOverlay.this.mView;
            this.w2s = v2.getCanvas().getXForm();
            if (DbExplorerPanel.enableExtendedUI()) {
                this.drawSpringUniverse();
            }
            AForceOverlay.this.mDrawing = false;
        }
    }
}

