/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.topology.fUniverse;

public class AForceVector {
    protected double mX;
    protected double mY;

    public AForceVector() {
        this.mX = 0.0;
        this.mY = 0.0;
    }

    public AForceVector(double x, double y) {
        this.mX = x;
        this.mY = y;
    }

    public static AForceVector createFromAngle(long l, double alpha) {
        AForceVector f = new AForceVector();
        f.setX((double)l * Math.cos(alpha));
        f.setY((double)l * Math.sin(alpha));
        return f;
    }

    public AForceVector(double x0, double y0, double x1, double y1) {
        this.mX = x1 - x0;
        this.mY = y1 - y0;
    }

    public double getX() {
        return this.mX;
    }

    public double getY() {
        return this.mY;
    }

    public void setX(double x) {
        this.mX = x;
    }

    public void setY(double y) {
        this.mY = y;
    }

    public double dot(AForceVector v) {
        return this.mX * v.getX() + this.mY * v.getY();
    }

    public double cross(AForceVector v) {
        return this.mX * v.getY() - this.mY * v.getX();
    }

    public double right(AForceVector v) {
        return -this.cross(v);
    }

    public AForceVector add(AForceVector v) {
        return new AForceVector(this.mX + v.getX(), this.mY + v.getY());
    }

    public AForceVector add(double x, double y) {
        return new AForceVector(this.mX + x, this.mY + y);
    }

    public AForceVector times(double t) {
        return new AForceVector(this.mX * t, this.mY * t);
    }

    public double angle() {
        return Math.atan2(this.mY, this.mX);
    }

    public double lengthSq() {
        return this.mX * this.mX + this.mY * this.mY;
    }

    public double length() {
        return Math.sqrt(this.mX * this.mX + this.mY * this.mY);
    }

    public boolean isZeroLength() {
        return this.mX == 0.0 && this.mY == 0.0;
    }
}

