/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.topology.fUniverse;

import com.sigrity.acl.ALog;
import com.sigrity.acl.topology.fUniverse.AForce;
import com.sigrity.acl.topology.fUniverse.AForceVector;
import com.sigrity.acl.topology.fUniverse.AParticle;

public class ClearanceSpring<V, E>
extends AForce<V, E> {
    protected Long minSize;
    protected Long maxSize;
    protected Long extent;

    public ClearanceSpring(long min) {
        this.minSize = min;
        this.maxSize = null;
        this.oS = null;
        this.extent = 0L;
    }

    public ClearanceSpring(long min, long max, E e, long extent) {
        this.minSize = min;
        this.maxSize = max;
        this.oS = e;
        this.extent = extent;
    }

    protected ClearanceSpring(long min, long max, AParticle<V, E> oA, AParticle<V, E> oB, long extent) {
        this.oA = oA;
        this.oB = oB;
        this.minSize = min;
        this.maxSize = max;
        this.extent = extent;
    }

    public Long getMinSize() {
        return this.minSize;
    }

    @Override
    public AForceVector forceVector(AParticle<V, E> from) {
        double angle = this.angle();
        if (this.oA == from) {
            return AForceVector.createFromAngle(this.force(), angle);
        }
        if (this.oB == from) {
            return AForceVector.createFromAngle(-this.force(), angle);
        }
        ALog.logWarn((String)"No Vector Component");
        return null;
    }

    protected long force() {
        long length = this.length() - this.extent;
        long slack = length - this.minSize;
        if (slack >= 0L) {
            return 0L;
        }
        if (!this.oA.movable || !this.oB.movable) {
            return slack * 10L;
        }
        return slack;
    }
}

