/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.topology.fUniverse;

import com.google.common.collect.HashBiMap;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.topology.fUniverse.AForce;
import com.sigrity.acl.topology.fUniverse.AForceOverlay;
import com.sigrity.acl.topology.fUniverse.AForceUniverseDrawer;
import com.sigrity.acl.topology.fUniverse.AForceUpdateListener;
import com.sigrity.acl.topology.fUniverse.AForceVector;
import com.sigrity.acl.topology.fUniverse.AParticle;
import com.sigrity.acl.topology.fUniverse.AParticlePoint;
import com.sigrity.acl.topology.fUniverse.ClearanceSpring;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import com.sigrity.orbit.ui.core.DesignView2D;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.ArrayList;

public class ForceUniverse<P, F> {
    HashBiMap<P, AParticle<P, F>> object2Particle = HashBiMap.create();
    ArrayList<AForce<P, F>> forces = new ArrayList();
    AForceUpdateListener updateListner = null;

    public void addObject(P o, long x, long y, boolean m) {
        if (this.object2Particle.get(o) == null) {
            AParticle so = new AParticle(o, x, y, 0L, 1L, 1L, 1L, m);
            this.object2Particle.put(o, so);
        }
    }

    public void addObject(P o, long x, long y) {
        if (this.object2Particle.get(o) == null) {
            AParticle so = new AParticle(o, x, y, 0L, 1L, 1L, 1L, true);
            this.object2Particle.put(o, so);
        }
    }

    public void addObject(P o, long x, long y, long z) {
        if (this.object2Particle.get(o) == null) {
            AParticle so = new AParticle(o, x, y, z, 1L, 1L, 1L, true);
            this.object2Particle.put(o, so);
        }
    }

    public void addUpdater(AForceUpdateListener l) {
        this.updateListner = l;
    }

    public void addSpring(P oA, P oB, AForce<P, F> s) {
        AParticle sA = (AParticle)this.object2Particle.get(oA);
        AParticle sB = (AParticle)this.object2Particle.get(oB);
        s.oA = sA;
        s.oB = sB;
        sA.springList.add(s);
        sB.springList.add(s);
        this.forces.add(s);
    }

    public void relax() {
        for (long i = 0L; i < 100L; ++i) {
            for (AParticle so : this.object2Particle.values()) {
                AForceVector dv = so.forceVector();
                long dx = (long)dv.mX;
                long dy = (long)dv.mY;
                if (dx == 0L && dy == 0L) continue;
                so.p.x += dx;
                so.p.y += dy;
            }
            if (this.updateListner == null) continue;
            this.updateListner.update();
        }
    }

    public HashBiMap<P, AParticlePoint> getMove() {
        HashBiMap moveAmt = HashBiMap.create();
        for (Object o : this.object2Particle.keySet()) {
            AParticle so = (AParticle)this.object2Particle.get(o);
            if (!so.movable) continue;
            moveAmt.put(o, (Object)new AParticlePoint(so.p.x, so.p.y, so.p.z));
        }
        return moveAmt;
    }

    public ArrayList<P> getVs() {
        ArrayList vs = new ArrayList();
        for (AParticle so : this.object2Particle.values()) {
            Object v = so.usrObject;
            vs.add(v);
        }
        return vs;
    }

    public ArrayList<AForce<P, F>> getEs() {
        return this.forces;
    }

    public static void testMe() {
        class Thing {
            long x;
            long y;
            long z;
            String name;
            long d;
            boolean movable = false;

            public Thing(long x, long y, long z, String name, long d, boolean m) {
                this.x = x;
                this.y = y;
                this.z = z;
                this.name = name;
                this.d = d;
                this.movable = m;
            }

            public void addSU(ForceUniverse<Thing, 1Spring> su) {
                class Spring {
                    Spring() {
                    }
                }
                su.addObject(this, this.x, this.y, this.movable);
            }

            public void draw(Graphics2D g, DesignCanvas2D.XForm w2s) {
                Point p = w2s.getScreenPt(new APoint2D(this.x, this.y));
                g.setColor(Color.red);
                g.fillOval(p.x - 5, p.y - 5, 10, 10);
            }
        }
        Thing thing1 = new Thing(0L, 0L, 0L, "pin0", 10L, false);
        Thing thing2 = new Thing(0L, 300L, 0L, "w0", 10L, true);
        Thing thing3 = new Thing(0L, 600L, 0L, "w1", 10L, true);
        Thing thing31 = new Thing(0L, 700L, 0L, "w12", 10L, true);
        Thing thing4 = new Thing(0L, 3000L, 0L, "pin1", 10L, false);
        class ThingSpringUniverse
        extends ForceUniverse<Thing, 1Spring>
        implements AForceUniverseDrawer<Thing, 1Spring>,
        AForceUpdateListener {
            AForceOverlay<Thing, 1Spring> overlay;

            ThingSpringUniverse() {
            }

            public void debugView() {
                this.overlay = new AForceOverlay<Thing, Spring>((DesignView2D)OrbitIO.getCurView(), this, this);
                this.addUpdater(this);
            }

            @Override
            public void update() {
                HashBiMap moves = this.getMove();
                for (Thing thing : moves.keySet()) {
                    AParticlePoint d = (AParticlePoint)moves.get((Object)thing);
                    thing.x = d.x;
                    thing.y = d.y;
                    thing.z = d.z;
                }
                this.overlay.update();
            }

            @Override
            public void drawE(AForce<Thing, 1Spring> e, Graphics2D g, DesignCanvas2D.XForm w2s) {
                ClearanceSpring c = (ClearanceSpring)e;
                if (e.length() < c.minSize) {
                    g.setColor(Color.red);
                } else {
                    g.setColor(Color.green);
                }
                Point p1 = w2s.getScreenPt(new APoint2D(e.oA.p.x, e.oA.p.y));
                Point p2 = w2s.getScreenPt(new APoint2D(e.oB.p.x, e.oB.p.y));
                g.drawLine(p1.x, p1.y, p2.x, p2.y);
            }

            @Override
            public void drawV(Thing v, Graphics2D g, DesignCanvas2D.XForm w2s) {
                v.draw(g, w2s);
            }
        }
        ThingSpringUniverse su = new ThingSpringUniverse();
        su.debugView();
        thing1.addSU(su);
        thing2.addSU(su);
        thing3.addSU(su);
        thing31.addSU(su);
        thing4.addSU(su);
        ClearanceSpring s12 = new ClearanceSpring(500L);
        ClearanceSpring s23 = new ClearanceSpring(600L);
        ClearanceSpring s33 = new ClearanceSpring(500L);
        ClearanceSpring s34 = new ClearanceSpring(500L);
        su.addSpring(thing1, thing2, s12);
        su.addSpring(thing2, thing3, s23);
        su.addSpring(thing3, thing31, s33);
        su.addSpring(thing3, thing4, s34);
        su.relax();
    }
}

