/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.transformers;

import com.sigrity.acl.ALog;
import com.sigrity.acl.Unit;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.AGeomUtil;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.optimizer.ASpreader;
import com.sigrity.lic.LSession;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;

public class AIOCellSpreader {
    protected ArrayList<DevicePath> mActive = new ArrayList();
    protected DevicePath mParent = null;
    protected SpreadDir mDir = SpreadDir.Undefined;
    protected boolean mParentIsGroup = false;
    protected ALine mBounds = new ALine();
    protected long mStart;
    protected long mStop;
    protected long mCornerSize;
    private HashMap<DevicePath, NeighborList> mDevicePathToNeighbors = new HashMap();
    protected ASpreader mSpreader;
    protected boolean mJustSelected;
    protected long mSpecificSep;
    protected final int mVCutoff = 32;

    public void setCornerSize(long size) {
        this.mCornerSize = size;
    }

    public void spread(ArrayList<DevicePath> active, ArrayList<DevicePath> obs, SpreadAlgo algo, SpreadDir dir, DevicePath parent, int quad) {
        boolean sameParent;
        this.mActive = active;
        this.mParent = parent;
        if (this.mActive.size() <= 1) {
            return;
        }
        this.mDir = dir;
        if (this.mDir == SpreadDir.Guess) {
            this.mDir = this.guessDir();
        }
        if (!(sameParent = this.sameParentCheck())) {
            // empty if block
        }
        this.mParentIsGroup = this.mActive.get(0).getLast().getPersonality() != null;
        long capacity = this.deriveCapacity(active, obs, quad);
        long inUse = this.deriveInUse();
        long excess = capacity - inUse;
        Unit unit = OrbitIO.getCurView().getUnit();
        ALog.logInfo((String)("The " + AGeomUtil.quadToSideString((int)quad) + " side has a capacity of " + unit.toUserStr(capacity) + " and is currently using " + unit.toUserStr(inUse)));
        this.mSpreader = new ASpreader();
        ASpreader.ADistributionCurve c = ASpreader.createEvenSpreadingCurve(this.mActive.size() + 1, excess);
        if (algo == SpreadAlgo.ForWireBonding) {
            c = this.mActive.size() < 32 ? ASpreader.createEvenSpreadingCurve(this.mActive.size() + 1, excess) : ASpreader.createVCurve(this.mActive.size() + 1, excess);
        } else if (algo == SpreadAlgo.PushBeginning) {
            c = ASpreader.createSquish(this.mActive.size() + 1, excess, true);
        } else if (algo == SpreadAlgo.PushEnd) {
            c = ASpreader.createSquish(this.mActive.size() + 1, excess, false);
        } else if (algo == SpreadAlgo.Specific) {
            c = ASpreader.createConstantSpreadingCurve(this.mActive.size() + 1, this.mSpecificSep);
        }
        if (!this.mJustSelected) {
            this.normalizeParents();
        }
        this.updatePositions(c);
        if (!this.mJustSelected) {
            this.stretchParents();
        }
    }

    protected void normalizeParents() {
        ArrayList<Personality> parentPersonalities = new ArrayList<Personality>();
        for (DevicePath dp : this.mActive) {
            Personality p = dp.getLast().getPersonality();
            if (p == null || parentPersonalities.contains(p)) continue;
            parentPersonalities.add(p);
        }
        for (Personality p : parentPersonalities) {
            DevicePath path = p.getParentDevicePath().pathToParent(this.mParent);
            this.normalizeDevice(path);
        }
    }

    protected void stretchParents() {
        ArrayList<Personality> parentPersonalities = new ArrayList<Personality>();
        for (DevicePath dp : this.mActive) {
            Personality p = dp.getLast().getPersonality();
            if (p == null || parentPersonalities.contains(p)) continue;
            parentPersonalities.add(p);
        }
        for (Personality p : parentPersonalities) {
            DevicePath path = p.getParentDevicePath().pathToParent(this.mParent);
            this.normalizeDevice(path);
            p.encompassChildDevices();
        }
    }

    protected void normalizeDevice(DevicePath path) {
        class TransActions {
            float rot;
            boolean mirror;
            APoint2D p;

            TransActions() {
            }
        }
        TransActions ta;
        DevicePath childPath;
        HashMap<Device, TransActions> mDevToTransform = new HashMap<Device, TransActions>();
        Device d = path.getLast();
        ARect r = new ARect();
        boolean first = true;
        for (Device child : d.getChildren()) {
            childPath = new DevicePath(path, child);
            ta = new TransActions();
            ta.rot = childPath.getRot();
            ta.mirror = childPath.getMirror();
            ta.p = childPath.getOrigin();
            mDevToTransform.put(child, ta);
            ARect bb = childPath.getBB();
            if (first) {
                r = bb;
                first = false;
                continue;
            }
            r.expand(bb);
        }
        d.setMirror(false);
        d.setRotate(0.0f);
        d.getTemplate().setBounds((AGeom)new ARect(0L, 0L, r.width(), r.height()));
        d.setLoc(r.getLL());
        for (Device child : d.getChildren()) {
            childPath = new DevicePath(path, child);
            ta = (TransActions)mDevToTransform.get(child);
            child.setRotate(ta.rot);
            child.setMirror(ta.mirror);
            child.setLoc(ta.p);
            APoint2D n = new APoint2D(childPath.getOrigin());
            APoint2D ds = new APoint2D(ta.p.sub(n));
            child.moveBy(ds.getX(), ds.getY());
        }
    }

    protected long deriveCapacity(ArrayList<DevicePath> active, ArrayList<DevicePath> obs, int quad) {
        long capacity;
        if (this.mJustSelected) {
            this.deriveSelectedExtents();
            capacity = this.mStop - this.mStart;
        } else {
            DevicePath first = active.get(0);
            APoint2D firstLoc = first.getLast().getLoc();
            DevicePath last = active.get(active.size() - 1);
            APoint2D lastLoc = last.getLast().getLoc();
            APoint2D origFirstLoc = new APoint2D(firstLoc);
            APoint2D origLastLoc = new APoint2D(lastLoc);
            ARect s = this.deriveWireBondingBounds();
            switch (quad) {
                case 0: {
                    first.getLast().moveTo(firstLoc.getX(), s.getLR().getY());
                    last.getLast().moveTo(lastLoc.getX(), s.getUR().getY());
                    for (DevicePath o : obs) {
                        if (o.getBB().intersects(first.getBB())) {
                            s.bottom(o.getBB().top());
                        }
                        if (!o.getBB().intersects(last.getBB())) continue;
                        s.top(o.getBB().bottom());
                    }
                    break;
                }
                case 1: {
                    first.getLast().moveTo(s.getUL().getX(), firstLoc.getY());
                    last.getLast().moveTo(s.getUR().getX(), lastLoc.getY());
                    for (DevicePath o : obs) {
                        if (o.getBB().intersects(first.getBB())) {
                            s.left(o.getBB().right());
                        }
                        if (!o.getBB().intersects(last.getBB())) continue;
                        s.right(o.getBB().left());
                    }
                    break;
                }
                case 2: {
                    first.getLast().moveTo(firstLoc.getX(), s.getLL().getY());
                    last.getLast().moveTo(lastLoc.getX(), s.getUL().getY());
                    for (DevicePath o : obs) {
                        if (o.getBB().intersects(first.getBB())) {
                            s.bottom(o.getBB().top());
                        }
                        if (!o.getBB().intersects(last.getBB())) continue;
                        s.top(o.getBB().bottom());
                    }
                    break;
                }
                case 3: {
                    first.getLast().moveTo(s.getLL().getX(), firstLoc.getY());
                    last.getLast().moveTo(s.getLR().getX(), lastLoc.getY());
                    for (DevicePath o : obs) {
                        if (o.getBB().intersects(first.getBB())) {
                            s.left(o.getBB().right());
                        }
                        if (!o.getBB().intersects(last.getBB())) continue;
                        s.right(o.getBB().left());
                    }
                    break;
                }
            }
            if (this.mDir == SpreadDir.Horizontal) {
                this.mStart = s.left();
                this.mStop = s.right();
            } else {
                this.mStart = s.bottom();
                this.mStop = s.top();
            }
            capacity = this.mStop - this.mStart - this.mCornerSize * 2L;
            first.getLast().moveTo(origFirstLoc);
            last.getLast().moveTo(origLastLoc);
        }
        return capacity;
    }

    protected boolean sameParentCheck() {
        DevicePath parent = null;
        for (DevicePath dp : this.mActive) {
            if (parent == null) {
                parent = dp.getParent();
                continue;
            }
            if (dp.getParent().toString().equals(parent.toString())) continue;
            return false;
        }
        return true;
    }

    protected void updatePositions(ASpreader.ADistributionCurve c) {
        long x = this.mCornerSize;
        long y = this.mCornerSize;
        if (this.mDir == SpreadDir.Horizontal) {
            x = this.mStart + this.mCornerSize;
        } else {
            y = this.mStart + this.mCornerSize;
        }
        if (this.mJustSelected) {
            if (this.mDir == SpreadDir.Horizontal) {
                x = this.mStart;
            } else {
                y = this.mStart;
            }
        }
        int i = 0;
        for (DevicePath dp : this.mActive) {
            if (this.mDir == SpreadDir.Horizontal) {
                long xOff = dp.getBB().left() - dp.getOrigin().getX();
                y = dp.getLast().getLoc().getY();
                dp.getLast().setLoc(new APoint2D((x += c.getArea(i)) - xOff, y));
                if (dp.getLast().getPersonality() != null) {
                    dp.getLast().moveBy(-dp.getLast().getPersonality().getParentDevicePath().getBB().left(), 0L);
                }
                x += dp.getBB().width();
            } else {
                long yOff = dp.getBB().bottom() - dp.getOrigin().getY();
                x = dp.getLast().getLoc().getX();
                dp.getLast().setLoc(new APoint2D(x, (y += c.getArea(i)) - yOff));
                if (dp.getLast().getPersonality() != null) {
                    dp.getLast().moveBy(0L, -dp.getLast().getPersonality().getParentDevicePath().getBB().bottom());
                }
                y += dp.getBB().height();
            }
            ++i;
        }
    }

    protected ARect deriveWireBondingBounds() {
        ARect r = new ARect(this.mParent.getLast().getLocalBB());
        return r;
    }

    protected void updateParentSizeIfNecessary() {
    }

    public void deriveSelectedExtents() {
        DevicePath first = new DevicePath(this.mActive.get(0));
        DevicePath last = new DevicePath(this.mActive.get(this.mActive.size() - 1));
        if (this.mDir == SpreadDir.Horizontal) {
            this.mStart = first.getBB().left();
            this.mStop = last.getBB().right();
        } else {
            this.mStart = first.getBB().bottom();
            this.mStop = last.getBB().top();
        }
    }

    public long deriveInUse() {
        long inUse = 0L;
        for (DevicePath dp : this.mActive) {
            if (this.mDir == SpreadDir.Horizontal) {
                inUse += dp.getBB().width();
                continue;
            }
            inUse += dp.getBB().height();
        }
        return inUse;
    }

    public SpreadDir guessDir() {
        boolean first = true;
        ARect bounds = new ARect();
        for (DevicePath dp : this.mActive) {
            if (first) {
                bounds = dp.getBB();
                first = false;
                continue;
            }
            bounds.expand(dp.getBB());
        }
        if (bounds.width() > bounds.height()) {
            return SpreadDir.Horizontal;
        }
        return SpreadDir.Vertical;
    }

    public void sortNeighbors(DevicePath dp) {
        Collections.sort(this.mDevicePathToNeighbors.get((Object)dp).neighbors, new DeviceSort(this.mDir));
    }

    public void deriveNeighbors(DevicePath dp) {
        for (DevicePath cdp : dp.getDescendants()) {
            if (!this.shadows(dp, cdp)) continue;
            this.addNeighbor(dp, cdp);
        }
    }

    protected boolean shadows(DevicePath p1, DevicePath p2) {
        ARect r1 = p1.getBB();
        ARect r2 = p2.getBB();
        return this.mDir == SpreadDir.Horizontal ? r1.vOverlaps(r2) : r1.hOverlaps(r2);
    }

    protected ArrayList<DevicePath> getAllCandidates(DevicePath dp, boolean justSelected) {
        Db db = OrbitIO.getCurDb();
        Selection s = Design.getSelection((Db)db);
        ArrayList<DevicePath> candidates = new ArrayList<DevicePath>();
        for (DevicePath cdp : dp.getDescendants()) {
            Device child = cdp.getLast();
            if (child.getIsFixed() || justSelected && !s.contains((DbObject)child)) continue;
            boolean movable = false;
            if (child.getTemplate().getType() == DeviceTemplate.Type.MACRO && child.anyChildrenAreIOPads()) {
                movable = true;
            }
            if (child.getTemplate().getType() == DeviceTemplate.Type.PAD) {
                movable = true;
            }
            if (!movable) continue;
            candidates.add(cdp);
        }
        return candidates;
    }

    public void spreadIOCells(String die, SpreadAlgo algo, boolean justSelected, long cornerDist, long sep) {
        this.mJustSelected = justSelected;
        this.mSpecificSep = sep;
        ArrayList devByQuads = new ArrayList();
        Db db = OrbitIO.getCurDb();
        DevicePath dp = DevicePath.fromString((Db)db, (String)die);
        if (dp == null) {
            return;
        }
        ArrayList<DevicePath> candidates = this.getAllCandidates(dp, justSelected);
        int highestRing = this.highestRing(candidates);
        ArrayList<DevicePath> alreadyPlaced = new ArrayList<DevicePath>();
        for (int ring = highestRing; ring >= 0; --ring) {
            devByQuads.clear();
            ArrayList<DevicePath> ringList = this.getRing(ring, candidates);
            for (int i = 0; i < 4; ++i) {
                devByQuads.add(new ArrayList());
            }
            for (DevicePath cp : ringList) {
                int q = AIOCellSpreader.determineQuadrant(dp, cp);
                ((ArrayList)devByQuads.get(q)).add(cp);
            }
            for (int quad = 0; quad < 4; ++quad) {
                ArrayList sideDevs = (ArrayList)devByQuads.get(quad);
                if (sideDevs.size() == 0) continue;
                Collections.sort(sideDevs, quad % 2 == 0 ? new DeviceSort(SpreadDir.Vertical) : new DeviceSort(SpreadDir.Horizontal));
                if (quad % 2 == 0) {
                    this.setCornerSize(cornerDist);
                }
                this.spread(sideDevs, alreadyPlaced, algo, quad % 2 == 0 ? SpreadDir.Vertical : SpreadDir.Horizontal, dp, quad);
                for (DevicePath dpInst : sideDevs) {
                    alreadyPlaced.add(dpInst);
                }
            }
        }
    }

    protected ArrayList<DevicePath> getRing(int ring, ArrayList<DevicePath> candidates) {
        ArrayList<DevicePath> ringList = new ArrayList<DevicePath>();
        for (DevicePath dp : candidates) {
            if (this.determineRing(dp) != ring) continue;
            ringList.add(dp);
        }
        return ringList;
    }

    protected int highestRing(ArrayList<DevicePath> candidates) {
        int ring = 0;
        for (DevicePath dp : candidates) {
            ring = Math.max(ring, this.determineRing(dp));
        }
        return ring;
    }

    protected int determineRing(DevicePath c) {
        Device d = c.getLast();
        String side = d.getSide();
        if (side != null && !side.isEmpty()) {
            if (side.contains("right")) {
                String num = side.substring(5);
                if (num.isEmpty()) {
                    return 0;
                }
                return Integer.parseInt(num);
            }
            if (side.contains("top")) {
                String num = side.substring(3);
                if (num.isEmpty()) {
                    return 0;
                }
                return Integer.parseInt(num);
            }
            if (side.contains("left")) {
                String num = side.substring(4);
                if (num.isEmpty()) {
                    return 0;
                }
                return Integer.parseInt(num);
            }
            if (side.contains("bottom")) {
                String num = side.substring(6);
                if (num.isEmpty()) {
                    return 0;
                }
                return Integer.parseInt(num);
            }
            return 0;
        }
        return 0;
    }

    protected static int determineQuadrant(DevicePath p, DevicePath c) {
        Device d = c.getLast();
        String side = d.getSide();
        if (side != null && !side.isEmpty()) {
            if (side.contains("right")) {
                return 0;
            }
            if (side.contains("top")) {
                return 1;
            }
            if (side.contains("left")) {
                return 2;
            }
            if (side.contains("bottom")) {
                return 3;
            }
        }
        APoint2D llc = new APoint2D(c.getBB().centerX(), c.getBB().centerY());
        int q = AGeomUtil.getQuadrant((APoint2D)llc, (ARect)p.getBB());
        return q;
    }

    protected boolean anyChildrenAreIOPads(Device child) {
        for (Device d : child.getDescendants()) {
            if (d.getTemplate().getType() != DeviceTemplate.Type.PAD) continue;
            return true;
        }
        return false;
    }

    protected void addNeighbor(DevicePath dp, DevicePath n) {
        NeighborList nl = this.mDevicePathToNeighbors.get(dp);
        if (nl == null) {
            nl = new NeighborList();
            this.mDevicePathToNeighbors.put(dp, nl);
        }
        nl.neighbors.add(n);
    }

    protected static class NeighborList {
        ArrayList<DevicePath> neighbors = new ArrayList();

        protected NeighborList() {
        }
    }

    public static class DeviceSort
    implements Comparator<DevicePath> {
        SpreadDir mDir;

        public DeviceSort(SpreadDir dir) {
            this.mDir = dir;
        }

        @Override
        public int compare(DevicePath o1, DevicePath o2) {
            if (this.mDir == SpreadDir.Vertical) {
                return Long.compare(o1.getBB().centerY(), o2.getBB().centerY());
            }
            return Long.compare(o1.getBB().centerX(), o2.getBB().centerX());
        }
    }

    public static enum SpreadAlgo {
        ForWireBonding,
        Evenly,
        Specific,
        PushBeginning,
        PushEnd,
        Undefined;

    }

    public static enum SpreadDir {
        Horizontal,
        Vertical,
        Guess,
        Undefined;

    }
}

