/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.transformers;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;

public class Abutter {
    private Abutter() {
    }

    public static AbutTo toEnum(String alignByString) {
        if (alignByString.compareToIgnoreCase("top") == 0) {
            return AbutTo.TOP;
        }
        if (alignByString.compareToIgnoreCase("bottom") == 0) {
            return AbutTo.BOTTOM;
        }
        if (alignByString.compareToIgnoreCase("left") == 0) {
            return AbutTo.LEFT;
        }
        if (alignByString.compareToIgnoreCase("right") == 0) {
            return AbutTo.RIGHT;
        }
        ALog.logWarn((String)("Unknow abut type " + alignByString));
        return null;
    }

    public static void abutSelectedTo(String to, String devicePathString) {
        DevicePath dp = DevicePath.fromString((Db)OrbitIO.getCurDb(), (String)devicePathString);
        AbutTo toEnum = Abutter.toEnum(to);
        if (toEnum != null) {
            Abutter.AbutToSelected(toEnum, dp);
        }
    }

    public static void AbutToSelected(AbutTo to, DevicePath dp) {
        Db db = OrbitIO.getCurDb();
        ARect targetBB = dp.getBB();
        Design design = Design.getDesign((Db)db);
        Selection s = design.getCurSelection();
        for (Device d : s.get(Device.class)) {
            if (d == dp.getLast()) continue;
            switch (to) {
                case TOP: {
                    d.moveBy(0L, targetBB.top() - d.getBB().getLL().getY());
                    break;
                }
                case BOTTOM: {
                    d.moveBy(0L, targetBB.bottom() - d.getBB().getUR().getY());
                    break;
                }
                case LEFT: {
                    d.moveBy(targetBB.left() - d.getBB().getUR().getX(), 0L);
                    break;
                }
                case RIGHT: {
                    d.moveBy(targetBB.right() - d.getBB().getLL().getX(), 0L);
                }
            }
        }
        design.binAllDevices();
    }

    public static enum AbutTo {
        TOP,
        RIGHT,
        BOTTOM,
        LEFT;

    }
}

