/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.transformers;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;

public class Aligner {
    private Aligner() {
    }

    public static AlignBy toEnum(String alignByString) {
        if (alignByString.compareToIgnoreCase("top") == 0) {
            return AlignBy.TOP;
        }
        if (alignByString.compareToIgnoreCase("bottom") == 0) {
            return AlignBy.BOTTOM;
        }
        if (alignByString.compareToIgnoreCase("left") == 0) {
            return AlignBy.LEFT;
        }
        if (alignByString.compareToIgnoreCase("right") == 0) {
            return AlignBy.RIGHT;
        }
        if (alignByString.compareToIgnoreCase("centerx") == 0) {
            return AlignBy.CENTERX;
        }
        if (alignByString.compareToIgnoreCase("centery") == 0) {
            return AlignBy.CENTERY;
        }
        ALog.logWarn((String)("Unknow align type " + alignByString));
        return null;
    }

    public static void alignSelectedTo(AlignBy by, DevicePath targetPath) {
        Db db = OrbitIO.getCurDb();
        ARect targetBB = targetPath.getBB();
        Design design = Design.getDesign((Db)db);
        Selection s = design.getCurSelection();
        for (DbObject o : s.getAll()) {
            Device d;
            if (!(o instanceof Device) || (d = (Device)o) == targetPath.getLast()) continue;
            switch (by) {
                case TOP: {
                    d.moveBy(0L, targetBB.top() - d.getBB().getUR().getY());
                    break;
                }
                case BOTTOM: {
                    d.moveBy(0L, targetBB.bottom() - d.getBB().getLL().getY());
                    break;
                }
                case LEFT: {
                    d.moveBy(targetBB.left() - d.getBB().getLL().getX(), 0L);
                    break;
                }
                case RIGHT: {
                    d.moveBy(targetBB.right() - d.getBB().getUR().getX(), 0L);
                    break;
                }
                case CENTERX: {
                    d.moveBy(targetBB.centerX() - d.getBB().centerX(), 0L);
                    break;
                }
                case CENTERY: {
                    d.moveBy(0L, targetBB.centerY() - d.getBB().centerY());
                }
            }
        }
        design.binAllDevices();
    }

    public static enum AlignBy {
        TOP,
        RIGHT,
        BOTTOM,
        LEFT,
        CENTERX,
        CENTERY;

    }
}

