/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.transformers;

import com.sigrity.acl.db.std.Connection;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.ALine;
import com.sigrity.eda.NetCutManager;
import com.sigrity.orbit.DevicePath;
import java.util.ArrayList;

public class Rotater {
    public static int getBestRotateAngle(Device d) {
        int bestCrosses = 0;
        int bestRot = 0;
        float oldRot = d.getRotate();
        for (int i = 0; i < 4; ++i) {
            Rotater.orient90(d, i * 90);
            int crosses = Rotater.determineConnectionCrossings(d);
            if (i != 0 && crosses >= bestCrosses) continue;
            bestRot = i;
            bestCrosses = crosses;
        }
        d.setRotate(oldRot);
        return bestRot * 90;
    }

    public static void bestRotate(Device d) {
        int bestRot = Rotater.getBestRotateAngle(d);
        Rotater.orient90(d, bestRot);
    }

    public static void orient90(Device d, int r) {
        d.setRotate((float)r);
    }

    public static int determineConnectionCrossings(ArrayList<Connection> cList) {
        int size = cList.size();
        int crosses = 0;
        for (int i = 0; i < size - 1; ++i) {
            ALine aL = cList.get(i).getLine();
            for (int j = i + 1; j < size; ++j) {
                ALine bL = cList.get(j).getLine();
                if (!bL.intersects((AGeom)aL)) continue;
                ++crosses;
            }
        }
        return crosses;
    }

    public static int determineConnectionCrossings(Device d) {
        DevicePath surrogate = d.getADevicePath();
        ArrayList<Connection> cList = NetCutManager.deriveClosestConnectionsSet(surrogate);
        int size = cList.size();
        int crosses = 0;
        for (int i = 0; i < size - 1; ++i) {
            ALine aL = cList.get(i).getLine();
            for (int j = i + 1; j < size; ++j) {
                ALine bL = cList.get(j).getLine();
                if (!bL.intersects((AGeom)aL)) continue;
                ++crosses;
            }
        }
        return crosses;
    }
}

